/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui;

import ca.bradj.questown.core.UtilClean;
import ca.bradj.questown.core.network.AddWorkFromUIMessage;
import ca.bradj.questown.core.network.EconomicsUpdate;
import ca.bradj.questown.core.network.QuestownNetwork;
import ca.bradj.questown.gui.AbstractPagedCardScreen;
import ca.bradj.questown.gui.IngredientRenderer;
import ca.bradj.questown.gui.Ingredients;
import ca.bradj.questown.gui.ItemEconomicsData;
import ca.bradj.questown.gui.PagedCardScreen;
import ca.bradj.questown.gui.RenderContext;
import ca.bradj.questown.gui.VillagerEconomicsMenu;
import ca.bradj.questown.gui.VillagerTabs;
import ca.bradj.questown.mc.Compat;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.crafting.Ingredient;

public class VillagerEconomicsScreen
extends AbstractPagedCardScreen<VillagerEconomicsMenu, ItemEconomicsData> {
    private final VillagerTabs tabs;
    public static EconomicsUpdate lastUpdate = new EconomicsUpdate((ImmutableList<ItemEconomicsData>)ImmutableList.of());
    IngredientRenderer ingredientRenderer = new IngredientRenderer();

    public VillagerEconomicsScreen(VillagerEconomicsMenu menu, Inventory playerInv, Component title) {
        super(menu, playerInv, title);
        this.f_97726_ = 256;
        this.f_97727_ = 220;
        this.tabs = VillagerTabs.forMenu(menu);
    }

    @Override
    protected ImmutableList<ItemEconomicsData> cardsData() {
        return lastUpdate.data();
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 81) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    protected void m_7027_(PoseStack p_97808_, int p_97809_, int p_97810_) {
    }

    private void renderTooltips(PoseStack stack, int mouseX, int mouseY) {
        int bgX = (this.f_96543_ - 176) / 2;
        int bgY = (this.f_96544_ - this.backgroundHeight()) / 2;
        if (this.tabs.renderTooltip(bgX, bgY, mouseX, mouseY, key -> super.m_96602_(stack, Compat.translatable(key), mouseX, mouseY))) {
            return;
        }
        for (PagedCardScreen.Card card : this.cards()) {
            int y;
            int x = card.coords().leftX();
            if (!UtilClean.isCoordInBox(mouseX, mouseY, x, y = card.coords().topY(), 156, this.cardHeight)) continue;
            String key1 = "questown.menu.needs_in_period_1";
            String key2 = "questown.menu.needs_in_period_2";
            Ingredient ingr = Ingredients.fromString(((ItemEconomicsData)card.data()).ingredientKey());
            Component itemName = Ingredients.getName(ingr);
            int timesNeeded = ((ItemEconomicsData)card.data()).timesNeeded();
            ImmutableList es = ImmutableList.of((Object)Compat.translatable(key1, itemName, timesNeeded), (Object)Compat.translatable(key2, 1));
            super.m_169388_(stack, (List)es, Optional.empty(), mouseX, mouseY);
        }
        super.m_7025_(stack, mouseX, mouseY);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.renderTooltips(poseStack, mouseX, mouseY);
    }

    @Override
    protected List<Component> renderCardContent(PoseStack poseStack, PagedCardScreen.Card<ItemEconomicsData> card, int mouseX, int mouseY) {
        this.renderDataAndIcons(poseStack, card.coords(), card.data());
        return null;
    }

    private void renderDataAndIcons(PoseStack poseStack, PagedCardScreen.CardCoordinates coords, ItemEconomicsData data) {
        int iconX = coords.leftX() + 5;
        int iconY = coords.topY() + 5;
        Ingredient item = Ingredients.fromString(data.ingredientKey());
        this.ingredientRenderer.render(this.f_96542_, item, iconX, iconY);
        int textX = iconX + this.ingredientRenderer.getSize() + 1 + 1;
        int textY = coords.topYPadded();
        Compat.drawDarkText(this.f_96547_, poseStack, Ingredients.getName(item), textX, textY);
        String count = Integer.toString(data.timesNeeded());
        int countX = coords.rightXPadded() - this.f_96547_.m_92895_(count);
        Compat.drawDarkText(this.f_96547_, poseStack, Compat.literal(count), countX, textY);
    }

    @Override
    protected void m_7286_(PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(stack, partialTicks, mouseX, mouseY);
        int bgX = (this.f_96543_ - 176) / 2;
        int bgY = (this.f_96544_ - this.backgroundHeight()) / 2;
        this.tabs.draw(new RenderContext(this.f_96542_, stack), bgX, bgY);
    }

    public boolean m_7043_() {
        return false;
    }

    @Override
    public List<Rect2i> getExtraAreas() {
        int x = (this.f_96543_ - 176) / 2;
        int y = (this.f_96544_ - this.backgroundHeight()) / 2;
        return ImmutableList.of((Object)new Rect2i(x, y, 176, this.backgroundHeight()));
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int p_97750_) {
        for (PagedCardScreen.Card card : this.cards()) {
            PagedCardScreen.CardCoordinates c = card.coords();
            if (!UtilClean.isCoordInBox(mouseX, mouseY, VillagerEconomicsScreen.getIconX(c), VillagerEconomicsScreen.getIconY(c), 16, 16)) continue;
            Ingredient ing = Ingredients.fromString(((ItemEconomicsData)card.data()).ingredientKey());
            AddWorkFromUIMessage.Action inquired = AddWorkFromUIMessage.Action.INQUIRED;
            AddWorkFromUIMessage msg = new AddWorkFromUIMessage(ing, ((VillagerEconomicsMenu)this.f_97732_).getFlagPos(), inquired);
            QuestownNetwork.CHANNEL.sendToServer((Object)msg);
            return true;
        }
        int x = (this.f_96543_ - 176) / 2;
        int y = (this.f_96544_ - this.backgroundHeight()) / 2;
        this.tabs.mouseClicked(x, y, mouseX, mouseY);
        return super.m_6375_(mouseX, mouseY, p_97750_);
    }

    private static int getIconY(PagedCardScreen.CardCoordinates coords) {
        return coords.topY() + 5;
    }

    private static int getIconX(PagedCardScreen.CardCoordinates coords) {
        return coords.leftX() + 5;
    }

    @Override
    protected void setRenderColorForCard(ItemEconomicsData itemEconomicsData) {
    }
}

