/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui;

import ca.bradj.questown.QT;
import ca.bradj.questown.gui.InventoryAndStatusMenu;
import ca.bradj.questown.gui.JobChangeConfirmMenu;
import ca.bradj.questown.gui.UIQuest;
import ca.bradj.questown.gui.VillagerBlockofProgressMenu;
import ca.bradj.questown.gui.VillagerEconomicsData;
import ca.bradj.questown.gui.VillagerEconomicsMenu;
import ca.bradj.questown.gui.VillagerQuestsContainer;
import ca.bradj.questown.gui.VillagerStatsMenu;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.Jobs;
import ca.bradj.questown.mobs.visitor.VisitorMobEntity;
import ca.bradj.questown.town.VillagerStatsData;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class VillagerMenus {
    final VisitorMobEntity entity;
    InventoryAndStatusMenu invMenu;
    VillagerStatsMenu statsMenu;
    VillagerQuestsContainer questsMenu;
    VillagerEconomicsMenu econMenu;
    VillagerBlockofProgressMenu bopMenu;
    JobChangeConfirmMenu changeMenu;

    public VillagerMenus(VisitorMobEntity e) {
        this.entity = e;
    }

    public static VillagerMenus fromNetwork(int windowId, Player player, FriendlyByteBuf buf) {
        try {
            return VillagerMenus.doFromNetwork(windowId, player, buf);
        }
        catch (Exception e) {
            QT.GUI_LOGGER.error("Failed to load menus from network", e);
            throw e;
        }
    }

    @NotNull
    private static VillagerMenus doFromNetwork(int windowId, Player player, FriendlyByteBuf buf) {
        int i = buf.readInt();
        JobID jobId = Jobs.getIdFromNetwork(buf);
        int invSize = buf.readInt();
        Collection<UIQuest> quests = VillagerQuestsContainer.readQuests(buf);
        BlockPos flagPos = VillagerQuestsContainer.readFlagPos(buf);
        VillagerStatsData stats = VillagerStatsMenu.read(buf);
        VillagerEconomicsData econ = VillagerEconomicsMenu.read(buf);
        boolean showBlockOfProgressTab = buf.readBoolean();
        boolean alreadyPending = buf.readBoolean();
        VisitorMobEntity e = (VisitorMobEntity)player.f_19853_.m_6815_(i);
        VillagerMenus menus = new VillagerMenus(e);
        menus.initQuestsMenu(windowId, e.m_20148_(), quests, flagPos, showBlockOfProgressTab);
        menus.initVillagerStatsMenu(windowId, flagPos, stats, showBlockOfProgressTab);
        menus.initInventory(windowId, jobId, player, e.m_20148_(), e.getSlotLocks(), invSize, flagPos, showBlockOfProgressTab);
        menus.initVillagerEconomicsMenu(windowId, flagPos, econ, showBlockOfProgressTab);
        menus.bopMenu = new VillagerBlockofProgressMenu(windowId, e.m_20148_(), flagPos);
        SimpleContainer bopSlot = new SimpleContainer(1){

            public int m_6893_() {
                return 1;
            }
        };
        menus.changeMenu = new JobChangeConfirmMenu(windowId, (Container)bopSlot, player.m_150109_(), e.m_20148_(), jobId, flagPos, alreadyPending);
        return menus;
    }

    public static void write(FriendlyByteBuf data, List<UIQuest> quests, VisitorMobEntity e, int capacity, JobID jobId, VillagerStatsData stats, VillagerEconomicsData econ, boolean showBlockOfProgressTab, boolean jobChangeAlreadyPending) {
        data.writeInt(e.m_19879_());
        data.m_130070_(jobId.rootId());
        data.m_130070_(jobId.jobId());
        data.writeInt(capacity);
        VillagerQuestsContainer.write(data, quests, e.getFlagPos());
        VillagerStatsMenu.write(stats, data);
        VillagerEconomicsMenu.write(econ, data);
        data.writeBoolean(showBlockOfProgressTab);
        data.writeBoolean(jobChangeAlreadyPending);
    }

    private InventoryAndStatusMenu initInventory(int windowId, JobID jobId, Player player, UUID uuid, Collection<Boolean> slotLocks, int invSize, BlockPos flagPos, boolean showBlockOfProgressTab) {
        this.invMenu = new InventoryAndStatusMenu(windowId, (Container)new SimpleContainer(invSize){

            public int m_6893_() {
                return 1;
            }
        }, player.m_150109_(), slotLocks, uuid, jobId, flagPos, showBlockOfProgressTab);
        return this.invMenu;
    }

    public VillagerQuestsContainer initQuestsMenu(int windowId, UUID uuid, Collection<UIQuest> quests, BlockPos flagPos, boolean showBlockOfProgressTab) {
        this.questsMenu = new VillagerQuestsContainer(windowId, uuid, quests, flagPos, showBlockOfProgressTab);
        return this.questsMenu;
    }

    public VillagerStatsMenu initVillagerStatsMenu(int windowId, BlockPos flagPos, VillagerStatsData data, boolean showBlockOfProgressTab) {
        this.statsMenu = new VillagerStatsMenu(windowId, this.entity, flagPos, data, showBlockOfProgressTab);
        return this.statsMenu;
    }

    public VillagerEconomicsMenu initVillagerEconomicsMenu(int windowId, BlockPos flagPos, VillagerEconomicsData data, boolean showBlockOfProgressTab) {
        this.econMenu = new VillagerEconomicsMenu(windowId, this.entity, flagPos, data, showBlockOfProgressTab);
        return this.econMenu;
    }
}

