/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui;

import ca.bradj.questown.core.init.MenuTypesInit;
import ca.bradj.questown.gui.AbstractTabbedVillagerMenu;
import ca.bradj.questown.gui.VillagerMenus;
import ca.bradj.questown.gui.VillagerTabs;
import ca.bradj.questown.gui.VillagerTabsEmbedding;
import ca.bradj.questown.jobs.IStatus;
import ca.bradj.questown.mobs.visitor.VisitorMobEntity;
import ca.bradj.questown.town.VillagerStatsData;
import java.util.Collection;
import java.util.Stack;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;

public class VillagerStatsMenu
extends AbstractTabbedVillagerMenu
implements Consumer<VillagerStatsData>,
VillagerTabsEmbedding {
    private static final Collection<String> ENABLED_TABS = VillagerTabs.except("stats");
    private final DataSlot fullnessSlot;
    private final DataSlot damageSlot;
    private final DataSlot moodSlot;
    private final DataSlot experienceSlot;
    private final DataSlot experienceTargetSlot;
    private final Stack<Runnable> closers = new Stack();
    private final boolean showBlockOfProgressTab;

    public static VillagerStatsMenu ForClientSide(int windowId, Inventory inv, FriendlyByteBuf buf) {
        VillagerMenus menus = VillagerMenus.fromNetwork(windowId, inv.f_35978_, buf);
        return menus.statsMenu;
    }

    public <S extends IStatus<S>> VillagerStatsMenu(int windowId, VisitorMobEntity entity, BlockPos flagPos, VillagerStatsData initialData, boolean showBlockOfProgressTab) {
        super((MenuType)MenuTypesInit.VILLAGER_STATS.get(), null, null, windowId, flagPos, entity.m_20148_());
        this.showBlockOfProgressTab = showBlockOfProgressTab;
        this.fullnessSlot = DataSlot.m_39401_();
        this.m_38895_(this.fullnessSlot);
        this.fullnessSlot.m_6422_((int)(initialData.fullnessPercent() * 100.0f));
        this.experienceSlot = DataSlot.m_39401_();
        this.m_38895_(this.experienceSlot);
        this.experienceSlot.m_6422_(initialData.experienceValue());
        this.experienceTargetSlot = DataSlot.m_39401_();
        this.m_38895_(this.experienceTargetSlot);
        this.experienceTargetSlot.m_6422_(initialData.experienceTarget());
        this.moodSlot = DataSlot.m_39401_();
        this.m_38895_(this.moodSlot);
        this.moodSlot.m_6422_((int)(initialData.moodPercent() * 100.0f));
        this.damageSlot = DataSlot.m_39401_();
        this.m_38895_(this.damageSlot);
        this.damageSlot.m_6422_((int)(initialData.damageLevelPercent() * 100.0f));
        entity.addStatsListener(this);
        this.closers.add(() -> entity.removeStatsListener(this));
    }

    public static VillagerStatsData read(FriendlyByteBuf buf) {
        return new VillagerStatsData(buf.readFloat(), buf.readInt(), buf.readInt(), buf.readFloat(), buf.readFloat());
    }

    public static void write(VillagerStatsData data, FriendlyByteBuf buf) {
        buf.writeFloat(data.fullnessPercent());
        buf.writeInt(data.experienceValue());
        buf.writeInt(data.experienceTarget());
        buf.writeFloat(data.moodPercent());
        buf.writeFloat(data.damageLevelPercent());
    }

    @Override
    public ItemStack m_7648_(Player player, int i) {
        return ItemStack.f_41583_;
    }

    @Override
    public boolean m_6875_(Player p_38874_) {
        return true;
    }

    @Override
    public void onClose() {
        this.closers.forEach(Runnable::run);
    }

    @Override
    public void accept(VillagerStatsData villagerStatsData) {
        int fullness = (int)(100.0f * villagerStatsData.fullnessPercent());
        this.fullnessSlot.m_6422_(fullness);
        int damage = (int)(100.0f * villagerStatsData.damageLevelPercent());
        this.damageSlot.m_6422_(damage);
        int mood = (int)(100.0f * villagerStatsData.moodPercent());
        this.moodSlot.m_6422_(mood);
    }

    public int getFullnessPercent() {
        return this.fullnessSlot.m_6501_();
    }

    public int getDamageLevel() {
        return this.damageSlot.m_6501_();
    }

    public int getMoodPercent() {
        return this.moodSlot.m_6501_();
    }

    @Override
    public Collection<String> getEnabledTabs() {
        return ENABLED_TABS;
    }

    @Override
    public boolean showBlockOfProgressTab() {
        return this.showBlockOfProgressTab;
    }

    public int getExperienceValue() {
        return this.experienceSlot.m_6501_();
    }

    public int getExperienceTarget() {
        return this.experienceTargetSlot.m_6501_();
    }
}

