/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui;

import ca.bradj.questown.core.Config;
import ca.bradj.questown.gui.RenderContext;
import ca.bradj.questown.gui.VillagerStatsMenu;
import ca.bradj.questown.gui.VillagerTabs;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.mc.JEI;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mezz.jei.common.util.ImmutableRect2i;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class VillagerStatsScreen
extends AbstractContainerScreen<VillagerStatsMenu> {
    public static final int HALF_WIDTH = 82;
    private static final int backgroundWidth = 176;
    private static final int backgroundHeight = 166;
    private final JEI.NineNine background;
    private final VillagerTabs tabs;
    private ImmutableRect2i expBar = new ImmutableRect2i(0, 0, 0, 0);
    private ImmutableRect2i hngBar = new ImmutableRect2i(0, 0, 0, 0);
    private ImmutableRect2i moodBar = new ImmutableRect2i(0, 0, 0, 0);
    private ImmutableRect2i dmgBar = new ImmutableRect2i(0, 0, 0, 0);

    public VillagerStatsScreen(VillagerStatsMenu menu, Inventory playerInv, Component title) {
        super((AbstractContainerMenu)menu, playerInv, title);
        this.f_97726_ = 256;
        this.f_97727_ = 220;
        this.background = JEI.getRecipeGuiBackground();
        this.tabs = VillagerTabs.forMenu(menu);
    }

    public void m_7379_() {
        super.m_7379_();
        ((VillagerStatsMenu)this.f_97732_).onClose();
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 81) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    protected void m_7027_(PoseStack p_97808_, int p_97809_, int p_97810_) {
    }

    protected void m_7025_(PoseStack stack, int mouseX, int mouseY) {
        int bgX = (this.f_96543_ - 176) / 2;
        int bgY = (this.f_96544_ - 166) / 2;
        if (this.tabs.renderTooltip(bgX, bgY, mouseX, mouseY, key -> super.m_96602_(stack, Compat.translatable(key), mouseX, mouseY))) {
            return;
        }
        if (JEI.isCoordInBox(mouseX, mouseY, this.expBar)) {
            super.m_96602_(stack, (Component)Compat.translatable("menu.common.stat_tooltip", Compat.translatable("menu.villager_stats.experience"), ((VillagerStatsMenu)this.f_97732_).getExperienceValue(), ((VillagerStatsMenu)this.f_97732_).getExperienceTarget()), mouseX, mouseY);
            return;
        }
        if (JEI.isCoordInBox(mouseX, mouseY, this.hngBar)) {
            super.m_96602_(stack, (Component)Compat.translatable("menu.common.stat_tooltip", Compat.translatable("menu.villager_stats.hunger"), ((VillagerStatsMenu)this.f_97732_).getFullnessPercent() * 100, 100), mouseX, mouseY);
            return;
        }
        if (JEI.isCoordInBox(mouseX, mouseY, this.moodBar)) {
            super.m_96602_(stack, (Component)Compat.translatable("menu.common.stat_tooltip", Compat.translatable("menu.villager_stats.mood"), ((VillagerStatsMenu)this.f_97732_).getMoodPercent() * 100, 100), mouseX, mouseY);
            return;
        }
        if (JEI.isCoordInBox(mouseX, mouseY, this.dmgBar)) {
            super.m_96602_(stack, (Component)Compat.translatable("menu.common.stat_tooltip", Compat.translatable("menu.villager_stats.damage"), ((VillagerStatsMenu)this.f_97732_).getDamageLevel() * 100, 100), mouseX, mouseY);
            return;
        }
        super.m_7025_(stack, mouseX, mouseY);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        int position = 0;
        this.expBar = this.renderExperience(poseStack, position);
        ++position;
        ++position;
        if (((Boolean)Config.HUNGER_ENABLED.get()).booleanValue()) {
            this.hngBar = this.renderHunger(poseStack, position);
            ++position;
        }
        this.m_7025_(poseStack, mouseX, mouseY);
    }

    private ImmutableRect2i renderExperience(PoseStack stack, int position) {
        Component title = Compat.translatable("menu.villager_stats.experience");
        return this.renderBar(stack, position, title, (int)(100.0f * (float)((VillagerStatsMenu)this.f_97732_).getExperienceValue() / (float)((VillagerStatsMenu)this.f_97732_).getExperienceTarget()));
    }

    private void renderMood(PoseStack stack, int position) {
        Component title = Compat.translatable("menu.villager_stats.mood");
        this.renderBar(stack, position, title, ((VillagerStatsMenu)this.f_97732_).getMoodPercent());
    }

    private ImmutableRect2i renderHunger(PoseStack stack, int position) {
        int fullnessPercent = ((VillagerStatsMenu)this.f_97732_).getFullnessPercent();
        Component title = Compat.translatable("menu.villager_stats.hunger");
        return this.renderBar(stack, position, title, fullnessPercent);
    }

    private ImmutableRect2i renderDamage(PoseStack stack, int position) {
        int damageLevel = ((VillagerStatsMenu)this.f_97732_).getDamageLevel();
        Component title = Compat.translatable("menu.villager_stats.damage");
        return this.renderBar(stack, position, title, damageLevel);
    }

    private ImmutableRect2i renderBar(PoseStack stack, int index, Component title, int fullnessPercent) {
        int bgX = (this.f_96543_ - 176) / 2;
        int bxY = (this.f_96544_ - 166) / 2;
        this.f_96547_.m_92889_(stack, title, (float)(bgX + 8), (float)((bxY += 25 * index) + 16), 0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("textures/gui/icons.png"));
        int x = 8 + bgX;
        int y = 28 + bxY;
        int height = 5;
        int barLeftX = x - 1;
        VillagerStatsScreen.m_93143_((PoseStack)stack, (int)barLeftX, (int)y, (int)0, (float)0.0f, (float)64.0f, (int)82, (int)height, (int)256, (int)256);
        VillagerStatsScreen.m_93143_((PoseStack)stack, (int)(x + 78), (int)y, (int)0, (float)100.0f, (float)64.0f, (int)82, (int)height, (int)256, (int)256);
        float fP = (float)fullnessPercent / 100.0f;
        int greenY = 69;
        int leftWidth = (int)(82.0 * (2.0 * Math.min(0.5, (double)fP)));
        int rightWidth = (int)(82.0 * (2.0 * Math.min(0.5, (double)fP - 0.5)));
        VillagerStatsScreen.m_93143_((PoseStack)stack, (int)barLeftX, (int)y, (int)0, (float)0.0f, (float)greenY, (int)leftWidth, (int)height, (int)256, (int)256);
        VillagerStatsScreen.m_93143_((PoseStack)stack, (int)(x + 78), (int)y, (int)0, (float)100.0f, (float)greenY, (int)rightWidth, (int)height, (int)256, (int)256);
        return new ImmutableRect2i(barLeftX, y, 164, height);
    }

    protected void m_7286_(PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        int x = (this.f_96543_ - 176) / 2;
        int y = (this.f_96544_ - 166) / 2;
        this.background.draw(stack, x, y, 176, 166);
        this.tabs.draw(new RenderContext(this.f_96542_, stack), x, y);
    }

    public boolean m_7043_() {
        return false;
    }

    public List<Rect2i> getExtraAreas() {
        int x = (this.f_96543_ - 176) / 2;
        int y = (this.f_96544_ - 166) / 2;
        return ImmutableList.of((Object)new Rect2i(x, y, 176, 166));
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int p_97750_) {
        int x = (this.f_96543_ - 176) / 2;
        int y = (this.f_96544_ - 166) / 2;
        this.tabs.mouseClicked(x, y, mouseX, mouseY);
        return super.m_6375_(mouseX, mouseY, p_97750_);
    }
}

