/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui;

import ca.bradj.questown.Questown;
import ca.bradj.questown.core.init.items.ItemsInit;
import ca.bradj.questown.core.network.OpenVillagerMenuMessage;
import ca.bradj.questown.core.network.QuestownNetwork;
import ca.bradj.questown.gui.RenderContext;
import ca.bradj.questown.gui.RenderUtil;
import ca.bradj.questown.gui.SubUI;
import ca.bradj.questown.gui.Tab;
import ca.bradj.questown.gui.Tabs;
import ca.bradj.questown.gui.VillagerTabsEmbedding;
import ca.bradj.questown.mc.Util;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;

public class VillagerTabs
extends Tabs
implements SubUI {
    public VillagerTabs(@Nullable Runnable invScreenFn, @Nullable Runnable qScreenFn, @Nullable Runnable sScreenFn, @Nullable Runnable skillScreenFn, @Nullable Runnable changeRootScreenFn, @Nullable Runnable econScreenFn, @Nullable Runnable bopScreenFn, boolean showBopTab) {
        super(VillagerTabs.build(invScreenFn, qScreenFn, sScreenFn, skillScreenFn, changeRootScreenFn, econScreenFn, bopScreenFn, showBopTab));
    }

    @NotNull
    private static ImmutableList<Tab> build(@Nullable Runnable invScreenFn, @Nullable Runnable qScreenFn, @Nullable Runnable sScreenFn, @Nullable Runnable skillScreenFn, @Nullable Runnable changeRootScreenFn, @Nullable Runnable econScreenFn, @Nullable Runnable bopScreenFn, boolean showBopTab) {
        ImmutableList.Builder b = ImmutableList.builder();
        b.add((Object)new Tab((TriConsumer<RenderContext, Integer, Integer>)((TriConsumer)(rc, x, y) -> rc.itemRenderer().m_115203_(Items.f_42009_.m_7968_(), x + 10, y + 7)), VillagerTabs.setScreen(invScreenFn), "tooltips.inventory", invScreenFn == null));
        b.add((Object)new Tab((TriConsumer<RenderContext, Integer, Integer>)((TriConsumer)(rc, x, y) -> {
            int txBefore = RenderSystem.m_157203_((int)0);
            Util.blitTab(rc.stack(), x, y, 0);
            RenderSystem.m_157453_((int)0, (int)txBefore);
        }), VillagerTabs.setScreen(econScreenFn), "tooltips.economics", econScreenFn == null));
        b.add((Object)new Tab((TriConsumer<RenderContext, Integer, Integer>)((TriConsumer)(rc, x, y) -> {
            int txBefore = RenderSystem.m_157203_((int)0);
            RenderSystem.m_157456_((int)0, (ResourceLocation)Questown.ResourceLocation("textures/menu/gatherer/menu.png"));
            GuiComponent.m_93143_((PoseStack)rc.stack(), (int)(x + 13), (int)(y + 11), (int)0, (float)0.0f, (float)0.0f, (int)9, (int)9, (int)256, (int)256);
            RenderSystem.m_157453_((int)0, (int)txBefore);
        }), VillagerTabs.setScreen(sScreenFn), "tooltips.stats", sScreenFn == null));
        b.add((Object)new Tab((TriConsumer<RenderContext, Integer, Integer>)((TriConsumer)(rc, x, y) -> {
            int txBefore = RenderSystem.m_157203_((int)0);
            RenderSystem.m_157456_((int)0, (ResourceLocation)Questown.ResourceLocation("textures/menu/gatherer/menu.png"));
            PoseStack stack = rc.stack();
            stack.m_85836_();
            stack.m_85841_(0.5f, 0.5f, 1.0f);
            int adjustedX = (int)((float)(x + 11) / 0.5f);
            int adjustedY = (int)((float)(y + 7) / 0.5f);
            GuiComponent.m_93143_((PoseStack)stack, (int)adjustedX, (int)adjustedY, (int)0, (float)17.0f, (float)7.0f, (int)30, (int)30, (int)256, (int)256);
            stack.m_85849_();
            RenderSystem.m_157453_((int)0, (int)txBefore);
        }), VillagerTabs.setScreen(skillScreenFn), "tooltips.skills", skillScreenFn == null));
        b.add((Object)new Tab((TriConsumer<RenderContext, Integer, Integer>)((TriConsumer)(rc, x, y) -> {
            int txBefore = RenderSystem.m_157203_((int)0);
            Util.blitTab(rc.stack(), x, y, 1);
            RenderSystem.m_157453_((int)0, (int)txBefore);
        }), VillagerTabs.setScreen(changeRootScreenFn), "tooltips.change_root", skillScreenFn == null));
        b.add((Object)new Tab((TriConsumer<RenderContext, Integer, Integer>)((TriConsumer)(rc, x, y) -> rc.itemRenderer().m_115203_(Items.f_42517_.m_7968_(), x + 10, y + 7)), VillagerTabs.setScreen(qScreenFn), "tooltips.quests", qScreenFn == null));
        if (showBopTab) {
            b.add((Object)new Tab((TriConsumer<RenderContext, Integer, Integer>)((TriConsumer)(rc, x, y) -> RenderUtil.renderItemScaled(rc.itemRenderer(), 2, ((Item)ItemsInit.BLOCK_OF_PROGRESS.get()).m_7968_(), x + 10, y + 7)), VillagerTabs.setScreen(bopScreenFn), "tooltips.blocks_of_progress", bopScreenFn == null));
        }
        return b.build();
    }

    private static Runnable setScreen(Runnable s) {
        if (s == null) {
            return () -> {};
        }
        return s;
    }

    public static Runnable makeOpenFn(BlockPos fp, UUID gathererId, String type) {
        Runnable fn = () -> QuestownNetwork.CHANNEL.sendToServer((Object)new OpenVillagerMenuMessage(fp.m_123341_(), fp.m_123342_(), fp.m_123343_(), gathererId, type));
        return fn;
    }

    public static VillagerTabs forMenu(VillagerTabsEmbedding menu) {
        Collection<String> enabledTabs = menu.getEnabledTabs();
        Function<String, Runnable> factory = typ -> {
            if (enabledTabs.contains(typ)) {
                return VillagerTabs.makeOpenFn(menu.getFlagPos(), menu.getVillagerUUID(), typ);
            }
            return null;
        };
        return new VillagerTabs(factory.apply("inventory"), factory.apply("quests"), factory.apply("stats"), factory.apply("skills"), factory.apply("change_root"), factory.apply("economics"), factory.apply("bop"), menu.showBlockOfProgressTab());
    }

    public static Collection<String> except(String except) {
        ImmutableList all = ImmutableList.of((Object)"inventory", (Object)"bop", (Object)"quests", (Object)"stats", (Object)"skills", (Object)"change_root", (Object)"economics");
        return ImmutableList.copyOf(all.stream().filter(v -> !v.equals(except)).toList());
    }

    public static Collection<String> all() {
        return VillagerTabs.except("");
    }
}

