/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui.town.status;

import ca.bradj.questown.core.UtilClean;
import ca.bradj.questown.core.network.OpenJobMessage;
import ca.bradj.questown.core.network.QuestownNetwork;
import ca.bradj.questown.gui.AbstractPagedCardScreen;
import ca.bradj.questown.gui.FlagTabs;
import ca.bradj.questown.gui.MultiStatusMenu;
import ca.bradj.questown.gui.PagedCardScreen;
import ca.bradj.questown.gui.RenderContext;
import ca.bradj.questown.gui.StatusPacket;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.mc.Util;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class MultiStatusScreen
extends AbstractPagedCardScreen<MultiStatusMenu, UUID> {
    private final Map<UUID, Collection<StatusPacket>> statusSmoothingQueue = new HashMap<UUID, Collection<StatusPacket>>();
    private final FlagTabs tabs;
    static SyncedData syncedData = new SyncedData(new HashMap<UUID, StatusPacket>(), new HashMap<UUID, ImmutableList<Item>>());

    public MultiStatusScreen(MultiStatusMenu menu, Inventory playerInv, Component title) {
        super(menu, new Inventory(null){

            public Component m_5446_() {
                return Compat.literal("");
            }
        }, Compat.literal(""));
        this.tabs = FlagTabs.forMenu(menu);
    }

    @Override
    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        int bgX = (this.f_96543_ - 176) / 2;
        int bgY = (this.f_96544_ - super.backgroundHeight()) / 2;
        super.m_7333_(stack);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        this.tabs.draw(new RenderContext(this.f_96542_, stack), bgX, bgY);
        this.m_7025_(stack, mouseX, mouseY);
    }

    @Override
    protected ImmutableList<UUID> cardsData() {
        return ImmutableList.copyOf(MultiStatusScreen.syncedData.villagerStatuses.keySet());
    }

    @Override
    protected List<Component> renderCardContent(PoseStack poseStack, PagedCardScreen.Card<UUID> card, int mouseX, int mouseY) {
        this.renderStatus(poseStack, card.coords(), card.data());
        this.renderInventory(card.coords(), card.data());
        this.renderFace(poseStack, card.coords(), card.data());
        return null;
    }

    private void renderInventory(PagedCardScreen.CardCoordinates coords, UUID uuid) {
        int iconX = coords.leftXPadded();
        Collection items = (Collection)MultiStatusScreen.syncedData.items.get(uuid);
        for (Item item : items) {
            int destX = iconX + 1;
            int destY = coords.topYPadded() + 10;
            this.f_96542_.m_115203_(new ItemStack((ItemLike)item), destX, destY);
            iconX += 16;
        }
    }

    private void renderFace(PoseStack stack, PagedCardScreen.CardCoordinates coords, UUID uuid) {
        int x = coords.leftXPadded();
        int destY = coords.topYPadded();
        Util.blitFace(stack, uuid, x, destY);
        int nameX = x + 8 + 4;
        Compat.drawDarkText(this.f_96547_, stack, Compat.translatable(MultiStatusScreen.syncedData.villagerStatuses.get(uuid).jobId().rootId()), nameX, destY);
    }

    private void renderStatus(PoseStack stack, PagedCardScreen.CardCoordinates coords, UUID uuid) {
        int drawWidth = 32;
        int drawHeight = 32;
        int texWidth = 32;
        int texHeight = 32;
        int destX = MultiStatusScreen.getStatusX(coords);
        int destY = MultiStatusScreen.getStatusY(coords);
        @NotNull StatusPacket status = this.getSmoothedStatus(uuid);
        RenderSystem.m_157456_((int)0, (ResourceLocation)status.image());
        MultiStatusScreen.m_93133_((PoseStack)stack, (int)destX, (int)destY, (float)0.0f, (float)0.0f, (int)drawWidth, (int)drawHeight, (int)texWidth, (int)texHeight);
    }

    private static int getStatusY(PagedCardScreen.CardCoordinates coords) {
        return coords.topYPadded() - 5;
    }

    private static int getStatusX(PagedCardScreen.CardCoordinates coords) {
        return coords.rightXPadded() - 32;
    }

    @NotNull
    private StatusPacket getSmoothedStatus(UUID villagerUUID) {
        Collection<StatusPacket> q = UtilClean.getOrDefaultCollection(this.statusSmoothingQueue, villagerUUID, EvictingQueue.create((int)5), true);
        q.add(MultiStatusScreen.syncedData.villagerStatuses.get(villagerUUID));
        this.statusSmoothingQueue.put(villagerUUID, q);
        HashMap<StatusPacket, Integer> counter = new HashMap<StatusPacket, Integer>();
        for (StatusPacket iStatus : q) {
            counter.compute(iStatus, (ignored, oldCt) -> oldCt == null ? 1 : oldCt + 1);
        }
        return counter.entrySet().stream().max(Comparator.comparingInt(Map.Entry::getValue)).map(Map.Entry::getKey).orElseThrow();
    }

    protected void m_7025_(@NotNull PoseStack stack, int mouseX, int mouseY) {
        int bgX = (this.f_96543_ - 176) / 2;
        int bgY = (this.f_96544_ - this.backgroundHeight()) / 2;
        if (this.tabs.renderTooltip(bgX, bgY, mouseX, mouseY, key -> super.m_96602_(stack, Compat.translatable(key), mouseX, mouseY))) {
            return;
        }
        bgY = bgY + 10 + 10;
        int leftX = bgX + 176 - 16 - 32;
        int topY = bgY + 16;
        int rightX = leftX + 32;
        int botY = topY + 32;
        ImmutableList<UUID> uuids = this.cardsData();
        for (int i = 0; i < uuids.size(); ++i) {
            if (mouseX < leftX || mouseX > rightX || mouseY < topY + i * this.cardHeight || mouseY > botY + i * this.cardHeight) continue;
            UUID villagerUUID = (UUID)uuids.get(i);
            @NotNull StatusPacket status = this.getSmoothedStatus(villagerUUID);
            super.m_169388_(stack, status.texts(), Optional.empty(), mouseX, mouseY);
            return;
        }
        super.m_7025_(stack, mouseX, mouseY);
    }

    public boolean m_6375_(double p_97748_, double p_97749_, int p_97750_) {
        int bgX = (this.f_96543_ - 176) / 2;
        int bgY = (this.f_96544_ - this.backgroundHeight()) / 2;
        this.tabs.mouseClicked(bgX, bgY, p_97748_, p_97749_);
        for (PagedCardScreen.Card v : this.cards()) {
            int y;
            PagedCardScreen.CardCoordinates coords = v.coords();
            int x = MultiStatusScreen.getStatusX(coords);
            if (!UtilClean.isCoordInBox(p_97748_, p_97749_, x, y = MultiStatusScreen.getStatusY(v.coords()), 32, 32)) continue;
            QuestownNetwork.CHANNEL.sendToServer((Object)new OpenJobMessage(((MultiStatusMenu)this.f_97732_).getFlagInfo().flagPos(), syncedData.getJob((UUID)v.data())));
            return true;
        }
        return super.m_6375_(p_97748_, p_97749_, p_97750_);
    }

    @Override
    protected void setRenderColorForCard(UUID uuid) {
    }

    public record SyncedData(Map<UUID, StatusPacket> villagerStatuses, Map<UUID, ImmutableList<Item>> items) {
        public JobID getJob(UUID uuid) {
            return Util.orNull(this.villagerStatuses.get(uuid), StatusPacket::jobId);
        }
    }
}

