/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui.villager.advancements;

import ca.bradj.questown.core.network.ChangeVillagerJobMessage;
import ca.bradj.questown.core.network.QuestownNetwork;
import ca.bradj.questown.core.network.UnlockJobMessage;
import ca.bradj.questown.gui.RenderContext;
import ca.bradj.questown.gui.VillagerTabs;
import ca.bradj.questown.gui.VillagerTabsEmbedding;
import ca.bradj.questown.gui.villager.advancements.VillagerAdvancements;
import ca.bradj.questown.gui.villager.advancements.VillagerAdvancementsContent;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.mc.Compat;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;

public class VillagerAdvancementsScreen
extends Screen {
    private static final ResourceLocation WINDOW_LOCATION = new ResourceLocation("textures/gui/advancements/window.png");
    private static final Component VERY_SAD_LABEL = Compat.translatable("advancements.sad_label");
    private static final Component NO_ADVANCEMENTS_LABEL = Compat.translatable("advancements.empty");
    private static final Component TITLE = Compat.translatable("menu.jobs");
    public static final int backgroundWidth = 252;
    public static final int backgroundHeight = 140;
    private final BlockPos flagPos;
    private final UUID villagerUUID;
    private final VillagerAdvancementsContent content;
    private final VillagerTabs tabs;
    private boolean isScrolling;

    public VillagerAdvancementsScreen(final BlockPos flagPos, final UUID villagerUUID, Collection<JobID> unlockedJobs, Collection<JobID> unlockableJobs, JobID currentJob, final boolean showBlockOfProgressTab) {
        super(Compat.literal(""));
        DisplayInfo displayInfo = new DisplayInfo(Items.f_42682_.m_7968_(), Compat.literal("test"), Compat.literal("test2"), new ResourceLocation("textures/gui/advancements/backgrounds/stone.png"), FrameType.TASK, false, false, false);
        this.content = new VillagerAdvancementsContent(Minecraft.m_91087_(), this, displayInfo, currentJob, unlockedJobs, unlockableJobs, currentJob == null || VillagerAdvancementsScreen.isCreative() ? VillagerAdvancements.all() : VillagerAdvancements.all().branch(currentJob.rootId()));
        this.flagPos = flagPos;
        this.villagerUUID = villagerUUID;
        this.tabs = VillagerTabs.forMenu(new VillagerTabsEmbedding(){

            @Override
            public Collection<String> getEnabledTabs() {
                return VillagerTabs.all();
            }

            @Override
            public BlockPos getFlagPos() {
                return flagPos;
            }

            @Override
            public UUID getVillagerUUID() {
                return villagerUUID;
            }

            @Override
            public boolean showBlockOfProgressTab() {
                return showBlockOfProgressTab;
            }
        });
    }

    private static boolean isCreative() {
        return Minecraft.m_91087_().f_91074_.m_7500_();
    }

    protected void m_7856_() {
    }

    public void m_6305_(PoseStack p_97361_, int p_97362_, int p_97363_, float p_97364_) {
        int i = (this.f_96543_ - 252) / 2;
        int j = (this.f_96544_ - 140) / 2;
        this.m_7333_(p_97361_);
        this.renderInside(p_97361_, p_97362_, p_97363_, i, j);
        this.renderWindow(p_97361_, i, j);
        this.renderTooltips(p_97361_, p_97362_, p_97363_, i, j);
    }

    public boolean m_7979_(double p_97347_, double p_97348_, int p_97349_, double p_97350_, double p_97351_) {
        if (p_97349_ != 0) {
            this.isScrolling = false;
            return false;
        }
        if (!this.isScrolling) {
            this.isScrolling = true;
        } else if (this.content != null) {
            this.content.scroll(p_97350_, p_97351_);
        }
        return true;
    }

    public boolean m_6050_(double p_94686_, double p_94687_, double p_94688_) {
        this.content.scroll(0.0, p_94688_ * 3.0);
        return super.m_6050_(p_94686_, p_94687_, p_94688_);
    }

    private void renderInside(PoseStack p_97374_, int p_97375_, int p_97376_, int p_97377_, int p_97378_) {
        VillagerAdvancementsContent advancementtab = this.content;
        if (advancementtab == null) {
            VillagerAdvancementsScreen.m_93172_((PoseStack)p_97374_, (int)(p_97377_ + 9), (int)(p_97378_ + 18), (int)(p_97377_ + 9 + 234), (int)(p_97378_ + 18 + 113), (int)-16777216);
            int i = p_97377_ + 9 + 117;
            VillagerAdvancementsScreen.m_93215_((PoseStack)p_97374_, (Font)this.f_96547_, (Component)NO_ADVANCEMENTS_LABEL, (int)i, (int)(p_97378_ + 18 + 56 - 4), (int)-1);
            VillagerAdvancementsScreen.m_93215_((PoseStack)p_97374_, (Font)this.f_96547_, (Component)VERY_SAD_LABEL, (int)i, (int)(p_97378_ + 18 + 113 - 9), (int)-1);
        } else {
            PoseStack posestack = RenderSystem.m_157191_();
            posestack.m_85836_();
            posestack.m_85837_((double)(p_97377_ + 9), (double)(p_97378_ + 18), 0.0);
            RenderSystem.m_157182_();
            advancementtab.drawContents(p_97374_);
            posestack.m_85849_();
            RenderSystem.m_157182_();
            RenderSystem.m_69456_((int)515);
            RenderSystem.m_69465_();
        }
    }

    public void renderWindow(PoseStack p_97357_, int p_97358_, int p_97359_) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)WINDOW_LOCATION);
        this.m_93228_(p_97357_, p_97358_, p_97359_, 0, 0, 252, 140);
        this.f_96547_.m_92889_(p_97357_, TITLE, (float)(p_97358_ + 8), (float)(p_97359_ + 6), 0x404040);
        int bgX = (this.f_96543_ - 252) / 2;
        int bgY = (this.f_96544_ - 140) / 2;
        this.tabs.draw(new RenderContext(this.f_96542_, p_97357_), bgX, bgY);
    }

    private void renderTooltips(PoseStack p_97382_, int p_97383_, int p_97384_, int mouseX, int mouseY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.content != null) {
            PoseStack posestack = RenderSystem.m_157191_();
            posestack.m_85836_();
            posestack.m_85837_((double)(mouseX + 9), (double)(mouseY + 18), 400.0);
            RenderSystem.m_157182_();
            RenderSystem.m_69482_();
            this.content.drawTooltips(p_97382_, p_97383_ - mouseX - 9, p_97384_ - mouseY - 18, mouseX, mouseY);
            RenderSystem.m_69465_();
            posestack.m_85849_();
            RenderSystem.m_157182_();
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int p_94697_) {
        JobID id = this.content.getClickJob(mouseY, mouseX);
        if (id == null) {
            int bgX = (this.f_96543_ - 252) / 2;
            int bgY = (this.f_96544_ - 140) / 2;
            this.tabs.mouseClicked(bgX, bgY, mouseX, mouseY);
            return super.m_6375_(mouseX, mouseY, p_94697_);
        }
        if (this.content.isLocked(id)) {
            QuestownNetwork.CHANNEL.sendToServer((Object)new UnlockJobMessage(this.flagPos, this.villagerUUID, id, true));
            return true;
        }
        this.changeJobAndClose(id);
        return true;
    }

    private void changeJobAndClose(JobID id) {
        QuestownNetwork.CHANNEL.sendToServer((Object)new ChangeVillagerJobMessage(this.flagPos.m_123341_(), this.flagPos.m_123342_(), this.flagPos.m_123343_(), this.villagerUUID, id, true));
        this.f_96541_.m_91152_((Screen)null);
    }
}

