/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui.villager.advancements;

import ca.bradj.questown.gui.villager.advancements.VillagerAdvancementsContent;
import ca.bradj.questown.jobs.JobID;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class VillagerAdvancementsWidget
extends GuiComponent {
    private static final ResourceLocation WIDGETS_LOCATION = new ResourceLocation("textures/gui/advancements/widgets.png");
    private static final int[] TEST_SPLIT_OFFSETS = new int[]{0, 10, -10, 25, -25};
    private static final int OBTAINED = 0;
    private static final int UNOBTAINED = 1;
    private final VillagerAdvancementsContent tab;
    final DisplayInfo display;
    private final FormattedCharSequence title;
    private final int width;
    private final List<FormattedCharSequence> description;
    private final Minecraft minecraft;
    public final JobID id;
    @Nullable
    public final JobID parentId;
    @Nullable
    private VillagerAdvancementsWidget parent;
    private final List<VillagerAdvancementsWidget> children = Lists.newArrayList();
    private final boolean active;
    private final boolean unlocked;
    private final boolean canUnlock;
    private final int x;
    private final int y;

    public VillagerAdvancementsWidget(VillagerAdvancementsContent p_97255_, Minecraft p_97256_, DisplayInfo p_97258_, JobID id, boolean active, boolean unlocked, @Nullable JobID parentId, boolean canUnlock) {
        this.id = id;
        this.active = active;
        this.unlocked = unlocked;
        this.canUnlock = canUnlock;
        this.parentId = parentId;
        this.tab = p_97255_;
        this.display = p_97258_;
        this.minecraft = p_97256_;
        this.title = Language.m_128107_().m_5536_(p_97256_.f_91062_.m_92854_((FormattedText)p_97258_.m_14977_(), 163));
        this.x = Mth.m_14143_((float)(p_97258_.m_14993_() * 28.0f));
        this.y = Mth.m_14143_((float)(p_97258_.m_14994_() * 27.0f));
        int l = 29 + p_97256_.f_91062_.m_92724_(this.title);
        this.description = Language.m_128107_().m_128112_(this.findOptimalLines((Component)ComponentUtils.m_130750_((MutableComponent)p_97258_.m_14985_().m_6881_(), (Style)Style.f_131099_.m_131140_(p_97258_.m_14992_().m_15552_())), l));
        for (FormattedCharSequence formattedcharsequence : this.description) {
            l = Math.max(l, p_97256_.f_91062_.m_92724_(formattedcharsequence));
        }
        this.width = l + 3 + 5;
    }

    private static float getMaxWidth(StringSplitter p_97304_, List<FormattedText> p_97305_) {
        Stream var10000 = p_97305_.stream();
        Objects.requireNonNull(p_97304_);
        return (float)var10000.mapToDouble(arg_0 -> ((StringSplitter)p_97304_).m_92384_(arg_0)).max().orElse(0.0);
    }

    private List<FormattedText> findOptimalLines(Component p_97309_, int p_97310_) {
        StringSplitter stringsplitter = this.minecraft.f_91062_.m_92865_();
        List list = null;
        float f = Float.MAX_VALUE;
        for (int i : TEST_SPLIT_OFFSETS) {
            List list1 = stringsplitter.m_92414_((FormattedText)p_97309_, p_97310_ - i, Style.f_131099_);
            float f1 = Math.abs(VillagerAdvancementsWidget.getMaxWidth(stringsplitter, list1) - (float)p_97310_);
            if (f1 <= 10.0f) {
                return list1;
            }
            if (!(f1 < f)) continue;
            f = f1;
            list = list1;
        }
        return list;
    }

    @Nullable
    private VillagerAdvancementsWidget getFirstVisibleParent(JobID p_97312_) {
        return this.tab.getWidget(p_97312_);
    }

    public void drawConnectivity(PoseStack p_97299_, int p_97300_, int p_97301_, boolean p_97302_) {
        if (!(this.minecraft.f_91074_.m_7500_() || this.unlocked || this.canUnlock)) {
            return;
        }
        if (this.parent != null) {
            int j1;
            int i = p_97300_ + this.parent.x + 13;
            int j = p_97300_ + this.parent.x + 26 + 4;
            int k = p_97301_ + this.parent.y + 13;
            int l = p_97300_ + this.x + 13;
            int i1 = p_97301_ + this.y + 13;
            int n = j1 = p_97302_ ? -16777216 : -1;
            if (p_97302_) {
                this.m_93154_(p_97299_, j, i, k - 1, j1);
                this.m_93154_(p_97299_, j + 1, i, k, j1);
                this.m_93154_(p_97299_, j, i, k + 1, j1);
                this.m_93154_(p_97299_, l, j - 1, i1 - 1, j1);
                this.m_93154_(p_97299_, l, j - 1, i1, j1);
                this.m_93154_(p_97299_, l, j - 1, i1 + 1, j1);
                this.m_93222_(p_97299_, j - 1, i1, k, j1);
                this.m_93222_(p_97299_, j + 1, i1, k, j1);
            } else {
                this.m_93154_(p_97299_, j, i, k, j1);
                this.m_93154_(p_97299_, l, j, i1, j1);
                this.m_93222_(p_97299_, j, i1, k, j1);
            }
        }
        for (VillagerAdvancementsWidget advancementwidget : this.children) {
            advancementwidget.drawConnectivity(p_97299_, p_97300_, p_97301_, p_97302_);
        }
    }

    public void draw(PoseStack p_97267_, int p_97268_, int p_97269_) {
        if (!this.display.m_14997_()) {
            int advancementwidgettype = this.active ? 0 : 1;
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)WIDGETS_LOCATION);
            int v1 = 128 + advancementwidgettype * 26;
            int v2 = 26;
            int v3 = 26;
            int x = p_97268_ + this.x + 3;
            int y = p_97269_ + this.y;
            int ft = this.getFrameType();
            if (ft >= 0) {
                this.m_93228_(p_97267_, x, y, ft, v1, v2, v3);
                this.minecraft.m_91291_().m_115218_(this.display.m_14990_(), p_97268_ + this.x + 8, p_97269_ + this.y + 5);
            }
        }
        for (VillagerAdvancementsWidget advancementwidget : this.children) {
            advancementwidget.draw(p_97267_, p_97268_, p_97269_);
        }
    }

    private int getFrameType() {
        int ft = -1;
        if (this.unlocked) {
            ft = FrameType.TASK.m_15551_();
        } else if (this.canUnlock) {
            ft = FrameType.GOAL.m_15551_();
        } else if (this.minecraft.f_91074_.m_7500_()) {
            ft = FrameType.CHALLENGE.m_15551_();
        }
        return ft;
    }

    public void addChild(VillagerAdvancementsWidget p_97307_) {
        this.children.add(p_97307_);
    }

    public void drawHover(PoseStack p_97271_, int p_97272_, int p_97273_, float p_97274_, int p_97275_, int p_97276_) {
        if (!(this.unlocked || this.canUnlock || this.minecraft.f_91074_.m_7500_())) {
            return;
        }
        boolean flag = p_97275_ + p_97272_ + this.x + this.width + 26 >= this.tab.getScreen().f_96543_;
        boolean flag1 = 113 - p_97273_ - this.y - 26 <= 6 + this.description.size() * 9;
        boolean advancementwidgettype = false;
        boolean advancementwidgettype1 = true;
        int advancementwidgettype2 = 1;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)WIDGETS_LOCATION);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        int l = p_97273_ + this.y;
        int i1 = flag ? p_97272_ + this.x - this.width + 26 + 6 : p_97272_ + this.x;
        int j1 = 32 + this.description.size() * 9;
        if (!this.description.isEmpty()) {
            if (flag1) {
                this.render9Sprite(p_97271_, i1, l + 26 - j1, this.width, j1, 10, 200, 26, 0, 52);
            } else {
                this.render9Sprite(p_97271_, i1, l, this.width, j1, 10, 200, 26, 0, 52);
            }
        }
        int texture = this.getFrameType();
        if (this.getFrameType() < 0) {
            return;
        }
        this.m_93228_(p_97271_, p_97272_ + this.x + 3, p_97273_ + this.y, texture, 128 + advancementwidgettype2 * 26, 26, 26);
        if (flag) {
            this.minecraft.f_91062_.m_92744_(p_97271_, this.title, (float)(i1 + 5), (float)(p_97273_ + this.y + 9), -1);
        } else {
            this.minecraft.f_91062_.m_92744_(p_97271_, this.title, (float)(p_97272_ + this.x + 32), (float)(p_97273_ + this.y + 9), -1);
        }
        if (flag1) {
            for (int k1 = 0; k1 < this.description.size(); ++k1) {
                this.minecraft.f_91062_.m_92877_(p_97271_, this.description.get(k1), (float)(i1 + 5), (float)(l + 26 - j1 + 7 + k1 * 9), -5592406);
            }
        } else {
            for (int k1 = 0; k1 < this.description.size(); ++k1) {
                this.minecraft.f_91062_.m_92877_(p_97271_, this.description.get(k1), (float)(i1 + 5), (float)(p_97273_ + this.y + 9 + 17 + k1 * 9), -5592406);
            }
        }
        this.minecraft.m_91291_().m_115218_(this.display.m_14990_(), p_97272_ + this.x + 8, p_97273_ + this.y + 5);
    }

    protected void render9Sprite(PoseStack p_97288_, int p_97289_, int p_97290_, int p_97291_, int p_97292_, int p_97293_, int p_97294_, int p_97295_, int p_97296_, int p_97297_) {
        this.m_93228_(p_97288_, p_97289_, p_97290_, p_97296_, p_97297_, p_97293_, p_97293_);
        this.renderRepeating(p_97288_, p_97289_ + p_97293_, p_97290_, p_97291_ - p_97293_ - p_97293_, p_97293_, p_97296_ + p_97293_, p_97297_, p_97294_ - p_97293_ - p_97293_, p_97295_);
        this.m_93228_(p_97288_, p_97289_ + p_97291_ - p_97293_, p_97290_, p_97296_ + p_97294_ - p_97293_, p_97297_, p_97293_, p_97293_);
        this.m_93228_(p_97288_, p_97289_, p_97290_ + p_97292_ - p_97293_, p_97296_, p_97297_ + p_97295_ - p_97293_, p_97293_, p_97293_);
        this.renderRepeating(p_97288_, p_97289_ + p_97293_, p_97290_ + p_97292_ - p_97293_, p_97291_ - p_97293_ - p_97293_, p_97293_, p_97296_ + p_97293_, p_97297_ + p_97295_ - p_97293_, p_97294_ - p_97293_ - p_97293_, p_97295_);
        this.m_93228_(p_97288_, p_97289_ + p_97291_ - p_97293_, p_97290_ + p_97292_ - p_97293_, p_97296_ + p_97294_ - p_97293_, p_97297_ + p_97295_ - p_97293_, p_97293_, p_97293_);
        this.renderRepeating(p_97288_, p_97289_, p_97290_ + p_97293_, p_97293_, p_97292_ - p_97293_ - p_97293_, p_97296_, p_97297_ + p_97293_, p_97294_, p_97295_ - p_97293_ - p_97293_);
        this.renderRepeating(p_97288_, p_97289_ + p_97293_, p_97290_ + p_97293_, p_97291_ - p_97293_ - p_97293_, p_97292_ - p_97293_ - p_97293_, p_97296_ + p_97293_, p_97297_ + p_97293_, p_97294_ - p_97293_ - p_97293_, p_97295_ - p_97293_ - p_97293_);
        this.renderRepeating(p_97288_, p_97289_ + p_97291_ - p_97293_, p_97290_ + p_97293_, p_97293_, p_97292_ - p_97293_ - p_97293_, p_97296_ + p_97294_ - p_97293_, p_97297_ + p_97293_, p_97294_, p_97295_ - p_97293_ - p_97293_);
    }

    protected void renderRepeating(PoseStack p_97278_, int p_97279_, int p_97280_, int p_97281_, int p_97282_, int p_97283_, int p_97284_, int p_97285_, int p_97286_) {
        for (int i = 0; i < p_97281_; i += p_97285_) {
            int j = p_97279_ + i;
            int k = Math.min(p_97285_, p_97281_ - i);
            for (int l = 0; l < p_97282_; l += p_97286_) {
                int i1 = p_97280_ + l;
                int j1 = Math.min(p_97286_, p_97282_ - l);
                this.m_93228_(p_97278_, j, i1, p_97283_, p_97284_, k, j1);
            }
        }
    }

    public boolean isMouseOver(int p_97260_, int p_97261_, int p_97262_, int p_97263_) {
        if (this.display.m_14997_()) {
            return false;
        }
        int i = p_97260_ + this.x;
        int j = i + 26;
        int k = p_97261_ + this.y;
        int l = k + 26;
        return p_97262_ >= i && p_97262_ <= j && p_97263_ >= k && p_97263_ <= l;
    }

    public void attachToParent() {
        if (this.parent == null && this.parentId != null) {
            this.parent = this.getFirstVisibleParent(this.parentId);
            if (this.parent != null) {
                this.parent.addChild(this);
            }
        }
    }

    public int getY() {
        return this.y;
    }

    public int getX() {
        return this.x;
    }
}

