/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.integration;

import ca.bradj.questown.QT;
import ca.bradj.questown.integration.jobs.BeforeFindJobSiteEvent;
import ca.bradj.questown.integration.jobs.BeforeMaxTicksJobChangeEvent;
import ca.bradj.questown.integration.jobs.BeforeTickEvent;
import ca.bradj.questown.integration.jobs.JobPhaseModifier;
import ca.bradj.questown.integration.jobs.UnsafeVillagerData;
import ca.bradj.questown.jobs.Jobs;
import ca.bradj.questown.jobs.declarative.WithReason;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.mc.Util;
import com.google.common.collect.ImmutableList;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import org.jetbrains.annotations.Nullable;

public class RandomShortLivedWorkSpot
extends JobPhaseModifier {
    private static final String DATA_KEY_WORKSPOT_OVERRIDE = "questown:work_spot_override";
    private static final String DATA_KEY_WORKSPOT_OVERRIDE_UNTIL = "questown:work_spot_override_until";
    private final boolean preferSocial;
    private final int pauseForTicks;

    public RandomShortLivedWorkSpot(boolean preferSocial, int pauseForTicks) {
        this.preferSocial = preferSocial;
        this.pauseForTicks = pauseForTicks;
    }

    public static boolean hasTargetChanged(UnsafeVillagerData currentPosSource, BlockPos vsPos) {
        if (currentPosSource.get(DATA_KEY_WORKSPOT_OVERRIDE) != null) {
            @Nullable BlockPos ovr = RandomShortLivedWorkSpot.getOverride(currentPosSource, false);
            return ovr != null && !ovr.equals((Object)vsPos);
        }
        return false;
    }

    @Override
    public void beforeTick(BeforeTickEvent bxEvent) {
        super.beforeTick(bxEvent);
        UnsafeVillagerData villagerData = bxEvent.villagerData();
        ServerLevel serverLevel = bxEvent.level().get();
        @Nullable BlockPos override = RandomShortLivedWorkSpot.getOverride(villagerData, false);
        if (override == null) {
            this.choosePosAndStoreOnVillager(bxEvent.otherVillagerPositions(), bxEvent.randomWalkableTownPosition(), villagerData::write, serverLevel);
            return;
        }
        String until = villagerData.get(DATA_KEY_WORKSPOT_OVERRIDE_UNTIL);
        if (until == null) {
            if (Jobs.isCloseTo(bxEvent.position(), override)) {
                this.setNewTimeout(serverLevel, villagerData);
            }
            return;
        }
        if (Util.getTick(serverLevel) >= Long.parseLong(until)) {
            villagerData.clear(DATA_KEY_WORKSPOT_OVERRIDE);
            villagerData.clear(DATA_KEY_WORKSPOT_OVERRIDE_UNTIL);
        }
    }

    private void setNewTimeout(ServerLevel serverLevel, UnsafeVillagerData villagerData) {
        long newUntil = Util.getTick(serverLevel) + (long)this.pauseForTicks;
        villagerData.write(DATA_KEY_WORKSPOT_OVERRIDE_UNTIL, Long.toString(newUntil));
    }

    private void choosePosAndStoreOnVillager(Supplier<ImmutableList<BlockPos>> otherVillagerPositions, Supplier<BlockPos> randomWalkableTownPosition, BiConsumer<String, String> writeUnsafeDataToVillager, ServerLevel serverLevel) {
        ImmutableList<BlockPos> ovp;
        if (this.preferSocial && Compat.getRandomBool(serverLevel) && !(ovp = otherVillagerPositions.get()).isEmpty()) {
            BlockPos pos = (BlockPos)Compat.shuffle(ovp, serverLevel).get(0);
            this.storePosOnVillager(writeUnsafeDataToVillager, pos);
            return;
        }
        BlockPos p = randomWalkableTownPosition.get();
        this.storePosOnVillager(writeUnsafeDataToVillager, p);
    }

    private void storePosOnVillager(BiConsumer<String, String> writeUnsafeDataToVillager, BlockPos p) {
        if (p == null) {
            QT.logBug("RandomWorkSpot: Chose null work spot position.", new Object[0]);
            return;
        }
        String val = Long.toString(p.m_121878_());
        writeUnsafeDataToVillager.accept(DATA_KEY_WORKSPOT_OVERRIDE, val);
        QT.JOB_LOGGER.debug("RandomWorkSpot: Chose new work spot at " + String.valueOf(p) + " stored as " + val, new Object[0]);
    }

    @Override
    public void beforeFindJobSite(BeforeFindJobSiteEvent event) {
        super.beforeFindJobSite(event);
        BlockPos override = RandomShortLivedWorkSpot.getOverride(event.unsafeVillagerData(), true);
        if (override == null) {
            return;
        }
        event.applyWorkspotOverride().accept(WithReason.always(override, "Overridden by " + this.getClass().getSimpleName(), new Object[0]));
    }

    @Nullable
    private static BlockPos getOverride(UnsafeVillagerData event, boolean logMissing) {
        String posStr = event.get(DATA_KEY_WORKSPOT_OVERRIDE);
        if (posStr == null || posStr.isEmpty()) {
            if (logMissing) {
                QT.logBug("RandomWorkSpot: No work spot override data found.", new Object[0]);
            }
            return null;
        }
        BlockPos override = BlockPos.m_122022_((long)Long.parseLong(posStr));
        return override;
    }

    @Override
    public void beforeMaxTicksJobChange(BeforeMaxTicksJobChangeEvent ctx) {
        super.beforeMaxTicksJobChange(ctx);
        ctx.unsafeVillagerData().clear(DATA_KEY_WORKSPOT_OVERRIDE);
        ctx.unsafeVillagerData().clear(DATA_KEY_WORKSPOT_OVERRIDE_UNTIL);
    }
}

