/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.integration;

import ca.bradj.questown.Questown;
import ca.bradj.questown.integration.jobs.JobPhaseModifier;
import ca.bradj.questown.mc.Util;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class SpecialRulesRegistry {
    private static ImmutableMap.Builder<ResourceLocation, JobPhaseModifier> registry = ImmutableMap.builder();
    private static ImmutableMap<ResourceLocation, JobPhaseModifier> listeners = ImmutableMap.of();

    public static void finalizeForServer() {
        listeners = registry.build();
    }

    public static void registerSpecialRule(ResourceLocation id, JobPhaseModifier result) {
        registry.put((Object)id, (Object)result);
    }

    public static ImmutableList<JobPhaseModifier> getRuleAppliers(Collection<String> ruleIDs) {
        List<ResourceLocation> rules = ruleIDs.stream().map(v -> v.contains(":") ? new ResourceLocation(v) : Questown.ResourceLocation(v)).toList();
        ImmutableList.Builder b = ImmutableList.builder();
        rules.forEach(v -> b.add((Object)Util.getOrDefault(listeners, v, JobPhaseModifier.NO_OP)));
        return b.build();
    }
}

