/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.integration.minecraft;

import ca.bradj.questown.integration.minecraft.MCTownItem;
import ca.bradj.questown.items.QTNBT;
import ca.bradj.questown.jobs.HeldItem;
import ca.bradj.questown.jobs.gatherer.GathererTools;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MCHeldItem
implements HeldItem<MCHeldItem, MCTownItem> {
    private final MCTownItem delegate;
    private boolean locked = false;
    private final String prefix;
    private final String biome;

    protected MCHeldItem(MCTownItem item, boolean locked, @Nullable String prefix, @Nullable String biome) {
        this.delegate = item;
        this.locked = locked;
        this.prefix = prefix;
        this.biome = biome;
    }

    public static MCHeldItem fromLootTable(MCTownItem item, GathererTools.LootTablePrefix lootTablePrefix, ResourceLocation biome) {
        return new MCHeldItem(item, false, lootTablePrefix.value(), biome.toString());
    }

    public static MCHeldItem fromTag(CompoundTag tag) {
        CompoundTag nbt = tag.m_128469_("item");
        ItemStack stack = ItemStack.m_41712_((CompoundTag)nbt);
        MCTownItem ti = new MCTownItem(stack.m_41720_(), stack.m_41613_(), nbt);
        boolean loqued = tag.m_128471_("locked");
        String prefix = QTNBT.getString(tag, "prefix");
        String biome = QTNBT.getString(tag, "biome");
        return new MCHeldItem(ti, loqued, prefix, biome);
    }

    public static MCHeldItem fromMCItemStack(ItemStack item) {
        if (item.m_41619_()) {
            return MCHeldItem.Air();
        }
        return new MCHeldItem(MCTownItem.fromMCItemStack(item), false, QTNBT.getString(item.m_41784_(), "prefix"), QTNBT.getString(item.m_41784_(), "biome"));
    }

    public static ImmutableList<MCHeldItem> fromMCItemStacks(Iterable<ItemStack> item) {
        ImmutableList.Builder b = ImmutableList.builder();
        item.forEach(v -> b.add((Object)MCHeldItem.fromMCItemStack(v)));
        return b.build();
    }

    public static MCHeldItem fromTown(MCTownItem mcTownItem) {
        return new MCHeldItem(mcTownItem.copy(), false, null, null);
    }

    public static MCHeldItem fromTown(ItemStack itemstack) {
        return MCHeldItem.fromTown(MCTownItem.fromMCItemStack(itemstack));
    }

    public static MCHeldItem fromTown(@NotNull Item item) {
        return MCHeldItem.fromTown(item.m_7968_());
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean isFood() {
        return this.delegate.isFood();
    }

    @Override
    public MCHeldItem shrink() {
        return new MCHeldItem(this.delegate.shrink(), this.locked, this.prefix, this.biome);
    }

    @Override
    public MCHeldItem unit() {
        return new MCHeldItem(this.delegate.unit(), this.locked, this.prefix, this.biome);
    }

    @Override
    public int quantity() {
        return this.delegate.quantity();
    }

    @Override
    public String getShortName() {
        String name = "[unknown]";
        ResourceLocation registryName = ForgeRegistries.ITEMS.getKey((Object)this.delegate.get());
        if (registryName != null) {
            name = registryName.toString();
        }
        return name;
    }

    public static MCHeldItem Air() {
        return new MCHeldItem(MCTownItem.Air(), false, null, null);
    }

    @Override
    public MCTownItem get() {
        return this.delegate;
    }

    @Override
    @Nullable
    public String acquiredViaLootTablePrefix() {
        return this.prefix;
    }

    @Override
    @Nullable
    public String foundInBiome() {
        return this.biome;
    }

    @Override
    public MCHeldItem locked() {
        return new MCHeldItem(this.delegate, true, this.prefix, this.biome);
    }

    @Override
    public MCHeldItem unlocked() {
        return new MCHeldItem(this.delegate, false, this.prefix, this.biome);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = this.delegate.serializeNBT();
        tag.m_128379_("locked", this.locked);
        if (this.biome != null) {
            tag.m_128359_("biome", this.biome);
        }
        if (this.prefix != null) {
            tag.m_128359_("prefix", this.prefix);
        }
        return tag;
    }

    public static MCHeldItem deserialize(CompoundTag v) {
        ItemStack del = ItemStack.m_41712_((CompoundTag)v.m_128469_("item"));
        boolean locked = false;
        if (v.m_128441_("locked")) {
            locked = v.m_128471_("locked");
        }
        String biome = null;
        if (v.m_128441_("biome")) {
            biome = v.m_128461_("biome");
        }
        String prefix = null;
        if (v.m_128441_("prefix")) {
            prefix = v.m_128461_("prefix");
        }
        return new MCHeldItem(MCTownItem.fromMCItemStack(del), locked, prefix, biome);
    }

    public MCTownItem toItem() {
        return this.delegate;
    }

    public String toString() {
        return "MCHeldItem{delegate=" + String.valueOf(this.delegate) + ", locked=" + this.locked + ", prefix=" + this.prefix + ", biome=" + this.biome + "}";
    }

    @Override
    public String toShortString() {
        String itemName = ForgeRegistries.ITEMS.getKey((Object)this.delegate.get()).toString();
        return String.format("{item=%s, prefix=%s, biome=%s}", itemName, this.prefix, this.biome);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MCHeldItem that = (MCHeldItem)o;
        return this.locked == that.locked && Objects.equals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return Objects.hash(this.delegate, this.locked);
    }

    public CompoundTag getItemNBTData() {
        return this.delegate.getItemNBT();
    }
}

