/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.items;

import ca.bradj.questown.Questown;
import ca.bradj.questown.gui.Ingredients;
import ca.bradj.questown.items.QTNBT;
import ca.bradj.questown.jobs.requests.WorkRequest;
import ca.bradj.questown.jobs.requests.WorkRequestSerializer;
import ca.bradj.questown.mc.Compat;
import ca.bradj.roomrecipes.adapter.Positions;
import ca.bradj.roomrecipes.core.Room;
import ca.bradj.roomrecipes.serialization.MCRoom;
import ca.bradj.roomrecipes.serialization.RoomSerializer;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class StockRequestItem
extends Item {
    public static final String ITEM_ID = "stock_request";

    public StockRequestItem() {
        super(Questown.DEFAULT_ITEM_PROPS);
    }

    public static void writeToNBT(CompoundTag tag, WorkRequest item) {
        QTNBT.put(tag, "request", WorkRequestSerializer.INSTANCE.serialize(item));
    }

    public static WorkRequest getRequest(CompoundTag tag) {
        CompoundTag reqTag = QTNBT.getCompound(tag, "request");
        return WorkRequestSerializer.INSTANCE.deserialize(reqTag);
    }

    public static boolean hasRequest(CompoundTag tag) {
        if (tag == null) {
            return false;
        }
        return QTNBT.contains(tag, "request");
    }

    public static void writeToNBT(CompoundTag tag, MCRoom room, BlockPos p) {
        QTNBT.putInt(tag, "workspot_x", p.m_123341_());
        QTNBT.putInt(tag, "workspot_y", p.m_123342_());
        QTNBT.putInt(tag, "workspot_z", p.m_123343_());
        QTNBT.put(tag, "workspot_room", (Tag)RoomSerializer.INSTANCE.serializeNBT((Room)room));
        QTNBT.putInt(tag, "workspot_room_y", room.yCoord);
    }

    public static boolean hasRoom(CompoundTag tag) {
        boolean x = QTNBT.contains(tag, "workspot_x");
        boolean y = QTNBT.contains(tag, "workspot_y");
        boolean z = QTNBT.contains(tag, "workspot_z");
        boolean room = QTNBT.contains(tag, "workspot_room");
        boolean room_y = QTNBT.contains(tag, "workspot_room_y");
        return x && y && z && room && room_y;
    }

    @Nullable
    public static MCRoom getRoom(CompoundTag tag) {
        if (!QTNBT.contains(tag, "workspot_room")) {
            return null;
        }
        if (!QTNBT.contains(tag, "workspot_room_y")) {
            return null;
        }
        Integer y = QTNBT.getInt(tag, "workspot_room_y");
        CompoundTag roomTag = QTNBT.getCompound(tag, "workspot_room");
        Room room = RoomSerializer.INSTANCE.deserializeNBT(roomTag);
        return new MCRoom(room.doorPos, (Collection)room.getSpaces(), y.intValue());
    }

    @Nullable
    public static BlockPos getJobBlock(CompoundTag itemTag) {
        Integer x = null;
        Integer y = null;
        Integer z = null;
        if (QTNBT.contains(itemTag, "workspot_x")) {
            x = QTNBT.getInt(itemTag, "workspot_x");
        }
        if (QTNBT.contains(itemTag, "workspot_y")) {
            y = QTNBT.getInt(itemTag, "workspot_y");
        }
        if (QTNBT.contains(itemTag, "workspot_z")) {
            z = QTNBT.getInt(itemTag, "workspot_z");
        }
        if (x == null || y == null || z == null) {
            return null;
        }
        return new BlockPos(x.intValue(), y.intValue(), z.intValue());
    }

    public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> tooltips, TooltipFlag p_41424_) {
        CompoundTag tag = p_41421_.m_41784_();
        if (StockRequestItem.hasRequest(tag)) {
            tooltips.add(Ingredients.getName(StockRequestItem.getRequest(tag).asIngredient()));
        }
        if (p_41424_.m_7050_() && StockRequestItem.hasRoom(tag)) {
            tooltips.add(Compat.literal("Room Door: " + StockRequestItem.getRoom((CompoundTag)tag).doorPos.getUIString()));
            tooltips.add(Compat.literal("Job Block: " + Positions.FromBlockPos((BlockPos)StockRequestItem.getJobBlock(tag)).getUIString()));
        }
        super.m_7373_(p_41421_, p_41422_, tooltips, p_41424_);
    }
}

