/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs;

import ca.bradj.questown.QT;
import ca.bradj.questown.blocks.JobBlock;
import ca.bradj.questown.commands.DebugLogArgument;
import ca.bradj.questown.core.Config;
import ca.bradj.questown.core.UtilClean;
import ca.bradj.questown.core.VillagerUUID;
import ca.bradj.questown.gui.Ingredients;
import ca.bradj.questown.integration.jobs.ItemCheckReplacer;
import ca.bradj.questown.integration.jobs.JobCheckReplacer;
import ca.bradj.questown.integration.jobs.SupplyRoomCheckReplacer;
import ca.bradj.questown.integration.jobs.UnsafeVillagerData;
import ca.bradj.questown.integration.minecraft.MCContainer;
import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.integration.minecraft.MCTownItem;
import ca.bradj.questown.jobs.DeclarativeJobChecks;
import ca.bradj.questown.jobs.DeclarativeJobs;
import ca.bradj.questown.jobs.DeclarativeProductionJob;
import ca.bradj.questown.jobs.EntityCurrentJobSite;
import ca.bradj.questown.jobs.EntityLocStateProvider;
import ca.bradj.questown.jobs.ExpirationRules;
import ca.bradj.questown.jobs.IProductionStatusFactory;
import ca.bradj.questown.jobs.JobBlockTestContext;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.JobLogic;
import ca.bradj.questown.jobs.JobName;
import ca.bradj.questown.jobs.JobTownProvider;
import ca.bradj.questown.jobs.Jobs;
import ca.bradj.questown.jobs.JobsClean;
import ca.bradj.questown.jobs.LZCD;
import ca.bradj.questown.jobs.NoMCNeeds;
import ca.bradj.questown.jobs.RoomsStatusLogic;
import ca.bradj.questown.jobs.Signals;
import ca.bradj.questown.jobs.SimpleSnapshot;
import ca.bradj.questown.jobs.Snapshot;
import ca.bradj.questown.jobs.SupplyItemStatus;
import ca.bradj.questown.jobs.WorkLocation;
import ca.bradj.questown.jobs.WorkPosition;
import ca.bradj.questown.jobs.declarative.AbstractWorldInteraction;
import ca.bradj.questown.jobs.declarative.DowntimeWork;
import ca.bradj.questown.jobs.declarative.MCExtra;
import ca.bradj.questown.jobs.declarative.NeedsRegistrations;
import ca.bradj.questown.jobs.declarative.PostDropHook;
import ca.bradj.questown.jobs.declarative.PreFindJobSiteHook;
import ca.bradj.questown.jobs.declarative.PreInitHook;
import ca.bradj.questown.jobs.declarative.PreMaxTicksJobChangeHook;
import ca.bradj.questown.jobs.declarative.PreTickHook;
import ca.bradj.questown.jobs.declarative.ProductionJournal;
import ca.bradj.questown.jobs.declarative.RealtimeWorldInteraction;
import ca.bradj.questown.jobs.declarative.SoundInfo;
import ca.bradj.questown.jobs.declarative.WithReason;
import ca.bradj.questown.jobs.declarative.nomc.WorkSeekerJob;
import ca.bradj.questown.jobs.fetcher.FetcherHack;
import ca.bradj.questown.jobs.leaver.ContainerTarget;
import ca.bradj.questown.jobs.production.AbstractSupplyGetter;
import ca.bradj.questown.jobs.production.ProductionJob;
import ca.bradj.questown.jobs.production.ProductionStatus;
import ca.bradj.questown.jobs.production.RoomsNeedingVillagerInput;
import ca.bradj.questown.logic.PredicateCollection;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.mc.PredicateCollections;
import ca.bradj.questown.mc.Util;
import ca.bradj.questown.mobs.visitor.VisitorMobEntity;
import ca.bradj.questown.town.Claim;
import ca.bradj.questown.town.TownContainers;
import ca.bradj.questown.town.interfaces.TownInterface;
import ca.bradj.questown.town.interfaces.WorkStatusHandle;
import ca.bradj.questown.town.special.SpecialQuests;
import ca.bradj.questown.town.workstatus.State;
import ca.bradj.roomrecipes.adapter.IRoomRecipeMatch;
import ca.bradj.roomrecipes.adapter.Positions;
import ca.bradj.roomrecipes.adapter.RoomRecipeMatch;
import ca.bradj.roomrecipes.core.Room;
import ca.bradj.roomrecipes.core.space.InclusiveSpace;
import ca.bradj.roomrecipes.core.space.Position;
import ca.bradj.roomrecipes.logic.InclusiveSpaces;
import ca.bradj.roomrecipes.rooms.XWall;
import ca.bradj.roomrecipes.rooms.ZWall;
import ca.bradj.roomrecipes.serialization.MCRoom;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeclarativeJob
extends DeclarativeProductionJob<ProductionStatus, SimpleSnapshot<ProductionStatus, MCHeldItem>, ProductionJournal<MCTownItem, MCHeldItem>> {
    private final DeclarativeJobChecks<MCExtra, MCHeldItem, MCTownItem, RoomRecipeMatch<MCRoom>, BlockPos> checks;
    private static final Marker marker = MarkerManager.getMarker((String)"DJob");
    private final RealtimeWorldInteraction world;
    private final JobLogic<MCExtra, Boolean, BlockPos> logic;
    private final WorkLocation location;
    @NotNull
    private final Integer maxState;
    private final JobID jobId;
    private final ExpirationRules expiration;
    private final long totalDuration;
    private final int workInterval;
    private final ProductionJob.RecipeProvider recipe;
    public final ImmutableMap<Integer, Ingredient> initialIngredients;
    public final ImmutableMap<Integer, Ingredient> initialTools;
    private final ImmutableMap<Integer, Integer> initialWork;
    private Signals signal;
    @Nullable
    private Long lastSupplyTick = null;
    @Nullable
    private Long secondLastSupplyTick = null;
    private final AbstractSupplyGetter<ProductionStatus, BlockPos, MCTownItem, MCHeldItem, MCRoom> getter = new AbstractSupplyGetter();
    private boolean isFirstTick = true;
    private TownInterface.DebugLogger logger = QT.JOB_LOGGER::debug;

    public DeclarativeJob(UUID ownerUUID, int inventoryCapacity, @NotNull JobID jobId, WorkLocation location, int maxState, int workInterval, ImmutableMap<Integer, Ingredient> ingredientsRequiredAtStates, ImmutableMap<Integer, Integer> ingredientsQtyRequiredAtStates, ImmutableMap<Integer, Ingredient> toolsRequiredAtStates, ImmutableMap<Integer, Integer> workRequiredAtStates, ImmutableMap<Integer, Integer> timeRequiredAtStates, ImmutableMap<ProductionStatus, Collection<String>> specialStatusRules, ImmutableList<String> specialGlobalRules, ExpirationRules expiration, BiFunction<ServerLevel, Collection<MCHeldItem>, Iterable<MCHeldItem>> resultGenerator, @Nullable SoundInfo sound) {
        super(ownerUUID, inventoryCapacity, marker, DeclarativeJobs.journalInitializer(jobId), DeclarativeJobs.STATUS_FACTORY, specialStatusRules, specialGlobalRules, () -> {
            if (specialGlobalRules.contains((Object)"claim_spot")) {
                return DeclarativeJob.makeClaim(ownerUUID);
            }
            return null;
        }, location);
        this.initialIngredients = ingredientsRequiredAtStates;
        this.initialTools = toolsRequiredAtStates;
        this.initialWork = workRequiredAtStates;
        this.jobId = jobId;
        this.checks = new DeclarativeJobChecks((Map<Integer, PredicateCollection<MCHeldItem, MCHeldItem>>)Jobs.unMCHeld3(ingredientsRequiredAtStates), (Map<Integer, Integer>)ingredientsQtyRequiredAtStates, (Map<Integer, PredicateCollection<MCTownItem, MCTownItem>>)Jobs.unMC5(toolsRequiredAtStates), (Map<Integer, Integer>)workRequiredAtStates, (Map<Integer, Integer>)timeRequiredAtStates, r -> true, p -> false);
        this.world = this.initWorldInteraction(maxState, this.checks, resultGenerator, (Map<ProductionStatus, Collection<String>>)specialStatusRules, extra -> {
            if (specialGlobalRules.contains((Object)"claim_spot")) {
                return DeclarativeJob.makeClaim(ownerUUID);
            }
            return null;
        }, (x, i) -> DeclarativeJob.getUnmetNeed(ingredientsRequiredAtStates, ingredientsQtyRequiredAtStates, toolsRequiredAtStates, i), () -> location.baseRoom().toString(), workInterval, sound);
        this.maxState = maxState;
        this.location = location;
        this.expiration = expiration;
        this.totalDuration = timeRequiredAtStates.values().stream().reduce(Integer::sum).orElse(0).intValue();
        this.logic = new JobLogic();
        this.workInterval = workInterval;
        this.recipe = DeclarativeJob.buildRecipe(this);
    }

    @Nullable
    private static String getUnmetNeed(ImmutableMap<Integer, Ingredient> ingredientsRequiredAtStates, ImmutableMap<Integer, Integer> qtyRequiredAtStates, ImmutableMap<Integer, Ingredient> toolsRequiredAtStates, NeedsRegistrations.Need need) {
        Integer ii = need.timesInserted();
        if (ii != null) {
            int actual = NoMCNeeds.getActualIndex(ii, qtyRequiredAtStates);
            return Util.orNull((Ingredient)ingredientsRequiredAtStates.get((Object)(actual + 1)), Ingredients::toString);
        }
        return Util.orNull((Ingredient)toolsRequiredAtStates.get((Object)need.toolIndex()), Ingredients::toString);
    }

    @Override
    public void initialize(ServerLevel level, Snapshot<MCHeldItem> journal) {
        super.initialize(level, journal);
        HashMap ingr = new HashMap();
        HashMap tool = new HashMap();
        Map<Integer, PredicateCollection<MCHeldItem, MCHeldItem>> jobIngrs = this.checks.getAllRequiredIngredients();
        Map<Integer, PredicateCollection<MCTownItem, MCTownItem>> jobTools = this.checks.getAllRequiredTools();
        PredicateCollection noCheck = PredicateCollection.empty("no requirements");
        for (int i = 0; i < this.maxState; ++i) {
            ingr.put(i, new ItemCheckReplacer<MCHeldItem>(UtilClean.getOrDefault(jobIngrs, i, noCheck)));
            tool.put(i, new ItemCheckReplacer<MCTownItem>(UtilClean.getOrDefault(jobTools, i, noCheck)));
        }
        JobCheckReplacer globalJCR = new JobCheckReplacer(this::isJobBlock);
        SupplyRoomCheckReplacer globalSRCR = new SupplyRoomCheckReplacer();
        DeclarativeJob self = this;
        for (int i = 0; i <= this.maxState; ++i) {
            ProductionStatus ss = ProductionStatus.fromJobBlockStatus(i);
            ImmutableList stageRules = UtilClean.getOrDefaultCollection(this.specialRules, ss, ImmutableList.of());
            PreInitHook.run(stageRules, () -> level, (ItemCheckReplacer)ingr.get(i), (ItemCheckReplacer)tool.get(i), globalJCR, globalSRCR);
        }
        PreInitHook.run((Collection<String>)this.specialGlobalRules, () -> level, ItemCheckReplacer.doNotReplace(), ItemCheckReplacer.doNotReplace(), globalJCR, globalSRCR);
        this.checks.initialize(ItemCheckReplacer.withItems(ingr, ((ProductionJournal)self.journal)::getItems), this.checks.getAllRequiredQuantity(), ItemCheckReplacer.withItems(tool, ((ProductionJournal)self.journal)::getItems), this.checks.getAllRequiredWork(), this.checks.getAllRequiredTime(), SupplyRoomCheckReplacer.withItems(globalSRCR, ((ProductionJournal)self.journal)::getItems), JobCheckReplacer.withContext(globalJCR, new JobBlockTestContext(level, Util.info(level), BlockPos.f_121853_, ((ProductionJournal)self.journal)::getItems, ImmutableList::of, false, false)));
    }

    private boolean isJobBlock(JobBlockTestContext ctx) {
        return this.location.isJobBlock().test(ctx.withBlockAlreadyUsed(this.logic.hasWorkedRecently() || this.hasInserted(0)).withJobAlreadyStarted(true));
    }

    @NotNull
    public static Claim makeClaim(UUID ownerUUID) {
        return new Claim(ownerUUID, (Long)Config.BLOCK_CLAIMS_TICK_LIMIT.get());
    }

    @Override
    public JobID getId() {
        return this.jobId;
    }

    @Override
    public boolean shouldStandStill(TownInterface town, BlockPos position) {
        if (DowntimeWork.matches(this.jobId) && this.isCloseToJobSite(position) && !this.hasTargetOverrideChanged(town)) {
            return true;
        }
        return this.logic.hasWorkedRecently();
    }

    @NotNull
    protected RealtimeWorldInteraction initWorldInteraction(int maxState, DeclarativeJobChecks<MCExtra, MCHeldItem, MCTownItem, RoomRecipeMatch<MCRoom>, BlockPos> checks, BiFunction<ServerLevel, Collection<MCHeldItem>, Iterable<MCHeldItem>> resultGenerator, Map<ProductionStatus, Collection<String>> specialRules, Function<MCExtra, Claim> claimSpots, BiFunction<MCExtra, NeedsRegistrations.Need, String> getUnmetNeed, Supplier<String> location, int interval, @Nullable SoundInfo sound) {
        return new RealtimeWorldInteraction(t -> t.town().getTownFlagBasePos(), (ProductionJournal)this.journal, maxState, checks, specialRules, resultGenerator, claimSpots, getUnmetNeed, location, interval, sound);
    }

    public static ProductionJob.RecipeProvider buildRecipe(DeclarativeJob self) {
        return s -> {
            ImmutableList.Builder bb = ImmutableList.builder();
            PredicateCollection<MCHeldItem, MCHeldItem> ingr = self.checks.getIngredientsForStep(s);
            if (ingr != null) {
                bb.add(PredicateCollections.townify(ingr));
            }
            for (int i = 0; i <= s; ++i) {
                PredicateCollection<MCTownItem, ?> tool = self.checks.getToolsForStep(i);
                if (tool == null) continue;
                bb.add(tool);
            }
            return bb.build();
        };
    }

    @Override
    public void tick(TownInterface town, LivingEntity entity, Direction facingPos) {
        this.logger = (p, a) -> town.getDebugLogger(QT.JOB_LOGGER, DebugLogArgument.JOB_LOGIC).log(p, a);
        WorkStatusHandle<BlockPos, MCHeldItem> work = this.getWorkStatusHandle(town);
        AtomicReference<RoomsNeedingVillagerInput<MCRoom, ResourceLocation, BlockPos>> rniot = new AtomicReference<RoomsNeedingVillagerInput<MCRoom, ResourceLocation, BlockPos>>(this.roomsNeedingIngredientsOrTools(town, work::getJobBlockState, bp -> work.canClaim((BlockPos)bp, this.claimSupplier)));
        VisitorMobEntity vme = (VisitorMobEntity)entity;
        ImmutableList heldItems = vme.getJobJournalSnapshot().items();
        Function<BlockPos, @NotNull State> bsFn = bp -> Util.applyOrDefault(bp, p -> town.getWorkStatusHandle(this.ownerUUID).getJobBlockState((BlockPos)p), State.fresh());
        boolean firstTick = this.isFirstTick;
        if (this.isFirstTick) {
            this.isFirstTick = false;
        }
        Supplier<ImmutableList<BlockPos>> otherVillagerPositions = () -> (ImmutableList)town.getVillagerHandle().entities().stream().filter(v -> !this.ownerUUID.equals(v.m_20148_())).map(Entity::m_20097_).collect(ImmutableList.toImmutableList());
        Supplier<BlockPos> randomWalkableTownPosition = () -> town.getRandomWanderTarget(entity.m_20097_());
        UnsafeVillagerData villagerData = town.getVillagerHandle().getUnprotectedDataHandle(vme.getVUID());
        PreTickHook.run((Collection<String>)this.specialGlobalRules, town::getServerLevel, this.location, heldItems, fn -> rniot.set((RoomsNeedingVillagerInput)fn.apply((RoomsNeedingVillagerInput)rniot.get())), bsFn, firstTick, entity.m_20183_(), otherVillagerPositions, randomWalkableTownPosition, villagerData);
        this.specialRules.forEach((state, rules) -> PreTickHook.run(rules, town::getServerLevel, this.location, (ImmutableList<MCHeldItem>)heldItems, fn -> rniot.set((RoomsNeedingVillagerInput)fn.apply((RoomsNeedingVillagerInput)rniot.get())), bsFn, firstTick, entity.m_20183_(), otherVillagerPositions, randomWalkableTownPosition, villagerData));
        this.roomsNeedingIngredientsOrTools = new RoomsNeedingVillagerInput<MCRoom, ResourceLocation, BlockPos>(rniot.get().get());
        MCExtra extra = new MCExtra(town, work, (VisitorMobEntity)entity);
        this.tick(extra, work, entity, facingPos, (RoomsNeedingVillagerInput<MCRoom, ResourceLocation, BlockPos>)this.roomsNeedingIngredientsOrTools, this.statusFactory);
    }

    @Override
    protected void tick(MCExtra extra, WorkStatusHandle<BlockPos, MCHeldItem> work, LivingEntity entity, Direction facingPos, RoomsNeedingVillagerInput<MCRoom, ResourceLocation, BlockPos> roomsNeedingIngredientsOrTools, IProductionStatusFactory<ProductionStatus> statusFactory) {
        JobTownProvider<MCRoom> jtp = this.makeTownProviderForTick(extra, work, roomsNeedingIngredientsOrTools);
        final EntityCurrentJobSite<MCRoom> entityCurrentJobSite = Jobs.getEntityCurrentJobSite(entity.m_20183_(), roomsNeedingIngredientsOrTools, jtp.roomsWithCompletedProduct());
        EntityLocStateProvider<MCRoom> elp = new EntityLocStateProvider<MCRoom>(){

            @Override
            @Nullable
            public MCRoom getEntityCurrentJobSite() {
                if (entityCurrentJobSite == null) {
                    return null;
                }
                return (MCRoom)entityCurrentJobSite.room();
            }
        };
        Supplier<ProductionStatus> computeState = this.getStateComputer(extra.town(), statusFactory, jtp, elp);
        this.signal = Signals.fromDayTime(Util.getDayTime((Level)extra.town().getServerLevel()));
        WorkPosition workSpot = this.world.getWorkSpot();
        BlockPos bp = Util.orNull(workSpot, WorkPosition::jobBlock);
        int action = bp == null ? 0 : Util.withFallbackForNullInput(work.getJobBlockState(bp), State::processingState, 0);
        this.logic.tick(extra, computeState, this.jobId, entityCurrentJobSite != null, WorkSeekerJob.isSeekingWork(this.jobId), workSpot != null && this.hasInserted(action), !this.inventory.m_7983_(), this.expiration, new JobLogic.JobDetails(this.maxState, this.checks.getWorkForStep(0), this.workInterval), this.asLogicWorld(extra, work, (VisitorMobEntity)entity, entityCurrentJobSite, roomsNeedingIngredientsOrTools), (tuwn, bpp) -> Util.withFallbackForNullInput(this.getWorkStatusHandle(extra.town()).getJobBlockState((BlockPos)bpp), State::processingState, 0), ((Long)Config.WORKED_RECENTLY_TICKS.get()).intValue());
    }

    @Override
    protected boolean grabbedSuppliesRecently(Predicate<Long> isTickRecent) {
        return isTickRecent.test(this.lastSupplyTick) && isTickRecent.test(this.secondLastSupplyTick);
    }

    @Override
    protected boolean shouldCheckContainerForSupplies(RoomRecipeMatch<MCRoom> mcRoom) {
        return this.checks.shouldCheckContainerForSupplies(mcRoom);
    }

    @Override
    protected Collection<? extends Predicate<MCTownItem>> cleanRooms() {
        return this.roomsNeedingIngredientsOrTools.cleanFns(this.checks::getIngredientsForStep, this.checks::getToolsForStep);
    }

    @NotNull
    private JobTownProvider<MCRoom> makeTownProviderForTick(final MCExtra extra, final WorkStatusHandle<BlockPos, MCHeldItem> work, final RoomsNeedingVillagerInput<MCRoom, ResourceLocation, BlockPos> roomsNeedingIngredientsOrTools) {
        WorkLocation.BlockInfo info = Util.info(extra.town().getServerLevel());
        final Supplier<Map> roomsV2 = () -> DeclarativeJobs.rooms(this.maxState, roomsNeedingIngredientsOrTools, work, bp -> this.isJobBlock(new JobBlockTestContext(extra.town().getServerLevel(), info, (BlockPos)bp, ((ProductionJournal)this.journal)::getItems, () -> TownContainers.getUniqueItems(extra.town()), false, false)));
        return new JobTownProvider<MCRoom>(){
            private final Function<BlockPos, State> getJobBlockState = work::getJobBlockState;

            @Override
            public Collection<MCRoom> roomsWithCompletedProduct() {
                return DeclarativeJob.this.roomsWithState(extra.town(), this.getJobBlockState, DeclarativeJob.this.maxState).stream().map(v -> (MCRoom)v.room).toList();
            }

            @Override
            public RoomsNeedingVillagerInput<MCRoom, ResourceLocation, BlockPos> roomsNeedingIngredientsByState() {
                return roomsNeedingIngredientsOrTools;
            }

            @Override
            public Map<Integer, ? extends LZCD.Dependency<Void>> roomsWithWorkableStatefulBlocks() {
                return (Map)roomsV2.get();
            }

            @Override
            public boolean isUnfinishedTimeWorkPresent() {
                return Jobs.isUnfinishedTimeWorkPresent(extra.town().getRoomHandle(), DeclarativeJob.this.location.baseRoom(), work::getTimeToNextState);
            }

            @Override
            public Collection<Integer> getStatesWithUnfinishedItemlessWork() {
                Collection<Integer> statesWithUnfinishedWork = Jobs.getStatesWithUnfinishedWork(() -> extra.town().getRoomHandle().getRoomsMatching(DeclarativeJob.this.location.baseRoom()).stream().map(v -> () -> v.getContainedBlocks().keySet().stream().filter(z -> DeclarativeJob.this.shouldInit((BlockPos)z, extra)).toList()).toList(), this.getJobBlockState, bp -> work.canClaim(bp, () -> DeclarativeJob.makeClaim(DeclarativeJob.this.ownerUUID)));
                ImmutableList.Builder b = ImmutableList.builder();
                statesWithUnfinishedWork.forEach(s -> {
                    PredicateCollection<MCTownItem, ?> toolsReq = DeclarativeJob.this.checks.getToolsForStep((Integer)s);
                    if (toolsReq != null && !toolsReq.isEmpty()) {
                        return;
                    }
                    b.add(s);
                });
                return b.build();
            }

            @Override
            public Collection<MCRoom> roomsAtState(Integer state) {
                return roomsNeedingIngredientsOrTools.get().get(state).stream().map(RoomsNeedingVillagerInput.NVIRoom::room).map(IRoomRecipeMatch::getRoom).toList();
            }

            @Override
            public boolean hasSupplies() {
                RoomsNeedingVillagerInput<MCRoom, ResourceLocation, BlockPos> needs = this.roomsNeedingIngredientsByState();
                ImmutableList<PredicateCollection<MCTownItem, ?>> neededItems = needs.cleanFns(DeclarativeJob.this.checks::getIngredientsForStep, DeclarativeJob.this.checks::getToolsForStep);
                return Jobs.townHasSupplies(extra.town(), DeclarativeJob.this.journal, neededItems);
            }

            @Override
            public LZCD.Dependency<Void> hasSuppliesV2() {
                return DeclarativeJobs.supplies(extra.town().getServerLevel(), roomsV2, extra.town(), DeclarativeJob.this.checks.getAllRequiredIngredients(), DeclarativeJob.this.checks.getAllRequiredTools(), DeclarativeJob.this.checks::shouldCheckContainerForSupplies, bp -> DeclarativeJob.this.isJobBlock((BlockPos)bp), js -> DeclarativeJob.this.location.baseRoom().equals(js));
            }

            @Override
            public boolean hasSpace() {
                return Jobs.townHasSpace(extra.town());
            }
        };
    }

    private boolean shouldInit(BlockPos z, MCExtra extra) {
        WorkLocation.BlockInfo info = Util.info(extra.town().getServerLevel());
        return this.location.shouldInitializeWorkState().test(info, z);
    }

    private Collection<RoomRecipeMatch<MCRoom>> roomsWithState(TownInterface town, Function<BlockPos, State> getJobBlockState, Integer state) {
        return this.roomsWithState(town, getJobBlockState, state, s -> true);
    }

    private Collection<RoomRecipeMatch<MCRoom>> roomsWithState(TownInterface town, Function<BlockPos, State> getJobBlockState, Integer state, Predicate<State> extraCheck) {
        Collection<RoomRecipeMatch<MCRoom>> rooms = town.getRoomHandle().getRoomsMatching(this.location.baseRoom());
        return Jobs.roomsWithState(rooms, p -> this.location.shouldInitializeWorkState().test(Util.info(town.getServerLevel()), (BlockPos)p), bp -> {
            State jbs = (State)getJobBlockState.apply((BlockPos)bp);
            if (jbs == null) {
                return false;
            }
            return state.equals(jbs.processingState()) && extraCheck.test(jbs);
        });
    }

    @Override
    protected boolean isJobBlock(BlockPos bp) {
        return this.checks.isJobBlock(bp);
    }

    private boolean hasInserted(Integer action) {
        for (int i = 1; i < action; ++i) {
            if (this.checks.getQuantityForStep(i - 1, 0) <= 0) continue;
            return true;
        }
        return false;
    }

    private JobLogic.JLWorld<MCExtra, Boolean, BlockPos> asLogicWorld(final MCExtra extra, final WorkStatusHandle<BlockPos, MCHeldItem> work, final VisitorMobEntity entity, final EntityCurrentJobSite<MCRoom> entityCurrentJobSite, final RoomsNeedingVillagerInput<MCRoom, ResourceLocation, BlockPos> roomsNeedingIngredientsOrTools) {
        final DeclarativeJob self = this;
        final TownInterface town = extra.town();
        return new JobLogic.JLWorld<MCExtra, Boolean, BlockPos>(){

            @Override
            public void changeJob(JobID id) {
                UnsafeVillagerData data = town.getVillagerHandle().getUnprotectedDataHandle(entity.getVUID());
                PreMaxTicksJobChangeHook.run((Collection<String>)DeclarativeJob.this.specialGlobalRules, data);
                town.getVillagerHandle().changeJobForVillager(DeclarativeJob.this.ownerUUID, id, false);
            }

            @Override
            public void changeToNextJob() {
                town.getVillagerHandle().changeToNextJobForVillager(DeclarativeJob.this.ownerUUID, DeclarativeJob.this.getId());
            }

            @Override
            public boolean setWorkLeftAtFreshState(int workRequiredAtFirstState) {
                ServerLevel sl = town.getServerLevel();
                boolean didIt = false;
                for (RoomRecipeMatch<MCRoom> room : town.getRoomHandle().getRoomsMatching(SpecialQuests.CLINIC)) {
                    Map<Integer, Collection<WorkPosition<BlockPos>>> spots = DeclarativeJob.this.listAllWorkSpots(DeclarativeJob.this.getWorkStatusHandle(town)::getJobBlockState, new EntityCurrentJobSite<MCRoom>((MCRoom)room.room, false), bp -> DeclarativeJob.this.isValidWalkTarget(town, bp), bp -> DeclarativeJob.this.location.shouldInitializeWorkState().test(Util.info(sl), (BlockPos)bp), bp -> {
                        town.getDebugLogger(QT.JOB_LOGGER, DebugLogArgument.VILLAGER_NAVIGATION).log("choosing to approach job block from random side", new Object[0]);
                        return bp.m_121945_(Compat.getRandomHorizontal(sl));
                    });
                    for (WorkPosition<BlockPos> p : UtilClean.getOrDefault(spots, 0, ImmutableList.of())) {
                        work.setJobBlockState(p.jobBlock(), State.fresh().setWorkLeft(workRequiredAtFirstState));
                        didIt = true;
                    }
                }
                return didIt;
            }

            @Override
            public WorkPosition<BlockPos> getWorkSpot() {
                return DeclarativeJob.this.world.getWorkSpot();
            }

            @Override
            public Map<Integer, Collection<WorkPosition<BlockPos>>> listAllWorkSpots() {
                ServerLevel sl = town.getServerLevel();
                if (sl == null) {
                    return ImmutableMap.of();
                }
                return self.listAllWorkSpots(work::getJobBlockState, entityCurrentJobSite, bp -> DeclarativeJob.this.isValidWalkTarget(town, bp), bp -> DeclarativeJob.this.isJobBlock((BlockPos)bp), bp -> bp.m_121945_(Compat.getRandomHorizontal(sl)));
            }

            @Override
            public boolean tryGrabbingInsertedSupplies() {
                return DeclarativeJob.this.world.tryGrabbingInsertedSupplies(extra);
            }

            @Override
            public void clearInsertedSupplies() {
                DeclarativeJob.this.world.clearInsertedSupplies(extra);
            }

            @Override
            public void registerUnmetNeeds(ProductionStatus status, @Nullable BlockPos workspot, int timesInserted) {
                DeclarativeJob.this.world.registerUnmetNeeds(extra, workspot, timesInserted);
            }

            @Override
            public void registerUnmetRooms() {
                DeclarativeJob.this.world.registerUnmetRooms(extra);
            }

            @Override
            public int timesInserted() {
                return DeclarativeJob.this.world.timesInserted(extra);
            }

            @Override
            public AbstractWorldInteraction<MCExtra, BlockPos, ?, ?, Boolean> getHandle() {
                return DeclarativeJob.this.world;
            }

            @Override
            public boolean tryDropLoot() {
                ImmutableList itemsBeforeDrop = ((ProductionJournal)DeclarativeJob.this.journal).getItems();
                boolean result = self.tryDropLoot(Util.getTick(town.getServerLevel()), entity.m_20183_());
                ImmutableList itemsAfterDrop = ((ProductionJournal)DeclarativeJob.this.journal).getItems();
                if (result) {
                    PostDropHook.run(town, (Collection<String>)DeclarativeJob.this.specialGlobalRules, town.getServerLevel(), DeclarativeJob.this.successTarget.getBlockPos(), itemsBeforeDrop, itemsAfterDrop, work::clearState);
                }
                return result;
            }

            @Override
            public void tryGetSupplies() {
                if (DeclarativeJob.this.logic.isWrappingUp()) {
                    return;
                }
                self.tryGetSupplies(extra.town(), roomsNeedingIngredientsOrTools, entity.m_20183_(), Util.getTick(town.getServerLevel()));
            }

            @Override
            public void setLookTarget(BlockPos position) {
                self.setLookTarget(position);
            }

            @Override
            public void registerHeldItemsAsFoundLoot() {
                town.getKnowledgeHandle().registerFoundLoots((Collection<MCHeldItem>)((ProductionJournal)DeclarativeJob.this.journal).getItems());
            }
        };
    }

    public String toString() {
        return "DeclarativeJob{jobId=" + this.jobId.toNiceString() + "}";
    }

    @NotNull
    protected Supplier<ProductionStatus> getStateComputer(TownInterface town, IProductionStatusFactory<ProductionStatus> statusFactory, JobTownProvider<MCRoom> jtp, EntityLocStateProvider<MCRoom> elp) {
        return () -> {
            ProductionStatus s;
            if (FetcherHack.isFetcher(this.jobId) && (s = FetcherHack.computeStatus(town, ((ProductionJournal)this.journal).getItems())) != null) {
                ((ProductionJournal)this.journal).changeStatus(s);
                return s;
            }
            ((ProductionJournal)this.journal).tryUpdateStatus(jtp, elp, this.defaultEntityInvProvider(), statusFactory, this.prioritizesExtraction());
            return ((ProductionJournal)this.journal).getStatus();
        };
    }

    public boolean prioritizesExtraction() {
        return this.specialGlobalRules.contains((Object)"prioritize_extraction");
    }

    private void tryGetSupplies(TownInterface town, RoomsNeedingVillagerInput<MCRoom, ResourceLocation, BlockPos> roomsNeedingIngredientsOrTools, final BlockPos entityBlockPos, Long currentTick) {
        if (this.suppliesTarget == null) {
            return;
        }
        JobsClean.SuppliesTarget<BlockPos, MCTownItem> st = new JobsClean.SuppliesTarget<BlockPos, MCTownItem>(){

            @Override
            public boolean isCloseTo() {
                return Jobs.isCloseTo(entityBlockPos, DeclarativeJob.this.suppliesTarget.getBlockPos());
            }

            @Override
            public String toShortString() {
                return DeclarativeJob.this.suppliesTarget.toShortString();
            }

            @Override
            public List<MCTownItem> getItems() {
                return DeclarativeJob.this.suppliesTarget.getItems();
            }

            @Override
            public void removeItem(int i) {
                DeclarativeJob.this.suppliesTarget.getContainer().removeItem(i);
            }
        };
        Function adjustOrder = UtilClean::enumerate;
        if (this.specialGlobalRules.contains((Object)"take_random_ingredient")) {
            adjustOrder = list -> {
                ImmutableList shuffled = ImmutableList.copyOf(UtilClean.enumerate(list));
                shuffled = Compat.shuffle(shuffled, town.getServerLevel());
                return shuffled;
            };
        }
        if (this.getter.tryGetSupplies(((ProductionJournal)this.journal).getStatus(), ((ProductionJournal)this.journal).getCapacity(), roomsNeedingIngredientsOrTools, st, this.recipe::getRecipe, (Collection<MCHeldItem>)((ProductionJournal)this.journal).getItems(), item -> {
            ((ProductionJournal)this.journal).addItem(MCHeldItem.fromTown(item));
            this.clearJobSite();
        }, adjustOrder)) {
            this.secondLastSupplyTick = this.lastSupplyTick;
            this.lastSupplyTick = currentTick;
        }
    }

    @Override
    protected ImmutableList<PredicateCollection<MCTownItem, ?>> getRecipe(Integer integer) {
        return this.recipe.getRecipe(integer);
    }

    Map<Integer, Collection<WorkPosition<BlockPos>>> listAllWorkSpots(Function<BlockPos, State> town, @Nullable EntityCurrentJobSite<MCRoom> jobSite, Predicate<BlockPos> isValidWalkTarget, Predicate<BlockPos> isJobBlock, Function<BlockPos, BlockPos> getRandomAdjacent) {
        if (jobSite == null) {
            return ImmutableMap.of();
        }
        Function<BlockPos, BlockPos> is = bp -> {
            bp = jobSite.isFarm() ? bp.m_7494_() : bp;
            return this.findInteractionSpot((BlockPos)bp, (Room)jobSite.room(), isValidWalkTarget, getRandomAdjacent);
        };
        HashMap b = new HashMap();
        Consumer<BlockPos> tryAdd = bp -> DeclarativeJob.tryAddSpot(town, bp, b, is, isJobBlock);
        jobSite.room().getSpaces().stream().flatMap(space -> InclusiveSpaces.getPositions((InclusiveSpace)space, (InclusiveSpaces.PositionType)InclusiveSpaces.PositionType.INTERIOR_ONLY).stream()).forEach(v -> {
            BlockPos pos = Positions.ToBlock((Position)v, (int)((MCRoom)jobSite.room()).yCoord);
            tryAdd.accept(pos);
            tryAdd.accept(pos.m_7494_());
        });
        if (b.isEmpty()) {
            // empty if block
        }
        return ImmutableMap.copyOf(b);
    }

    private static void tryAddSpot(Function<BlockPos, State> town, BlockPos bp, Map<Integer, List<WorkPosition<BlockPos>>> b, Function<BlockPos, BlockPos> i9nSpot, Predicate<BlockPos> isJobBlock) {
        @Nullable Integer blockAction = JobBlock.getState(town, bp);
        if (blockAction != null && isJobBlock.test(bp)) {
            WorkPosition<BlockPos> v = new WorkPosition<BlockPos>(bp, i9nSpot.apply(bp));
            UtilClean.addAllOrInitializeList(b, blockAction, ImmutableList.of(v));
        }
    }

    private BlockPos findInteractionSpot(BlockPos bp, Room jobSite, Predicate<BlockPos> isValidWalkTarget, Function<BlockPos, BlockPos> getRandomAdjacent) {
        BlockPos spot;
        if (this.specialGlobalRules.contains((Object)"prefer_interaction_below") && (spot = this.doFindInteractionSpot(bp.m_7495_(), jobSite, isValidWalkTarget)) != null) {
            return spot;
        }
        if (this.specialGlobalRules.contains((Object)"prefer_interaction_stand_on_top")) {
            return bp.m_7494_();
        }
        spot = this.doFindInteractionSpot(bp, jobSite, isValidWalkTarget);
        if (spot != null) {
            return spot;
        }
        return getRandomAdjacent.apply(bp);
    }

    @Nullable
    private BlockPos doFindInteractionSpot(BlockPos bp, Room jobSite, Predicate<BlockPos> isEmpty) {
        Direction d = this.getDoorDirectionFromCenter(jobSite);
        if (isEmpty.test(bp.m_121945_(d))) {
            return bp.m_121945_(d);
        }
        for (Direction dd : Direction.Plane.HORIZONTAL) {
            if (!isEmpty.test(bp.m_121945_(dd))) continue;
            return bp.m_121945_(dd);
        }
        if (InclusiveSpaces.calculateArea((Collection)jobSite.getSpaces()) == 9.0) {
            return Positions.ToBlock((Position)jobSite.getDoorPos(), (int)bp.m_123342_());
        }
        return null;
    }

    private Direction getDoorDirectionFromCenter(Room jobSite) {
        Optional backXWall = jobSite.getBackXWall();
        if (backXWall.isPresent() && ((XWall)backXWall.get()).getZ() > jobSite.doorPos.z) {
            return Direction.NORTH;
        }
        if (backXWall.isPresent()) {
            return Direction.SOUTH;
        }
        Optional backZWall = jobSite.getBackZWall();
        if (backZWall.isPresent() && ((ZWall)backZWall.get()).getX() > jobSite.doorPos.x) {
            return Direction.WEST;
        }
        if (backZWall.isPresent()) {
            return Direction.EAST;
        }
        return Direction.NORTH;
    }

    @Override
    public void initializeStatusFromEntityData(@Nullable String s) {
        ProductionStatus from;
        try {
            from = ProductionStatus.fromNumber(s);
        }
        catch (NumberFormatException nfe) {
            QT.JOB_LOGGER.error("Ignoring exception: {}", nfe.getMessage());
            from = ProductionStatus.FACTORY.idle();
        }
        if (from.isUnset()) {
            from = ProductionStatus.FACTORY.idle();
        }
        ((ProductionJournal)this.journal).initializeStatus(from);
    }

    @Override
    public Signals getSignal() {
        if (this.specialGlobalRules.contains((Object)"work_in_evening")) {
            return Signals.NOON;
        }
        return this.signal;
    }

    @Override
    public String getStatusToSyncToClient() {
        return ((ProductionJournal)this.journal).getStatus().name();
    }

    @Override
    protected Map<Integer, SupplyItemStatus> getSupplyItemStatus() {
        return JobsClean.getSupplyItemStatuses(((ProductionJournal)this.journal)::getItems, this.checks.getAllRequiredIngredients(), s -> !UtilClean.getOrDefault(this.checks.getAllRequiredIngredients(), s, PredicateCollection.empty("no ingredient defined")).isEmpty(), Jobs.unTown(this.checks.getAllRequiredTools()), s -> {
            PredicateCollection<MCTownItem, MCTownItem> toool = UtilClean.getOrDefault(this.checks.getAllRequiredTools(), s, PredicateCollection.empty("no tool defined"));
            return !toool.isEmpty();
        }, this.checks.getAllRequiredWork(), this.maxState);
    }

    @Override
    @Nullable
    protected WorkPosition<BlockPos> findProductionSpot(ServerLevel sl) {
        return this.logic.workSpot();
    }

    @Override
    protected @NotNull WithReason<@Nullable BlockPos> findJobSite(TownInterface town, RoomsNeedingVillagerInput<MCRoom, ResourceLocation, BlockPos> blocksSrc, Function<BlockPos, State> work, Predicate<BlockPos> isValidWalkTarget, Predicate<BlockPos> isJobBlock, Function<BlockPos, BlockPos> getRandomAdjacent) {
        AtomicReference<Object> override = new AtomicReference<Object>(null);
        UnsafeVillagerData data = town.getVillagerHandle().getUnprotectedDataHandle(VillagerUUID.from(this.ownerUUID));
        PreFindJobSiteHook.run(this.getGlobalSpecialRules(), data, override::set);
        if (override.get() != null && ((WithReason)override.get()).value() != null) {
            return override.get();
        }
        Map<Integer, SupplyItemStatus> statusItems = this.getSupplyItemStatus();
        return JobsClean.findJobSite(this.maxState, this.prioritizesExtraction(), statusItems, this.roomsWithState(town, work, this.maxState).stream().map(v -> (MCRoom)v.room).toList(), room -> Positions.ToBlock((Position)room.getDoorPos(), (int)room.yCoord), blocksSrc, work, isJobBlock, (block, room) -> this.findInteractionSpot((BlockPos)block, (Room)room, isValidWalkTarget, getRandomAdjacent));
    }

    @Override
    public RoomsNeedingVillagerInput<MCRoom, ResourceLocation, BlockPos> roomsNeedingIngredientsOrTools(TownInterface town, Function<BlockPos, State> work, Predicate<BlockPos> canClaim) {
        Collection<RoomRecipeMatch<MCRoom>> x = town.getRoomHandle().getRoomsMatching(this.location.baseRoom());
        Function<RoomRecipeMatch, Collection> gcb = m -> m.getContainedBlocks().keySet().stream().toList();
        WorkLocation.BlockInfo info = Util.info(town.getServerLevel());
        return RoomsStatusLogic.compute(x, work, canClaim, p -> this.location.shouldInitializeWorkState().test(info, (BlockPos)p), this.checks, gcb, this.maxState);
    }

    @Override
    public JobName getJobName() {
        return new JobName("jobs." + String.valueOf(this.jobId));
    }

    @Override
    public Function<Void, Void> addItemInsertionListener(BiConsumer<BlockPos, MCHeldItem> listener) {
        TriConsumer l = (extra, bp, item) -> listener.accept((BlockPos)bp, (MCHeldItem)item);
        this.world.addItemInsertionListener(l);
        return nul -> {
            this.world.removeItemInsertionListener(l);
            return null;
        };
    }

    @Override
    public Function<Void, Void> addJobCompletionListener(Consumer<JobID> listener) {
        this.world.addJobCompletionListener(listener);
        return nul -> {
            this.world.removeJobCompletionListener(listener);
            return null;
        };
    }

    @Override
    public long getTotalDuration() {
        return this.totalDuration;
    }

    @Override
    public Collection<String> getGlobalSpecialRules() {
        return this.specialGlobalRules;
    }

    @Override
    public int getExperienceEarned() {
        if (this.specialGlobalRules.contains((Object)"no_experience_gained")) {
            return 0;
        }
        int workPart = this.initialWork.values().stream().reduce(0, Integer::sum) * this.workInterval;
        long timePart = (long)workPart + Math.max(this.totalDuration / 10L, 1L);
        QT.JOB_LOGGER.debug("{} gained experience: {} from work, {} from time", UtilClean.truncateMiddle(this.ownerUUID), workPart, timePart);
        return (int)timePart;
    }

    public int getMaxState() {
        return this.maxState;
    }

    public WorkLocation location() {
        return this.location;
    }

    public DeclarativeJobChecks<MCExtra, MCHeldItem, MCTownItem, RoomRecipeMatch<MCRoom>, BlockPos> getChecks() {
        return this.checks;
    }

    @Override
    protected void setupForGetSupplies(TownInterface town, BlockPos pos, Long currentTick) {
        if (FetcherHack.isFetcher(this.jobId) && this.inventory.m_7983_()) {
            this.suppliesTarget = FetcherHack.getTarget(town);
            return;
        }
        super.setupForGetSupplies(town, pos, currentTick);
    }

    @Override
    @Nullable
    protected ContainerTarget<MCContainer, MCTownItem> getDropTargetForLoot(BlockPos entityBlockPos, TownInterface town) {
        ContainerTarget<MCContainer, MCTownItem> defaultTarget = super.getDropTargetForLoot(entityBlockPos, town);
        if (!FetcherHack.isFetcher(this.jobId)) {
            return defaultTarget;
        }
        return FetcherHack.getDropTargetForLoot(town, ((ProductionJournal)this.journal).getItems(), defaultTarget);
    }

    @Override
    public Iterable<MCHeldItem> getItemsForDrop() {
        if (!FetcherHack.isFetcher(this.jobId)) {
            return super.getItemsForDrop();
        }
        return FetcherHack.getItemsForDrop(super.getItemsForDrop(), this.successTarget);
    }

    public String getIngredient(@Nullable Integer integer) {
        return Util.orNull((Ingredient)this.initialIngredients.get((Object)integer), Ingredients::toString);
    }

    public String getTool(@Nullable Integer integer) {
        return Util.orNull((Ingredient)this.initialTools.get((Object)integer), Ingredients::toString);
    }

    @Override
    public void log(String s, Object ... args) {
        this.logger.log(s, args);
    }
}

