/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs;

import ca.bradj.questown.core.Pair;
import ca.bradj.questown.jobs.EntityInvStateProvider;
import ca.bradj.questown.jobs.EntityLocStateProvider;
import ca.bradj.questown.jobs.ILZCD;
import ca.bradj.questown.jobs.IProductionStatusFactory;
import ca.bradj.questown.jobs.IStatus;
import ca.bradj.questown.jobs.IStatusFactory;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.JobTownProvider;
import ca.bradj.questown.jobs.JobTownStates;
import ca.bradj.questown.jobs.LZCD;
import ca.bradj.questown.jobs.LZCDs;
import ca.bradj.questown.jobs.Populated;
import ca.bradj.questown.jobs.SupplyItemStatus;
import ca.bradj.questown.jobs.TownStateProvider;
import ca.bradj.questown.jobs.declarative.WithReason;
import ca.bradj.questown.jobs.production.IProductionJob;
import ca.bradj.questown.jobs.production.IProductionStatus;
import ca.bradj.questown.jobs.production.RoomsNeedingVillagerInput;
import ca.bradj.roomrecipes.core.Room;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JobStatuses {
    public static boolean hasItems(EntityInvStateProvider<?> inventory) {
        if (inventory.hasNonSupplyItems()) {
            return true;
        }
        return inventory.getSupplyItemStatus().values().stream().anyMatch(v -> v == SupplyItemStatus.HAS_ITEM);
    }

    @Deprecated(since="0.0.9")
    public static <STATUS extends IStatus<STATUS>, SUP_CAT> STATUS usualRoutine(STATUS currentStatus, boolean prioritizeExtraction, EntityInvStateProvider<SUP_CAT> inventory, TownStateProvider town, Job<STATUS, SUP_CAT> job, IStatusFactory<STATUS> factory) {
        return JobStatuses.usualRoutine(new UsualRoutineContext<STATUS, SUP_CAT>(new JobID("unknown", "unknown"), currentStatus, prioritizeExtraction, inventory, town, job, factory));
    }

    public static <STATUS extends IStatus<STATUS>, SUP_CAT> STATUS usualRoutine(UsualRoutineContext<STATUS, SUP_CAT> ctx) {
        LZCD<STATUS> root = JobStatuses.usualRoutineRoot(ctx);
        root.initializeAll();
        return (STATUS)JobStatuses.nullIfUnchanged(ctx.currentStatus, (IStatus)root.resolve());
    }

    @NotNull
    public static <STATUS extends IStatus<STATUS>, SUP_CAT> LZCD<STATUS> usualRoutineRoot(UsualRoutineContext<STATUS, SUP_CAT> ctx) {
        EntityInvStateProvider inventory = ctx.inventory();
        Map supplyItemStatus = inventory.getSupplyItemStatus();
        LZCD<LZCD.Dependency<STATUS>> dHasWorkItems = JobStatuses.prePopAble(new Pair<JobID, String>(ctx.jobId, "hasWorkItems"), () -> supplyItemStatus.containsValue((Object)SupplyItemStatus.HAS_ITEM));
        LZCD<LZCD.Dependency<STATUS>> dHasNonWorkItems = JobStatuses.prePopAble(new Pair<JobID, String>(ctx.jobId, "hasNonWorkItems"), inventory::hasNonSupplyItems);
        LZCD<LZCD.Dependency<STATUS>> dHasAnyItems = JobStatuses.prePopAble(new Pair<JobID, String>(ctx.jobId, "hasAnyItems"), () -> supplyItemStatus.containsValue((Object)SupplyItemStatus.HAS_ITEM) || inventory.hasNonSupplyItems());
        LZCD<LZCD.Dependency<STATUS>> dInventoryEmpty = JobStatuses.prePopAble(new Pair<JobID, String>(ctx.jobId, "inventory empty"), () -> !supplyItemStatus.containsValue((Object)SupplyItemStatus.HAS_ITEM) || !inventory.hasNonSupplyItems());
        LZCD dInventoryFull = JobStatuses.prePopAble(new Pair<JobID, String>(ctx.jobId, "inventory full"), inventory::inventoryFull);
        LZCD<LZCD.Dependency<STATUS>> dPrioritizeExtraction = JobStatuses.prePopAble(new Pair<JobID, String>(ctx.jobId, "prioritizing extraction"), () -> ctx.prioritizeExtraction);
        LZCD<LZCD.Dependency<IStatus>> dStatusNotGoing = JobStatuses.input(new Pair<JobID, String>(ctx.jobId, "not going to jobsite"), s -> !ctx.factory.goingToJobSite().equals(s));
        TownStateProvider town = ctx.town;
        ILZCD<LZCD.Dependency<STATUS>> dTownHasSpace = JobStatuses.fromVoid(town.hasSpace());
        ILZCD<LZCD.Dependency<STATUS>> dTimerActive = JobStatuses.fromVoid(town.isTimerActive());
        ILZCD<LZCD.Dependency<STATUS>> dTownHasSupplies = JobStatuses.fromVoid(town.hasSupplies());
        ILZCD<LZCD.Dependency<STATUS>> dTownHasNoSupplies = JobStatuses.fromVoid(LZCDs.invert(town.hasSupplies()));
        ILZCD<LZCD.Dependency<STATUS>> dHasWorkableBlocks = JobStatuses.fromVoid(town.containsWorkableBlocksAtAnyState());
        ILZCD<LZCD.Dependency<STATUS>> dHasNoWorkableBlocks = JobStatuses.fromVoid(LZCDs.invert(town.containsWorkableBlocksAtAnyState()));
        Job job = ctx.job;
        IStatusFactory factory = ctx.factory;
        LZCD<IStatus> root = new LZCD<IStatus>(new Pair<JobID, String>(ctx.jobId, "work without items"), LZCDs.leaf(job::tryChoosingItemlessWork, Objects::isNull), (Collection<ILZCD<LZCD.Dependency<IStatus>>>)ImmutableList.of(dPrioritizeExtraction, dStatusNotGoing), (ILZCD<IStatus>)new LZCD<IStatus>(new Pair<JobID, String>(ctx.jobId, "use items"), LZCDs.leaf(() -> (IStatus)job.tryUsingSupplies(supplyItemStatus), Objects::isNull), (Collection<ILZCD<LZCD.Dependency<IStatus>>>)ImmutableList.of(dHasWorkItems, dHasWorkableBlocks), (ILZCD<IStatus>)new LZCD<IStatus>(new Pair<JobID, String>(ctx.jobId, "work in different room without items"), LZCDs.leaf(job::tryChoosingItemlessWork, Objects::isNull), (Collection<ILZCD<LZCD.Dependency<IStatus>>>)ImmutableList.of(dPrioritizeExtraction, dHasWorkableBlocks), (ILZCD<IStatus>)new LZCD<IStatus>(new Pair<JobID, String>(ctx.jobId, "drop loot when hands full"), JobStatuses.leaf(factory::droppingLoot), (Collection<ILZCD<LZCD.Dependency<IStatus>>>)ImmutableList.of(dInventoryFull, dTownHasSpace), (ILZCD<IStatus>)LZCDs.oneDep(new Pair<JobID, String>(ctx.jobId, "stop when no space and hands full"), JobStatuses.leaf(factory::noSpace), dInventoryFull, new LZCD<IStatus>(new Pair<JobID, String>(ctx.jobId, "drop loot from non-full hands before starting more work"), JobStatuses.leaf(factory::droppingLoot), (Collection<ILZCD<LZCD.Dependency<IStatus>>>)ImmutableList.of(dHasNonWorkItems, dTownHasSpace), (ILZCD<IStatus>)new LZCD<IStatus>(new Pair<JobID, String>(ctx.jobId, "get work supplies"), JobStatuses.leaf(factory::collectingSupplies), (Collection<ILZCD<LZCD.Dependency<IStatus>>>)ImmutableList.of(dTownHasSupplies), (ILZCD<IStatus>)new LZCD<IStatus>(new Pair<JobID, String>(ctx.jobId, "drop loot when no work supplies available"), JobStatuses.leaf(factory::droppingLoot), (Collection<ILZCD<LZCD.Dependency<IStatus>>>)ImmutableList.of(dHasNonWorkItems, dHasWorkableBlocks, dTownHasSpace), (ILZCD<IStatus>)new LZCD<IStatus>(new Pair<JobID, String>(ctx.jobId, "drop loot when no work possible"), JobStatuses.leaf(factory::droppingLoot), (Collection<ILZCD<LZCD.Dependency<IStatus>>>)ImmutableList.of(dHasAnyItems, dTownHasSpace), (ILZCD<IStatus>)new LZCD<IStatus>(new Pair<JobID, String>(ctx.jobId, "wait for next stage is timer is active"), JobStatuses.leaf(factory::waitingForTimedState), (Collection<ILZCD<LZCD.Dependency<IStatus>>>)ImmutableList.of(dTimerActive), (ILZCD<IStatus>)new LZCD<IStatus>(new Pair<JobID, String>(ctx.jobId, "stop (nojobsite) when nowhere to work and town has items"), JobStatuses.leaf(factory::noJobSite), (Collection<ILZCD<LZCD.Dependency<IStatus>>>)ImmutableList.of(dTownHasSupplies, dInventoryEmpty), (ILZCD<IStatus>)new LZCD<IStatus>(new Pair<JobID, String>(ctx.jobId, "stop when no space and holding any items"), JobStatuses.leaf(factory::noSpace), (Collection<ILZCD<LZCD.Dependency<IStatus>>>)ImmutableList.of(dHasAnyItems), (ILZCD<IStatus>)new LZCD<IStatus>(new Pair<JobID, String>(ctx.jobId, "stop when no jobsite and no usable supplies in town"), JobStatuses.leaf(factory::noJobSite), (Collection<ILZCD<LZCD.Dependency<IStatus>>>)ImmutableList.of(dInventoryEmpty, dTownHasNoSupplies, dHasNoWorkableBlocks), JobStatuses.leaf(factory::noSupplies))))))))))))));
        return root;
    }

    private static <STATUS extends IStatus<STATUS>> ILZCD<LZCD.Dependency<STATUS>> fromVoid(LZCD.Dependency<Void> dep) {
        return LZCDs.noDeps(new Pair<JobID, String>(new JobID("unknown", "unknown"), dep.getName()), () -> dep, Objects::isNull);
    }

    @NotNull
    private static <STATUS extends IStatus<STATUS>> ILZCD<STATUS> leaf(Supplier<STATUS> factory) {
        return LZCDs.leaf(factory, Objects::isNull);
    }

    public static <STATUS extends IProductionStatus<STATUS>, ROOM extends Room> STATUS productionRoutine(STATUS currentStatus, boolean prioritizeExtraction, EntityInvStateProvider<Integer> inventory, final EntityLocStateProvider<ROOM> entity, final JobTownProvider<ROOM> town, final IProductionJob<STATUS> job, final IProductionStatusFactory<STATUS> factory) {
        if (factory.waitingForTimedState().equals(currentStatus) && town.isUnfinishedTimeWorkPresent()) {
            return null;
        }
        STATUS status = JobStatuses.usualRoutine(currentStatus, prioritizeExtraction, inventory, JobTownStates.forTown(town), new Job<STATUS, Integer>(){

            @Override
            @Nullable
            public STATUS tryChoosingItemlessWork() {
                Object location = entity.getEntityCurrentJobSite();
                Collection<Integer> states = town.getStatesWithUnfinishedItemlessWork();
                if (!states.isEmpty()) {
                    for (Integer state : states) {
                        if (location == null || !town.roomsAtState(state).contains(location)) continue;
                        return factory.fromJobBlockState(state);
                    }
                    return (IProductionStatus)factory.goingToJobSite();
                }
                Collection rooms = town.roomsWithCompletedProduct();
                if (rooms.isEmpty()) {
                    return null;
                }
                if (location != null && rooms.contains(location)) {
                    return (IProductionStatus)factory.extractingProduct();
                }
                return (IProductionStatus)factory.goingToJobSite();
            }

            @Override
            @Nullable
            public STATUS tryUsingSupplies(Map<Integer, SupplyItemStatus> supplyItemStatus) {
                if (supplyItemStatus.isEmpty()) {
                    return null;
                }
                Object location = entity.getEntityCurrentJobSite();
                RoomsNeedingVillagerInput roomNeedsMap = town.roomsNeedingIngredientsByState().floor();
                boolean foundWork = false;
                List<Integer> orderedWithSupplies = job.getAllWorkStatesSortedByPreference().stream().filter(work -> supplyItemStatus.getOrDefault(work, SupplyItemStatus.NOT_REQUIRED) != SupplyItemStatus.NEEDS_ITEM).toList();
                for (Integer s : orderedWithSupplies) {
                    if (!roomNeedsMap.containsKey(s) || roomNeedsMap.get(s).isEmpty()) continue;
                    foundWork = true;
                    if (location == null) continue;
                    Stream stream = roomNeedsMap.get(s).stream();
                    if (!(stream = stream.filter(v -> !v.dueToWorkOnly())).anyMatch(v -> location.equals(v.room().getRoom()))) continue;
                    return factory.fromJobBlockState(s);
                }
                if (foundWork) {
                    return (IProductionStatus)factory.goingToJobSite();
                }
                return (IProductionStatus)job.tryUsingSupplies(supplyItemStatus);
            }
        }, factory);
        if ((status == null || ((IProductionStatus)factory.idle()).equals(status) || ((IProductionStatus)factory.noSupplies()).equals(status)) && town.isUnfinishedTimeWorkPresent()) {
            return (STATUS)factory.waitingForTimedState();
        }
        return status;
    }

    private static <S> S nullIfUnchanged(S oldStatus, S newStatus) {
        if (oldStatus == newStatus) {
            return null;
        }
        return newStatus;
    }

    private static <STATUS> LZCD<LZCD.Dependency<STATUS>> prePopAble(final Pair<JobID, String> name, final Supplier<Boolean> s) {
        return LZCDs.noDeps(name, () -> new LZCD.Dependency<STATUS>(){
            private WithReason<Boolean> value;

            @Override
            public Populated<WithReason<Boolean>> populate() {
                this.value = WithReason.always((Boolean)s.get(), "input", new Object[0]);
                return new Populated<WithReason<Boolean>>(name.toString(), this.value, (Map)ImmutableMap.of(), null){

                    @Override
                    protected String stringRep() {
                        return "PrePopulatable[" + String.valueOf(value) + "]";
                    }
                };
            }

            @Override
            public String describe() {
                String v = this.value == null ? "<?>" : this.value.toString();
                return name.toString() + "=" + v;
            }

            @Override
            public String getName() {
                return (String)name.b();
            }

            @Override
            public WithReason<Boolean> apply(Supplier<STATUS> statusSupplier) {
                this.populate();
                return this.value;
            }
        }, v -> false);
    }

    private static <STATUS> LZCD<LZCD.Dependency<STATUS>> input(final Pair<JobID, String> name, final Function<STATUS, Boolean> s) {
        return LZCDs.noDeps(name, () -> new LZCD.Dependency<STATUS>(){

            @Override
            public Populated<WithReason<Boolean>> populate() {
                return new Populated<WithReason<Boolean>>((String)name.b(), WithReason.always(null, "cannot be pre-computed", new Object[0]), (Map)ImmutableMap.of(), null){

                    @Override
                    protected String stringRep() {
                        return "Input[Value TBD]";
                    }
                };
            }

            @Override
            public String describe() {
                return String.valueOf(name) + "=<?>";
            }

            @Override
            public String getName() {
                return (String)name.b();
            }

            @Override
            public WithReason<Boolean> apply(Supplier<STATUS> statusSupplier) {
                return WithReason.always((Boolean)s.apply(statusSupplier.get()), "input", new Object[0]);
            }
        }, v -> false);
    }

    public record UsualRoutineContext<STATUS extends IStatus<STATUS>, SUP_CAT>(JobID jobId, STATUS currentStatus, boolean prioritizeExtraction, EntityInvStateProvider<SUP_CAT> inventory, TownStateProvider town, Job<STATUS, SUP_CAT> job, IStatusFactory<STATUS> factory) {
    }

    public static interface Job<STATUS, SUP_CAT> {
        @Nullable
        public STATUS tryChoosingItemlessWork();

        @Nullable
        public STATUS tryUsingSupplies(Map<SUP_CAT, SupplyItemStatus> var1);
    }
}

