/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs;

import ca.bradj.questown.jobs.JobStatusesHelpers;
import ca.bradj.questown.jobs.JobTownProvider;
import ca.bradj.questown.jobs.LZCD;
import ca.bradj.questown.jobs.Populated;
import ca.bradj.questown.jobs.TownStateProvider;
import ca.bradj.questown.jobs.declarative.WithReason;
import ca.bradj.roomrecipes.core.Room;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import joptsimple.internal.Strings;
import org.jetbrains.annotations.Nullable;

public class JobTownStates {
    public static <ROOM extends Room> TownStateProvider forTown(final JobTownProvider<ROOM> town) {
        return new TownStateProvider(){

            @Override
            public LZCD.Dependency<Void> hasSupplies() {
                return town.hasSuppliesV2();
            }

            @Override
            public LZCD.Dependency<Void> hasSpace() {
                return new JobStatusesHelpers.PrePopDep<Void>("town has storage space", town::hasSpace);
            }

            @Override
            public LZCD.Dependency<Void> isTimerActive() {
                return new JobStatusesHelpers.PrePopDep<Void>("town has active timer", town::isUnfinishedTimeWorkPresent);
            }

            @Override
            public LZCD.Dependency<Void> containsWorkableBlocksAtAnyState() {
                return new RoomsWithWorkableBlocksAtAnyState(town.roomsWithWorkableStatefulBlocks());
            }
        };
    }

    private static class RoomsWithWorkableBlocksAtAnyState
    implements LZCD.Dependency<Void> {
        private static final String NAME = "town has workable blocks for ANY WorkState";
        private final Map<Integer, ? extends LZCD.Dependency<Void>> rooms;
        private final Map<Integer, Populated<WithReason<@Nullable Boolean>>> roomCache = new HashMap<Integer, Populated<WithReason<Boolean>>>();

        public RoomsWithWorkableBlocksAtAnyState(Map<Integer, ? extends LZCD.Dependency<Void>> rooms) {
            this.rooms = rooms;
        }

        @Override
        public Populated<WithReason<@Nullable Boolean>> populate() {
            for (Integer i : this.rooms.keySet()) {
                this.roomCache.put(i, this.rooms.get(i).populate());
            }
            ImmutableMap.Builder b = ImmutableMap.builder();
            this.roomCache.forEach((k, v) -> b.put((Object)k.toString(), v));
            final ImmutableMap build = b.build();
            return new Populated<WithReason<Boolean>>(this.getName(), this.apply(() -> null), (Map)build, null){

                @Override
                protected String stringRep() {
                    return "SupplyNeeds[" + String.valueOf(build) + "]";
                }
            };
        }

        @Override
        public String describe() {
            StringBuilder b = new StringBuilder(NAME).append("{");
            for (Integer k : this.rooms.keySet()) {
                b.append("\n\tStage: ").append(k).append(", RoomsWithWorkableBlocks=[");
                b.append(this.rooms.get(k).describe());
                b.append("]");
            }
            b.append("}");
            return b.toString();
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public WithReason<Boolean> apply(Supplier<Void> voidSupplier) {
            for (Integer i : this.rooms.keySet()) {
                Populated<WithReason<@Nullable Boolean>> cacheGet = this.roomCache.get(i);
                if (cacheGet == null) {
                    LZCD.Dependency<Void> voidDependency = this.rooms.get(i);
                    WithReason checkedTown = (WithReason)voidDependency.apply((Void)((Object)voidSupplier));
                    this.roomCache.put(i, voidDependency.populate());
                    if (!((Boolean)checkedTown.value).booleanValue()) continue;
                    return checkedTown;
                }
                if (!Boolean.TRUE.equals(cacheGet.value().value())) continue;
                return cacheGet.value();
            }
            return WithReason.always(Boolean.FALSE, "No rooms found with workable blocks at states [" + Strings.join(this.rooms.keySet().stream().map(Object::toString).toList(), (String)",") + "]", new Object[0]);
        }
    }
}

