/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs;

import ca.bradj.questown.QT;
import ca.bradj.questown.core.Pair;
import ca.bradj.questown.jobs.EntityCurrentJobSite;
import ca.bradj.questown.jobs.HeldItem;
import ca.bradj.questown.jobs.IStatus;
import ca.bradj.questown.jobs.Item;
import ca.bradj.questown.jobs.ItemsHolder;
import ca.bradj.questown.jobs.SupplyItemStatus;
import ca.bradj.questown.jobs.declarative.WithReason;
import ca.bradj.questown.jobs.production.RoomsNeedingVillagerInput;
import ca.bradj.questown.town.workstatus.State;
import ca.bradj.roomrecipes.adapter.IRoomRecipeMatch;
import ca.bradj.roomrecipes.core.Room;
import ca.bradj.roomrecipes.core.space.Position;
import ca.bradj.roomrecipes.logic.InclusiveSpaces;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JobsClean {
    public static <STATUS extends IStatus<STATUS>> STATUS doOrGoTo(STATUS status, boolean isAtJobSite, STATUS goStatus) {
        if (isAtJobSite) {
            return status;
        }
        return goStatus;
    }

    public static <HELD extends HeldItem<HELD, TOWN_ITEM>, TOWN_ITEM extends Item<TOWN_ITEM>> boolean hasNonSupplyItems(ItemsHolder<HELD> journal, ImmutableList<? extends Predicate<TOWN_ITEM>> recipe) {
        return journal.getItems().stream().filter(Predicates.not(Item::isEmpty)).anyMatch(Predicates.not(v -> recipe.stream().anyMatch(z -> z.test(v.get()))));
    }

    @NotNull
    static <I extends Item<I>> ImmutableMap<Integer, SupplyItemStatus> getSupplyItemStatuses(Supplier<Collection<I>> journal, Map<Integer, ? extends Predicate<I>> ingredientsRequiredAtStates, Function<Integer, Boolean> anyIngredientsRequiredAtStates, Map<Integer, ? extends Predicate<I>> toolsRequiredAtStates, Function<Integer, Boolean> anyToolsRequiredAtStates, Map<Integer, Integer> workRequiredAtStates, int maxState) {
        HashMap<Integer, SupplyItemStatus> b = new HashMap<Integer, SupplyItemStatus>();
        BiConsumer<Integer, Predicate> fn = (state, ingr) -> {
            boolean neededOrUnknown;
            if (ingr == null) {
                if (!b.containsKey(state)) {
                    b.put((Integer)state, SupplyItemStatus.NOT_REQUIRED);
                }
                return;
            }
            boolean hasItem = ((Collection)journal.get()).stream().anyMatch(ingr);
            boolean bl = neededOrUnknown = b.getOrDefault(state, SupplyItemStatus.NEEDS_ITEM) == SupplyItemStatus.NEEDS_ITEM;
            if (neededOrUnknown) {
                b.put((Integer)state, hasItem ? SupplyItemStatus.HAS_ITEM : SupplyItemStatus.NEEDS_ITEM);
            }
        };
        ingredientsRequiredAtStates.forEach(fn);
        toolsRequiredAtStates.forEach(fn);
        for (Map.Entry<Integer, Integer> work : workRequiredAtStates.entrySet()) {
            if (anyIngredientsRequiredAtStates.apply(work.getKey()).booleanValue() || anyToolsRequiredAtStates.apply(work.getKey()).booleanValue()) continue;
            b.put(work.getKey(), SupplyItemStatus.NOT_REQUIRED);
        }
        for (int i = 0; i < maxState; ++i) {
            fn.accept(i, null);
        }
        return ImmutableMap.copyOf(b);
    }

    public static <I extends Item<I>> boolean hasNonSupplyItems(Collection<I> items, int state, Map<Integer, ? extends Predicate<I>> ingredientsRequiredAtStates, Map<Integer, ? extends Predicate<I>> toolsRequiredAtStates) {
        if (items.isEmpty() || items.stream().allMatch(Item::isEmpty)) {
            return false;
        }
        items = items.stream().filter(v -> !v.isEmpty()).toList();
        Predicate ings = ingredientsRequiredAtStates.get(state);
        if (ings == null) {
            return items.stream().anyMatch(i -> JobsClean.isNotToolFromAnyStage(i, toolsRequiredAtStates));
        }
        return items.stream().anyMatch(v -> !ings.test(v));
    }

    private static <I> boolean isNotToolFromAnyStage(I i, Map<Integer, ? extends Predicate<I>> toolsRequiredAtStates) {
        for (Predicate<I> e : toolsRequiredAtStates.values()) {
            if (!e.test(i)) continue;
            return false;
        }
        return true;
    }

    public static <I extends Item<I>, H extends HeldItem<H, I>> boolean shouldTakeItem(int invCapacity, Collection<? extends Predicate<I>> neededItemsIn, Collection<H> currentHeldItems, I item) {
        if (neededItemsIn.isEmpty()) {
            return false;
        }
        if (currentHeldItems.stream().noneMatch(Item::isEmpty)) {
            return false;
        }
        ArrayList<Predicate<I>> neededItems = new ArrayList<Predicate<I>>(neededItemsIn);
        JobsClean.removeItemsAlreadyHeld(neededItems, currentHeldItems);
        return JobsClean.isItemNeeded(neededItems, item);
    }

    private static <I extends Item<I>> boolean isItemNeeded(Collection<Predicate<I>> itemsNeeded, I item) {
        for (Predicate<I> ingredient : itemsNeeded) {
            if (!ingredient.test(item)) continue;
            return true;
        }
        return false;
    }

    private static <I extends Item<I>, H extends HeldItem<H, I>> void removeItemsAlreadyHeld(ArrayList<Predicate<I>> ingredientsToSatisfy, Collection<H> currentHeldItems) {
        ArrayList<H> heldItemsToCheck = new ArrayList<H>(currentHeldItems);
        block0: for (int i = 0; i < ingredientsToSatisfy.size(); ++i) {
            for (HeldItem heldItem : heldItemsToCheck) {
                if (!ingredientsToSatisfy.get(i).test(heldItem.get())) continue;
                ingredientsToSatisfy.remove(i);
                --i;
                heldItemsToCheck.remove(heldItem);
                continue block0;
            }
        }
    }

    public static <ROOM, POS, MATCH extends IRoomRecipeMatch<ROOM, ?, POS, ?>> ImmutableList<MATCH> roomsWithState(Collection<MATCH> rooms, Predicate<POS> isCorrectBlock, Predicate<POS> hasCorrectState) {
        @NotNull List<WithReason<@Nullable MATCH>> filtered = JobsClean.filterByPredicates(rooms, isCorrectBlock, hasCorrectState);
        List<IRoomRecipeMatch> values = filtered.stream().map(v -> (IRoomRecipeMatch)v.value).filter(Objects::nonNull).toList();
        return ImmutableList.copyOf(values);
    }

    private static <ROOM, POS, MATCH extends IRoomRecipeMatch<ROOM, ?, POS, ?>> @NotNull List<WithReason<@Nullable MATCH>> filterByPredicates(Collection<MATCH> rooms, Predicate<POS> isCorrectBlock, Predicate<POS> hasCorrectState) {
        ArrayList<WithReason<@Nullable MATCH>> out = new ArrayList<WithReason<MATCH>>();
        for (IRoomRecipeMatch room : rooms) {
            out.add(JobsClean.describeFilteredRoom(room, isCorrectBlock, hasCorrectState));
        }
        return out;
    }

    private static <MATCH extends IRoomRecipeMatch<?, ?, POS, ?>, POS> WithReason<@Nullable MATCH> describeFilteredRoom(MATCH room, Predicate<POS> isCorrectBlock, Predicate<POS> hasCorrectState) {
        ImmutableMap allContainedBlocks = room.getContainedBlocks();
        HashSet allUniquePos = new HashSet(allContainedBlocks.keySet());
        ArrayList<WithReason<Object>> allTestedPos = new ArrayList<WithReason<Object>>();
        for (Object p : allUniquePos) {
            if (isCorrectBlock.test(p)) {
                allTestedPos.add(WithReason.always(p, "is correct block: " + String.valueOf(isCorrectBlock), new Object[0]));
                continue;
            }
            allTestedPos.add(WithReason.always(null, "is not correct block: " + String.valueOf(isCorrectBlock), new Object[0]));
        }
        if (allTestedPos.isEmpty()) {
            return WithReason.always(null, "None of the blocks are job blocks", new Object[0]);
        }
        List<Object> allTestedNonNullPos = allTestedPos.stream().filter(v -> v.value != null).map(v -> v.value).toList();
        for (Object e : allTestedNonNullPos) {
            if (e == null || !hasCorrectState.test(e)) continue;
            return WithReason.always(room, String.valueOf(e) + " had correct state", new Object[0]);
        }
        return WithReason.always(null, "None of the job blocks has correct state: [" + String.join((CharSequence)", ", allTestedNonNullPos.stream().map(Object::toString).toList()) + "]", new Object[0]);
    }

    public static <ROOM extends Room, RECIPE, POS> EntityCurrentJobSite<ROOM> getEntityCurrentJobSite(Position entityBlockPos, RoomsNeedingVillagerInput<ROOM, RECIPE, POS> roomsNeedingIngredientsOrTools, Collection<ROOM> roomsWithCompletedProduct, Predicate<ROOM> additionalPosCheck, Predicate<RECIPE> isFarm) {
        for (Room room : roomsWithCompletedProduct) {
            if (!InclusiveSpaces.contains((Iterable)room.getSpaces(), (Position)entityBlockPos)) continue;
            return new EntityCurrentJobSite<Room>(room, false);
        }
        Predicate<IRoomRecipeMatch> containsEntity = v -> {
            boolean contains = InclusiveSpaces.contains((Iterable)((Room)v.getRoom()).getSpaces(), (Position)entityBlockPos);
            return contains || ((Room)v.getRoom()).getDoorPos().equals((Object)entityBlockPos);
        };
        return roomsNeedingIngredientsOrTools.getMatches().stream().map(RoomsNeedingVillagerInput.NVIRoom::room).filter(v -> additionalPosCheck.test((Room)v.getRoom())).filter(containsEntity).findFirst().map(v -> new EntityCurrentJobSite<Room>((Room)v.getRoom(), v.getRecipeIDs().stream().anyMatch(isFarm))).orElse(null);
    }

    public static <ROOM extends Room, RECIPE, BLOCK> @NotNull WithReason<@Nullable BLOCK> findJobSite(int maxState, boolean prioritizeExtraction, Map<Integer, SupplyItemStatus> statusItems, Collection<ROOM> roomsWithFinishedProduct, Function<ROOM, BLOCK> getPositionWithin, RoomsNeedingVillagerInput<ROOM, RECIPE, BLOCK> blocksSrc, Function<BLOCK, State> work, Predicate<BLOCK> isJobBlock, BiFunction<BLOCK, ROOM, BLOCK> findInteractionSpot) {
        if (prioritizeExtraction && !roomsWithFinishedProduct.isEmpty()) {
            return WithReason.always(getPositionWithin.apply((Room)roomsWithFinishedProduct.iterator().next()), "prioritizing extraction and room has result", new Object[0]);
        }
        ArrayList<RoomsNeedingVillagerInput.NVIRoom<ROOM, RECIPE, BLOCK>> rooms = new ArrayList<RoomsNeedingVillagerInput.NVIRoom<ROOM, RECIPE, BLOCK>>(blocksSrc.getMatches());
        Collections.shuffle(rooms);
        boolean roomFoundButNotBlock = true;
        for (RoomsNeedingVillagerInput.NVIRoom match : rooms) {
            for (Map.Entry blocks : match.room().getContainedBlocks().entrySet()) {
                Object blockPos = blocks.getKey();
                State blockState = work.apply(blockPos);
                if (blockState == null) {
                    blockState = State.freshAtState(0);
                }
                if (!isJobBlock.test(blockPos)) continue;
                roomFoundButNotBlock = false;
                Supplier<Object> is = () -> findInteractionSpot.apply(blockPos, (Room)match.room().getRoom());
                if (maxState == blockState.processingState()) {
                    return new WithReason<Object>(is.get(), "Found extractable product");
                }
                SupplyItemStatus sis = statusItems.getOrDefault(blockState.processingState(), SupplyItemStatus.NOT_REQUIRED);
                if (sis == SupplyItemStatus.NEEDS_ITEM) continue;
                return new WithReason<Object>(is.get(), "Found a spot where a held item can be used");
            }
        }
        if (roomFoundButNotBlock) {
            return new WithReason<Object>(null, "Job site found, but no usable job blocks");
        }
        return new WithReason<Object>(null, "No job sites");
    }

    public static <POS, TOWN_ITEM extends Item<TOWN_ITEM>> boolean tryTakeContainerItems(Consumer<TOWN_ITEM> villager, SuppliesTarget<POS, TOWN_ITEM> suppliesTarget, Function<TOWN_ITEM, Boolean> isRemovalCandidate, Function<List<TOWN_ITEM>, List<Pair<Integer, TOWN_ITEM>>> adjustOrder) {
        if (!suppliesTarget.isCloseTo()) {
            return false;
        }
        String start = suppliesTarget.toShortString();
        List<Pair<Integer, TOWN_ITEM>> items = adjustOrder.apply(suppliesTarget.getItems());
        for (Pair<Integer, TOWN_ITEM> mcTownItem : items) {
            if (!isRemovalCandidate.apply((Item)mcTownItem.b()).booleanValue()) continue;
            Object unit = ((Item)mcTownItem.b()).unit();
            QT.JOB_LOGGER.debug("Villager is taking {} from {}", unit.getShortName(), start);
            villager.accept(unit);
            suppliesTarget.removeItem(mcTownItem.a());
            return true;
        }
        return false;
    }

    public static interface SuppliesTarget<POS, TOWN_ITEM> {
        public boolean isCloseTo();

        public String toShortString();

        public List<TOWN_ITEM> getItems();

        public void removeItem(int var1);
    }
}

