/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs;

import ca.bradj.questown.jobs.EmptyFactory;
import ca.bradj.questown.jobs.HeldItem;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;

public class JournalItemList<H extends HeldItem<H, ?>>
extends ArrayList<H> {
    public JournalItemList(int initialCapacity, EmptyFactory<H> ef) {
        super(initialCapacity);
        for (int i = 0; i < initialCapacity; ++i) {
            this.add((HeldItem)ef.makeEmptyItem());
        }
    }

    public void setItems(Iterable<H> items) {
        ImmutableList.Builder b = ImmutableList.builder();
        items.forEach(arg_0 -> ((ImmutableList.Builder)b).add(arg_0));
        ImmutableList initItems = b.build();
        if (initItems.size() != this.size()) {
            throw new IllegalArgumentException(String.format("Argument to setItems is wrong length. Should be %d but got %s", this.size(), initItems.size()));
        }
        this.clear();
        this.addAll(initItems);
    }
}

