/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs;

import ca.bradj.questown.core.Pair;
import ca.bradj.questown.jobs.ILZCD;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.Populated;
import ca.bradj.questown.jobs.declarative.WithReason;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LZCD<T>
implements ILZCD<T> {
    public final Pair<JobID, String> jobAndName;
    final ILZCD<T> wrapped;
    final Collection<? extends ILZCD<Dependency<T>>> conditions;
    final ILZCD<T> ifCondFail;
    @Nullable
    private T value = null;

    @Nullable
    public T getValue() {
        return this.value;
    }

    public LZCD(Pair<JobID, String> jobAndName, ILZCD<T> wrapped, Collection<? extends ILZCD<Dependency<T>>> conditions, ILZCD<T> ifCondFail) {
        this.jobAndName = jobAndName;
        this.wrapped = wrapped;
        this.conditions = ImmutableList.copyOf(conditions);
        this.ifCondFail = ifCondFail;
    }

    @Override
    public void initializeAll() {
        this.value = null;
        this.wrapped.initializeAll();
        if (this.ifCondFail != null) {
            this.ifCondFail.initializeAll();
        }
        for (ILZCD<Dependency<T>> condition : this.conditions) {
            condition.initializeAll();
        }
    }

    @Override
    public T resolve() {
        if (!this.isValueNull(this.value)) {
            return this.value;
        }
        Supplier<T> cacher = this.getValueWithCaching();
        int condPassed = this.checkConditions(cacher);
        if (condPassed < this.conditions.size()) {
            return this.ifCondFail.resolve();
        }
        T vv = this.setValue(cacher.get());
        if (vv == null) {
            return this.ifCondFail.resolve();
        }
        return vv;
    }

    @NotNull
    private Supplier<T> getValueWithCaching() {
        AtomicReference cached = new AtomicReference();
        Supplier<Object> cacher = () -> {
            if (cached.get() == null) {
                cached.set(this.wrapped.resolve());
            }
            return cached.get();
        };
        return cacher;
    }

    private int checkConditions(Supplier<T> cachedSelf) {
        int condPassed = 0;
        for (ILZCD<Dependency<T>> d : this.conditions) {
            WithReason apply;
            boolean v;
            Dependency<Supplier<T>> resolve = d.resolve();
            if (resolve == null || !(v = ((Boolean)(apply = (WithReason)resolve.apply(cachedSelf)).value()).booleanValue())) continue;
            ++condPassed;
        }
        return condPassed;
    }

    private T setValue(@Nullable T t) {
        return t;
    }

    @Override
    public boolean isValueNull(T value) {
        return value == null;
    }

    @Override
    public Populated<T> populate() {
        HashMap<String, Object> b = new HashMap<String, Object>();
        for (ILZCD<Dependency<T>> d : this.conditions) {
            d.populate();
            Populated<Dependency<T>> resolve = d.populate();
            if (resolve.value() == null) continue;
            Populated<WithReason<Boolean>> v = resolve.value().populate();
            b.put(resolve.value().describe(), v);
        }
        T resolve = this.wrapped.resolve();
        if (resolve == null) {
            b.put("wrapped value", "null (so fallback will be used)");
        }
        return new Populated<T>(this.jobAndName.b(), resolve, Collections.unmodifiableMap(b), this.ifCondFail.populate()){

            @Override
            protected String stringRep() {
                return LZCD.this.jobAndName.b();
            }
        };
    }

    public String toString() {
        String v;
        String string = v = this.value == null ? "<?>" : this.value.toString();
        if (this.conditions.isEmpty()) {
            return this.jobAndName.b() + "=" + v;
        }
        return String.format("(%s=%s) if [%s] else (%s)", this.jobAndName.b(), v, String.join((CharSequence)",", this.conditions.stream().map(z -> {
            Populated resolve = z.populate();
            if (resolve == null) {
                return "null";
            }
            return resolve.toString();
        }).toList()), this.ifCondFail);
    }

    public static interface Dependency<T>
    extends Function<Supplier<T>, WithReason<Boolean>> {
        public Populated<WithReason<@Nullable Boolean>> populate();

        public String describe();

        public String getName();
    }
}

