/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs;

import ca.bradj.questown.core.Pair;
import ca.bradj.questown.jobs.ILZCD;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.LZCD;
import ca.bradj.questown.jobs.Populated;
import ca.bradj.questown.jobs.SimpleDependency;
import ca.bradj.questown.jobs.declarative.WithReason;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class LZCDs {
    public static <T> LZCD<T> oneDep(Pair<JobID, String> name, ILZCD<T> wrapped, ILZCD<LZCD.Dependency<T>> condition, ILZCD<T> ifCondFail) {
        return new LZCD<T>(name, wrapped, ImmutableList.of(condition), ifCondFail);
    }

    public static <T> LZCD<T> noDeps(final Pair<JobID, String> name, final Supplier<T> o, final Predicate<T> isNull) {
        return new LZCD<Object>(name, new ILZCD<T>(){
            private Populated<T> populated = null;
            private T val;

            @Override
            public void initializeAll() {
                this.val = null;
                this.populated = null;
            }

            @Override
            public boolean isValueNull(T val) {
                return isNull.test(val);
            }

            @Override
            public T resolve() {
                this.val = o.get();
                return this.val;
            }

            @Override
            public Populated<T> populate() {
                if (this.populated != null) {
                    return this.populated;
                }
                this.populated = new Populated<T>(name.toString(), this.resolve(), (Map)ImmutableMap.of(), null){

                    @Override
                    protected String stringRep() {
                        return String.valueOf(name) + " [no dependencies]";
                    }
                };
                return this.populated;
            }
        }, (Collection<ILZCD<LZCD.Dependency<Object>>>)ImmutableList.of(), LZCDs.leaf(() -> null, v -> true));
    }

    public static <T> ILZCD<T> leaf(final Supplier<T> o, final Predicate<T> isNull) {
        return new ILZCD<T>(){
            private Populated<T> populated = null;
            @Nullable
            T value = null;

            @Override
            public void initializeAll() {
                this.value = null;
            }

            @Override
            public boolean isValueNull(T value) {
                return isNull.test(value);
            }

            @Override
            public T resolve() {
                return o.get();
            }

            @Override
            public Populated<T> populate() {
                if (this.populated != null) {
                    return this.populated;
                }
                this.value = this.resolve();
                this.populated = new Populated<T>("value resolver", this.value, (Map)ImmutableMap.of(), null){

                    @Override
                    protected String stringRep() {
                        return "leaf node [" + String.valueOf(value) + "]";
                    }
                };
                return this.populated;
            }

            public String toString() {
                return "leaf node [" + String.valueOf(this.value == null ? "<?>" : this.value) + "]";
            }
        };
    }

    public static LZCD.Dependency<Void> invert(final LZCD.Dependency<Void> voidDependency) {
        return new SimpleDependency(voidDependency.getName() + " (result inverted)"){

            @Override
            protected Populated<WithReason<Boolean>> doPopulate(boolean stopOnTrue) {
                Populated<WithReason<Boolean>> p = voidDependency.populate();
                return new Populated<WithReason<Boolean>>(p.name(), p.value().map(v -> v == false).wrap("inverted"), p.conditions(), p.ifCondFailOrNull()){

                    @Override
                    protected String stringRep() {
                        return "inverted value of " + voidDependency.getName();
                    }
                };
            }

            @Override
            public String describe() {
                return voidDependency.describe() + "(result inverted)";
            }
        };
    }
}

