/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs;

import ca.bradj.questown.integration.minecraft.MCContainer;
import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.integration.minecraft.MCTownItem;
import ca.bradj.questown.integration.minecraft.MCTownState;
import ca.bradj.questown.items.EffectMetaItem;
import ca.bradj.questown.jobs.DeclarativeJobChecks;
import ca.bradj.questown.jobs.EntityInvStateProvider;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.JobTownProvider;
import ca.bradj.questown.jobs.Jobs;
import ca.bradj.questown.jobs.JobsClean;
import ca.bradj.questown.jobs.LZCD;
import ca.bradj.questown.jobs.ProductionTimeWarper;
import ca.bradj.questown.jobs.SupplyItemStatus;
import ca.bradj.questown.jobs.WorkEffects;
import ca.bradj.questown.jobs.WorkOutput;
import ca.bradj.questown.jobs.WorkPosition;
import ca.bradj.questown.jobs.WorkSpot;
import ca.bradj.questown.jobs.WorkedSpot;
import ca.bradj.questown.jobs.declarative.AbstractWorldInteraction;
import ca.bradj.questown.jobs.declarative.NeedsRegistrations;
import ca.bradj.questown.jobs.declarative.PostExtractHook;
import ca.bradj.questown.jobs.declarative.PostInsertHook;
import ca.bradj.questown.jobs.declarative.PreExtractHook;
import ca.bradj.questown.jobs.declarative.PreStateChangeHook;
import ca.bradj.questown.jobs.leaver.ContainerTarget;
import ca.bradj.questown.jobs.production.ProductionStatus;
import ca.bradj.questown.jobs.production.RoomsNeedingVillagerInput;
import ca.bradj.questown.logic.PredicateCollection;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.mc.Util;
import ca.bradj.questown.town.Claim;
import ca.bradj.questown.town.Effect;
import ca.bradj.questown.town.TownState;
import ca.bradj.questown.town.TownVillagerMoods;
import ca.bradj.questown.town.interfaces.ImmutableWorkStateContainer;
import ca.bradj.questown.town.workstatus.State;
import ca.bradj.roomrecipes.adapter.RoomRecipeMatch;
import ca.bradj.roomrecipes.serialization.MCRoom;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MCTownStateWorldInteraction
extends AbstractWorldInteraction<Inputs, BlockPos, MCTownItem, MCHeldItem, MCTownState> {
    private final BlockPos townPos;
    private final BiFunction<ServerLevel, Collection<MCHeldItem>, Iterable<MCHeldItem>> resultGenerator;

    public MCTownStateWorldInteraction(BlockPos townPos, JobID jobId, int villagerIndex, int interval, int maxState, DeclarativeJobChecks<Inputs, MCHeldItem, MCTownItem, RoomRecipeMatch<MCRoom>, BlockPos> checks, BiFunction<ServerLevel, Collection<MCHeldItem>, Iterable<MCHeldItem>> resultGenerator, Function<Inputs, Claim> claimSpots, Map<ProductionStatus, Collection<String>> specialRules) {
        super(jobId, villagerIndex, interval, maxState, checks, claimSpots, specialRules);
        this.resultGenerator = resultGenerator;
        this.townPos = townPos;
    }

    @Override
    protected int getWorkSpeedOf10(Inputs inputs) {
        Collection<Effect> effects = inputs.town().getVillager(this.villagerIndex).getEffectsAndClearExpired(Util.getTick(inputs.level()));
        return Math.max(TownVillagerMoods.compute(effects) / 10, 1);
    }

    @Override
    protected int getAffectedTime(Inputs inputs, Integer nextStepTime) {
        return (int)(this.getTimeFactor(inputs) * (float)nextStepTime.intValue());
    }

    private float getTimeFactor(Inputs inputs) {
        Collection<Effect> effects = inputs.town().getVillager(this.villagerIndex).getEffectsAndClearExpired(Util.getTick(inputs.level()));
        return WorkEffects.calculateTimeFactor(effects);
    }

    @Override
    protected MCTownState setHeldItem(Inputs uxtra, MCTownState tuwn, int villagerIndex, int itemIndex, MCHeldItem item) {
        if (tuwn == null) {
            tuwn = uxtra.town();
        }
        TownState.VillagerData villager = (TownState.VillagerData)tuwn.villagers.get(villagerIndex);
        return (MCTownState)tuwn.withVillagerData(villagerIndex, villager.withSetItem(itemIndex, item));
    }

    @Override
    protected MCTownState degradeTool(Inputs mcTownState, @Nullable MCTownState tuwn, PredicateCollection<MCTownItem, ?> isExpectedTool) {
        if (tuwn == null) {
            tuwn = mcTownState.town();
        }
        int i = -1;
        for (MCHeldItem item : this.getHeldItems(mcTownState, this.villagerIndex)) {
            ++i;
            if (!isExpectedTool.test(item.get())) continue;
            ItemStack itemStack = item.get().toQTItemStack();
            itemStack.m_220157_(1, mcTownState.level.m_213780_(), null);
            if (itemStack.m_41773_() >= itemStack.m_41776_()) {
                itemStack = ItemStack.f_41583_;
            }
            return this.setHeldItem(mcTownState, tuwn, this.villagerIndex, i, MCHeldItem.fromMCItemStack(itemStack));
        }
        return tuwn;
    }

    @Override
    protected boolean canInsertItem(Inputs mcTownState, MCHeldItem item, BlockPos bp) {
        return true;
    }

    @Override
    protected ImmutableWorkStateContainer<BlockPos, MCTownState> getWorkStatuses(Inputs mcTownState) {
        return mcTownState.town();
    }

    @Override
    protected WorkOutput<MCTownState, WorkPosition<BlockPos>> getWithSurfaceInteractionPos(Inputs inputs, WorkOutput<MCTownState, WorkPosition<BlockPos>> v) {
        return Util.workWithSurfaceInteractionPos(inputs.level(), v);
    }

    @Override
    protected ArrayList<WorkPosition<BlockPos>> shuffle(Inputs inputs, Collection<WorkPosition<BlockPos>> workSpots) {
        return new ArrayList<WorkPosition<BlockPos>>((Collection<WorkPosition<BlockPos>>)Compat.shuffle(ImmutableList.copyOf(workSpots), inputs.level));
    }

    @Override
    protected WorkedSpot<BlockPos> getCurWorkedSpot(Inputs inputs, MCTownState stateSource, BlockPos workSpot) {
        int stateAfterWork = stateSource.getJobBlockState(workSpot).processingState();
        return new WorkedSpot<BlockPos>(workSpot, stateAfterWork);
    }

    @Override
    protected Collection<MCHeldItem> getHeldItems(Inputs mcTownState, int villagerIndex) {
        return ProductionTimeWarper.getHeldItems(mcTownState.town(), villagerIndex);
    }

    @Override
    protected void triggerCompletionAdvancement(Inputs inputs, BlockPos position) {
    }

    @Override
    protected void preStateChangeHooks(@NotNull MCTownState ctx, Collection<String> rules, Inputs inputs, WorkSpot<Integer, BlockPos> position) {
        PreStateChangeHook.run(rules, pose -> {}, job -> {});
    }

    @Override
    @NotNull
    protected MCTownState postInsertHook(@NotNull MCTownState mcTownState, Collection<String> rules, Inputs inputs, WorkedSpot<BlockPos> position, MCHeldItem item) {
        return PostInsertHook.run(mcTownState, rules, inputs.level(), position, item.get().toMCItemStack(), ts -> (MCTownState)ts.withBOPCleared(inputs.vUUID), inputs.vUUID);
    }

    @Override
    protected BlockPos getTownPos(Inputs inputs) {
        return this.townPos;
    }

    @Override
    @Nullable
    protected MCTownState preExtractHook(MCTownState town, Collection<String> rules, Inputs inputs, BlockPos position) {
        Item insertedItem = null;
        return PreExtractHook.run(town, rules, inputs.level(), (ctx, i, s) -> {
            Inputs in = new Inputs((MCTownState)ctx, inputs.level(), inputs.vUUID());
            return (MCTownState)this.tryGiveItems(in, ImmutableList.of((Object)i), position);
        }, (ctx, up) -> ctx.withHungerFilledBy(inputs.vUUID, (Float)up), position, insertedItem, () -> {});
    }

    @Override
    protected MCTownState postExtractHook(MCTownState mcTownState, Collection<String> rules, Inputs inputs, BlockPos position, MCHeldItem extractedItem) {
        return PostExtractHook.run(mcTownState, this.townPos, rules, inputs.level(), position, (ctx, itemData) -> {
            CompoundTag t = extractedItem.get().toMCItemStack().m_41784_();
            itemData.forEach((arg_0, arg_1) -> ((CompoundTag)t).m_128405_(arg_0, arg_1));
            return ctx;
        });
    }

    @Override
    protected MCTownState setJobBlockState(@NotNull Inputs inputs, MCTownState ts, BlockPos position, State fresh) {
        return (MCTownState)ts.setJobBlockState(position, fresh);
    }

    @Override
    protected MCTownState withEffectApplied(@NotNull Inputs inputs, MCTownState ts, MCHeldItem newItem) {
        ItemStack s = newItem.get().toQTItemStack();
        ResourceLocation effect = EffectMetaItem.getEffect(s);
        return (MCTownState)ts.withVillagerData(this.villagerIndex, ts.getVillager(this.villagerIndex).withEffect(new Effect(effect, EffectMetaItem.getEffectExpiry(s, Util.getTick(inputs.level)))));
    }

    @Override
    protected MCTownState withKnowledge(@NotNull Inputs inputs, MCTownState ts, MCHeldItem newItem) {
        return ts.withKnowledge(newItem);
    }

    @Override
    protected boolean isInstanze(MCTownItem mcTownItem, Class<?> clazz) {
        return clazz.isInstance(mcTownItem.get().m_5456_());
    }

    @Override
    protected boolean isMulti(MCTownItem mcTownItem) {
        return mcTownItem.toQTItemStack().m_41613_() > 1;
    }

    @Override
    protected MCTownState getTown(Inputs inputs) {
        return inputs.town();
    }

    @Override
    protected Iterable<MCHeldItem> getResults(Inputs inputs, Collection<MCHeldItem> mcHeldItems) {
        return this.resultGenerator.apply(inputs.level, mcHeldItems);
    }

    @Override
    protected boolean isEntityClose(Inputs mcTownState, BlockPos position) {
        return true;
    }

    @Override
    protected boolean isReady(Inputs mcTownState) {
        return true;
    }

    @Override
    public boolean tryGrabbingInsertedSupplies(Inputs mcExtra) {
        return true;
    }

    @Override
    public int timesInserted(Inputs inputs) {
        return 0;
    }

    @Override
    protected void registerUnmetNeed(Inputs inputs, NeedsRegistrations.Need ingredientIndex) {
    }

    @Override
    protected void registerUnmetRoom(Inputs inputs) {
    }

    public void injectTicks(int interval) {
        this.ticksSinceLastAction += interval;
    }

    public JobTownProvider<MCRoom> asTownJobs(final @NotNull State workStates, final RoomRecipeMatch<MCRoom> mcRoom, final BlockPos roomBlock, final @NotNull ImmutableList<ContainerTarget<MCContainer, MCTownItem>> containers) {
        return new JobTownProvider<MCRoom>(){

            @Override
            public Collection<MCRoom> roomsWithCompletedProduct() {
                if (workStates.processingState() == MCTownStateWorldInteraction.this.maxState) {
                    return ImmutableList.of((Object)((MCRoom)mcRoom.room));
                }
                return ImmutableList.of();
            }

            @Override
            public Collection<MCRoom> roomsAtState(Integer state) {
                if (workStates.processingState() == state.intValue()) {
                    return ImmutableList.of((Object)((MCRoom)mcRoom.room));
                }
                return ImmutableList.of();
            }

            @Override
            public RoomsNeedingVillagerInput<MCRoom, ResourceLocation, BlockPos> roomsNeedingIngredientsByState() {
                int curState = workStates.processingState();
                PredicateCollection ings = MCTownStateWorldInteraction.this.checks.getIngredientsForStep(curState);
                if (ings != null) {
                    return new RoomsNeedingVillagerInput<MCRoom, ResourceLocation, BlockPos>((Map<Integer, Collection<RoomsNeedingVillagerInput.NVIRoom<MCRoom, ResourceLocation, BlockPos>>>)ImmutableMap.of((Object)curState, (Object)ImmutableList.of(new RoomsNeedingVillagerInput.NVIRoom(mcRoom, false))));
                }
                PredicateCollection toolChk = MCTownStateWorldInteraction.this.checks.getToolsForStep(curState);
                if (toolChk != null) {
                    return new RoomsNeedingVillagerInput<MCRoom, ResourceLocation, BlockPos>((Map<Integer, Collection<RoomsNeedingVillagerInput.NVIRoom<MCRoom, ResourceLocation, BlockPos>>>)ImmutableMap.of((Object)curState, (Object)ImmutableList.of(new RoomsNeedingVillagerInput.NVIRoom(mcRoom, false))));
                }
                if (workStates.workLeft() > 0) {
                    return new RoomsNeedingVillagerInput<MCRoom, ResourceLocation, BlockPos>((Map<Integer, Collection<RoomsNeedingVillagerInput.NVIRoom<MCRoom, ResourceLocation, BlockPos>>>)ImmutableMap.of((Object)curState, (Object)ImmutableList.of(new RoomsNeedingVillagerInput.NVIRoom(mcRoom, false))));
                }
                return new RoomsNeedingVillagerInput<MCRoom, ResourceLocation, BlockPos>((Map<Integer, Collection<RoomsNeedingVillagerInput.NVIRoom<MCRoom, ResourceLocation, BlockPos>>>)ImmutableMap.of());
            }

            @Override
            public Map<Integer, LZCD.Dependency<Void>> roomsWithWorkableStatefulBlocks() {
                return Map.of();
            }

            @Override
            public LZCD.Dependency<Void> hasSuppliesV2() {
                return null;
            }

            @Override
            public boolean isUnfinishedTimeWorkPresent() {
                return false;
            }

            @Override
            public Collection<Integer> getStatesWithUnfinishedItemlessWork() {
                Collection<Integer> statesWithUnfinishedWork = Jobs.getStatesWithUnfinishedWork(() -> ImmutableList.of(() -> ImmutableList.of((Object)roomBlock)), bp -> workStates, bp -> true);
                ImmutableList.Builder b = ImmutableList.builder();
                statesWithUnfinishedWork.forEach(state -> {
                    if (MCTownStateWorldInteraction.this.checks.getToolsForStep((Integer)state) == null) {
                        b.add(state);
                    }
                });
                return b.build();
            }

            @Override
            public boolean hasSupplies() {
                PredicateCollection toolChk;
                int curState = workStates.processingState();
                PredicateCollection ings = MCTownStateWorldInteraction.this.checks.getIngredientsForStep(curState);
                if (ings != null) {
                    for (ContainerTarget container : containers) {
                        if (!container.hasItem(i -> ings.test(MCHeldItem.fromTown(i)))) continue;
                        return true;
                    }
                }
                if ((toolChk = MCTownStateWorldInteraction.this.checks.getToolsForStep(curState)) != null) {
                    for (ContainerTarget container : containers) {
                        if (!container.hasItem(toolChk::test)) continue;
                        return true;
                    }
                }
                return false;
            }

            @Override
            public boolean hasSpace() {
                return containers.stream().anyMatch(v -> !v.isFull());
            }
        };
    }

    public EntityInvStateProvider<Integer> asInventory(final Supplier<Collection<MCHeldItem>> heldItems, final Supplier<Integer> state) {
        return new EntityInvStateProvider<Integer>(){

            @Override
            public boolean inventoryFull() {
                Collection items = (Collection)heldItems.get();
                return items.stream().noneMatch(MCHeldItem::isEmpty);
            }

            @Override
            public boolean hasNonSupplyItems() {
                return JobsClean.hasNonSupplyItems((Collection)heldItems.get(), (Integer)state.get(), MCTownStateWorldInteraction.this.checks.getAllRequiredIngredients(), Jobs.unTown(MCTownStateWorldInteraction.this.checks.getAllRequiredTools()));
            }

            @Override
            public Map<Integer, SupplyItemStatus> getSupplyItemStatus() {
                return JobsClean.getSupplyItemStatuses(heldItems, MCTownStateWorldInteraction.this.checks.getAllRequiredIngredients(), s -> true, Jobs.unTown(MCTownStateWorldInteraction.this.checks.getAllRequiredTools()), s -> true, MCTownStateWorldInteraction.this.checks.getAllRequiredWork(), MCTownStateWorldInteraction.this.maxState);
            }
        };
    }

    public MCTownState simulateDropLoot(MCTownState inState, ProductionStatus status) {
        return ProductionTimeWarper.simulateDropLoot(inState, status, this.villagerIndex, MCHeldItem::Air);
    }

    @Nullable
    public MCTownState simulateCollectSupplies(MCTownState inState, int processingState) {
        Map ingr = this.checks.getAllRequiredIngredients();
        ImmutableMap<Integer, Predicate<MCHeldItem>> tool = Jobs.unTown(this.checks.getAllRequiredTools());
        return ProductionTimeWarper.simulateCollectSupplies(inState, processingState, this.villagerIndex, ingr, tool, MCHeldItem::fromTown);
    }

    @Override
    protected void iterate(Iterable<MCHeldItem> newItemsSource, Function<MCHeldItem, MCHeldItem> push) {
        Util.iterate(newItemsSource, push::apply);
    }

    public record Inputs(MCTownState town, ServerLevel level, UUID vUUID) {
    }
}

