/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs;

import ca.bradj.questown.QT;
import ca.bradj.questown.Questown;
import ca.bradj.questown.core.Config;
import ca.bradj.questown.core.Pair;
import ca.bradj.questown.core.UtilClean;
import ca.bradj.questown.gui.Ingredients;
import ca.bradj.questown.integration.SpecialRulesRegistry;
import ca.bradj.questown.integration.jobs.JobPhaseModifier;
import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.jobs.IStatus;
import ca.bradj.questown.jobs.IllegalJobDefinition;
import ca.bradj.questown.jobs.JobBlockTestContext;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.NotValidCoreStatus;
import ca.bradj.questown.jobs.Overrides;
import ca.bradj.questown.jobs.ResultGenerator;
import ca.bradj.questown.jobs.Work;
import ca.bradj.questown.jobs.WorkDescription;
import ca.bradj.questown.jobs.WorkLocation;
import ca.bradj.questown.jobs.WorkSpecialRules;
import ca.bradj.questown.jobs.WorkStates;
import ca.bradj.questown.jobs.WorkWorldInteractions;
import ca.bradj.questown.jobs.WorksBehaviour;
import ca.bradj.questown.jobs.declarative.SoundInfo;
import ca.bradj.questown.jobs.gatherer.GathererTools;
import ca.bradj.questown.jobs.gatherer.Loots;
import ca.bradj.questown.jobs.production.ProductionStatus;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.mc.Util;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.InactiveProfiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceJobLoader {
    public static final ReloadListener LISTENER = new ReloadListener();

    @NotNull
    private static WorkDescription description(@Nullable Item initReq, JsonObject object) {
        String type;
        if (!object.has("result")) {
            throw new IllegalArgumentException("result is required");
        }
        JsonObject rizz = object.get("result").getAsJsonObject();
        return switch (type = rizz.get("type").getAsString()) {
            case "biome_loot" -> ResourceJobLoader.biomeDesc(initReq, rizz);
            default -> WorksBehaviour.standardDescription(initReq == null ? () -> null : () -> ((Item)initReq).m_7968_());
        };
    }

    @NotNull
    private static WorkDescription biomeDesc(@Nullable Item initReq, JsonObject rizz) {
        String resultPrefix = ResourceJobLoader.required(rizz, "prefix", JsonElement::getAsString);
        GathererTools.LootTablePrefix lootTablePrefix = new GathererTools.LootTablePrefix(resultPrefix);
        return new WorkDescription(t -> t.allKnownGatherItemsFn().apply(lootTablePrefix), initReq == null ? null : initReq.m_7968_());
    }

    private static void registerRule(JsonElement rule, JsonObject rowObj, ImmutableList.Builder<String> globals, Map<ProductionStatus, List<String>> writeableStages) throws NotValidCoreStatus {
        String type;
        switch (type = rowObj.get("type").getAsString()) {
            case "global": {
                globals.add((Object)rule.getAsString());
                break;
            }
            case "processing_state": {
                int state = ResourceJobLoader.requiredInt(rowObj, "state");
                UtilClean.addOrInitializeList(writeableStages, ProductionStatus.fromJobBlockStatus(state), rule.getAsString());
                break;
            }
            case "core_state": {
                ProductionStatus productionStatus = ResourceJobLoader.getCore(rowObj);
                UtilClean.addOrInitializeList(writeableStages, productionStatus, rule.getAsString());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected special type " + type);
            }
        }
    }

    private static ProductionStatus getCore(JsonObject rowObj) {
        String name = ResourceJobLoader.required(rowObj, "state", JsonElement::getAsString);
        ImmutableSet<ProductionStatus> all = ProductionStatus.allStatuses();
        ProductionStatus productionStatus = all.stream().filter(v -> v.name.equals(name)).findFirst().orElseThrow(() -> new NotValidCoreStatus(name, all));
        return productionStatus;
    }

    @NotNull
    private static ResultGenerator<MCHeldItem> itemResult(final JsonObject object, final JsonObject rizz) {
        final Item resultItem = (Item)ForgeRegistries.ITEMS.getValue(ResourceJobLoader.required(rizz, "item"));
        return new ResultGenerator<MCHeldItem>(){

            @Override
            public Iterable<MCHeldItem> generate(ServerLevel level, Collection<MCHeldItem> heldItems) {
                if (resultItem == null) {
                    throw new IllegalArgumentException("Result item does not exist: " + object.get("icon").getAsString());
                }
                ItemStack s = resultItem.m_7968_();
                int qty = 1;
                if (rizz.has("quantity")) {
                    qty = rizz.get("quantity").getAsInt();
                }
                s.m_41764_(qty);
                MCHeldItem mci = MCHeldItem.fromMCItemStack(s);
                return ImmutableList.of((Object)mci);
            }

            @Override
            public boolean isResultAlwaysEmpty() {
                return resultItem == null || resultItem.m_7968_().m_41619_();
            }
        };
    }

    @NotNull
    private static ResultGenerator<MCHeldItem> biomeLootResult(JsonObject rizz) {
        final String resultPrefix = ResourceJobLoader.required(rizz, "prefix", JsonElement::getAsString);
        final String resultDefault = ResourceJobLoader.required(rizz, "default", JsonElement::getAsString);
        final int resultAttempts = ResourceJobLoader.requiredInt(rizz, "attempts");
        return new ResultGenerator<MCHeldItem>(){

            @Override
            public Iterable<MCHeldItem> generate(ServerLevel level, Collection<MCHeldItem> heldItems) {
                return Loots.getFromLootTables(level, heldItems, resultAttempts, new GathererTools.LootTableParameters(new GathererTools.LootTablePrefix(resultPrefix), new GathererTools.LootTablePath(resultDefault)));
            }

            @Override
            public boolean isResultAlwaysEmpty() {
                return false;
            }
        };
    }

    @NotNull
    private static ResultGenerator<MCHeldItem> lootResult(JsonObject rizz) {
        final String table = ResourceJobLoader.required(rizz, "table", JsonElement::getAsString);
        final int maxResults = ResourceJobLoader.requiredInt(rizz, "max_results");
        return new ResultGenerator<MCHeldItem>(){

            @Override
            public Iterable<MCHeldItem> generate(ServerLevel level, Collection<MCHeldItem> heldItems) {
                LootTables tables = level.m_7654_().m_129898_();
                LootTable loot = tables.m_79217_(ResourceLocation.m_135820_((String)table));
                return Loots.loadFromTables(level, loot, 1, maxResults).stream().map(MCHeldItem::fromTown).toList();
            }

            @Override
            public boolean isResultAlwaysEmpty() {
                return false;
            }
        };
    }

    @NotNull
    private static ResultGenerator<MCHeldItem> craftingTableResult(JsonObject rizz) {
        final JsonArray ingredientChar = ResourceJobLoader.required(rizz, "recipe", JsonElement::getAsJsonArray);
        final @Nullable String fallback = ResourceJobLoader.optional(rizz, "fallback", JsonElement::getAsString);
        final int qty = ResourceJobLoader.requiredInt(rizz, "quantity");
        return new ResultGenerator<MCHeldItem>(){

            @Override
            public Iterable<MCHeldItem> generate(ServerLevel l, Collection<MCHeldItem> heldItems) {
                ItemStack itemstack = ItemStack.f_41583_;
                CraftingContainer cc = new CraftingContainer(new AbstractContainerMenu(null, 0){

                    public ItemStack m_7648_(Player player, int i) {
                        return ItemStack.f_41583_;
                    }

                    public boolean m_6875_(Player p_38874_) {
                        return false;
                    }
                }, 3, 3);
                for (int j = 0; j < ingredientChar.size(); ++j) {
                    String rowStr = ingredientChar.get(j).getAsString();
                    for (int k = 0; k < rowStr.length(); ++k) {
                        if (Character.isWhitespace(rowStr.charAt(k))) continue;
                        ItemStack itemFromChar = Items.f_41837_.m_7968_();
                        cc.m_6836_((j + 1) * k, itemFromChar);
                    }
                }
                Optional optional = l.m_7654_().m_129894_().m_44015_(RecipeType.f_44107_, (Container)cc, (Level)l);
                if (optional.isPresent()) {
                    CraftingRecipe craftingrecipe = (CraftingRecipe)optional.get();
                    itemstack = craftingrecipe.m_5874_((Container)cc);
                }
                if (itemstack.m_41619_() && fallback != null) {
                    itemstack = ((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(fallback))).m_7968_();
                }
                itemstack.m_41764_(1);
                return ImmutableList.copyOf(Collections.nCopies(qty, MCHeldItem.fromMCItemStack(itemstack)));
            }

            @Override
            public boolean isResultAlwaysEmpty() {
                return false;
            }
        };
    }

    private static WorkStates workStates(JobID id, JsonObject object) {
        ImmutableMap.Builder ing = ImmutableMap.builder();
        HashMap<Integer, Supplier<Integer>> qty = new HashMap<Integer, Supplier<Integer>>();
        ImmutableMap.Builder tools = ImmutableMap.builder();
        ImmutableMap.Builder work = ImmutableMap.builder();
        ImmutableMap.Builder time = ImmutableMap.builder();
        JsonArray states = object.get("work_states").getAsJsonArray();
        int maxState = 0;
        for (int i = 0; i < states.size(); ++i) {
            JsonObject v = states.get(i).getAsJsonObject();
            boolean valid = false;
            if (v.has("ingredients")) {
                Ingredient ingredients = ResourceJobLoader.getIngredient(v.get("ingredients").getAsString());
                ing.put((Object)i, () -> ingredients);
                maxState = Math.max(maxState, i + 1);
                Util.putIfAbsent(qty, i, () -> 1);
                valid = true;
            }
            if (v.has("quantity")) {
                int quantity = v.get("quantity").getAsInt();
                qty.put(i, () -> quantity);
                maxState = Math.max(maxState, i + 1);
                valid = true;
            }
            if (v.has("tools")) {
                Ingredient tools1 = ResourceJobLoader.getIngredient(v.get("tools").getAsString());
                tools.put((Object)i, () -> tools1);
                maxState = Math.max(maxState, i + 1);
                valid = true;
            }
            if (v.has("work")) {
                int work1 = v.get("work").getAsInt();
                work.put((Object)i, () -> work1);
                maxState = Math.max(maxState, i + 1);
                boolean bl = valid = valid || i != 0;
            }
            if (v.has("time")) {
                int time1 = v.get("time").getAsInt();
                time.put((Object)i, () -> time1);
                maxState = Math.max(maxState, i + 1);
                valid = true;
            }
            if (valid) continue;
            String fmt = "Job %s is missing ingredients, tools, work, or time for state at index %d: %s";
            if (i == 0) {
                fmt = "Job %s is missing ingredients, tools, or time for state at index %d: %s";
            }
            throw new IllegalJobDefinition(String.format(fmt, id.toNiceString(), i, v));
        }
        return new WorkStates(maxState, (ImmutableMap<Integer, Supplier<Ingredient>>)ing.build(), (ImmutableMap<Integer, Supplier<Integer>>)ImmutableMap.copyOf(qty), (ImmutableMap<Integer, Supplier<Ingredient>>)tools.build(), (ImmutableMap<Integer, Supplier<Integer>>)work.build(), (ImmutableMap<Integer, Supplier<Integer>>)time.build());
    }

    private static BiPredicate<WorkLocation.BlockInfo, BlockPos> isJobBlock(String block) {
        Ingredient ing = ResourceJobLoader.getIngredient(block);
        return (sl, bp) -> ing.test(sl.state((BlockPos)bp).m_60734_().m_5456_().m_7968_());
    }

    private static Optional<Integer> getStateValue(BlockState state, String name) {
        return state.m_61148_().entrySet().stream().filter(v -> ((Property)v.getKey()).m_61708_().equals(name)).filter(v -> ((Property)v.getKey()).m_61709_().equals(Integer.class)).map(v -> (Integer)v.getValue()).findFirst();
    }

    private static Optional<ItemStack> getSlotValue(BlockEntity state, int slot) {
        if (!(state instanceof Container)) {
            return Optional.empty();
        }
        Container c = (Container)state;
        return Optional.of(c.m_8020_(slot));
    }

    private static BiPredicate<WorkLocation.BlockInfo, BlockPos> shouldInitWS(JsonObject block, WorkSpecialRules special) {
        Predicate<BlockState> baseTest = ResourceJobLoader.getBlockCheck(ResourceJobLoader.required(block, "id", JsonElement::getAsString));
        Optional<BlockStateComparator> stateComparator = ResourceJobLoader.getStateComparator(block);
        Optional<BlockSlotComparator> slotComparator = ResourceJobLoader.getSlotComparator(block);
        boolean requireAirAbove = special.containsGlobal("require_air_above");
        return (i, p) -> {
            if (requireAirAbove && !i.state(p.m_7494_()).m_60795_()) {
                return false;
            }
            BlockState state = i.state((BlockPos)p);
            return baseTest.test(state);
        };
    }

    private static Predicate<JobBlockTestContext> isJobBlockV2(JsonObject block, WorkSpecialRules special) {
        Predicate<BlockState> baseTest = ResourceJobLoader.getBlockCheck(ResourceJobLoader.required(block, "id", JsonElement::getAsString));
        Optional<BlockStateComparator> stateComparator = ResourceJobLoader.getStateComparator(block);
        Optional<BlockSlotComparator> slotComparator = ResourceJobLoader.getSlotComparator(block);
        boolean requireAirAbove = special.containsGlobal("require_air_above");
        return ctx -> {
            if (requireAirAbove && !ctx.blockInfo().state(ctx.blockPos().m_7494_()).m_60795_()) {
                return false;
            }
            BlockState state = ctx.blockInfo().state(ctx.blockPos());
            if (!baseTest.test(state)) {
                return false;
            }
            Boolean stateCheck = stateComparator.map(comparator -> comparator.test(state)).orElse(true);
            if (!stateCheck.booleanValue()) {
                return false;
            }
            if (ctx.jobBlockAlreadyUsed()) {
                return true;
            }
            BlockEntity entity = ctx.blockInfo().entity(ctx.blockPos());
            boolean slotOk = slotComparator.map(comparator -> comparator.test(entity)).orElse(true);
            if (!slotOk) {
                return false;
            }
            return ResourceJobLoader.trySpecialRuleIsJobBlock(ctx, special);
        };
    }

    private static boolean trySpecialRuleIsJobBlock(JobBlockTestContext ctx, WorkSpecialRules special) {
        ImmutableList allRules = ImmutableList.builder().addAll(special.specialGlobalRules()).build();
        boolean passed = false;
        for (JobPhaseModifier rule : SpecialRulesRegistry.getRuleAppliers((Collection<String>)allRules)) {
            if (rule.postJobBlockCheckPassed(ctx)) {
                passed = true;
                continue;
            }
            return false;
        }
        return passed;
    }

    private static Optional<BlockStateComparator> getStateComparator(JsonObject block) {
        String stateStr = ResourceJobLoader.optional(block, "int_state", JsonElement::getAsString);
        return stateStr == null ? Optional.empty() : BlockStateComparator.parse(stateStr);
    }

    private static Optional<BlockSlotComparator> getSlotComparator(JsonObject block) {
        String stateStr = ResourceJobLoader.optional(block, "has_item_in_slot_initially", JsonElement::getAsString);
        return stateStr == null ? Optional.empty() : BlockSlotComparator.parse(stateStr);
    }

    @NotNull
    private static Ingredient getIngredient(String block) {
        Ingredient ingredient = Ingredients.fromString(block);
        if (ingredient.m_43947_()) {
            throw new IllegalArgumentException(block + " is an unknown or empty ingredient");
        }
        return ingredient;
    }

    @NotNull
    private static Predicate<BlockState> getBlockCheck(String block) {
        if (block.startsWith("#")) {
            TagKey tag = BlockTags.create((ResourceLocation)new ResourceLocation(block.replace("#", "")));
            return bs -> ForgeRegistries.BLOCKS.tags().getTag(tag).contains((Object)bs.m_60734_());
        }
        return bs -> {
            ResourceLocation resourceLocation = new ResourceLocation(block);
            return resourceLocation.equals((Object)Compat.getItemId(bs.m_60734_()));
        };
    }

    @Nullable
    private static <X> X optional(JsonObject object, String k, Function<JsonElement, X> puller) {
        if (!object.has(k)) {
            return null;
        }
        return puller.apply(object.get(k));
    }

    private static int requiredInt(JsonObject object, String k) {
        return ResourceJobLoader.required(object, k, JsonElement::getAsInt);
    }

    private static <X> X required(JsonObject object, String k, Function<JsonElement, X> puller) {
        if (!object.has(k)) {
            throw new IllegalArgumentException(k + " is required (missing)");
        }
        JsonElement t = object.get(k);
        if (t.isJsonNull()) {
            throw new IllegalArgumentException(k + " is required (null)");
        }
        return puller.apply(t);
    }

    private static ResourceLocation required(JsonObject object, String k) {
        String v = ResourceJobLoader.required(object, k, JsonElement::getAsString);
        return new ResourceLocation(v);
    }

    private static class BlockStateComparator {
        private final String name;
        private final Function<Integer, Boolean> compare;

        public BlockStateComparator(String name, Function<Integer, Boolean> compare) {
            this.name = name;
            this.compare = compare;
        }

        public boolean test(BlockState state) {
            return ResourceJobLoader.getStateValue(state, this.name).map(this.compare).orElse(true);
        }

        public static Optional<BlockStateComparator> parse(String stateStr) {
            String[] eq = stateStr.split("=");
            if (eq.length > 1) {
                return Optional.of(new BlockStateComparator(eq[0], value -> value.equals(Integer.parseInt(eq[1]))));
            }
            String[] lt = stateStr.split("<");
            if (lt.length > 1) {
                return Optional.of(new BlockStateComparator(lt[0], value -> value.compareTo(Integer.parseInt(lt[1])) < 0));
            }
            String[] gt = stateStr.split(">");
            if (gt.length > 1) {
                return Optional.of(new BlockStateComparator(gt[0], value -> value.compareTo(Integer.parseInt(gt[1])) > 0));
            }
            return Optional.empty();
        }
    }

    private static class BlockSlotComparator {
        private final int slotIndex;
        private final Function<ItemStack, Boolean> compare;

        public BlockSlotComparator(int slot, Function<ItemStack, Boolean> compare) {
            this.slotIndex = slot;
            this.compare = compare;
        }

        public boolean test(BlockEntity entity) {
            return ResourceJobLoader.getSlotValue(entity, this.slotIndex).map(this.compare).orElse(true);
        }

        public static Optional<BlockSlotComparator> parse(String stateStr) {
            String[] eq = stateStr.split("/");
            if (eq.length > 1) {
                int slot = Integer.parseInt(eq[0]);
                Ingredient check = ItemStack::m_41619_;
                if (!eq[1].equals("minecraft:air")) {
                    check = Ingredients.fromString(eq[1]);
                }
                return Optional.of(new BlockSlotComparator(slot, ((Predicate)check)::test));
            }
            return Optional.empty();
        }
    }

    public static class ReloadListener
    extends SimpleJsonResourceReloadListener {
        private static final Gson GSON = new Gson();
        private ImmutableMap<JobID, Work> jobs;

        public ImmutableMap<JobID, Work> getJobs() {
            return this.jobs;
        }

        protected ReloadListener() {
            super(GSON, "questown_jobs");
        }

        protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profiler) {
            ImmutableMap.Builder b = ImmutableMap.builder();
            for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
                JsonElement element = entry.getValue();
                if (!element.isJsonObject()) continue;
                ResourceLocation id = entry.getKey();
                JsonObject object = element.getAsJsonObject();
                try {
                    int version = ResourceJobLoader.requiredInt(object, "version");
                    Work type = switch (version) {
                        case 1 -> this.workFromJsonV1(object);
                        case 2 -> this.workFromJsonV2(object);
                        default -> throw new IllegalArgumentException(String.format("Unknown job file version \"%s\"", version));
                    };
                    QT.INIT_LOGGER.info("Work found in filesystem: {}", type.id);
                    QT.INIT_LOGGER.debug("{}: {}", type.id.toNiceString(), type);
                    b.put((Object)type.id, (Object)type);
                }
                catch (Exception e) {
                    QT.INIT_LOGGER.error("Failed to load work {} using version {}", id, ResourceJobLoader.optional(object, "version", JsonElement::getAsInt), e);
                    if (!Compat.configGet(Config.CRASH_ON_INVALID_JOBS).get().booleanValue()) continue;
                    throw e;
                }
            }
            this.jobs = b.build();
        }

        public void loadFromFiles(ResourceManager man) {
            Map map = this.m_5944_(man, (ProfilerFiller)InactiveProfiler.f_18554_);
            this.apply(map, man, (ProfilerFiller)InactiveProfiler.f_18554_);
        }

        private Work workFromJsonV1(JsonObject object) {
            Item iconItem = (Item)ForgeRegistries.ITEMS.getValue(ResourceJobLoader.required(object, "icon"));
            if (iconItem == null) {
                throw new IllegalArgumentException("Icon image does not exist: " + object.get("icon").getAsString());
            }
            ResourceLocation initialRequest = ResourceJobLoader.optional(object, "initial_request", el -> el.isJsonNull() ? null : new ResourceLocation(el.getAsString()));
            Item initReq = null;
            if (initialRequest != null && (initReq = (Item)ForgeRegistries.ITEMS.getValue(initialRequest)) == null) {
                throw new IllegalArgumentException("Initial request item does not exist: " + object.get("icon").getAsString());
            }
            BiPredicate<WorkLocation.BlockInfo, BlockPos> isJobBlock = ResourceJobLoader.isJobBlock(object.get("block").getAsString());
            int cooldownTicks = ResourceJobLoader.requiredInt(object, "cooldown_ticks");
            WorkWorldInteractions wwi = this.worldWorkInt(object, cooldownTicks);
            JobID id = JobID.fromJSON(Util.getOrDefault(object, "id", JsonElement::getAsString, null));
            Work wb = WorksBehaviour.productionWork(iconItem.m_7968_(), id, JobID.fromJSON(Util.getOrDefault(object, "parent", JsonElement::getAsString, null)), ResourceJobLoader.description(initReq, object), new WorkLocation(ctx -> isJobBlock.test(ctx.blockInfo(), ctx.blockPos()), isJobBlock, ResourceJobLoader.required(object, "room")), ResourceJobLoader.workStates(id, object), wwi, this.loadRulesV1(object), this.loadSoundV1(object)).withPriority(ResourceJobLoader.requiredInt(object, "priority"));
            @Nullable Overrides overrides = this.overridesFromJsonV2(object);
            if (overrides != null) {
                return wb.withOverrides(overrides);
            }
            return wb;
        }

        @Nullable
        private Overrides overridesFromJsonV2(JsonObject object) {
            ImmutableMap<IStatus<?>, ResourceLocation> textureOverrides = this.textureOverridesV2(object);
            ImmutableMap<IStatus<?>, Pair<String, String>> statusTextOverrides = this.statusTextOverridesV2(object);
            return new Overrides(textureOverrides, statusTextOverrides);
        }

        private ImmutableMap<IStatus<?>, ResourceLocation> textureOverridesV2(JsonObject object) {
            ImmutableMap.Builder textureOverrides = ImmutableMap.builder();
            if (object.has("status_texture_overrides")) {
                JsonArray rows = object.getAsJsonArray("status_texture_overrides");
                block6: for (JsonElement row : rows) {
                    String type;
                    JsonObject rowObj = row.getAsJsonObject();
                    switch (type = rowObj.get("type").getAsString()) {
                        case "core_state": {
                            ProductionStatus productionStatus = ResourceJobLoader.getCore(rowObj);
                            String newTexture = rowObj.get("new_texture").getAsString();
                            @NotNull String[] newTextureParts = newTexture.split(":");
                            if (newTextureParts.length == 2) {
                                ResourceLocation rl = new ResourceLocation(newTextureParts[0], newTextureParts[1]);
                                textureOverrides.put((Object)productionStatus, (Object)rl);
                                continue block6;
                            }
                            textureOverrides.put((Object)productionStatus, (Object)Questown.ResourceLocation(newTexture));
                            continue block6;
                        }
                    }
                    throw new IllegalArgumentException("Unexpected texture override type " + type);
                }
            }
            return textureOverrides.build();
        }

        private ImmutableMap<IStatus<?>, Pair<String, String>> statusTextOverridesV2(JsonObject object) {
            ImmutableMap.Builder textOverrides = ImmutableMap.builder();
            if (object.has("status_text_overrides")) {
                JsonArray rows = object.getAsJsonArray("status_text_overrides");
                block6: for (JsonElement row : rows) {
                    String type;
                    JsonObject rowObj = row.getAsJsonObject();
                    switch (type = rowObj.get("type").getAsString()) {
                        case "core_state": {
                            ProductionStatus productionStatus = ResourceJobLoader.getCore(rowObj);
                            String newKey1 = rowObj.get("new_key_1").getAsString();
                            String newKey2 = rowObj.get("new_key_2").getAsString();
                            textOverrides.put((Object)productionStatus, new Pair<String, String>(newKey1, newKey2));
                            continue block6;
                        }
                    }
                    throw new IllegalArgumentException("Unexpected status text override type " + type);
                }
            }
            return textOverrides.build();
        }

        private Work workFromJsonV2(JsonObject obj) {
            Item iconItem = (Item)ForgeRegistries.ITEMS.getValue(ResourceJobLoader.required(obj, "icon"));
            if (iconItem == null) {
                throw new IllegalArgumentException("Icon image does not exist: " + obj.get("icon").getAsString());
            }
            ResourceLocation initialRequest = ResourceJobLoader.optional(obj, "initial_request", el -> el.isJsonNull() ? null : new ResourceLocation(el.getAsString()));
            Item initReq = (Item)ForgeRegistries.ITEMS.getValue(initialRequest);
            if (initReq == null) {
                throw new IllegalArgumentException("Initial request item does not exist: " + obj.get("icon").getAsString());
            }
            WorkSpecialRules special = this.loadRulesV2(obj);
            if (!obj.get("block").isJsonObject()) {
                throw new IllegalArgumentException("block must be an object");
            }
            try {
                JsonObject block = obj.getAsJsonObject("block");
                Predicate<JobBlockTestContext> isJobBlock = ResourceJobLoader.isJobBlockV2(block, special);
                int cooldownTicks = ResourceJobLoader.requiredInt(obj, "cooldown_ticks");
                WorkWorldInteractions wwi = this.worldWorkInt(obj, cooldownTicks);
                JobID id = JobID.fromJSON(Util.getOrDefault(obj, "id", JsonElement::getAsString, null));
                BiPredicate<WorkLocation.BlockInfo, BlockPos> shouldInitWS = ResourceJobLoader.shouldInitWS(block, special);
                return WorksBehaviour.productionWork(iconItem.m_7968_(), id, JobID.fromJSON(Util.getOrDefault(obj, "parent", JsonElement::getAsString, null)), ResourceJobLoader.description(initReq, obj), new WorkLocation(isJobBlock, shouldInitWS, ResourceJobLoader.required(obj, "room")), ResourceJobLoader.workStates(id, obj), wwi, special, this.loadSoundV1(obj)).withPriority(ResourceJobLoader.requiredInt(obj, "priority"));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to parse block: " + e.getMessage(), e);
            }
        }

        private WorkSpecialRules loadRulesV1(JsonObject object) {
            ImmutableList.Builder globals = ImmutableList.builder();
            globals.add((Object)"prioritize_extraction");
            if (!object.has("special")) {
                return new WorkSpecialRules((ImmutableMap<ProductionStatus, Collection<String>>)ImmutableMap.of(), (ImmutableList<String>)globals.build());
            }
            HashMap stages = new HashMap();
            object.get("special").getAsJsonArray().forEach(row -> {
                JsonObject rowObj = row.getAsJsonObject();
                JsonArray rules = rowObj.get("rules").getAsJsonArray();
                rules.forEach(rule -> ResourceJobLoader.registerRule(rule, rowObj, (ImmutableList.Builder<String>)globals, stages));
            });
            return new WorkSpecialRules((ImmutableMap<ProductionStatus, Collection<String>>)ImmutableMap.copyOf(stages), (ImmutableList<String>)globals.build());
        }

        private WorkSpecialRules loadRulesV2(JsonObject object) {
            ImmutableList.Builder globals = ImmutableList.builder();
            globals.add((Object)"prioritize_extraction");
            if (!object.has("special")) {
                return new WorkSpecialRules((ImmutableMap<ProductionStatus, Collection<String>>)ImmutableMap.of(), (ImmutableList<String>)globals.build());
            }
            HashMap stages = new HashMap();
            object.get("special").getAsJsonArray().forEach(row -> {
                JsonObject rowObj = row.getAsJsonObject();
                JsonArray rules = rowObj.get("rules").getAsJsonArray();
                rules.forEach(rule -> ResourceJobLoader.registerRule(rule, rowObj, (ImmutableList.Builder<String>)globals, stages));
            });
            return new WorkSpecialRules((ImmutableMap<ProductionStatus, Collection<String>>)ImmutableMap.copyOf(stages), (ImmutableList<String>)globals.build());
        }

        @Nullable
        private SoundInfo loadSoundV1(JsonObject object) {
            if (!object.has("sound")) {
                return null;
            }
            JsonObject info = object.getAsJsonObject("sound");
            ResourceLocation rl = new ResourceLocation(info.get("id").getAsString());
            Integer chance = null;
            if (info.has("chance")) {
                chance = info.get("chance").getAsInt();
            }
            Integer duration = null;
            if (info.has("duration")) {
                duration = info.get("duration").getAsInt();
            }
            return new SoundInfo(rl, chance, duration);
        }

        private WorkWorldInteractions worldWorkInt(JsonObject object, int cooldownTicks) {
            String type;
            if (!object.has("result")) {
                throw new IllegalArgumentException("result is required");
            }
            JsonObject rizz = object.get("result").getAsJsonObject();
            ResultGenerator<MCHeldItem> g = switch (type = rizz.get("type").getAsString()) {
                case "item" -> ResourceJobLoader.itemResult(object, rizz);
                case "biome_loot" -> ResourceJobLoader.biomeLootResult(rizz);
                case "loot" -> ResourceJobLoader.lootResult(rizz);
                case "crafting_table" -> ResourceJobLoader.craftingTableResult(rizz);
                default -> throw new IllegalArgumentException("Unexpected result type: " + type);
            };
            return new WorkWorldInteractions(cooldownTicks, g);
        }
    }
}

