/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs;

import ca.bradj.questown.QT;
import ca.bradj.questown.Questown;
import ca.bradj.questown.blocks.JobBoardBlock;
import ca.bradj.questown.core.Pair;
import ca.bradj.questown.core.UtilClean;
import ca.bradj.questown.core.VillagerUUID;
import ca.bradj.questown.core.init.TagsInit;
import ca.bradj.questown.core.init.items.ItemsInit;
import ca.bradj.questown.gui.Ingredients;
import ca.bradj.questown.gui.JobTooltips;
import ca.bradj.questown.gui.StatusArt;
import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.integration.minecraft.MCTownItem;
import ca.bradj.questown.integration.minecraft.MCTownState;
import ca.bradj.questown.jobs.IStatus;
import ca.bradj.questown.jobs.ImmutableSnapshot;
import ca.bradj.questown.jobs.Job;
import ca.bradj.questown.jobs.JobBlockTestContext;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.Signals;
import ca.bradj.questown.jobs.SimpleSnapshot;
import ca.bradj.questown.jobs.Snapshot;
import ca.bradj.questown.jobs.Work;
import ca.bradj.questown.jobs.WorkLocation;
import ca.bradj.questown.jobs.Works;
import ca.bradj.questown.jobs.WorksBehaviour;
import ca.bradj.questown.jobs.declarative.BOPDepositorWork;
import ca.bradj.questown.jobs.declarative.DinerNoTableWork;
import ca.bradj.questown.jobs.declarative.DinerWork;
import ca.bradj.questown.jobs.declarative.DowntimeWork;
import ca.bradj.questown.jobs.declarative.ResterWork;
import ca.bradj.questown.jobs.declarative.meta.DinerRawFoodWork;
import ca.bradj.questown.jobs.declarative.nomc.WorkSeekerJob;
import ca.bradj.questown.jobs.gatherer.GathererUnmappedNoToolWorkQtrDay;
import ca.bradj.questown.jobs.production.ProductionStatus;
import ca.bradj.questown.jobs.requests.WorkRequest;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.mc.Util;
import ca.bradj.questown.town.NoOpWarper;
import ca.bradj.questown.town.Warper;
import ca.bradj.questown.town.workstatus.State;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.TriPredicate;

public class ServerJobsRegistry {
    private static ImmutableList<SpecialJob> specialJobs;
    private static ImmutableMap<String, Jerb> jobs;

    public static boolean canAlwaysStart(UUID uuid, JobID p) {
        return ((Job)ServerJobsRegistry.getWorkSupplier((JobID)p).get().jobFunc.apply(uuid)).getGlobalSpecialRules().contains("always_consider");
    }

    public static ResourceLocation getTexture(JobID job, IStatus<?> status) {
        if (WorkSeekerJob.isSeekingWork(job)) {
            return StatusArt.getTexture(job, status);
        }
        try {
            ResourceLocation tex;
            Work work = ServerJobsRegistry.getWork(job, true);
            if (work != null && (tex = work.applyStatusTextureOverride(status)) != null) {
                return tex;
            }
        }
        catch (Exception e) {
            QT.JOB_LOGGER.error("Failed to apply status texture override", new Object[0]);
        }
        return StatusArt.getTexture(job, status);
    }

    private static boolean isSpecial(JobID job) {
        Optional<SpecialJob> first = specialJobs.stream().filter(id -> id.idTest.test(job)).findFirst();
        return first.isPresent();
    }

    @NotNull
    public static ImmutableList<Component> getStatusText(JobID job, IStatus<?> status) {
        if (WorkSeekerJob.isSeekingWork(job)) {
            return JobTooltips.buildStandardTooltipKeys(status, job);
        }
        try {
            Work work = ServerJobsRegistry.getWork(job, true);
            if (work == null) {
                throw new IllegalStateException("No work found for job ID: " + String.valueOf(job));
            }
            Pair<String, String> stringStringPair = work.applyStatusTextOverride(status);
            if (stringStringPair != null) {
                Component jobName = Compat.translatable("jobs." + job.rootId());
                return (ImmutableList)Pair.toList(stringStringPair).stream().map(v -> Compat.translatable(v, jobName)).collect(ImmutableList.toImmutableList());
            }
        }
        catch (Exception e) {
            QT.JOB_LOGGER.error("Failed to apply status tooltip override", e);
        }
        return JobTooltips.buildStandardTooltipKeys(status, job);
    }

    @Nullable
    private static Work getWork(JobID job, boolean includeSpecial) {
        Work work;
        Optional<SpecialJob> sj = specialJobs.stream().filter(v -> v.idTest.test(job)).findFirst();
        if (sj.isPresent() && (work = sj.get().reference().apply(job)) != null) {
            return work;
        }
        Supplier<Work> workSupplier = ServerJobsRegistry.getWorkSupplier(job);
        if (workSupplier == null) {
            return null;
        }
        Work work2 = workSupplier.get();
        if (work2 == null) {
            return null;
        }
        return work2;
    }

    public static Job<MCHeldItem, ? extends ImmutableSnapshot<MCHeldItem, ?>, ? extends IStatus<?>> getInitialJobForVillager(UUID villagerUUID) {
        JobID initialID = GathererUnmappedNoToolWorkQtrDay.ID;
        Work work = ServerJobsRegistry.getWorkSupplier(initialID).get();
        return (Job)work.jobFunc.apply(villagerUUID);
    }

    public static ImmutableMap<JobID, ResourceLocation> getAllJobsThatProduce(WorksBehaviour.TownData data, Ingredient wantedResult) {
        ImmutableMap.Builder b = ImmutableMap.builder();
        block0: for (Supplier<Work> value : Works.values()) {
            Work w = value.get();
            if (w.hasNoOutput()) continue;
            ResourceLocation name = Compat.getItemId(w.icon.m_41720_());
            if (wantedResult.test(w.initialRequest)) {
                b.put((Object)w.id, (Object)Util.ifNull(name, Questown.ResourceLocationError));
                continue;
            }
            ImmutableSet<MCTownItem> wResults = w.results.apply(data);
            for (MCTownItem wr : wResults) {
                if (!wantedResult.test(wr.toQTItemStack())) continue;
                b.put((Object)w.id, (Object)Util.ifNull(name, Questown.ResourceLocationError));
                continue block0;
            }
        }
        return b.build();
    }

    public static Collection<JobID> getRandomNodesUnder(JobID parentID, Supplier<Integer> randomInt) {
        return null;
    }

    public static boolean isParentOf(JobID parent, JobID child) {
        JobID parentID = ServerJobsRegistry.getWork((JobID)child, (boolean)false).parentID;
        if (parentID == null) {
            return false;
        }
        return parentID.equals(parent);
    }

    public static ImmutableSet<JobID> getAllRootJobs() {
        ImmutableSet.Builder b = ImmutableSet.builder();
        for (JobID j : ServerJobsRegistry.getAllJobs()) {
            Work work = ServerJobsRegistry.getWork(j, false);
            if (work == null || work.parentID != null) continue;
            b.add((Object)j);
        }
        return b.build();
    }

    public static ImmutableSet<MCTownItem> getResults(WorksBehaviour.TownData data, JobID job) {
        @Nullable Work work = ServerJobsRegistry.getWork(job, true);
        if (work == null) {
            return ImmutableSet.of();
        }
        return work.results.apply(data);
    }

    private static void initSpecialJobs() {
        ImmutableList.Builder b = ImmutableList.builder();
        b.add((Object)new SpecialJob(id -> null, WorkSeekerJob::isSeekingWork, (j, owner) -> new ca.bradj.questown.jobs.declarative.WorkSeekerJob((UUID)owner, 6, j.rootId()), (TriFunction<JobID, Snapshot<MCHeldItem>, ImmutableList<MCHeldItem>, Snapshot<MCHeldItem>>)((TriFunction)ServerJobsRegistry::newWorkSeekerJournal), (TriPredicate<JobID, Supplier<BlockState>, JobBlockTestContext>)((TriPredicate)(id, bsSrc, bp) -> {
            Block block = ((BlockState)bsSrc.get()).m_60734_();
            return Ingredient.m_204132_(TagsInit.Items.JOB_BOARD_INPUTS).test(block.m_5456_().m_7968_());
        }), (TriPredicate<JobID, Supplier<BlockState>, Pair<WorkLocation.BlockInfo, BlockPos>>)((TriPredicate)(id, bsSrc, bp) -> {
            Block block = ((BlockState)bsSrc.get()).m_60734_();
            return Ingredient.m_204132_(TagsInit.Items.JOB_BOARD_INPUTS).test(block.m_5456_().m_7968_());
        }), (id, items) -> ImmutableList.of()));
        b.add((Object)SpecialJob.fromWork(DinerWork::isDining, id -> DinerWork.asWork(id.rootId())));
        b.add((Object)SpecialJob.fromWork(DinerNoTableWork::isDining, id -> DinerNoTableWork.asWork(id.rootId())));
        b.add((Object)SpecialJob.fromWork(DinerRawFoodWork::isDining, id -> DinerRawFoodWork.asWork(id.rootId())));
        b.add((Object)SpecialJob.fromWork(ResterWork::isResting, id -> ResterWork.asWork(id.rootId())));
        b.add((Object)SpecialJob.fromWork(BOPDepositorWork::matches, id -> BOPDepositorWork.asWork(id.rootId())));
        b.add((Object)SpecialJob.fromWork(DowntimeWork::matches, id -> DowntimeWork.asWork(id.rootId())));
        specialJobs = b.build();
    }

    public static boolean shouldInitializeWithState(WorkLocation.BlockInfo info, BlockPos pos) {
        BlockState state = info.state(pos);
        if (state.m_60795_()) {
            return false;
        }
        BlockState bs = state;
        Block b = bs.m_60734_();
        JobID a = new JobID("temporary", "temporary");
        for (SpecialJob sj : specialJobs) {
            if (!sj.shouldInit.test((Object)a, () -> bs, new Pair<WorkLocation.BlockInfo, BlockPos>(info, pos))) continue;
            return true;
        }
        boolean isWorkMatch = Works.values().stream().anyMatch(v -> ((Work)v.get()).shouldInitializeWorkState.test(info, pos));
        if (Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsInit.PLATE_BLOCK.get()}).test(b.m_5456_().m_7968_())) {
            return true;
        }
        if (Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsInit.TOWN_FLAG_BLOCK.get()}).test(b.m_5456_().m_7968_())) {
            return true;
        }
        return isWorkMatch;
    }

    public static boolean isJobBlock(JobBlockTestContext ctx) {
        BlockState state = ctx.blockInfo().state(ctx.blockPos());
        if (state.m_60795_()) {
            return false;
        }
        BlockState bs = state;
        Block b = bs.m_60734_();
        JobID a = new JobID("temporary", "temporary");
        for (SpecialJob sj : specialJobs) {
            if (!sj.jobBlockTest.test((Object)a, () -> bs, (Object)ctx)) continue;
            return true;
        }
        boolean isWorkMatch = Works.values().stream().anyMatch(v -> ((Work)v.get()).isJobBlock.test(ctx));
        if (Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsInit.PLATE_BLOCK.get()}).test(b.m_5456_().m_7968_())) {
            return true;
        }
        if (Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsInit.TOWN_FLAG_BLOCK.get()}).test(b.m_5456_().m_7968_())) {
            return true;
        }
        return isWorkMatch;
    }

    public static ImmutableSet<JobID> getAllJobs() {
        return ImmutableSet.copyOf((Collection)Works.ids().stream().filter(v -> !WorkSeekerJob.isSeekingWork(v)).collect(Collectors.toSet()));
    }

    public static ResourceLocation getRoomForJobRootId(ServerLevel rand, String rootId) {
        Work work = ServerJobsRegistry.getRandomWork(rand, rootId, v -> true);
        return work.baseRoom;
    }

    public static ResourceLocation getRoomForJobId(JobID jobId) {
        Supplier<Work> w = ServerJobsRegistry.getWorkSupplier(jobId);
        return w.get().baseRoom;
    }

    public static Work getRandomWork(ServerLevel rand, String rootId, Predicate<JobID> include) {
        List<Map.Entry> x = Works.entrySet(rootId).stream().filter(v -> ((JobID)v.getKey()).rootId().equals(rootId)).filter(v -> include.test((JobID)v.getKey())).toList();
        if (x.isEmpty()) {
            QT.JOB_LOGGER.error("No jobs found for root ID: {}", rootId);
            return ServerJobsRegistry.getWorkSupplier(GathererUnmappedNoToolWorkQtrDay.ID).get();
        }
        Work work = (Work)((Supplier)x.get(Compat.nextRandomInt(rand, x.size())).getValue()).get();
        return work;
    }

    public static ImmutableList<JobID> getPreferredWorkIds(JobID jobId) {
        Jerb f = (Jerb)jobs.get((Object)jobId.rootId());
        if (f == null) {
            QT.JOB_LOGGER.error("Unrecognized job {}", jobId);
            return ImmutableList.of();
        }
        return f.preferredWork;
    }

    public static ImmutableList<JobID> getDefaultWork(JobID jobID) {
        Jerb fn = (Jerb)jobs.get((Object)jobID.rootId());
        if (fn == null) {
            QT.JOB_LOGGER.error("Returning no work for unrecognized job ID: {}", jobID);
            return ImmutableList.of();
        }
        return fn.defaultWork;
    }

    public static String getStringValue(JobID jobID) {
        return String.format("%s/%s", jobID.rootId(), jobID.jobId());
    }

    public static JobID parseStringValue(String jobID) {
        String[] parts = jobID.split("/");
        if (parts.length == 2) {
            return new JobID(parts[0], parts[1]);
        }
        if (parts.length == 1) {
            switch (parts[0]) {
                case "gatherer": {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown single-part job ID: " + parts[0]);
                }
            }
            return GathererUnmappedNoToolWorkQtrDay.ID;
        }
        throw new IllegalArgumentException("Unexpected job ID format: " + jobID);
    }

    public static State getDefaultJobBlockState(Block b) {
        if (b instanceof JobBoardBlock) {
            return State.freshAtState(1);
        }
        return State.fresh();
    }

    public static Warper<ServerLevel, MCTownState> getWarper(int villagerIndex, JobID jobID) {
        return NoOpWarper.INSTANCE;
    }

    public static boolean canSatisfy(WorksBehaviour.TownData town, JobID p, Ingredient requestedResult) {
        if (WorkSeekerJob.isSeekingWork(p)) {
            return false;
        }
        Supplier<Work> w = ServerJobsRegistry.getWorkSupplier(p);
        if (w == null) {
            QT.JOB_LOGGER.error("[Satisfaction check] No recognized job for ID: {}", p);
            return false;
        }
        Work work = w.get();
        if (work.initialRequest == null) {
            return true;
        }
        for (MCTownItem r : work.results.apply(town)) {
            if (!requestedResult.test(r.toQTItemStack())) continue;
            return true;
        }
        return requestedResult.test(work.initialRequest);
    }

    public static Function<List<MCHeldItem>, ImmutableList<Ingredient>> getWantedResourcesProvider(JobID p) {
        if (WorkSeekerJob.isSeekingWork(p)) {
            return items -> ImmutableList.of((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsInit.JOB_BOARD_BLOCK.get()}));
        }
        if (ResterWork.isResting(p)) {
            return items -> ImmutableList.of((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsInit.HOSPITAL_BED.get()}));
        }
        Optional<SpecialJob> sj = specialJobs.stream().filter(v -> v.idTest.test(p)).findFirst();
        if (sj.isPresent()) {
            return items -> ((SpecialJob)sj.get()).needs().apply(p, (List<MCHeldItem>)items);
        }
        Supplier<Work> w = ServerJobsRegistry.getWorkSupplier(p);
        if (w == null) {
            QT.JOB_LOGGER.error("No recognized job for ID: {}", p);
            return items -> ImmutableList.of();
        }
        return items -> ImmutableList.copyOf(((Work)w.get()).needs.apply((List<MCHeldItem>)items));
    }

    @Nullable
    private static Supplier<Work> getWorkSupplier(JobID p) {
        Supplier<Work> workSupplier = Works.get(p);
        if (workSupplier == null) {
            QT.JOB_LOGGER.error("No work found for job ID: {}. Falling back to any job in the same root ID.", p);
            ImmutableSet<Map.Entry<JobID, Supplier<Work>>> sameRootFallback = Works.entrySet(p.rootId());
            Iterator i = sameRootFallback.stream().filter(v -> ((JobID)v.getKey()).sameRoot(p)).iterator();
            if (!i.hasNext()) {
                QT.JOB_LOGGER.error("No fallback work found for root ID: {}", p.rootId());
                return null;
            }
            return (Supplier)((Map.Entry)i.next()).getValue();
        }
        return workSupplier;
    }

    public static ItemStack getDefaultWorkForNewWorker(JobID v) {
        if (WorkSeekerJob.isSeekingWork(v)) {
            return ItemStack.f_41583_;
        }
        Supplier<Work> w = ServerJobsRegistry.getWorkSupplier(v);
        if (w == null) {
            QT.JOB_LOGGER.error("[Default Work Request] No recognized job for ID: {}", v);
            return ItemStack.f_41583_;
        }
        return w.get().initialRequest;
    }

    public static ImmutableSet<Ingredient> getAllOutputs(WorksBehaviour.TownData t) {
        List<Ingredient> list = Works.values().stream().map(v -> {
            Work work = (Work)v.get();
            ImmutableSet.Builder b = ImmutableSet.builder();
            work.results.apply(t).forEach(z -> b.add((Object)z.toMCItemStack()));
            if (work.initialRequest != null) {
                b.add((Object)work.initialRequest);
            }
            return b.build();
        }).flatMap(Collection::stream).map(xva$0 -> Ingredient.m_43927_((ItemStack[])new ItemStack[]{xva$0})).filter(v -> !v.m_43947_()).map(Ingredients::asWorkRequest).collect(Collectors.toSet()).stream().map(WorkRequest::asIngredient).toList();
        return ImmutableSet.copyOf(list);
    }

    public static boolean isDining(JobID jobID) {
        return DinerWork.isDining(jobID) || DinerNoTableWork.isDining(jobID) || DinerRawFoodWork.isDining(jobID);
    }

    public static boolean canFit(UUID villagerID, JobID p, Signals.DayTime currentTick) {
        Signals currentSegment;
        Work w = ServerJobsRegistry.getWorkSupplier(p).get();
        long jobDuration = ((Job)w.jobFunc.apply(villagerID)).getTotalDuration();
        long finalTick = currentTick.dayTime() + jobDuration;
        Signals nextSegment = Signals.fromDayTime(new Signals.DayTime(finalTick));
        if (nextSegment.compareTo(currentSegment = Signals.fromDayTime(currentTick)) < 0) {
            return false;
        }
        return ImmutableList.of((Object)((Object)Signals.MORNING), (Object)((Object)Signals.NOON)).contains((Object)nextSegment);
    }

    public static void staticInitialize(ImmutableMap<JobID, Work> js) {
        ServerJobsRegistry.initJobs(js);
        ServerJobsRegistry.initSpecialJobs();
    }

    private static void initJobs(ImmutableMap<JobID, Work> js) {
        ImmutableMap.Builder b = ImmutableMap.builder();
        HashMap<String, ArrayList> ps = new HashMap<String, ArrayList>();
        HashMap defaults = new HashMap();
        js.forEach((id, job) -> {
            ArrayList rL = (ArrayList)Util.getOrDefault(ps, id.rootId(), new ArrayList());
            rL.add(job);
            rL.sort(Comparator.comparingInt(w -> w.priority));
            ps.put(id.rootId(), rL);
            if (ServerJobsRegistry.isUnlockedInitially(job)) {
                UtilClean.addOrInitializeList(defaults, id.rootId(), job.id);
            }
        });
        ps.forEach((rootId, w) -> b.put(rootId, (Object)new Jerb(w.stream().map(x -> x.id).toList(), (List<JobID>)ImmutableList.copyOf((Collection)((Collection)defaults.get(rootId))))));
        jobs = b.build();
    }

    private static boolean isUnlockedInitially(Work job) {
        return job.parentID == null;
    }

    public static Job<MCHeldItem, ? extends Snapshot<?>, ? extends IStatus<?>> getInitializedJob(ServerLevel level, JobID jobName, @NotNull Snapshot<MCHeldItem> journal, UUID ownerUUID) {
        return ServerJobsRegistry.getInitializedJob(level, jobName, journal, null, ownerUUID);
    }

    public static Job<MCHeldItem, ? extends ImmutableSnapshot<MCHeldItem, ?>, ? extends IStatus<?>> getInitializedJob(ServerLevel level, JobID jobName, ImmutableList<MCHeldItem> heldItems, UUID ownerUUID) {
        return ServerJobsRegistry.getInitializedJob(level, jobName, null, heldItems, ownerUUID);
    }

    public static JobInitPair getUninitializedJob(JobID jobName, VillagerUUID ownerVUID) {
        UUID ownerUUID = VillagerUUID.get(ownerVUID);
        BiFunction<ImmutableList, @Nullable Snapshot, Snapshot> journal = null;
        Supplier<Job> j = null;
        for (SpecialJob sj : specialJobs) {
            if (!sj.idTest.test(jobName)) continue;
            j = () -> sj.jobFn.apply(jobName, ownerUUID);
            journal = (items, jrn) -> (Snapshot)sj.journalFn.apply((Object)jobName, jrn, items);
            break;
        }
        if (j == null) {
            Supplier<Work> fn = ServerJobsRegistry.getWorkSupplier(jobName);
            if (fn == null) {
                QT.JOB_LOGGER.error("Unknown job name {}. Falling back to gatherer.", jobName);
                j = () -> (Job)ServerJobsRegistry.getWorkSupplier((JobID)GathererUnmappedNoToolWorkQtrDay.ID).get().jobFunc.apply(ownerUUID);
            } else {
                Work work = fn.get();
                j = () -> (Job)work.jobFunc.apply(ownerUUID);
                journal = (items, jrn) -> ServerJobsRegistry.newJournal(jobName, jrn, (ImmutableList<MCHeldItem>)items, work);
            }
        }
        final BiFunction<ImmutableList, Snapshot, Snapshot> fJournal = journal;
        final Supplier<Job> fj = j;
        return new JobInitPair(){

            @Override
            public Job<MCHeldItem, ? extends ImmutableSnapshot<MCHeldItem, ?>, ? extends IStatus<?>> getJob() {
                return (Job)fj.get();
            }

            @Override
            public Snapshot<MCHeldItem> newJournal(ImmutableList<MCHeldItem> heldItems, @Nullable Snapshot<MCHeldItem> seed) {
                return (Snapshot)fJournal.apply(heldItems, seed);
            }
        };
    }

    private static Job<MCHeldItem, ? extends ImmutableSnapshot<MCHeldItem, ?>, ? extends IStatus<?>> getInitializedJob(ServerLevel level, JobID jobName, @Nullable Snapshot<MCHeldItem> journal, @Nullable ImmutableList<MCHeldItem> heldItems, UUID ownerUUID) {
        JobInitPair u = ServerJobsRegistry.getUninitializedJob(jobName, VillagerUUID.from(ownerUUID));
        Job<MCHeldItem, ImmutableSnapshot<MCHeldItem, ?>, IStatus<?>> j = u.getJob();
        if ((journal = u.newJournal(heldItems, journal)) != null) {
            j.initialize(level, journal);
        }
        return j;
    }

    @Nullable
    private static Snapshot<MCHeldItem> newJournal(JobID jobName, @Nullable Snapshot<MCHeldItem> journal, @Nullable ImmutableList<MCHeldItem> heldItems, Work fn) {
        if (journal == null && heldItems != null) {
            journal = (Snapshot)fn.snapshotFunc.apply(jobName, fn.initialStatus.name(), heldItems);
        } else if (journal == null) {
            QT.JOB_LOGGER.error("Null items and journal. We probably just lost items.", new Object[0]);
        }
        return journal;
    }

    @Nullable
    private static Snapshot<MCHeldItem> newWorkSeekerJournal(JobID jobName, @Nullable Snapshot<MCHeldItem> journal, @Nullable ImmutableList<MCHeldItem> heldItems) {
        if (journal == null && heldItems != null) {
            journal = new SimpleSnapshot<ProductionStatus, MCHeldItem>(jobName, ProductionStatus.FACTORY.idle(), heldItems);
        } else if (journal == null) {
            QT.JOB_LOGGER.error("Null items and journal. We probably just lost items.", new Object[0]);
        }
        return journal;
    }

    public static ImmutableSnapshot<MCHeldItem, ?> getNewJournal(JobID job, String status, ImmutableList<MCHeldItem> heldItems) {
        if (specialJobs.stream().anyMatch(j -> j.idTest().test(job))) {
            return new SimpleSnapshot<ProductionStatus, MCHeldItem>(job, ProductionStatus.fromNumber(status), heldItems);
        }
        Supplier<Work> f = ServerJobsRegistry.getWorkSupplier(job);
        if (f == null) {
            QT.JOB_LOGGER.error("No journal snapshot factory for {}. Falling back to Simple/Gatherer", job);
            f = ServerJobsRegistry.getWorkSupplier(GathererUnmappedNoToolWorkQtrDay.ID);
        }
        return (ImmutableSnapshot)f.get().snapshotFunc.apply(job, status, heldItems);
    }

    private record SpecialJob(Function<JobID, @Nullable Work> reference, Predicate<JobID> idTest, BiFunction<JobID, UUID, Job<MCHeldItem, ? extends ImmutableSnapshot<MCHeldItem, ?>, ? extends IStatus<?>>> jobFn, TriFunction<JobID, @Nullable Snapshot<MCHeldItem>, @Nullable ImmutableList<MCHeldItem>, Snapshot<MCHeldItem>> journalFn, TriPredicate<JobID, Supplier<BlockState>, JobBlockTestContext> jobBlockTest, TriPredicate<JobID, Supplier<BlockState>, Pair<WorkLocation.BlockInfo, BlockPos>> shouldInit, BiFunction<JobID, List<MCHeldItem>, ImmutableList<Ingredient>> needs) {
        static SpecialJob fromWork(Predicate<JobID> idTest, Function<JobID, Work> work) {
            HashMap cache = new HashMap();
            Function<JobID, Work> cached = id -> {
                Work w = (Work)cache.get(id);
                if (w != null) {
                    return w;
                }
                Work newOne = (Work)work.apply((JobID)id);
                cache.put(id, newOne);
                return newOne;
            };
            return new SpecialJob(cached, idTest, (id, owner) -> (Job)((Work)cached.apply(id)).jobFunc.apply(owner), (TriFunction<JobID, Snapshot<MCHeldItem>, ImmutableList<MCHeldItem>, Snapshot<MCHeldItem>>)((TriFunction)(id, snap, held) -> ServerJobsRegistry.newJournal(id, snap, (ImmutableList<MCHeldItem>)held, (Work)cached.apply((JobID)id))), (TriPredicate<JobID, Supplier<BlockState>, JobBlockTestContext>)((TriPredicate)(id, bs, bp) -> ((Work)cached.apply(id)).isJobBlock.test(new JobBlockTestContext(null, new WorkLocation.BlockInfo((Supplier)bs){
                final /* synthetic */ Supplier val$bs;
                {
                    this.val$bs = supplier;
                }

                @Override
                public BlockState state(BlockPos bp) {
                    return (BlockState)this.val$bs.get();
                }

                @Override
                @Nullable
                public BlockEntity entity(BlockPos bp) {
                    return null;
                }
            }, bp.blockPos(), bp.heldItems(), bp.townUniqueItems(), bp.jobBlockAlreadyUsed(), bp.jobActive()))), (TriPredicate<JobID, Supplier<BlockState>, Pair<WorkLocation.BlockInfo, BlockPos>>)((TriPredicate)(id, bs, bp) -> ((Work)cached.apply(id)).shouldInitializeWorkState.test(new WorkLocation.BlockInfo((Supplier)bs){
                final /* synthetic */ Supplier val$bs;
                {
                    this.val$bs = supplier;
                }

                @Override
                public BlockState state(BlockPos bp) {
                    return (BlockState)this.val$bs.get();
                }

                @Override
                @Nullable
                public BlockEntity entity(BlockPos bp) {
                    return null;
                }
            }, (BlockPos)bp.b())), (id, items) -> ImmutableList.copyOf(((Work)cached.apply(id)).needs.apply((List<MCHeldItem>)items)));
        }
    }

    private record Jerb(ImmutableList<JobID> preferredWork, ImmutableList<JobID> defaultWork) {
        public Jerb(List<JobID> preferredWork, List<JobID> defaultWork) {
            this((ImmutableList<JobID>)ImmutableList.copyOf(preferredWork), (ImmutableList<JobID>)ImmutableList.copyOf(defaultWork));
        }
    }

    public static interface JobInitPair {
        public Job<MCHeldItem, ? extends ImmutableSnapshot<MCHeldItem, ?>, ? extends IStatus<?>> getJob();

        public Snapshot<MCHeldItem> newJournal(ImmutableList<MCHeldItem> var1, @Nullable Snapshot<MCHeldItem> var2);
    }
}

