/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs;

public enum Signals {
    UNDEFINED,
    MORNING,
    NOON,
    EVENING,
    NIGHT;

    public static final long NIGHT_START_TICK = 22000L;

    public static Signals fromDayTime(DayTime gameTime) {
        long dayTime = gameTime.dayTime % 24000L;
        if (dayTime < 6000L) {
            return MORNING;
        }
        if (dayTime < 11500L) {
            return NOON;
        }
        if (dayTime < 22000L) {
            return EVENING;
        }
        return NIGHT;
    }

    public record DayTime(long dayTime) {
        public long ticksBeforeMidnight() {
            return 24000L - this.dayTime;
        }
    }
}

