/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs;

import ca.bradj.questown.core.Pair;
import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.integration.minecraft.MCTownItem;
import ca.bradj.questown.integration.minecraft.MCTownState;
import ca.bradj.questown.jobs.IStatus;
import ca.bradj.questown.jobs.JobBlockTestContext;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.Overrides;
import ca.bradj.questown.jobs.WorkLocation;
import ca.bradj.questown.jobs.WorksBehaviour;
import ca.bradj.questown.town.Warper;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Work {
    public final JobID id;
    @javax.annotation.Nullable
    public final JobID parentID;
    public final ItemStack icon;
    public final WorksBehaviour.JobFunc jobFunc;
    final WorksBehaviour.SnapshotFunc snapshotFunc;
    final Predicate<JobBlockTestContext> isJobBlock;
    final BiPredicate<WorkLocation.BlockInfo, BlockPos> shouldInitializeWorkState;
    public final ResourceLocation baseRoom;
    final IStatus<?> initialStatus;
    public final Function<WorksBehaviour.TownData, ImmutableSet<MCTownItem>> results;
    @javax.annotation.Nullable
    final ItemStack initialRequest;
    final Function<List<MCHeldItem>, Collection<Ingredient>> needs;
    private final Function<WorksBehaviour.WarpInput, Warper<ServerLevel, MCTownState>> warper;
    final int priority;
    private Overrides overrides;
    private boolean hasNoOutput;

    public Work(JobID id, @javax.annotation.Nullable JobID parentID, ItemStack icon, WorksBehaviour.JobFunc jobFunc, WorksBehaviour.SnapshotFunc snapshotFunc, Predicate<JobBlockTestContext> isJobBlock, BiPredicate<WorkLocation.BlockInfo, BlockPos> shouldInitializeWorkState, ResourceLocation baseRoom, IStatus<?> initialStatus, Function<WorksBehaviour.TownData, ImmutableSet<MCTownItem>> results, @javax.annotation.Nullable ItemStack initialRequest, Function<List<MCHeldItem>, Collection<Ingredient>> needs, Function<WorksBehaviour.WarpInput, Warper<ServerLevel, MCTownState>> warper, int priority, boolean hasNoOutput) {
        this.id = id;
        this.parentID = parentID;
        this.icon = icon;
        this.jobFunc = jobFunc;
        this.snapshotFunc = snapshotFunc;
        this.isJobBlock = isJobBlock;
        this.shouldInitializeWorkState = shouldInitializeWorkState;
        this.baseRoom = baseRoom;
        this.initialStatus = initialStatus;
        this.results = results;
        this.initialRequest = initialRequest;
        this.needs = needs;
        this.warper = warper;
        this.priority = priority;
        this.overrides = Overrides.none();
        this.hasNoOutput = hasNoOutput;
    }

    public Work withPriority(int priority) {
        return new Work(this.id, this.parentID, this.icon, this.jobFunc, this.snapshotFunc, this.isJobBlock, this.shouldInitializeWorkState, this.baseRoom, this.initialStatus, this.results, this.initialRequest, this.needs, this.warper, priority, this.hasNoOutput);
    }

    public Work withNeeds(Function<List<MCHeldItem>, Collection<Ingredient>> needz) {
        return new Work(this.id, this.parentID, this.icon, this.jobFunc, this.snapshotFunc, this.isJobBlock, this.shouldInitializeWorkState, this.baseRoom, this.initialStatus, this.results, this.initialRequest, needz, this.warper, this.priority, this.hasNoOutput);
    }

    @Nullable
    public ResourceLocation applyStatusTextureOverride(IStatus<?> status) {
        return (ResourceLocation)this.overrides.statusTextures().get(status);
    }

    @javax.annotation.Nullable
    public Pair<String, String> applyStatusTextOverride(IStatus<?> status) {
        return (Pair)this.overrides.statusTextOverrides().get(status);
    }

    public Work withOverrides(@NotNull Overrides overrides) {
        Work work = new Work(this.id, this.parentID, this.icon, this.jobFunc, this.snapshotFunc, this.isJobBlock, this.shouldInitializeWorkState, this.baseRoom, this.initialStatus, this.results, this.initialRequest, this.needs, this.warper, this.priority, this.hasNoOutput);
        work.overrides = overrides;
        return work;
    }

    public boolean hasNoOutput() {
        return this.hasNoOutput;
    }
}

