/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs;

import ca.bradj.questown.core.Config;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.Work;
import ca.bradj.questown.jobs.declarative.DinerNoTableWork;
import ca.bradj.questown.jobs.declarative.DinerWork;
import ca.bradj.questown.jobs.gatherer.ExplorerWork;
import ca.bradj.questown.jobs.gatherer.GathererMappedAxeWork;
import ca.bradj.questown.jobs.gatherer.GathererUnmappedPickaxeWorkFullDay;
import ca.bradj.questown.jobs.gatherer.GathererUnmappedPickaxeWorkHalfDay;
import ca.bradj.questown.jobs.gatherer.GathererUnmappedPickaxeWorkQtrDay;
import ca.bradj.questown.jobs.gatherer.GathererUnmappedShovelWorkFullDay;
import ca.bradj.questown.jobs.gatherer.GathererUnmappedShovelWorkHalfDay;
import ca.bradj.questown.jobs.gatherer.GathererUnmappedShovelWorkQtrDay;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;

public class Works {
    private static ImmutableMap<JobID, Supplier<Work>> works;
    private static boolean initialized;

    public static Collection<Supplier<Work>> values() {
        return works.values();
    }

    public static ImmutableSet<JobID> ids() {
        return works.keySet();
    }

    public static void staticInitialize(Map<JobID, Work> dataPackJobs) {
        ImmutableMap.Builder b = ImmutableMap.builder();
        dataPackJobs.forEach((k, v) -> b.put(k, () -> v));
        b.put((Object)ExplorerWork.ID, ExplorerWork::asWork);
        b.put((Object)GathererMappedAxeWork.ID, GathererMappedAxeWork::asWork);
        b.put((Object)GathererUnmappedPickaxeWorkQtrDay.ID, GathererUnmappedPickaxeWorkQtrDay::asWork);
        b.put((Object)GathererUnmappedPickaxeWorkHalfDay.ID, GathererUnmappedPickaxeWorkHalfDay::asWork);
        b.put((Object)GathererUnmappedPickaxeWorkFullDay.ID, GathererUnmappedPickaxeWorkFullDay::asWork);
        b.put((Object)GathererUnmappedShovelWorkQtrDay.ID, GathererUnmappedShovelWorkQtrDay::asWork);
        b.put((Object)GathererUnmappedShovelWorkHalfDay.ID, GathererUnmappedShovelWorkHalfDay::asWork);
        b.put((Object)GathererUnmappedShovelWorkFullDay.ID, GathererUnmappedShovelWorkFullDay::asWork);
        works = b.build();
        initialized = true;
    }

    public static ImmutableSet<Map.Entry<JobID, Supplier<Work>>> regularJobs() {
        assert (initialized);
        ImmutableSet.Builder b = ImmutableSet.builder();
        b.addAll((Iterable)works.entrySet());
        return b.build();
    }

    public static ImmutableSet<Map.Entry<JobID, Supplier<Work>>> entrySet(String rootForDining) {
        assert (initialized);
        ImmutableSet.Builder b = ImmutableSet.builder();
        b.addAll((Iterable)works.entrySet());
        if (((Boolean)Config.HUNGER_ENABLED.get()).booleanValue()) {
            b.add(new AbstractMap.SimpleEntry<JobID, Supplier<Work>>(DinerWork.getIdForRoot(rootForDining), () -> DinerWork.asWork(rootForDining)));
        }
        return b.build();
    }

    @Deprecated(forRemoval=true)
    public static Supplier<Work> get(JobID jobID) {
        if (!initialized) {
            throw new IllegalStateException("Works not initialized");
        }
        if (DinerWork.isDining(jobID)) {
            return () -> DinerWork.asWork(jobID.rootId());
        }
        if (DinerNoTableWork.isDining(jobID)) {
            return () -> DinerNoTableWork.asWork(jobID.rootId());
        }
        return (Supplier)works.get((Object)jobID);
    }
}

