/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs.declarative;

import ca.bradj.questown.QT;
import ca.bradj.questown.jobs.HeldItem;
import ca.bradj.questown.jobs.IllegalJobDefinition;
import ca.bradj.questown.jobs.WorkedSpot;
import ca.bradj.questown.jobs.declarative.InsertResult;
import ca.bradj.questown.jobs.declarative.ItemWI;
import ca.bradj.questown.jobs.declarative.ItemWorkChecks;
import ca.bradj.questown.logic.PredicateCollection;
import ca.bradj.questown.town.AbstractWorkStatusStore;
import ca.bradj.questown.town.Claim;
import ca.bradj.questown.town.interfaces.ImmutableWorkStateContainer;
import ca.bradj.questown.town.workstatus.State;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractItemWI<POS, EXTRA, ITEM extends HeldItem<ITEM, ?>, TOWN>
implements ItemWI<POS, EXTRA, TOWN, ITEM>,
AbstractWorkStatusStore.InsertionRules<ITEM> {
    private final int villagerIndex;
    private final Function<EXTRA, Claim> claimSpots;
    private final List<TriConsumer<EXTRA, POS, ITEM>> itemInsertedListener = new ArrayList<TriConsumer<EXTRA, POS, ITEM>>();
    private final ItemWorkChecks<EXTRA, ITEM, ?> checks;

    public <S> AbstractItemWI(int villagerIndex, ItemWorkChecks<EXTRA, ITEM, ?> checks, Function<EXTRA, Claim> claimSpots) {
        this.villagerIndex = villagerIndex;
        this.checks = checks;
        this.claimSpots = claimSpots;
    }

    @Override
    public InsertResult<TOWN, ITEM> tryInsertIngredients(EXTRA extra, PredicateCollection<ITEM, ITEM> ingredientsForStep, WorkedSpot<POS> ws) {
        int ps;
        if (ingredientsForStep == null || ingredientsForStep.isEmpty()) {
            return null;
        }
        Object bp = ws.workPosition();
        int curState = ws.state();
        State state = this.getWorkStatuses(extra).getJobBlockState(bp);
        if (state == null || state.isFresh()) {
            Integer initWork = this.checks.getWorkForStep(curState, 0);
            state = State.fresh().setWorkLeft(initWork);
        }
        if ((ps = state.processingState()) != curState) {
            return null;
        }
        Integer qty = this.checks.getQuantityForStep(ps, 0);
        if (qty == null || qty == 0) {
            throw new IllegalJobDefinition(qty + " quantity for non-null ingredient at state " + ps);
        }
        if (qty.intValue() == state.ingredientCount()) {
            return null;
        }
        int i = -1;
        Collection<ITEM> heldItems = this.getHeldItems(extra, this.villagerIndex);
        String invBefore = String.format("[%s]", String.join((CharSequence)", ", heldItems.stream().map(v -> v.toShortString()).toList()));
        for (HeldItem item : heldItems) {
            int ii;
            int nextStepTime;
            int nextStepWork;
            Object town;
            ++i;
            if (item.isEmpty()) continue;
            String name = item.getShortName();
            if (!this.canInsertItem(extra, item, bp) || (town = this.tryInsertItem(extra, this, state, item, bp, nextStepWork = this.checks.getWorkForStep(curState + 1, 0), nextStepTime = this.checks.getTimeForStep(extra, curState + 1, 0), (arg_0, arg_1) -> this.lambda$tryInsertIngredients$1(ii = i, item, arg_0, arg_1))) == null) continue;
            InsertResult<Object, HeldItem> res = new InsertResult<Object, HeldItem>(town, item);
            QT.JOB_LOGGER.debug("Villager removed {} from their inventory {}", name, invBefore);
            this.itemInsertedListener.forEach(v -> v.accept(extra, bp, (Object)item));
            Claim claim = this.claimSpots.apply(extra);
            if (claim != null) {
                if (this.getWorkStatuses(extra).claimSpot(bp, claim)) {
                    return res;
                }
                return null;
            }
            return res;
        }
        return null;
    }

    protected abstract TOWN setHeldItem(EXTRA var1, TOWN var2, int var3, int var4, ITEM var5);

    protected abstract Collection<ITEM> getHeldItems(EXTRA var1, int var2);

    @Nullable
    private TOWN tryInsertItem(EXTRA extra, AbstractWorkStatusStore.InsertionRules<ITEM> rules, State oldState, ITEM item, POS bp, int workInNextStep, int timeInNextStep, BiFunction<EXTRA, TOWN, TOWN> shrinkItem) {
        int count;
        ImmutableWorkStateContainer<POS, TOWN> ws = this.getWorkStatuses(extra);
        int curValue = oldState.processingState();
        PredicateCollection<ITEM, ?> ingredient = rules.getIngredientsRequiredAtState(curValue);
        if (ingredient != null && !ingredient.test(item)) {
            return null;
        }
        int qtyRequired = rules.getIngredientQuantityRequiredAtState(curValue, 0);
        int curCount = oldState.ingredientCount();
        if (curCount > qtyRequired) {
            QT.BLOCK_LOGGER.error("Somehow exceeded required quantity: can accept up to {}, had {}", qtyRequired, curCount);
        }
        boolean shrink = (count = curCount + 1) <= qtyRequired;
        TOWN updatedTown = AbstractItemWI.maybeUpdateBlockState(oldState, bp, workInNextStep, timeInNextStep, count, qtyRequired, ws);
        if (shrink) {
            return shrinkItem.apply(extra, updatedTown);
        }
        return updatedTown;
    }

    @Nullable
    private static <POS, TOWN> TOWN maybeUpdateBlockState(State oldState, POS bp, int workInNextStep, int timeInNextStep, int count, int qtyRequired, ImmutableWorkStateContainer<POS, TOWN> ws) {
        if (count == qtyRequired && oldState.workLeft() > 0) {
            State blockState = oldState.setCount(count);
            return ws.setJobBlockState(bp, blockState);
        }
        if (count <= qtyRequired) {
            State blockState = oldState.setCount(count);
            if (count == qtyRequired) {
                blockState = blockState.setWorkLeft(workInNextStep).setCount(0).setProcessing(oldState.processingState() + 1);
            }
            if (count == qtyRequired && timeInNextStep > 0) {
                return ws.setJobBlockStateWithTimer(bp, blockState, timeInNextStep);
            }
            return ws.setJobBlockState(bp, blockState);
        }
        return null;
    }

    protected abstract ImmutableWorkStateContainer<POS, TOWN> getWorkStatuses(EXTRA var1);

    protected abstract boolean canInsertItem(EXTRA var1, ITEM var2, POS var3);

    @Override
    @Nullable
    public Integer getIngredientQuantityRequiredAtState(int state, @Nullable Integer orDefault) {
        return this.checks.getQuantityForStep(state, orDefault);
    }

    @Override
    @Nullable
    public PredicateCollection<ITEM, ?> getIngredientsRequiredAtState(Integer state) {
        return this.checks.getIngredientsForStep(state);
    }

    public void addItemInsertionListener(TriConsumer<EXTRA, POS, ITEM> listener) {
        this.itemInsertedListener.add(listener);
    }

    public void removeItemInsertionListener(TriConsumer<EXTRA, POS, ITEM> listener) {
        this.itemInsertedListener.remove(listener);
    }

    private /* synthetic */ Object lambda$tryInsertIngredients$1(int ii, HeldItem item, Object uxtra, Object tuwn) {
        return this.setHeldItem(uxtra, tuwn, this.villagerIndex, ii, (HeldItem)item.shrink());
    }
}

