/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs.declarative;

import ca.bradj.questown.town.workstatus.State;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class NeedsRegistrations<POS, EXTRA> {
    private final BiConsumer<EXTRA, Need> registerUnmetNeed;
    private final BiFunction<EXTRA, POS, State> getState;
    private final Consumer<EXTRA> registerUnmetRoom;

    public NeedsRegistrations(Consumer<EXTRA> registerUnmetRoom, BiConsumer<EXTRA, Need> registerUnmetNeed, BiFunction<EXTRA, POS, @Nullable State> getState) {
        this.registerUnmetNeed = registerUnmetNeed;
        this.getState = getState;
        this.registerUnmetRoom = registerUnmetRoom;
    }

    public void addUnmet(EXTRA extra, @Nullable POS workspot, int timesInserted) {
        State state = State.fresh();
        if (workspot != null) {
            state = this.getState.apply(extra, workspot);
        }
        if (state == null) {
            this.registerUnmetNeed.accept(extra, new Need(0, null));
            return;
        }
        int ingredientIndex = state.processingState();
        if (state.hasWorkLeft()) {
            this.registerUnmetNeed.accept(extra, new Need(null, ingredientIndex));
            return;
        }
        if (timesInserted > 0) {
            ingredientIndex += timesInserted;
        }
        this.registerUnmetNeed.accept(extra, new Need(ingredientIndex, null));
    }

    public void addUnmetRoom(EXTRA extra) {
        this.registerUnmetRoom.accept(extra);
    }

    public record Need(@Nullable Integer timesInserted, @Nullable Integer toolIndex) {
        public boolean isTool() {
            return this.toolIndex != null;
        }
    }
}

