/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs.declarative;

import ca.bradj.questown.jobs.DefaultInventoryStateProvider;
import ca.bradj.questown.jobs.EmptyFactory;
import ca.bradj.questown.jobs.EntityInvStateProvider;
import ca.bradj.questown.jobs.EntityLocStateProvider;
import ca.bradj.questown.jobs.HeldItem;
import ca.bradj.questown.jobs.IProductionStatusFactory;
import ca.bradj.questown.jobs.IStatusFactory;
import ca.bradj.questown.jobs.Item;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.JobTownProvider;
import ca.bradj.questown.jobs.Jobs;
import ca.bradj.questown.jobs.Journal;
import ca.bradj.questown.jobs.JournalItemList;
import ca.bradj.questown.jobs.JournalItemsListener;
import ca.bradj.questown.jobs.SignalSource;
import ca.bradj.questown.jobs.Signals;
import ca.bradj.questown.jobs.SimpleSnapshot;
import ca.bradj.questown.jobs.StatusListener;
import ca.bradj.questown.jobs.production.ProductionStatus;
import ca.bradj.questown.jobs.production.ProductionStatuses;
import ca.bradj.roomrecipes.serialization.MCRoom;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProductionJournal<I extends Item<I>, H extends HeldItem<H, I>>
implements Journal<ProductionStatus, H, SimpleSnapshot<ProductionStatus, H>> {
    private final JournalItemList<H> inventory;
    private final DefaultInventoryStateProvider<H> invState;
    private final JobID jobId;
    private final int capacity;
    private final SignalSource sigs;
    private final IStatusFactory<ProductionStatus> statusFactory;
    @Nullable
    private ProductionStatus status;
    private final List<JournalItemsListener<H>> listeners = new ArrayList<JournalItemsListener<H>>();
    private final EmptyFactory<H> emptyFactory;
    private final ArrayList<StatusListener> statusListeners = new ArrayList();

    @Override
    public Function<Void, Void> addStatusListener(StatusListener o) {
        this.statusListeners.add(o);
        return x -> {
            this.removeStatusListener(o);
            return null;
        };
    }

    @Override
    public void removeStatusListener(StatusListener o) {
        this.statusListeners.remove(o);
    }

    @Override
    public Collection<? extends Runnable> notifyListenersOfNewJob(Function<StatusListener, Runnable> listenToNewJob) {
        ImmutableList.Builder b = ImmutableList.builder();
        for (StatusListener statusListener : this.statusListeners) {
            b.add((Object)statusListener.jobChanged(listenToNewJob));
        }
        return b.build();
    }

    public ProductionJournal(@NotNull JobID jobId, SignalSource sigs, int capacity, EmptyFactory<H> ef, IStatusFactory<ProductionStatus> sf) {
        this.jobId = jobId;
        this.sigs = sigs;
        this.inventory = new JournalItemList<H>(capacity, ef);
        this.capacity = capacity;
        this.invState = new DefaultInventoryStateProvider(() -> ImmutableList.copyOf(this.inventory));
        this.emptyFactory = ef;
        this.statusFactory = sf;
    }

    @Override
    public void initialize(SimpleSnapshot<ProductionStatus, H> journal) {
        this.setItems((Iterable<H>)journal.items());
        this.initializeStatus(journal.status());
    }

    @Override
    public boolean isInitialized() {
        return this.status != null && !this.status.isUnset();
    }

    @Override
    public ImmutableList<Boolean> getSlotLockStatuses() {
        return ImmutableList.copyOf(this.inventory.stream().map(HeldItem::isLocked).toList());
    }

    @Override
    public void setItems(Iterable<H> mcTownItemStream) {
        this.inventory.setItems(mcTownItemStream);
        this.updateItemListeners();
    }

    private void updateItemListeners() {
        ImmutableList copyForListeners = ImmutableList.copyOf(this.inventory);
        this.listeners.forEach(l -> l.itemsChanged(copyForListeners));
    }

    @Override
    public ImmutableList<H> getItems() {
        return ImmutableList.copyOf(this.inventory);
    }

    @Override
    public void setItemsNoUpdateNoCheck(ImmutableList<H> build) {
        this.inventory.clear();
        this.inventory.addAll(build);
        this.changeStatus(this.statusFactory.idle());
    }

    public void changeStatus(ProductionStatus s) {
        this.status = s;
        this.statusListeners.forEach(l -> l.statusChanged(this.status));
    }

    @Override
    public SimpleSnapshot<ProductionStatus, H> getSnapshot() {
        return new SimpleSnapshot(this.jobId, this.status, ImmutableList.copyOf(this.inventory));
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    public void tryUpdateStatus(JobTownProvider<MCRoom> townState, EntityLocStateProvider<MCRoom> entityState, EntityInvStateProvider<Integer> inventory, IProductionStatusFactory<ProductionStatus> factory, boolean prioritizeExtraction) {
        if (this.status == null || this.status.isUnset()) {
            throw new IllegalStateException("Must initialize status");
        }
        Signals sig = this.sigs.getSignal();
        @Nullable ProductionStatus newStatus = ProductionStatuses.getNewStatusFromSignal(this.status, sig, inventory, townState, entityState, factory, prioritizeExtraction);
        if (newStatus != null) {
            this.changeStatus(newStatus);
        }
    }

    @Override
    public ProductionStatus getStatus() {
        return this.status;
    }

    @Override
    public void addItem(H item) {
        if (this.invState.inventoryIsFull()) {
            throw new IllegalStateException("Inventory is full");
        }
        HeldItem emptySlot = this.inventory.stream().filter(Item::isEmpty).findFirst().get();
        this.inventory.set(this.inventory.indexOf(emptySlot), item);
        this.updateItemListeners();
    }

    @Override
    public boolean addItemIfSlotAvailable(H item) {
        if (Jobs.addItemIfSlotAvailable(this.inventory, this.invState, item)) {
            this.updateItemListeners();
            return true;
        }
        return false;
    }

    @Override
    public void addItemListener(JournalItemsListener<H> l) {
        this.listeners.add(l);
    }

    @Override
    public void initializeStatus(ProductionStatus s) {
        this.status = s;
    }

    @Override
    public boolean isInventoryFull() {
        return this.invState.inventoryIsFull();
    }

    @Override
    public boolean removeItem(H mct) {
        int index = this.inventory.lastIndexOf(mct);
        if (index < 0) {
            return false;
        }
        this.setItem(index, (H)((HeldItem)this.emptyFactory.makeEmptyItem()));
        return true;
    }

    @Override
    public boolean hasAnyLootToDrop() {
        return this.inventory.stream().anyMatch(v -> !v.isEmpty() && !v.isLocked());
    }

    @Override
    public void setItem(int idx, H mcHeldItem) {
        this.inventory.set(idx, mcHeldItem);
        this.updateItemListeners();
        this.changeStatus(ProductionStatus.FACTORY.idle());
    }

    public JobID getJobId() {
        return this.jobId;
    }
}

