/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs.fetcher;

import ca.bradj.questown.core.init.items.ItemsInit;
import ca.bradj.questown.integration.minecraft.MCContainer;
import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.integration.minecraft.MCTownItem;
import ca.bradj.questown.items.StockRequestItem;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.leaver.ContainerTarget;
import ca.bradj.questown.jobs.production.ProductionStatus;
import ca.bradj.questown.jobs.requests.WorkRequest;
import ca.bradj.questown.jobs.special.IngredientsFromHeldItemLogic;
import ca.bradj.questown.town.TownContainers;
import ca.bradj.questown.town.interfaces.TownInterface;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FetcherHack {
    public static boolean isFetcher(JobID jobId) {
        return jobId.rootId().equals("organizer") && jobId.jobId().equals("fetch");
    }

    @Nullable
    public static ContainerTarget<MCContainer, MCTownItem> getTarget(TownInterface town) {
        ServerLevel l = town.getServerLevel();
        for (ContainerTarget<MCContainer, MCTownItem> chest : TownContainers.getAllContainers(town, l)) {
            if (!FetcherHack.containsUsableRequest(town, chest) || chest.getContainer().isFull()) continue;
            return chest;
        }
        return null;
    }

    private static boolean containsUsableRequest(TownInterface town, ContainerTarget<MCContainer, MCTownItem> chest) {
        ServerLevel sl = town.getServerLevel();
        ImmutableList.Builder elsewhereB = ImmutableList.builder();
        for (ContainerTarget<MCContainer, MCTownItem> otherChest : TownContainers.getAllContainers(town, sl)) {
            if (otherChest.getBlockPos().equals((Object)chest.getBlockPos())) continue;
            elsewhereB.add(otherChest::getItems);
        }
        ImmutableList elsewhere = elsewhereB.build();
        for (MCTownItem item : chest.getItems()) {
            WorkRequest request;
            if (!((Item)ItemsInit.STOCK_REQUEST.get()).equals(item.get()) || !IngredientsFromHeldItemLogic.ingredientsExist(request = StockRequestItem.getRequest(item.getItemNBT()), (otherItem, req) -> req.asIngredient().test(otherItem.toQTItemStack()), elsewhere)) continue;
            return true;
        }
        return false;
    }

    public static Iterable<MCHeldItem> getItemsForDrop(Iterable<MCHeldItem> itemsForDrop, ContainerTarget<MCContainer, MCTownItem> successTarget) {
        ImmutableList.Builder b = ImmutableList.builder();
        itemsForDrop.forEach(v -> {
            if (!(v.get().get() instanceof StockRequestItem)) {
                b.add(v);
                return;
            }
            BlockPos jb = StockRequestItem.getJobBlock(v.get().getItemNBT());
            if (jb != null && jb.equals((Object)successTarget.getBlockPos())) {
                b.add(v);
            }
        });
        return b.build();
    }

    @Nullable
    public static ContainerTarget<MCContainer, MCTownItem> getDropTargetForLoot(TownInterface town, ImmutableList<MCHeldItem> items, ContainerTarget<MCContainer, MCTownItem> defaultTarget) {
        BlockPos sr = null;
        for (MCHeldItem item : items) {
            BlockPos jb;
            if (item.isEmpty() || !(item.get().get() instanceof StockRequestItem) || (jb = StockRequestItem.getJobBlock(item.get().getItemNBT())) == null) continue;
            sr = jb;
        }
        if (sr == null) {
            return defaultTarget;
        }
        BlockPos fsr = sr;
        return FetcherHack.getTargetContainer(town, fsr);
    }

    @Nullable
    private static ContainerTarget<MCContainer, MCTownItem> getTargetContainer(TownInterface town, BlockPos fsr) {
        List<ContainerTarget<MCContainer, MCTownItem>> all = TownContainers.getAllContainers(town, town.getServerLevel(), match -> match.getContainedBlocks().containsKey((Object)fsr));
        if (all.isEmpty()) {
            return null;
        }
        return all.get(0);
    }

    @Nullable
    public static ProductionStatus computeStatus(TownInterface town, ImmutableList<MCHeldItem> items) {
        @Nullable ContainerTarget<MCContainer, MCTownItem> dt = FetcherHack.getDropTargetForLoot(town, items, null);
        if (dt == null) {
            return null;
        }
        int emptyCount = 0;
        for (MCTownItem item : dt.getItems()) {
            if (!item.isEmpty()) continue;
            ++emptyCount;
        }
        int heldCount = 0;
        for (MCHeldItem item : items) {
            if (item.isEmpty()) continue;
            ++heldCount;
        }
        if (heldCount <= 1 && emptyCount == 1) {
            return ProductionStatus.DROPPING_LOOT;
        }
        if (heldCount >= 2 && emptyCount == 2) {
            return ProductionStatus.DROPPING_LOOT;
        }
        return null;
    }

    @NotNull
    public static List<Ingredient> getProductionNeeds(List<MCHeldItem> heldItems) {
        Optional<MCHeldItem> clipboard = heldItems.stream().filter(v -> v.get().get() instanceof StockRequestItem).findFirst();
        if (clipboard.isEmpty()) {
            return ImmutableList.of((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsInit.STOCK_REQUEST.get()}));
        }
        CompoundTag nbt = clipboard.get().getItemNBTData();
        if (!StockRequestItem.hasRequest(nbt)) {
            return ImmutableList.of((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsInit.STOCK_REQUEST.get()}));
        }
        WorkRequest request = StockRequestItem.getRequest(nbt);
        return ImmutableList.of((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsInit.STOCK_REQUEST.get()}), (Object)request.asIngredient());
    }
}

