/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs.gatherer;

import ca.bradj.questown.core.Config;
import ca.bradj.questown.core.init.TagsInit;
import ca.bradj.questown.core.init.items.ItemsInit;
import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.items.GathererMap;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.Work;
import ca.bradj.questown.jobs.gatherer.GathererTools;
import ca.bradj.questown.jobs.gatherer.GathererUnmappedAxeWorkFullDay;
import ca.bradj.questown.jobs.gatherer.Loots;
import ca.bradj.questown.jobs.gatherer.NewLeaverWork;
import ca.bradj.questown.jobs.production.ProductionStatus;
import ca.bradj.questown.mc.Util;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class GathererMappedAxeWork
extends NewLeaverWork {
    private static final GathererTools.LootTableParameters PARAMS = new GathererTools.LootTableParameters(GathererTools.AXE_LOOT_TABLE_PREFIX, GathererTools.AXE_LOOT_TABLE_DEFAULT);
    public static final JobID ID;
    public static final int BLOCK_STATE_NEED_TOOL = 0;
    public static final int BLOCK_STATE_NEED_MAP = 1;
    public static final int BLOCK_STATE_NEED_FOOD = 2;
    public static final int BLOCK_STATE_NEED_ROAM = 3;
    public static final int BLOCK_STATE_DONE = 4;
    public static final int MAX_STATE = 4;
    public static final ImmutableMap<Integer, Ingredient> INGREDIENTS_REQUIRED_AT_STATES;
    public static final ImmutableMap<Integer, Integer> INGREDIENT_QTY_REQUIRED_AT_STATES;
    public static final ImmutableMap<Integer, Ingredient> TOOLS_REQUIRED_AT_STATES;
    public static final ImmutableMap<Integer, Integer> WORK_REQUIRED_AT_STATES;
    public static final ImmutableMap<ProductionStatus, Collection<String>> SPECIAL_RULES;

    public GathererMappedAxeWork() {
        super(PARAMS);
    }

    public static Work asWork() {
        return NewLeaverWork.asWork(ID, GathererUnmappedAxeWorkFullDay.ID, Items.f_42391_.m_7968_(), GathererTools.AXE_LOOT_TABLE_PREFIX, Items.f_41888_.m_7968_(), 4, Util.constant(INGREDIENTS_REQUIRED_AT_STATES), Util.constant(INGREDIENT_QTY_REQUIRED_AT_STATES), Util.constant(TOOLS_REQUIRED_AT_STATES), Util.constant(WORK_REQUIRED_AT_STATES), (ImmutableMap<Integer, Supplier<Integer>>)ImmutableMap.of((Object)3, () -> Config.GATHERER_TIME_REQUIRED_BASELINE.get()), SPECIAL_RULES, GathererMappedAxeWork::getFromLootTables);
    }

    private static Iterable<MCHeldItem> getFromLootTables(ServerLevel level, Collection<MCHeldItem> items) {
        @Nullable ResourceLocation biome = GathererMap.computeBiome(items);
        if (biome == null) {
            return Loots.getFromLootTables(level, items, new GathererTools.LootTableParameters(GathererTools.AXE_LOOT_TABLE_PREFIX, GathererTools.AXE_LOOT_TABLE_DEFAULT));
        }
        return Loots.getFromLootTables(level, items.size(), new GathererTools.LootTableParameters(GathererTools.AXE_LOOT_TABLE_PREFIX, GathererTools.AXE_LOOT_TABLE_DEFAULT), biome);
    }

    static {
        allParameters.add(PARAMS);
        ID = new JobID("gatherer", "axe_mapped");
        INGREDIENTS_REQUIRED_AT_STATES = ImmutableMap.of((Object)2, (Object)Ingredient.m_204132_(TagsInit.Items.VILLAGER_FOOD));
        INGREDIENT_QTY_REQUIRED_AT_STATES = ImmutableMap.of((Object)2, (Object)1);
        TOOLS_REQUIRED_AT_STATES = ImmutableMap.of((Object)1, (Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsInit.GATHERER_MAP.get()}), (Object)0, (Object)Ingredient.m_204132_(TagsInit.Items.AXES));
        WORK_REQUIRED_AT_STATES = ImmutableMap.of();
        SPECIAL_RULES = ImmutableMap.of((Object)ProductionStatus.fromJobBlockStatus(3), (Object)ImmutableList.of((Object)"remove_from_world"), (Object)ProductionStatus.FACTORY.waitingForTimedState(), (Object)ImmutableList.of((Object)"remove_from_world"));
    }
}

