/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs.gatherer;

import ca.bradj.questown.QT;
import ca.bradj.questown.core.Config;
import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.integration.minecraft.MCTownItem;
import ca.bradj.questown.items.GathererMap;
import ca.bradj.questown.jobs.gatherer.GathererTools;
import ca.bradj.questown.mc.Compat;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Loots {
    public static ResourceLocation fallbackBiome = new ResourceLocation("forest");

    @NotNull
    public static List<MCHeldItem> getFromLootTables(ServerLevel level, Collection<MCHeldItem> items, GathererTools.LootTableParameters lt) {
        ResourceLocation biome = Loots.finalizeBiome(items);
        int maxAmount = items.size();
        return Loots.getFromLootTables(level, maxAmount / 2, maxAmount, lt, biome);
    }

    @NotNull
    public static List<MCHeldItem> getFromLootTables(ServerLevel level, Collection<MCHeldItem> items, int maxAmount, GathererTools.LootTableParameters lt) {
        return Loots.getFromLootTables(level, Math.max(1, maxAmount / 2), maxAmount, lt, Loots.finalizeBiome(items));
    }

    @NotNull
    public static List<MCHeldItem> getFromLootTables(ServerLevel level, int maxAmount, GathererTools.LootTableParameters lt, ResourceLocation biome) {
        return Loots.getFromLootTables(level, maxAmount / 2, maxAmount, lt, biome);
    }

    @NotNull
    public static List<MCHeldItem> getFromLootTables(ServerLevel level, int minAmount, int maxAmount, GathererTools.LootTableParameters lt, ResourceLocation biome) {
        String id = String.format("%s/%s/%s", lt.prefix().value(), biome.m_135827_(), biome.m_135815_());
        ResourceLocation rl = new ResourceLocation("questown", id);
        LootTables tables = level.m_7654_().m_129898_();
        if (!tables.m_79195_().contains(rl)) {
            QT.JOB_LOGGER.warn("No loot table found for {}. Using fallback {}", id, lt.fallback());
            rl = new ResourceLocation("questown", lt.fallback().path());
        }
        if (!tables.m_79195_().contains(rl)) {
            QT.JOB_LOGGER.warn("No loot table found for {}. Using fallback {}", id, lt.fallback());
            rl = new ResourceLocation("questown", GathererTools.NO_TOOL_LOOT_TABLE_DEFAULT.path());
        }
        if (!tables.m_79195_().contains(rl)) {
            throw new IllegalStateException(String.format("No loot table found for %s or fallback %s", id, lt.fallback()));
        }
        return Loots.getFromKnownTable(level, minAmount, maxAmount, lt, biome, tables, rl);
    }

    @NotNull
    public static List<MCHeldItem> getFromKnownTable(ServerLevel level, int minAmount, int maxAmount, GathererTools.LootTableParameters lt, ResourceLocation biome, ResourceLocation rl) {
        LootTables tables = level.m_7654_().m_129898_();
        return Loots.getFromKnownTable(level, minAmount, maxAmount, lt, biome, tables, rl);
    }

    @NotNull
    private static List<MCHeldItem> getFromKnownTable(ServerLevel level, int minAmount, int maxAmount, GathererTools.LootTableParameters lt, ResourceLocation biome, LootTables tables, ResourceLocation rl) {
        LootTable lootTable = tables.m_79217_(rl);
        List<MCTownItem> loot = Loots.loadFromTables(level, lootTable, minAmount, maxAmount);
        return loot.stream().map(v -> MCHeldItem.fromLootTable(v, lt.prefix(), biome)).toList();
    }

    @NotNull
    private static ResourceLocation finalizeBiome(Collection<MCHeldItem> journal) {
        @Nullable ResourceLocation biome = GathererMap.computeBiome(journal);
        if (biome == null) {
            biome = fallbackBiome;
        }
        return biome;
    }

    @NotNull
    public static List<MCTownItem> loadFromTables(ServerLevel level, LootTable lootTable, int minItems, int maxItems) {
        if (maxItems <= 0) {
            return ImmutableList.of();
        }
        LootContext.Builder lcb = new LootContext.Builder(level);
        LootContext lc = lcb.m_78975_(LootContextParamSets.f_81410_);
        ArrayList rItems = new ArrayList();
        int max = minItems + level.f_46441_.m_188503_(maxItems - minItems + 1);
        for (int i = 0; i < Compat.configGet(Config.BASE_MAX_LOOP).get() && rItems.size() < max; ++i) {
            rItems.addAll(lootTable.m_230922_(lc));
        }
        Collections.shuffle(rItems);
        int subLen = Math.min(rItems.size(), maxItems);
        List<MCTownItem> list = rItems.stream().filter(v -> !v.m_41619_()).map(MCTownItem::fromMCItemStack).toList().subList(0, subLen);
        return list;
    }
}

