/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs.gatherer;

import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.ResultGenerator;
import ca.bradj.questown.jobs.Work;
import ca.bradj.questown.jobs.WorkDescription;
import ca.bradj.questown.jobs.WorkSpecialRules;
import ca.bradj.questown.jobs.WorkStates;
import ca.bradj.questown.jobs.WorkWorldInteractions;
import ca.bradj.questown.jobs.WorksBehaviour;
import ca.bradj.questown.jobs.declarative.SoundInfo;
import ca.bradj.questown.jobs.gatherer.GathererTools;
import ca.bradj.questown.jobs.production.ProductionStatus;
import ca.bradj.questown.town.special.SpecialQuests;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class NewLeaverWork {
    protected static final List<GathererTools.LootTableParameters> allParameters = new ArrayList<GathererTools.LootTableParameters>();

    public static List<GathererTools.LootTableParameters> getAllParameters() {
        return allParameters;
    }

    public NewLeaverWork(GathererTools.LootTableParameters lootTableParams) {
        if (!allParameters.contains(lootTableParams)) {
            throw new IllegalStateException("Descendants of NewLeaveWork must register selves from a static context");
        }
    }

    protected static ImmutableList<String> standardRules() {
        return ImmutableList.of((Object)"prioritize_extraction", (Object)"nullify_excess_results");
    }

    protected static Work asWork(JobID id, JobID parentId, ItemStack icon, GathererTools.LootTablePrefix lootTablePrefix, ItemStack initialRequest, int maxState, ImmutableMap<Integer, Supplier<Ingredient>> ingredientsRequiredAtStates, ImmutableMap<Integer, Supplier<Integer>> ingredientQtyRequiredAtStates, ImmutableMap<Integer, Supplier<Ingredient>> toolsRequiredAtStates, ImmutableMap<Integer, Supplier<Integer>> workRequiredAtStates, ImmutableMap<Integer, Supplier<Integer>> timeRequiredAtStates, ImmutableMap<ProductionStatus, Collection<String>> specialRules, final BiFunction<ServerLevel, Collection<MCHeldItem>, Iterable<MCHeldItem>> resultGenerator) {
        return WorksBehaviour.productionWork(icon, id, parentId, new WorkDescription(t -> t.allKnownGatherItemsFn().apply(lootTablePrefix), initialRequest), SpecialQuests.TOWN_GATE_LOCATION, new WorkStates(maxState, ingredientsRequiredAtStates, ingredientQtyRequiredAtStates, toolsRequiredAtStates, workRequiredAtStates, timeRequiredAtStates), new WorkWorldInteractions(0, new ResultGenerator<MCHeldItem>(){

            @Override
            public Iterable<MCHeldItem> generate(ServerLevel level, Collection<MCHeldItem> heldItems) {
                return (Iterable)resultGenerator.apply(level, heldItems);
            }

            @Override
            public boolean isResultAlwaysEmpty() {
                return false;
            }
        }), new WorkSpecialRules(specialRules, NewLeaverWork.standardRules()), new SoundInfo(SoundEvents.f_11678_.m_11660_(), 100, 100));
    }
}

