/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs.production;

import ca.bradj.questown.jobs.EntityInvStateProvider;
import ca.bradj.questown.jobs.EntityLocStateProvider;
import ca.bradj.questown.jobs.IProductionStatusFactory;
import ca.bradj.questown.jobs.IStatusFactory;
import ca.bradj.questown.jobs.JobStatuses;
import ca.bradj.questown.jobs.JobTownProvider;
import ca.bradj.questown.jobs.Signals;
import ca.bradj.questown.jobs.TypicalProductionJob;
import ca.bradj.questown.jobs.production.ProductionStatus;
import ca.bradj.roomrecipes.core.Room;
import com.google.common.collect.ImmutableList;
import org.jetbrains.annotations.Nullable;

public class ProductionStatuses {
    @Nullable
    public static <ROOM extends Room> ProductionStatus getNewStatusFromSignal(ProductionStatus currentStatus, Signals signal, EntityInvStateProvider<Integer> inventory, JobTownProvider<ROOM> town, EntityLocStateProvider<ROOM> entity, IProductionStatusFactory<ProductionStatus> factory, boolean prioritizeExtraction) {
        switch (signal) {
            case MORNING: 
            case NOON: {
                return ProductionStatuses.getMorningStatus(currentStatus, inventory, town, entity, factory, prioritizeExtraction);
            }
            case NIGHT: 
            case EVENING: {
                return ProductionStatuses.getEveningStatus(currentStatus, inventory, town, factory);
            }
        }
        throw new IllegalArgumentException(String.format("Unrecognized signal %s", new Object[]{signal}));
    }

    @Nullable
    public static <ROOM extends Room> ProductionStatus getMorningStatus(ProductionStatus currentStatus, EntityInvStateProvider<Integer> inventory, JobTownProvider<ROOM> town, EntityLocStateProvider<ROOM> entity, IProductionStatusFactory<ProductionStatus> factory, boolean prioritizeExtraction) {
        ProductionStatus newStatus = JobStatuses.productionRoutine(currentStatus, prioritizeExtraction, inventory, entity, town, new TypicalProductionJob((ImmutableList<Integer>)ImmutableList.of((Object)0, (Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object)7, (Object)8, (Object)9, (Object)10)), factory);
        return ProductionStatuses.nullIfUnchanged(currentStatus, newStatus);
    }

    @Nullable
    public static <ROOM extends Room> ProductionStatus getEveningStatus(ProductionStatus currentStatus, EntityInvStateProvider<Integer> inventory, JobTownProvider<ROOM> town, IStatusFactory<ProductionStatus> factory) {
        if (JobStatuses.hasItems(inventory)) {
            return ProductionStatuses.nullIfUnchanged(currentStatus, factory.droppingLoot());
        }
        return ProductionStatuses.nullIfUnchanged(currentStatus, factory.relaxing());
    }

    private static ProductionStatus nullIfUnchanged(ProductionStatus oldStatus, ProductionStatus newStatus) {
        if (oldStatus.equals(newStatus)) {
            return null;
        }
        return newStatus;
    }
}

