/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs.production;

import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.integration.minecraft.MCTownItem;
import ca.bradj.questown.logic.PredicateCollection;
import ca.bradj.questown.mc.PredicateCollections;
import ca.bradj.roomrecipes.adapter.IRoomRecipeMatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class RoomsNeedingVillagerInput<ROOM, RECIPE, POS> {
    private final ImmutableMap<Integer, Collection<NVIRoom<ROOM, RECIPE, POS>>> inner;

    public RoomsNeedingVillagerInput(Map<Integer, ? extends Collection<NVIRoom<ROOM, RECIPE, POS>>> kvImmutableMap) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        kvImmutableMap.forEach((k, v) -> {
            ImmutableList.Builder b = ImmutableList.builder();
            v.forEach(arg_0 -> ((ImmutableList.Builder)b).add(arg_0));
            builder.put(k, (Object)b.build());
        });
        this.inner = builder.build();
    }

    public Map<Integer, Collection<NVIRoom<ROOM, RECIPE, POS>>> get() {
        return this.inner;
    }

    public ImmutableList<PredicateCollection<MCTownItem, ?>> cleanFns(Function<Integer, PredicateCollection<MCHeldItem, ?>> items, Function<Integer, PredicateCollection<MCTownItem, ?>> tools) {
        Optional<Integer> first = this.inner.entrySet().stream().filter(v -> !((Collection)v.getValue()).isEmpty()).map(Map.Entry::getKey).findFirst();
        if (first.isEmpty()) {
            return ImmutableList.of();
        }
        int s = first.get();
        ImmutableList.Builder bb = ImmutableList.builder();
        PredicateCollection<MCHeldItem, ?> ingr = items.apply(s);
        if (ingr != null) {
            bb.add(PredicateCollections.townify(ingr));
        }
        for (int i = 0; i <= s; ++i) {
            PredicateCollection<MCTownItem, ?> tool = tools.apply(i);
            if (tool == null) continue;
            bb.add(tool);
        }
        return bb.build();
    }

    public Set<Integer> getNonEmptyStates() {
        return this.inner.entrySet().stream().filter(v -> !((Collection)v.getValue()).isEmpty()).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public RoomsNeedingVillagerInput<ROOM, RECIPE, POS> floor() {
        HashMap b = new HashMap();
        this.inner.forEach((k, rooms) -> {
            ImmutableSet.Builder allPrevRooms = ImmutableSet.builder();
            for (int i = 0; i < k; ++i) {
                Collection elements = (Collection)b.get(i);
                if (elements == null) {
                    elements = ImmutableList.of();
                }
                allPrevRooms.addAll((Iterable)elements);
            }
            ImmutableSet prevRooms = allPrevRooms.build();
            ImmutableList.Builder bld = ImmutableList.builder();
            rooms.forEach(room -> {
                if (prevRooms.contains(room)) {
                    return;
                }
                bld.add(room);
            });
            ImmutableList build = bld.build();
            if (!build.isEmpty()) {
                b.put(k, build);
            }
        });
        return new RoomsNeedingVillagerInput<ROOM, RECIPE, POS>(ImmutableMap.copyOf(b));
    }

    public boolean containsKey(Integer s) {
        return this.inner.containsKey((Object)s);
    }

    public Collection<NVIRoom<ROOM, RECIPE, POS>> get(Integer s) {
        return (Collection)this.inner.get((Object)s);
    }

    public ImmutableList<NVIRoom<ROOM, RECIPE, POS>> getMatches() {
        return ImmutableList.copyOf(this.inner.values().stream().flatMap(Collection::stream).distinct().iterator());
    }

    public record NVIRoom<ROOM, RECIPE, POS>(IRoomRecipeMatch<ROOM, RECIPE, POS, ?> room, boolean dueToWorkOnly) {
    }
}

