/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs.requests;

import ca.bradj.questown.QT;
import ca.bradj.questown.mc.Compat;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class WorkRequest {
    @Nullable
    final TagKey<Item> tag;
    @Nullable
    final Item item;

    private WorkRequest(@Nullable TagKey<Item> tag, @Nullable Item item) {
        this.tag = tag;
        this.item = item;
    }

    public static WorkRequest of(Item requested) {
        return new WorkRequest(null, requested);
    }

    public static WorkRequest of(TagKey<Item> tk) {
        return new WorkRequest(tk, null);
    }

    public ImmutableList<Ingredient> getAllInterpretationsForGUI() {
        if (this.item != null) {
            return ImmutableList.of((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.item}));
        }
        if (this.tag != null) {
            ImmutableList.Builder b = ImmutableList.builder();
            Ingredient all = Ingredient.m_204132_(this.tag);
            b.add((Object)all);
            for (ItemStack i : all.m_43908_()) {
                b.add((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{i}));
            }
        }
        QT.GUI_LOGGER.error("WorkRequest has null tag AND item", new Object[0]);
        return ImmutableList.of();
    }

    public Ingredient asIngredient() {
        if (this.item != null) {
            return Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.item});
        }
        if (this.tag != null) {
            return Ingredient.m_204132_(this.tag);
        }
        QT.GUI_LOGGER.error("WorkRequest has null tag AND item", new Object[0]);
        return Ingredient.m_151265_();
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.item == null ? "" : ForgeRegistries.ITEMS.getKey((Object)this.item).toString());
        buffer.m_130070_(this.tag == null ? "" : this.tag.f_203868_().toString());
    }

    public static WorkRequest fromNetwork(FriendlyByteBuf buffer) {
        String i = buffer.m_130277_();
        String t = buffer.m_130277_();
        if (i.isEmpty() && t.isEmpty()) {
            throw new IllegalArgumentException("Invalid work request on buffer.");
        }
        if (i.isEmpty()) {
            return new WorkRequest((TagKey<Item>)new TagKey(Registry.f_122904_, new ResourceLocation(t)), null);
        }
        return new WorkRequest(null, (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(i)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkRequest that = (WorkRequest)o;
        return Objects.equals(this.tag, that.tag) && Objects.equals(this.item, that.item);
    }

    public int hashCode() {
        return Objects.hash(this.tag, this.item);
    }

    public String toString() {
        return "WorkRequest{tag=" + String.valueOf(this.tag) + ", item=" + String.valueOf(this.item) + "}";
    }

    public Component getName() {
        if (this.tag != null) {
            return Compat.translatable("#" + String.valueOf(this.tag.f_203868_()));
        }
        if (this.item != null) {
            return Compat.getItemName(this.item);
        }
        return Compat.translatable("invalid.workrequest");
    }
}

