/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.logic;

import ca.bradj.questown.Questown;
import ca.bradj.questown.core.Config;
import ca.bradj.questown.mc.Compat;
import ca.bradj.roomrecipes.adapter.Positions;
import ca.bradj.roomrecipes.core.Room;
import ca.bradj.roomrecipes.core.space.Position;
import ca.bradj.roomrecipes.logic.DoorDetection;
import ca.bradj.roomrecipes.logic.LevelRoomDetection;
import ca.bradj.roomrecipes.logic.interfaces.WallDetector;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class TownCycle {
    public static ImmutableMap<Position, Optional<Room>> findRooms(@Nullable Position scanAroundPosition, BlockChecker checker, Iterable<Position> registeredDoors) {
        ImmutableCollection<Position> foundDoors = ImmutableList.of();
        if (scanAroundPosition != null && Compat.configGet(Config.SCAN_FOR_DOORS).get().booleanValue()) {
            foundDoors = TownCycle.findDoors(checker, scanAroundPosition);
        }
        ImmutableList.Builder b = ImmutableList.builder();
        ImmutableList allDoors = b.addAll((Iterable)foundDoors).addAll(registeredDoors).build();
        return LevelRoomDetection.findRooms((Collection)allDoors, (int)20, checker::IsWall);
    }

    private static ImmutableCollection<Position> findDoors(BlockChecker blocks, Position townBlockPosition) {
        Questown.LOGGER.trace("Checking for doors");
        Collection doors = DoorDetection.LocateDoorsAroundPosition((Position)townBlockPosition, dp -> {
            if (blocks.IsEmpty(dp)) {
                return false;
            }
            return blocks.IsDoor(dp);
        }, (int)Compat.configGet(Config.DOOR_SEARCH_RADIUS).get());
        return ImmutableList.copyOf((Collection)doors);
    }

    public static Optional<BlockPos> findCampfire(BlockPos pos, Level level) {
        int radius = Compat.configGet(Config.CAMPFIRE_SEARCH_RADIUS).get();
        for (int z = -radius; z < radius; ++z) {
            for (int x = -radius; x < radius; ++x) {
                BlockPos cfPos = pos.m_7918_(x, 0, z);
                if (!level.m_8055_(cfPos).m_60734_().equals(Blocks.f_50683_)) continue;
                return Optional.of(cfPos);
            }
        }
        return Optional.empty();
    }

    @Nullable
    public static BlockPos findTownGate(BlockPos welcomePos, ServerLevel level, WallDetector wd) {
        BlockPos offsetX1 = welcomePos.m_7918_(1, 0, 0);
        BlockPos offsetX2 = welcomePos.m_7918_(-1, 0, 0);
        BlockPos offsetZ1 = welcomePos.m_7918_(0, 0, 1);
        BlockPos offsetZ2 = welcomePos.m_7918_(0, 0, -1);
        if (wd.IsWall(Positions.FromBlockPos((BlockPos)offsetX1)) && wd.IsWall(Positions.FromBlockPos((BlockPos)offsetX2)) && TownCycle.hasTorches(level, offsetX1, offsetX2)) {
            return welcomePos;
        }
        if (wd.IsWall(Positions.FromBlockPos((BlockPos)offsetZ1)) && wd.IsWall(Positions.FromBlockPos((BlockPos)offsetZ2)) && TownCycle.hasTorches(level, offsetZ1, offsetZ2)) {
            return welcomePos;
        }
        return null;
    }

    private static boolean hasTorches(ServerLevel level, BlockPos offsetX1, BlockPos offsetX2) {
        BlockPos torchPos1 = offsetX1.m_7494_().m_7918_(0, 0, 1);
        BlockPos torchPos2 = offsetX1.m_7494_().m_7918_(0, 0, -1);
        BlockPos torchPos3 = offsetX2.m_7494_().m_7918_(0, 0, 1);
        BlockPos torchPos4 = offsetX2.m_7494_().m_7918_(0, 0, -1);
        if (offsetX1.m_123341_() == offsetX2.m_123341_()) {
            torchPos1 = offsetX1.m_7494_().m_7918_(1, 0, 0);
            torchPos2 = offsetX1.m_7494_().m_7918_(-1, 0, 0);
            torchPos3 = offsetX2.m_7494_().m_7918_(1, 0, 0);
            torchPos4 = offsetX2.m_7494_().m_7918_(-1, 0, 0);
        }
        return level.m_8055_(torchPos1).m_60713_(Blocks.f_50082_) && level.m_8055_(torchPos2).m_60713_(Blocks.f_50082_) && level.m_8055_(torchPos3).m_60713_(Blocks.f_50082_) && level.m_8055_(torchPos4).m_60713_(Blocks.f_50082_);
    }

    public static interface BlockChecker {
        public boolean IsEmpty(Position var1);

        public boolean IsWall(Position var1);

        public boolean IsDoor(Position var1);
    }
}

