/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.mc;

import ca.bradj.questown.QT;
import ca.bradj.questown.core.Coordinate;
import ca.bradj.questown.core.init.CommandsInit;
import ca.bradj.questown.town.entity.TownFlagBlockEntity;
import ca.bradj.questown.town.rooms.TownPosition;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Compat {
    public static final RandomSource RANDOM = RandomSource.m_216327_();
    public static final IForgeRegistry<EntityType<?>> ENTITY_TYPES = ForgeRegistries.ENTITY_TYPES;
    @NotNull
    public static final Capability<IItemHandler> ITEM_HANDLER = ForgeCapabilities.ITEM_HANDLER;

    public static void playNeutralSound(ServerLevel serverLevel, BlockPos pos, SoundEvent sound) {
        float volume = 0.5f;
        float pitchUpOrDown = 1.0f + (serverLevel.f_46441_.m_188501_() - serverLevel.f_46441_.m_188501_()) * 0.4f;
        serverLevel.m_5594_(null, pos, sound, SoundSource.NEUTRAL, volume, pitchUpOrDown);
    }

    public static void playSound(ServerLevel serverLevel, BlockPos pos, SoundEvent sound, SoundSource source) {
        float volume = 0.5f;
        float pitchUpOrDown = 1.0f + (serverLevel.f_46441_.m_188501_() - serverLevel.f_46441_.m_188501_()) * 0.4f;
        serverLevel.m_5594_(null, pos, sound, source, volume, pitchUpOrDown);
    }

    public static Component translatable(String key) {
        return Component.m_237115_((String)key);
    }

    public static MutableComponent translatable(String key, Object ... args) {
        return Component.m_237110_((String)key, (Object[])args);
    }

    public static Component translatableStyled(String s, Style style, Object ... args) {
        MutableComponent v = Compat.translatable(s, args);
        v.m_6270_(style);
        return v;
    }

    public static Component literal(String x) {
        return Component.m_237113_((String)x);
    }

    public static <X> ImmutableList<X> shuffle(ImmutableCollection<X> c, ServerLevel serverLevel) {
        return Compat.shuffle(c.iterator(), serverLevel);
    }

    public static <X> ImmutableList<X> shuffle(Iterator<X> iterator, @Nullable ServerLevel serverLevel) {
        int size;
        ArrayList list = new ArrayList();
        iterator.forEachRemaining(list::add);
        for (int i = size = list.size(); i > 1; --i) {
            Collections.swap(list, i - 1, Compat.getRandomInt(serverLevel, i));
        }
        return ImmutableList.copyOf(list);
    }

    public static int nextRandomInt(@Nullable ServerLevel server, int i) {
        return server.m_213780_().m_188503_(i);
    }

    public static Direction getRandomHorizontal(ServerLevel serverLevel) {
        return Direction.Plane.HORIZONTAL.m_235690_(serverLevel.m_213780_());
    }

    public static void setCutoutRenderType(Block block) {
    }

    public static <MSG> SimpleChannel.MessageBuilder<MSG> withConsumer(SimpleChannel.MessageBuilder<MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> consumer) {
        return decoder.consumerNetworkThread(consumer);
    }

    public static CompoundTag getBlockStoredTagData(TownFlagBlockEntity e) {
        return e.getPersistentData();
    }

    public static void openScreen(ServerPlayer sender, MenuProvider menuProvider, Consumer<FriendlyByteBuf> writer) {
        NetworkHooks.openScreen((ServerPlayer)sender, (MenuProvider)menuProvider, writer);
    }

    public static DeferredRegister<MenuType<?>> CreateMenuRegister(String modid) {
        return DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)modid);
    }

    public static void enqueueOrLog(FMLCommonSetupEvent event, Runnable staticInitialize) {
        event.enqueueWork(staticInitialize).exceptionally(ex -> {
            QT.INIT_LOGGER.error("Enqueued work failed", ex);
            return null;
        });
    }

    public static <X> Supplier<X> configGet(ForgeConfigSpec.ConfigValue<X> cfg) {
        return () -> cfg.get();
    }

    public static TownPosition townPos(BlockPos flagPos, BlockPos blockPos) {
        return new TownPosition(blockPos.m_123341_(), blockPos.m_123343_(), blockPos.m_123342_() - flagPos.m_123342_());
    }

    public static boolean insertInNextOpenSlot(IItemHandler iItemHandler, ItemStack inserted, int targetSize) {
        ItemStack stackInSlot;
        int i;
        if (inserted.m_41784_().m_128456_()) {
            for (i = 0; i < iItemHandler.getSlots(); ++i) {
                stackInSlot = iItemHandler.getStackInSlot(i);
                if (!stackInSlot.m_41784_().m_128456_() || !stackInSlot.m_41656_(inserted) || stackInSlot.m_41613_() >= targetSize) continue;
                iItemHandler.insertItem(i, inserted, false);
                return true;
            }
        }
        for (i = 0; i < iItemHandler.getSlots(); ++i) {
            stackInSlot = iItemHandler.getStackInSlot(i);
            if (!stackInSlot.m_41619_()) continue;
            iItemHandler.insertItem(i, inserted, false);
            return true;
        }
        return false;
    }

    public static void drawDarkText(Font font, PoseStack stack, Component translatable, int x, int y) {
        font.m_92889_(stack, translatable, (float)x, (float)y, 0);
    }

    public static void drawDarkText(Font font, PoseStack stack, FormattedCharSequence translatable, int x, int y) {
        font.m_92877_(stack, translatable, (float)x, (float)y, 0);
    }

    public static void drawLightText(Font font, PoseStack stack, String translatable, int x, int y) {
        font.m_92750_(stack, translatable, (float)x, (float)y, -1);
    }

    public static Component getItemName(ResourceLocation wantedId) {
        return Compat.getItemName((Item)ForgeRegistries.ITEMS.getValue(wantedId));
    }

    public static Component getItemName(Item item) {
        return item.m_7626_(item.m_7968_());
    }

    public static ResourceLocation getItemId(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item);
    }

    public static ResourceLocation getItemId(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    public static boolean getRandomBool(@Nullable ServerLevel serverLevel) {
        return serverLevel.m_213780_().m_188499_();
    }

    public static int getRandomInt(ServerLevel serverLevel, int size) {
        return serverLevel.m_213780_().m_188503_(size);
    }

    public static void sendMessage(ServerPlayer sender, Component message) {
        sender.m_213846_(message);
    }

    public static void initCommands(IEventBus bus) {
        CommandsInit.register(bus);
    }

    public static int drawDarkTextWrap(Font font, PoseStack poseStack, Coordinate topLeft, int textWidth, Component translatable) {
        int out = 0;
        for (FormattedCharSequence line : font.m_92923_((FormattedText)translatable, textWidth)) {
            Compat.drawDarkText(font, poseStack, line, (int)topLeft.x(), topLeft.y() + out);
            Objects.requireNonNull(font);
            out += (int)(9.0 * 1.5);
        }
        return out;
    }

    public static double randomTriangle(double v, double v1) {
        return RANDOM.m_216328_(v, v1);
    }

    public static Vec3 relative(Vec3 start, Direction dir, double amount) {
        return start.m_231075_(dir, amount);
    }

    public static float nextFloat(float v, float v1) {
        return RANDOM.m_188501_() * (v1 - v) + v;
    }

    public static List<FormattedCharSequence> splitText(Font font, Component text, int width) {
        return font.m_92923_((FormattedText)text, width);
    }
}

