/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.mc;

import ca.bradj.questown.Questown;
import ca.bradj.questown.core.Config;
import ca.bradj.questown.core.UtilClean;
import ca.bradj.questown.core.network.OnScreenTextMessage;
import ca.bradj.questown.core.network.QuestownNetwork;
import ca.bradj.questown.jobs.AmountHeld;
import ca.bradj.questown.jobs.NoisyBiPredicate;
import ca.bradj.questown.jobs.NoisyPredicate;
import ca.bradj.questown.jobs.Signals;
import ca.bradj.questown.jobs.WorkLocation;
import ca.bradj.questown.jobs.WorkOutput;
import ca.bradj.questown.jobs.WorkPosition;
import ca.bradj.questown.jobs.declarative.WithReason;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.mobs.visitor.VisitorMobRenderer;
import ca.bradj.questown.town.workstatus.State;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Util {
    public static final int faceWidth = 8;

    public static long getTick(ServerLevel level) {
        return level.m_46467_();
    }

    public static Signals.DayTime getDayTime(Level serverLevel) {
        return new Signals.DayTime(serverLevel.m_46468_() % 24000L);
    }

    public static <X> ImmutableMap<Integer, Supplier<X>> constant(ImmutableMap<Integer, X> constant) {
        ImmutableMap.Builder b = ImmutableMap.builder();
        constant.forEach((k, v) -> b.put(k, () -> v));
        return b.build();
    }

    public static <X> ImmutableMap<Integer, X> realize(ImmutableMap<Integer, Supplier<X>> theoretical) {
        ImmutableMap.Builder b = ImmutableMap.builder();
        theoretical.forEach((k, v) -> b.put(k, v.get()));
        return b.build();
    }

    public static <X> ImmutableList<X> realize(ImmutableList<Supplier<X>> theoretical) {
        ImmutableList.Builder b = ImmutableList.builder();
        theoretical.forEach(v -> b.add(v.get()));
        return b.build();
    }

    public static <K, X, Y extends X> X getOrDefault(Map<K, X> map, K key, Y fallback) {
        return UtilClean.getOrDefault(map, key, fallback);
    }

    public static <K, X> ImmutableList<X> getOrDefaultCollection(Map<K, ? extends Collection<? extends X>> map, K key, ImmutableList<X> fallback) {
        return UtilClean.getOrDefaultCollection(map, key, fallback);
    }

    private static <K, X> Collection<X> getOrDefaultCollection(Map<K, ? extends Collection<? extends X>> map, K key, Collection<X> fallback, boolean mutable) {
        return UtilClean.getOrDefaultCollection(map, key, fallback, mutable);
    }

    public static <K, V> Map<K, ArrayList<V>> makeMutable(Map<K, ? extends Collection<V>> inMap) {
        HashMap kArrayListHashMap = new HashMap();
        inMap.forEach((k, v) -> kArrayListHashMap.put(k, new ArrayList(v)));
        return kArrayListHashMap;
    }

    public static <X, Y> Y applyOrDefault(X param, Function<X, Y> fn, Y defaultt) {
        Y v = fn.apply(param);
        if (v == null) {
            return defaultt;
        }
        return v;
    }

    public static <K, V> ImmutableMap<K, ImmutableList<V>> immutify(Map<K, ? extends Collection<V>> roomsNeedingIngredientsByState) {
        ImmutableMap.Builder b = ImmutableMap.builder();
        roomsNeedingIngredientsByState.forEach((k, v) -> b.put(k, (Object)ImmutableList.copyOf((Collection)v)));
        return b.build();
    }

    public static <K, V> Map<K, V> only(Map<K, V> map, K s) {
        if (map.containsKey(s)) {
            return ImmutableMap.of(s, map.get(s));
        }
        return ImmutableMap.of();
    }

    public static <ITEM> Predicate<ITEM> funcToPredNullable(Function<ITEM, Boolean> ingredient) {
        if (ingredient == null) {
            return null;
        }
        return ingredient::apply;
    }

    public static <I extends ca.bradj.questown.jobs.Item<I>> WithReason<Boolean> anyMatch(Stream<I> stream, NoisyPredicate<I> check) {
        List<WithReason> tests = stream.map(check::test).toList();
        for (WithReason test : tests) {
            if (!((Boolean)test.value).booleanValue()) continue;
            return test;
        }
        String joined = String.join((CharSequence)", ", tests.stream().map(v -> v.reason).toList());
        return new WithReason<Boolean>(false, "All failed: [%s]", joined);
    }

    public static <ITEM> Predicate<ITEM> toQuiet(NoisyPredicate<ITEM> check) {
        return i -> (Boolean)check.test(i).value;
    }

    public static <TOWN_ITEM extends ca.bradj.questown.jobs.Item<TOWN_ITEM>> Collection<? extends NoisyBiPredicate<AmountHeld, TOWN_ITEM>> sameNoise(Collection<BiPredicate<AmountHeld, TOWN_ITEM>> all, String messageIfPass, String messageIfFail) {
        ImmutableList.Builder b = ImmutableList.builder();
        all.forEach(bp -> b.add((amountHeld, townItem) -> WithReason.bool(bp.test(amountHeld, townItem), messageIfPass, messageIfFail, townItem.getShortName())));
        return b.build();
    }

    public static <X> void iterate(Iterable<X> source, Consumer<X> sink) {
        Iterator<X> iter = source.iterator();
        for (int i = 0; i < Compat.configGet(Config.BASE_MAX_LOOP).get(); ++i) {
            if (!iter.hasNext()) {
                return;
            }
            sink.accept(iter.next());
        }
    }

    public static <X> X getOrDefault(JsonObject object, String key, Function<JsonElement, X> puller, X fallback) {
        if (!object.has(key)) {
            return fallback;
        }
        if (object.get(key).isJsonNull()) {
            return fallback;
        }
        return puller.apply(object.get(key));
    }

    public static void setProcessingStateOnProperty(ServerLevel level, IntegerProperty prop, State state, BlockPos pos) {
        Integer maxPropVal = prop.m_6908_().stream().max(Integer::compare).orElse(0);
        int limited = Math.min(state.processingState(), maxPropVal);
        level.m_46597_(pos, (BlockState)level.m_8055_(pos).m_61124_((Property)prop, (Comparable)Integer.valueOf(limited)));
    }

    public static <K, V> void putIfAbsent(Map<K, V> qty, K k, V v) {
        if (qty.get(k) != null) {
            return;
        }
        qty.put(k, v);
    }

    @Nullable
    public static <X, Y> Y orNull(@Nullable X input, Function<@NotNull X, Y> fn) {
        if (input == null) {
            return null;
        }
        return fn.apply(input);
    }

    public static <X> void ifNotNull(X input, Consumer<X> fn) {
        if (input == null) {
            return;
        }
        fn.accept(input);
    }

    public static <X, Y> Y withFallbackForNullInput(X input, Function<X, Y> fn, Y fallback) {
        if (input == null) {
            return fallback;
        }
        return fn.apply(input);
    }

    public static Direction rotationToDirection(Integer value) {
        if (value == null) {
            return Direction.WEST;
        }
        int v = (value + 12) % 16;
        if (v == 15 || v < 2) {
            return Direction.SOUTH;
        }
        if (v < 7) {
            return Direction.WEST;
        }
        if (v < 10) {
            return Direction.NORTH;
        }
        return Direction.EAST;
    }

    public static <X> WorkOutput<X, WorkPosition<BlockPos>> workWithSurfaceInteractionPos(ServerLevel sl, WorkOutput<X, WorkPosition<BlockPos>> v) {
        BlockPos feet = v.spot().entityFeetPos();
        if (sl.m_8055_(feet).m_60767_().m_76333_()) {
            feet = feet.m_7494_();
        }
        return new WorkOutput<X, WorkPosition<BlockPos>>(v.worked(), v.claimed(), v.town(), new WorkPosition<BlockPos>(v.spot().jobBlock(), feet));
    }

    public static void blit(PoseStack stack, int screenX, int screenY, float firstPixelInFilex, float firstPixelInFileY, int drawNumPixelsX, int drawNumPixelsY, int widthOfEntireFile, int texFileHeight) {
        Util.blit(stack, screenX, screenY, firstPixelInFilex, firstPixelInFileY, drawNumPixelsX, drawNumPixelsY, widthOfEntireFile, texFileHeight, drawNumPixelsX, drawNumPixelsY);
    }

    public static void blit(PoseStack stack, int screenX, int screenY, float firstPixelInFilex, float firstPixelInFileY, int drawNumPixelsX, int drawNumPixelsY, int widthOfEntireFile, int texFileHeight, int drawWidth, int drawHeight) {
        GuiComponent.m_93160_((PoseStack)stack, (int)screenX, (int)screenY, (int)drawWidth, (int)drawHeight, (float)firstPixelInFilex, (float)firstPixelInFileY, (int)drawNumPixelsX, (int)drawNumPixelsY, (int)widthOfEntireFile, (int)texFileHeight);
    }

    public static void blitTab(PoseStack stack, Integer x, Integer y, int i) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)Questown.ResourceLocation("textures/menu/tabs.png"));
        Util.blit(stack, x + 12, y + 10, i * 16, 0.0f, 16, 16, 256, 256);
    }

    public static void onScreenText(Supplier<ServerPlayer> player, String msgKey, Object ... msgArgs) {
        QuestownNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(player), (Object)new OnScreenTextMessage(msgKey, msgArgs));
    }

    public static void blitFace(PoseStack stack, UUID uuid, int x, int y) {
        Util.blitFace(stack, uuid, x, y, 1);
    }

    public static void blitFace(PoseStack stack, UUID uuid, int x, int y, int scale) {
        float texStartX = 8.0f;
        float texStartY = 8.0f;
        int texFileWidth = 64;
        int texFileHeight = 64;
        ResourceLocation texture = VisitorMobRenderer.getTextureLocation(uuid);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        Util.blit(stack, x, y, texStartX, texStartY, 8, 8, texFileWidth, texFileHeight, 8 * scale, 8 * scale);
    }

    public static <X> X ifNull(@Nullable X input, X fallback) {
        return input == null ? fallback : input;
    }

    public static String toShortString(int containerSize, Function<Integer, ItemStack> getItem, boolean includeAir) {
        ImmutableList.Builder names = ImmutableList.builder();
        for (int i = 0; i < containerSize; ++i) {
            Item item = getItem.apply(i).m_41720_();
            if (Items.f_41852_.equals(item) && !includeAir) continue;
            if (ForgeRegistries.ITEMS.getKey((Object)item) == null) {
                names.add((Object)"<No ID>");
                continue;
            }
            names.add((Object)ForgeRegistries.ITEMS.getKey((Object)item).m_135815_());
        }
        return String.join((CharSequence)", ", (Iterable<? extends CharSequence>)names.build());
    }

    public static String getShortString(BlockPos target) {
        return String.format("[%d, %d ,%d]", target.m_123341_(), target.m_123342_(), target.m_123343_());
    }

    public static String getTinyString(BlockPos target) {
        return String.format("[%d, %d]", target.m_123341_(), target.m_123343_());
    }

    public static WorkLocation.BlockInfo info(final ServerLevel level) {
        return new WorkLocation.BlockInfo(){

            @Override
            public BlockState state(BlockPos bp) {
                return level.m_8055_(bp);
            }

            @Override
            @Nullable
            public BlockEntity entity(BlockPos bp) {
                return level.m_7702_(bp);
            }
        };
    }

    public static <X, Y> Y ifNullElse(@Nullable X texts, Supplier<Y> whenNull, Function<@NotNull X, Y> whenNotNull) {
        return texts == null ? whenNull.get() : whenNotNull.apply(texts);
    }
}

