/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.mobs.visitor;

import ca.bradj.questown.Questown;
import ca.bradj.questown.mobs.visitor.VisitorMobEntity;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;

public class SetWalkTargetFromBlockMemory
extends Behavior<VisitorMobEntity> {
    private final MemoryModuleType<GlobalPos> memoryType;
    private final float speedModifier;
    private final int closeEnoughDist;
    private final int tooFarDistance;
    private final int tooLongUnreachableDuration;

    public SetWalkTargetFromBlockMemory(MemoryModuleType<GlobalPos> p_24046_, float p_24047_, int p_24048_, int p_24049_, int p_24050_) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26326_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, p_24046_, (Object)MemoryStatus.VALUE_PRESENT));
        this.memoryType = p_24046_;
        this.speedModifier = p_24047_;
        this.closeEnoughDist = p_24048_;
        this.tooFarDistance = p_24049_;
        this.tooLongUnreachableDuration = p_24050_;
    }

    private void dropPOI(VisitorMobEntity p_24076_, long p_24077_) {
        Brain brain = p_24076_.m_6274_();
        p_24076_.releasePoi(this.memoryType);
        brain.m_21936_(this.memoryType);
        brain.m_21879_(MemoryModuleType.f_26326_, (Object)p_24077_);
    }

    protected void start(ServerLevel p_24059_, VisitorMobEntity ent, long p_24061_) {
        Brain brain = ent.m_6274_();
        brain.m_21952_(this.memoryType).ifPresent(p_24067_ -> {
            if (!this.wrongDimension(p_24059_, (GlobalPos)p_24067_) && !this.tiredOfTryingToFindTarget(p_24059_, ent)) {
                if (this.tooFar(ent, (GlobalPos)p_24067_)) {
                    int i;
                    Vec3 vec3 = null;
                    int j = 1000;
                    for (i = 0; i < 1000 && (vec3 == null || this.tooFar(ent, GlobalPos.m_122643_((ResourceKey)p_24059_.m_46472_(), (BlockPos)new BlockPos(vec3)))); ++i) {
                        vec3 = DefaultRandomPos.m_148412_((PathfinderMob)ent, (int)15, (int)7, (Vec3)Vec3.m_82539_((Vec3i)p_24067_.m_122646_()), (double)1.5707963705062866);
                    }
                    if (i == 1000) {
                        this.dropPOI(ent, p_24061_);
                        return;
                    }
                    brain.m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(vec3, this.speedModifier, this.closeEnoughDist));
                } else if (!this.closeEnough(p_24059_, ent, (GlobalPos)p_24067_)) {
                    brain.m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(p_24067_.m_122646_(), this.speedModifier, this.closeEnoughDist));
                }
            } else {
                if (ent.town == null) {
                    Questown.LOGGER.error("No town exists. Cannot start.");
                    return;
                }
                ent.setWalkTarget(ent.town.getRandomWanderTarget(ent.m_20183_()));
            }
        });
    }

    private boolean tiredOfTryingToFindTarget(ServerLevel p_24056_, VisitorMobEntity p_24057_) {
        Optional optional = p_24057_.m_6274_().m_21952_(MemoryModuleType.f_26326_);
        if (optional.isPresent()) {
            return p_24056_.m_46467_() - (Long)optional.get() > (long)this.tooLongUnreachableDuration;
        }
        return false;
    }

    private boolean tooFar(VisitorMobEntity p_24079_, GlobalPos p_24080_) {
        return p_24080_.m_122646_().m_123333_((Vec3i)p_24079_.m_20183_()) > this.tooFarDistance;
    }

    private boolean wrongDimension(ServerLevel p_24073_, GlobalPos p_24074_) {
        return p_24074_.m_122640_() != p_24073_.m_46472_();
    }

    private boolean closeEnough(ServerLevel p_24069_, VisitorMobEntity p_24070_, GlobalPos p_24071_) {
        return p_24071_.m_122640_() == p_24069_.m_46472_() && p_24071_.m_122646_().m_123333_((Vec3i)p_24070_.m_20183_()) <= this.closeEnoughDist;
    }
}

