/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.mobs.visitor;

import ca.bradj.questown.InventoryFullStrategy;
import ca.bradj.questown.QT;
import ca.bradj.questown.commands.DebugLogArgument;
import ca.bradj.questown.core.Config;
import ca.bradj.questown.core.UtilClean;
import ca.bradj.questown.core.VillagerUUID;
import ca.bradj.questown.core.advancements.VisitorTrigger;
import ca.bradj.questown.core.init.AdvancementsInit;
import ca.bradj.questown.core.init.EntitiesInit;
import ca.bradj.questown.gui.VillagerStats;
import ca.bradj.questown.gui.VillagerStatsMenu;
import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.jobs.IStatus;
import ca.bradj.questown.jobs.ImmutableSnapshot;
import ca.bradj.questown.jobs.Job;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.JobName;
import ca.bradj.questown.jobs.Jobs;
import ca.bradj.questown.jobs.ServerJobsRegistry;
import ca.bradj.questown.jobs.Signals;
import ca.bradj.questown.jobs.Snapshot;
import ca.bradj.questown.jobs.StatusListener;
import ca.bradj.questown.jobs.declarative.nomc.WorkSeekerJob;
import ca.bradj.questown.jobs.gatherer.GathererUnmappedNoToolWorkQtrDay;
import ca.bradj.questown.jobs.production.ProductionStatus;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.mc.Util;
import ca.bradj.questown.mobs.visitor.Admire;
import ca.bradj.questown.mobs.visitor.ClientSideThrowingJob;
import ca.bradj.questown.mobs.visitor.CoerceWalk;
import ca.bradj.questown.mobs.visitor.LookAtWalkTarget;
import ca.bradj.questown.mobs.visitor.MoveToTownTargetSink;
import ca.bradj.questown.mobs.visitor.OpenGateGoal;
import ca.bradj.questown.mobs.visitor.SetWalkTargetFromBlockMemory;
import ca.bradj.questown.mobs.visitor.ValidateBed;
import ca.bradj.questown.mobs.visitor.VillagerPathNavigation;
import ca.bradj.questown.mobs.visitor.VillagerSleptEvent;
import ca.bradj.questown.town.PoseInPlace;
import ca.bradj.questown.town.VillagerStatsData;
import ca.bradj.questown.town.entity.TownFlagBlockEntity;
import ca.bradj.questown.town.entity.TownVillagers;
import ca.bradj.questown.town.interfaces.TownInterface;
import ca.bradj.questown.town.quests.MCQuest;
import ca.bradj.questown.town.quests.MCReward;
import ca.bradj.questown.town.quests.Quest;
import ca.bradj.roomrecipes.serialization.MCRoom;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.SleepInBed;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.behavior.UpdateActivityFromSchedule;
import net.minecraft.world.entity.ai.behavior.WakeUp;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.entity.schedule.ScheduleBuilder;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisitorMobEntity
extends PathfinderMob
implements VillagerStats {
    public static final String DEFAULT_SCHEDULE_ID = "visitor_default_schedule";
    public static final Schedule DEFAULT_SCHEDULE = new ScheduleBuilder(new Schedule()).m_38040_(10, Activity.f_37979_).m_38040_(12500, Activity.f_37982_).m_38039_();
    public static final Map<MemoryModuleType<GlobalPos>, BiPredicate<VisitorMobEntity, Holder<PoiType>>> POI_MEMORIES = ImmutableMap.of((Object)MemoryModuleType.f_26359_, (p_35493_, p_35494_) -> p_35494_.m_203565_(PoiTypes.f_218060_));
    private static final EntityDataAccessor<Boolean> visible = SynchedEntityData.m_135353_(VisitorMobEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> hasBOP = SynchedEntityData.m_135353_(VisitorMobEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> status = SynchedEntityData.m_135353_(VisitorMobEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> jobName = SynchedEntityData.m_135353_(VisitorMobEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<ItemStack> heldItem = SynchedEntityData.m_135353_(VisitorMobEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<ItemStack> lastHeldItem = SynchedEntityData.m_135353_(VisitorMobEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final String NBT_TOWN_X = "town_x";
    private static final String NBT_TOWN_Y = "town_y";
    private static final String NBT_TOWN_Z = "town_z";
    private static final ImmutableList<SensorType<? extends Sensor<? super Villager>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26813_);
    private static final int inventoryCapacity = 6;
    private static final float slowWalkSpeed = 0.25f;
    private static final float walkSpeed = 0.3f;
    private static final float runSpeed = 0.4f;
    private final ArrayList<Integer> tickTimes = new ArrayList();
    private final ArrayList<Integer> targetTimes = new ArrayList();
    private boolean jobChangePending;
    boolean sitting = true;
    TownInterface town;
    Supplier<Job<MCHeldItem, ? extends ImmutableSnapshot<MCHeldItem, ?>, ? extends IStatus<?>>> job = this::getInitialJob;
    private int ticksWithoutJobTarget;
    private int ticksStuckWithTarget;
    private final List<Consumer<ImmutableList<Ingredient>>> ingrListeners = new ArrayList<Consumer<ImmutableList<Ingredient>>>();
    private final List<Consumer<VillagerSleptEvent>> sleepListeners = new ArrayList<Consumer<VillagerSleptEvent>>();
    private Signals.DayTime lastBedTime = new Signals.DayTime(22000L);
    @Nullable
    private Vec3 lastPos = null;
    @Nullable
    private WorkToUndo workToUndo;
    private BlockPos wanderTarget;
    private final List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();
    private boolean initialized;
    private final Collection<Function<Void, Void>> cleanupJobListeners = new ArrayList<Function<Void, Void>>();
    private int freezeTicks;

    public WorkToUndo getWorkToUndo() {
        return this.workToUndo;
    }

    public VisitorMobEntity(EntityType<? extends PathfinderMob> ownType, Level level, TownInterface town) {
        super(ownType, level);
        this.m_21553_(true);
        this.town = town;
        if (town != null) {
            this.initBrain();
            this.m_21317_((int)((long)town.getVillagerHandle().getDamageTicksLeft(this.f_19820_) / Compat.configGet(Config.DAMAGE_TICKS).get()));
        }
        this.changeListeners.add(() -> {
            Collection ing = (Collection)ServerJobsRegistry.getWantedResourcesProvider(this.getJobId()).apply((List<MCHeldItem>)Jobs.getHeldItems(this.job.get()));
            this.ingrListeners.forEach(l -> l.accept(ImmutableList.copyOf((Collection)ing)));
        });
    }

    public VisitorMobEntity(ServerLevel level, TownInterface town) {
        this((EntityType<? extends PathfinderMob>)((EntityType)EntitiesInit.VISITOR.get()), (Level)level, town);
    }

    public static AttributeSupplier setAttributes() {
        return PathfinderMob.m_21552_().m_22268_(Attributes.f_22277_, 100.0).m_22265_();
    }

    public static ImmutableList<Pair<Integer, ? extends Behavior<? super VisitorMobEntity>>> getCorePackage() {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new Swim(0.8f)), (Object)Pair.of((Object)0, (Object)((Object)new LookAtWalkTarget())), (Object)Pair.of((Object)0, (Object)new LookAtTargetSink(45, 90)), (Object)Pair.of((Object)0, (Object)new WakeUp()), (Object)Pair.of((Object)1, (Object)((Object)new MoveToTownTargetSink())), (Object)Pair.of((Object)4, (Object)((Object)new Admire(100))), (Object)Pair.of((Object)5, (Object)((Object)new CoerceWalk())), (Object)Pair.of((Object)9, (Object)((Object)new ValidateBed())));
    }

    public static ImmutableList<Pair<Integer, ? extends Behavior<? super VisitorMobEntity>>> getRestPackage() {
        SetWalkTargetFromBlockMemory walkTarget = new SetWalkTargetFromBlockMemory((MemoryModuleType<GlobalPos>)MemoryModuleType.f_26359_, 0.5f, 1, 150, 1200);
        return ImmutableList.of((Object)Pair.of((Object)1, (Object)((Object)walkTarget)), (Object)Pair.of((Object)4, (Object)new SleepInBed()), (Object)Pair.of((Object)99, (Object)new UpdateActivityFromSchedule()));
    }

    public static ImmutableList<Pair<Integer, ? extends Behavior<? super VisitorMobEntity>>> getIdlePackage(VisitorMobEntity entity) {
        ImmutableList.Builder b = ImmutableList.builder();
        b.add((Object)Pair.of((Object)3, (Object)((Object)new LookAtWalkTarget())));
        b.add((Object)Pair.of((Object)99, (Object)new UpdateActivityFromSchedule()));
        return b.build();
    }

    @NotNull
    private Job<MCHeldItem, ? extends ImmutableSnapshot<MCHeldItem, ?>, ? extends IStatus<?>> getInitialJob() {
        Job<MCHeldItem, ImmutableSnapshot<MCHeldItem, ?>, IStatus<?>> j = ServerJobsRegistry.getInitialJobForVillager(this.f_19820_);
        this.cleanupJobListeners.add(j.addStatusListener(this.getNotifiedOfJobStatusChanges()));
        return j;
    }

    public BlockPos getLookTarget() {
        return this.job.get().getLook();
    }

    public boolean tryGiveItem(MCHeldItem v, InventoryFullStrategy inventoryFullStrategy) {
        if (this.job.get().addToEmptySlot(v)) {
            return true;
        }
        if (inventoryFullStrategy.equals((Object)InventoryFullStrategy.REMOVE_FROM_WORLD)) {
            return false;
        }
        ItemEntity item = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), v.get().toMCItemStack());
        this.f_19853_.m_7967_((Entity)item);
        return false;
    }

    public void addSleepListener(Consumer<VillagerSleptEvent> l) {
        this.sleepListeners.add(l);
    }

    public void clearWorkToUndo() {
        this.workToUndo = null;
    }

    public boolean hasBlockOfProgress() {
        Boolean hasBOP = (Boolean)this.f_19804_.m_135370_(VisitorMobEntity.hasBOP);
        return hasBOP;
    }

    @Nullable
    public VillagerUUID getVUID() {
        return VillagerUUID.from(this.m_20148_());
    }

    public void setJob(Job<MCHeldItem, ? extends ImmutableSnapshot<MCHeldItem, ?>, ? extends IStatus<?>> initializedJob) {
        Level level = this.f_19853_;
        if (!(level instanceof ServerLevel)) {
            QT.VILLAGER_LOGGER.error("setJob should never be called from client side", new Object[0]);
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        Job<MCHeldItem, ImmutableSnapshot<MCHeldItem, ?>, IStatus<?>> curJob = this.job.get();
        String curJobName = "null";
        if (curJob != null) {
            curJobName = curJob.getId().toNiceString();
        }
        Job<MCHeldItem, ImmutableSnapshot<MCHeldItem, ?>, IStatus<?>> oldJob = this.job.get();
        this.job = () -> initializedJob;
        this.f_19804_.m_135381_(jobName, (Object)initializedJob.getJobName().translationKey());
        QT.VILLAGER_LOGGER.info("Job changed to {} for {} [from {}]", initializedJob.getId(), this.f_19820_, curJobName);
        Collection<Runnable> newCleanup = oldJob.notifyListenersOfNewJob(l -> {
            Function<Void, Void> out = initializedJob.addStatusListener((StatusListener)l);
            return () -> out.apply(null);
        });
        this.cleanupJobListeners.forEach(v -> v.apply(null));
        this.cleanupJobListeners.clear();
        List<Function> cleanupz = newCleanup.stream().map(UtilClean::voidVoid).toList();
        this.cleanupJobListeners.addAll(cleanupz);
        this.cleanupJobListeners.add(initializedJob.addStatusListener(this.getNotifiedOfJobStatusChanges()));
        this.cleanupJobListeners.add(initializedJob.addItemInsertionListener((bp, item) -> {
            this.workToUndo = WorkToUndo.and(this.workToUndo, initializedJob.getId(), bp, item);
        }));
        this.cleanupJobListeners.add(initializedJob.addJobCompletionListener(id -> {
            this.workToUndo = null;
        }));
        this.cleanupJobListeners.add(initializedJob.addJobCompletionListener(id -> this.town.getPossibleWork().invalidate()));
        this.cleanupJobListeners.add(initializedJob.addJobCompletionListener(id -> {
            Job<MCHeldItem, Snapshot<?>, IStatus<?>> job = ServerJobsRegistry.getInitializedJob(sl, id, this.getJobJournalSnapshot(), this.m_20148_());
            this.town.getVillagerHandle().addExperience(this.f_19820_, job.getExperienceEarned());
        }));
    }

    @NotNull
    private StatusListener getNotifiedOfJobStatusChanges() {
        return new StatusListener(){

            @Override
            public Runnable jobChanged(Function<StatusListener, Runnable> listenToNewJob) {
                return () -> {};
            }

            @Override
            public void statusChanged(IStatus<?> newStatus) {
                VisitorMobEntity.this.changeListeners.forEach(ChangeListener::Changed);
            }
        };
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(visible, (Object)true);
        this.f_19804_.m_135372_(hasBOP, (Object)true);
        this.f_19804_.m_135372_(status, (Object)ProductionStatus.IDLE.name());
        this.f_19804_.m_135372_(jobName, (Object)"jobs.gatherer");
        this.f_19804_.m_135372_(heldItem, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(lastHeldItem, (Object)ItemStack.f_41583_);
    }

    @NotNull
    private CompoundTag buildInitialSlotStatusesTag() {
        CompoundTag tag = new CompoundTag();
        ListTag statuses = new ListTag();
        for (int i = 0; i < 6; ++i) {
            statuses.add((Object)IntTag.m_128679_((int)0));
        }
        tag.m_128365_("slots", (Tag)statuses);
        return tag;
    }

    public boolean m_6785_(double p_21542_) {
        return false;
    }

    public void m_6075_() {
        super.m_6075_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_5803_()) {
            return;
        }
        Level level = this.f_19853_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        if (!this.initialized) {
            return;
        }
        if (!this.town.isInitialized()) {
            return;
        }
        this.f_19804_.m_135381_(hasBOP, (Object)this.town.getVillagerHandle().hasBlockOfProgress(this.m_20148_()));
        if (this.freezeTicks > 0) {
            --this.freezeTicks;
            return;
        }
        long start = System.currentTimeMillis();
        this.villagerTick(sl);
        long end = System.currentTimeMillis();
        this.tickTimes.add((int)(end - start));
        Integer rate = Compat.configGet(Config.TICK_SAMPLING_RATE).get();
        if (rate != 0 && this.tickTimes.size() > rate) {
            this.town.getDebugLogger(QT.VILLAGER_LOGGER, DebugLogArgument.SAMPLING).log("VME Average tick length: {}", this.tickTimes.stream().mapToInt(Integer::intValue).average());
            this.tickTimes.clear();
        }
    }

    private void villagerTick(ServerLevel sl) {
        boolean vis;
        Job<MCHeldItem, ImmutableSnapshot<MCHeldItem, ?>, IStatus<?>> j;
        this.detectNearbyDistractions(sl);
        this.town.getVillagerHandle().getLookTarget(this.getVUID()).ifPresentOrElse(arg_0 -> ((LookControl)this.f_21365_).m_148051_(arg_0), this::setLookFromBrain);
        if ((long)this.ticksWithoutJobTarget > Compat.configGet(Config.MAX_TICKS_WITHOUT_SUPPLIES).get()) {
            JobID seeker = WorkSeekerJob.getIDForRoot(this.job.get().getId());
            this.town.getVillagerHandle().changeJobForVillager(this.getVUID(), seeker, false);
        }
        if (this.m_5830_()) {
            Vec3 nudged = this.m_20182_().m_82520_(-1.0 + this.f_19796_.m_188500_() * 2.0, 0.0, -1.0 + this.f_19796_.m_188500_() * 2.0);
            this.town.getDebugLogger(QT.VILLAGER_LOGGER, DebugLogArgument.VILLAGER_NAVIGATION).log("Villager is stuck in wall. Nudging to {}", nudged);
            this.m_20219_(nudged);
        }
        if ((j = this.job.get()).getStatus() == null || j.getStatus().isUnset()) {
            @Nullable String s = this.getStatusForClient();
            j.initializeStatusFromEntityData(s);
        }
        j.tick(this.town, (LivingEntity)this, this.m_6350_());
        if (this.f_19853_.m_5776_()) {
            return;
        }
        this.town.getVillagerHandle().getRequestedPose(this.f_19820_).ifPresent(this::applyRequestedPose);
        this.trySetWalkTargetFromJob(j);
        if (this.town == null) {
            QT.VILLAGER_LOGGER.error("Visitor mob's parent could not be determined. Removing", new Object[0]);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        this.town.getVillagerHandle().validateEntity(this);
        boolean bl = vis = !j.shouldDisappear(this.town, this.m_20182_());
        if (!vis && this.job.get().getId().rootId().equals("gatherer")) {
            AdvancementsInit.VISITOR_TRIGGER.triggerForNearestPlayer(sl, VisitorTrigger.Triggers.FirstLeaveToGather, this.m_20183_());
        }
        this.f_19804_.m_135381_(visible, (Object)vis);
        if (j.isInitialized()) {
            this.f_19804_.m_135381_(status, (Object)j.getStatusToSyncToClient());
            this.f_19804_.m_135381_(heldItem, (Object)j.getInventory().m_8020_(0));
            if (!j.getGlobalSpecialRules().contains("only_render_first_item_in_hand")) {
                int size = j.getInventory().m_6643_();
                boolean holdingMultiple = false;
                for (int i = 1; i < size; ++i) {
                    ItemStack item = j.getInventory().m_8020_(size - i);
                    if (item.m_41619_()) continue;
                    this.f_19804_.m_135381_(lastHeldItem, (Object)item);
                    holdingMultiple = true;
                    break;
                }
                if (!holdingMultiple) {
                    this.f_19804_.m_135381_(lastHeldItem, (Object)ItemStack.f_41583_);
                }
            }
            this.f_19804_.m_135381_(heldItem, (Object)j.getInventory().m_8020_(0));
            if (!this.job.get().isInitialized()) {
                QT.VILLAGER_LOGGER.error("Wat", new Object[0]);
            }
            this.trackTarget();
        }
        this.useNearbyGates();
    }

    private void setLookFromBrain() {
        this.f_20939_.m_21952_(MemoryModuleType.f_26370_).ifPresent(e -> this.f_21365_.m_24964_(e.m_26420_().m_7024_()));
    }

    private void applyRequestedPose(PoseInPlace pose) {
        switch (pose.pose()) {
            case SLEEPING: {
                this.getInBed(pose.place());
                break;
            }
            default: {
                this.getOutOfBed();
            }
        }
    }

    private void trackTarget() {
        Job<MCHeldItem, ImmutableSnapshot<MCHeldItem, ?>, IStatus<?>> j = this.job.get();
        IStatus<?> status1 = j.getStatus();
        if (!j.isWorking()) {
            return;
        }
        if (status1 == null) {
            QT.VILLAGER_LOGGER.error("Null status", new Object[0]);
        } else if (!status1.isCollectingSupplies()) {
            return;
        }
        BlockPos target = j.getTarget(this.m_20183_(), this.m_20182_(), this.town);
        this.ticksWithoutJobTarget = target != null ? 0 : ++this.ticksWithoutJobTarget;
    }

    private void trySetWalkTargetFromJob(Job<?, ?, ? extends IStatus<?>> j) {
        if (j.shouldStandStill(this.town, this.m_20183_())) {
            this.m_6274_().m_21936_(MemoryModuleType.f_26370_);
            return;
        }
        Optional curTarget = this.m_6274_().m_21952_(MemoryModuleType.f_26370_);
        @Nullable BlockPos target = j.getTarget(this.m_20183_(), this.m_20182_(), this.town);
        if (target == null) {
            return;
        }
        Boolean isTargetDifferent = curTarget.map(t -> t.m_26420_().m_6675_().equals((Object)target)).orElse(true);
        if (isTargetDifferent.booleanValue()) {
            this.setWalkTarget(target);
        }
    }

    private void detectNearbyDistractions(ServerLevel sl) {
        List ps = this.f_19853_.m_45955_(TargetingConditions.m_148353_(), (LivingEntity)this, this.m_20191_().m_82377_(16.0, 64.0, 16.0));
        for (Player p : ps) {
            if (!this.isLookingAtMe(p)) continue;
            Long dur = Compat.configGet(Config.VILLAGER_DISTRACT_DURATION).get();
            Long cooldown = Compat.configGet(Config.VILLAGER_DISTRACT_COOLDOWN).get();
            long until = Util.getTick(sl) + dur;
            this.town.getVillagerHandle().setLookTarget(this.getVUID(), (Entity)p, until, until + cooldown);
            return;
        }
    }

    private boolean isLookingAtMe(Player p) {
        if (p.m_6047_()) {
            return false;
        }
        double v = p.m_20280_((Entity)this);
        if (v > 10.0) {
            return false;
        }
        Vec3 vec3 = p.m_20252_(1.0f).m_82541_();
        Vec3 vec31 = new Vec3(this.m_20185_() - p.m_20185_(), this.m_20188_() - p.m_20188_(), this.m_20189_() - p.m_20189_());
        double d0 = vec31.m_82553_();
        double d1 = vec3.m_82526_(vec31 = vec31.m_82541_());
        return d1 > 0.95 - 0.025 / d0 && p.m_142582_((Entity)this);
    }

    private void useNearbyGates() {
        if (this.m_6274_().m_21952_(MemoryModuleType.f_26370_).isPresent()) {
            BlockPos behind;
            BlockState bbs;
            Direction dir;
            BlockPos front;
            BlockState fbs;
            BlockPos on = this.m_20183_();
            BlockState bs = this.f_19853_.m_8055_(on);
            if (bs.m_60734_() instanceof FarmBlock) {
                on = on.m_7494_();
                bs = this.f_19853_.m_8055_(on);
            }
            if (bs.m_60734_() instanceof FenceGateBlock) {
                bs = (BlockState)bs.m_61124_((Property)FenceGateBlock.f_53341_, (Comparable)Boolean.valueOf(true));
                this.f_19853_.m_7731_(on, bs, 10);
            }
            if ((fbs = this.f_19853_.m_8055_(front = on.m_121945_(dir = this.m_6350_()))).m_60734_() instanceof FenceGateBlock) {
                fbs = (BlockState)fbs.m_61124_((Property)FenceGateBlock.f_53341_, (Comparable)Boolean.valueOf(true));
                this.f_19853_.m_7731_(front, fbs, 10);
            }
            if ((fbs = this.f_19853_.m_8055_(front = on.m_121945_(dir.m_122428_()))).m_60734_() instanceof FenceGateBlock) {
                fbs = (BlockState)fbs.m_61124_((Property)FenceGateBlock.f_53341_, (Comparable)Boolean.valueOf(true));
                this.f_19853_.m_7731_(front, fbs, 10);
            }
            if ((fbs = this.f_19853_.m_8055_(front = on.m_121945_(dir.m_122427_()))).m_60734_() instanceof FenceGateBlock) {
                fbs = (BlockState)fbs.m_61124_((Property)FenceGateBlock.f_53341_, (Comparable)Boolean.valueOf(true));
                this.f_19853_.m_7731_(front, fbs, 10);
            }
            if ((bbs = this.f_19853_.m_8055_(behind = on.m_121945_(this.m_6350_().m_122424_()))).m_60734_() instanceof FenceGateBlock) {
                bbs = (BlockState)bbs.m_61124_((Property)FenceGateBlock.f_53341_, (Comparable)Boolean.valueOf(false));
                this.f_19853_.m_7731_(behind, bbs, 10);
            }
        }
    }

    public void m_142687_(Entity.RemovalReason p_146834_) {
        super.m_142687_(p_146834_);
        if (p_146834_.equals((Object)Entity.RemovalReason.KILLED)) {
            for (int i = 0; i < this.getInventory().m_6643_(); ++i) {
                this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, this.getInventory().m_8020_(i)));
            }
            if (this.town != null) {
                this.town.getVillagerHandle().remove((LivingEntity)this);
            }
        }
    }

    public boolean m_20039_(BlockPos p_20040_, BlockState p_20041_) {
        if (this.getJob().shouldBeNoClip(this.town, this.m_20183_())) {
            return false;
        }
        return super.m_20039_(p_20040_, p_20041_);
    }

    public boolean m_5829_() {
        if (this.getJob().shouldBeNoClip(this.town, this.m_20183_())) {
            return false;
        }
        return super.m_5829_();
    }

    public boolean m_7337_(Entity p_20303_) {
        if (this.getJob().shouldBeNoClip(this.town, this.m_20183_())) {
            return false;
        }
        return super.m_7337_(p_20303_);
    }

    public void m_5997_(double p_20286_, double p_20287_, double p_20288_) {
        if (this.getJob().shouldBeNoClip(this.town, this.m_20183_())) {
            return;
        }
        super.m_5997_(p_20286_, p_20287_, p_20288_);
    }

    private Job<MCHeldItem, ? extends ImmutableSnapshot<MCHeldItem, ?>, ? extends IStatus<?>> getJob() {
        if (this.f_19853_.m_5776_()) {
            return ClientSideThrowingJob.INSTANCE;
        }
        return this.job.get();
    }

    protected void m_6138_() {
        if (this.getJob().shouldBeNoClip(this.town, this.m_20183_())) {
            return;
        }
        List<Entity> list = this.f_19853_.m_6249_((Entity)this, this.m_20191_(), EntitySelector.m_20421_((Entity)this));
        if (!(list = list.stream().filter(v -> !this.getClass().isInstance(v) && !(v instanceof Player)).toList()).isEmpty()) {
            int i = this.f_19853_.m_46469_().m_46215_(GameRules.f_46149_);
            if (i > 0 && list.size() > i - 1 && this.f_19796_.m_188503_(4) == 0) {
                int j = 0;
                for (Entity entity : list) {
                    if (entity.m_20159_()) continue;
                    ++j;
                }
                if (j > i - 1) {
                    this.m_6469_(DamageSource.f_19311_, 6.0f);
                }
            }
            for (Entity entity : list) {
                this.m_7324_(entity);
            }
        }
    }

    public void m_7380_(CompoundTag p_21484_) {
        super.m_7380_(p_21484_);
        ListTag items = new ListTag();
        Jobs.getItems(this.job.get()).forEach(v -> items.add((Object)v.serializeNBT()));
        p_21484_.m_128365_("items", (Tag)items);
    }

    public void m_7378_(CompoundTag p_21450_) {
        super.m_7378_(p_21450_);
        ListTag items = p_21450_.m_128437_("items", 10);
        List<MCHeldItem> itemz = items.stream().map(v -> ItemStack.m_41712_((CompoundTag)((CompoundTag)v))).map(MCHeldItem::fromMCItemStack).toList();
        this.job.get().initializeItems(itemz);
        this.f_19804_.m_135381_(status, (Object)p_21450_.m_128461_("status"));
    }

    private void initBrain() {
        this.m_6274_().m_21886_(MemoryModuleType.f_26328_, Optional.empty());
        this.m_6274_().m_21886_(MemoryModuleType.f_26329_, Optional.empty());
        this.m_6274_().m_21886_(MemoryModuleType.f_26370_, Optional.empty());
        this.m_6274_().m_21886_(MemoryModuleType.f_26326_, Optional.empty());
        this.m_6274_().m_21886_(MemoryModuleType.f_26377_, Optional.empty());
    }

    public ItemStack m_21205_() {
        return (ItemStack)this.m_20088_().m_135370_(heldItem);
    }

    public ItemStack m_21206_() {
        return (ItemStack)this.m_20088_().m_135370_(lastHeldItem);
    }

    public boolean m_6000_(double p_20296_, double p_20297_, double p_20298_) {
        Boolean isVisible = (Boolean)this.f_19804_.m_135370_(visible);
        if (!isVisible.booleanValue()) {
            return false;
        }
        return super.m_6000_(p_20296_, p_20297_, p_20298_);
    }

    public boolean m_20223_(CompoundTag p_20224_) {
        if (this.town == null) {
            QT.VILLAGER_LOGGER.error("Town is null. This is a bug.", new Object[0]);
            return super.m_20223_(p_20224_);
        }
        BlockPos bp = this.town.getTownFlagBasePos();
        p_20224_.m_128405_(NBT_TOWN_X, bp.m_123341_());
        p_20224_.m_128405_(NBT_TOWN_Y, bp.m_123342_());
        p_20224_.m_128405_(NBT_TOWN_Z, bp.m_123343_());
        return super.m_20223_(p_20224_);
    }

    public void m_20258_(CompoundTag tag) {
        super.m_20258_(tag);
        if (tag.m_128441_(NBT_TOWN_X) && tag.m_128441_(NBT_TOWN_Y) && tag.m_128441_(NBT_TOWN_Z)) {
            BlockPos bp = new BlockPos(tag.m_128451_(NBT_TOWN_X), tag.m_128451_(NBT_TOWN_Y), tag.m_128451_(NBT_TOWN_Z));
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                BlockEntity entity = sl.m_7702_(bp);
                if (!(entity instanceof TownFlagBlockEntity)) {
                    QT.VILLAGER_LOGGER.error("Entity at {} was not a TownFlag", bp);
                    return;
                }
                TownFlagBlockEntity flag = (TownFlagBlockEntity)entity;
                this.town = flag;
                TownVillagers.assumeStateFromTown(flag, this);
                this.initBrain();
            }
        }
    }

    protected PathNavigation m_6037_(Level p_21480_) {
        return new VillagerPathNavigation(this, p_21480_);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(2, (Goal)new OpenGateGoal((Mob)this, true));
    }

    protected Brain.Provider<?> m_5490_() {
        return Brain.m_21923_((Collection)ImmutableList.of((Object)MemoryModuleType.f_26359_, (Object)MemoryModuleType.f_26328_, (Object)MemoryModuleType.f_26329_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_26380_, (Object)MemoryModuleType.f_26374_, (Object)MemoryModuleType.f_26338_), SENSOR_TYPES);
    }

    protected Brain<?> m_8075_(Dynamic<?> p_21069_) {
        Brain brain = super.m_8075_(p_21069_);
        brain.m_21912_(DEFAULT_SCHEDULE);
        brain.m_21900_(Activity.f_37979_, VisitorMobEntity.getIdlePackage(this));
        brain.m_21900_(Activity.f_37982_, VisitorMobEntity.getRestPackage());
        brain.m_21900_(Activity.f_37978_, VisitorMobEntity.getCorePackage());
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21862_(this.f_19853_.m_46468_(), this.f_19853_.m_46467_());
        return brain;
    }

    public void m_6667_(DamageSource p_21014_) {
        this.releasePoi((MemoryModuleType<GlobalPos>)MemoryModuleType.f_26359_);
        super.m_6667_(p_21014_);
    }

    public void m_5802_(BlockPos p_21141_) {
        this.getInBed(p_21141_);
        this.m_21250_(p_21141_);
        this.f_20939_.m_21879_(MemoryModuleType.f_26328_, (Object)this.f_19853_.m_46467_());
        this.f_20939_.m_21936_(MemoryModuleType.f_26370_);
        this.f_20939_.m_21936_(MemoryModuleType.f_26326_);
        this.lastBedTime = Util.getDayTime(this.f_19853_);
    }

    private void getInBed(BlockPos p_21141_) {
        BlockState blockstate;
        this.f_20939_.m_21936_(MemoryModuleType.f_26370_);
        this.f_20939_.m_21936_(MemoryModuleType.f_26377_);
        if (this.m_20159_()) {
            this.m_8127_();
        }
        if ((blockstate = this.f_19853_.m_8055_(p_21141_)).isBed((BlockGetter)this.f_19853_, p_21141_, (LivingEntity)this)) {
            blockstate.setBedOccupied(this.f_19853_, p_21141_, (LivingEntity)this, true);
        }
        this.m_20124_(Pose.SLEEPING);
        this.setPosToBed(p_21141_);
        this.m_20256_(Vec3.f_82478_);
        this.f_19812_ = true;
    }

    private void setPosToBed(BlockPos p_21081_) {
        this.m_6034_((double)p_21081_.m_123341_() + 0.5, (double)p_21081_.m_123342_() + 0.6875, (double)p_21081_.m_123343_() + 0.5);
    }

    public void m_5796_() {
        Optional<BlockPos> sleepingPos = this.getOutOfBed();
        long curTime = this.f_19853_.m_46467_();
        this.f_20939_.m_21879_(MemoryModuleType.f_26329_, (Object)curTime);
        sleepingPos.ifPresent(bed -> {
            long nightSleepTicks = this.lastBedTime.ticksBeforeMidnight();
            long ticksSlept = Util.getDayTime(this.f_19853_).dayTime() + nightSleepTicks;
            this.sleepListeners.forEach(l -> l.accept(new VillagerSleptEvent(ticksSlept, (BlockPos)bed)));
        });
        this.m_21153_(this.m_21233_());
    }

    @NotNull
    private Optional<BlockPos> getOutOfBed() {
        Optional sleepingPos = this.m_21257_();
        sleepingPos.filter(arg_0 -> ((Level)this.f_19853_).m_46805_(arg_0)).ifPresent(p_147228_ -> {
            BlockState blockstate = this.f_19853_.m_8055_(p_147228_);
            if (blockstate.isBed((BlockGetter)this.f_19853_, p_147228_, (LivingEntity)this)) {
                blockstate.setBedOccupied(this.f_19853_, p_147228_, (LivingEntity)this, false);
                Vec3 vec31 = BedBlock.m_49458_((EntityType)this.m_6095_(), (CollisionGetter)this.f_19853_, (BlockPos)p_147228_, (float)this.m_146908_()).orElseGet(() -> {
                    BlockPos blockpos = p_147228_.m_7494_();
                    return new Vec3((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.1, (double)blockpos.m_123343_() + 0.5);
                });
                Vec3 vec32 = Vec3.m_82539_((Vec3i)p_147228_).m_82546_(vec31).m_82541_();
                float f = (float)Mth.m_14175_((double)(Mth.m_14136_((double)vec32.f_82481_, (double)vec32.f_82479_) * 57.2957763671875 - 90.0));
                this.m_6034_(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_);
                this.m_146922_(f);
                this.m_146926_(0.0f);
            }
        });
        Vec3 vec3 = this.m_20182_();
        this.m_20124_(Pose.STANDING);
        this.m_6034_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        this.m_21258_();
        return sleepingPos;
    }

    public void m_8107_() {
        this.m_21203_();
        super.m_8107_();
    }

    protected void m_8024_() {
        this.f_19853_.m_46473_().m_6180_(String.format("%s_%s", "questown", "visitorBrain"));
        Brain brain1 = this.m_6274_();
        brain1.m_21865_((ServerLevel)this.f_19853_, (LivingEntity)this);
        this.f_19853_.m_46473_().m_7238_();
        super.m_8024_();
        this.adjustSpeed((Brain<VisitorMobEntity>)brain1);
    }

    private void adjustSpeed(Brain<VisitorMobEntity> brain1) {
        if (!brain1.m_21874_(MemoryModuleType.f_26377_)) {
            return;
        }
        Optional path = brain1.m_21952_(MemoryModuleType.f_26377_);
        if (path.isEmpty()) {
            return;
        }
        Path vPath = (Path)path.get();
        int nodeCount = vPath.m_77398_();
        if (nodeCount < 10) {
            return;
        }
        if (this.job.get().getGlobalSpecialRules().contains("slow_walk")) {
            this.m_21573_().m_26517_(0.25);
            return;
        }
        if ((float)vPath.m_77399_() > (float)nodeCount * 0.75f) {
            this.m_21573_().m_26517_((double)0.3f);
            return;
        }
        this.m_21573_().m_26517_((double)0.4f);
    }

    public boolean isSitting() {
        return this.sitting;
    }

    public BlockPos getWanderTarget() {
        if (this.town == null) {
            this.m_6074_();
            return new BlockPos(0, 0, 0);
        }
        return this.wanderTarget;
    }

    public void setWalkTarget(BlockPos blockPos) {
        this.wanderTarget = blockPos;
        if (blockPos == null) {
            this.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        } else {
            this.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(blockPos, 0.3f, 0));
        }
    }

    public BlockPos newWanderTarget() {
        if (this.town == null) {
            this.m_6074_();
            return null;
        }
        long start = System.currentTimeMillis();
        BlockPos target = this.job.get().getTarget(this.m_20183_(), this.m_20182_(), this.town);
        long end = System.currentTimeMillis();
        this.targetTimes.add((int)(end - start));
        Integer rate = Compat.configGet(Config.TICK_SAMPLING_RATE).get();
        if (rate != 0 && this.targetTimes.size() > rate) {
            this.town.getDebugLogger(QT.PROFILE_LOGGER, DebugLogArgument.SAMPLING).log("VME Average target acquisition length: {}", this.targetTimes.stream().mapToInt(Integer::intValue).average());
            this.targetTimes.clear();
        }
        if (target != null) {
            this.setWalkTarget(target);
        } else {
            this.setWalkTarget(this.town.getRandomWanderTarget(this.m_20183_()));
        }
        return this.getWanderTarget();
    }

    public void releasePoi(MemoryModuleType<GlobalPos> p_35429_) {
        if (this.f_19853_ instanceof ServerLevel) {
            MinecraftServer minecraftserver = ((ServerLevel)this.f_19853_).m_7654_();
            this.f_20939_.m_21952_(p_35429_).ifPresent(p_186306_ -> {
                ServerLevel serverlevel = minecraftserver.m_129880_(p_186306_.m_122640_());
                if (serverlevel != null) {
                    PoiManager poimanager = serverlevel.m_8904_();
                    Optional optional = poimanager.m_27177_(p_186306_.m_122646_());
                    BiPredicate<VisitorMobEntity, Holder<PoiType>> bipredicate = POI_MEMORIES.get(p_35429_);
                    if (optional.isPresent() && bipredicate.test(this, (Holder<PoiType>)((Holder)optional.get()))) {
                        poimanager.m_27154_(p_186306_.m_122646_());
                        DebugPackets.m_133719_((ServerLevel)serverlevel, (BlockPos)p_186306_.m_122646_());
                    }
                }
            });
        }
    }

    protected void m_6135_() {
        BlockState onBlock = this.f_19853_.m_8055_(this.m_20183_());
        if (!this.job.get().isJumpingAllowed(onBlock)) {
            return;
        }
        super.m_6135_();
    }

    public InteractionResult m_7111_(Player player, Vec3 p_19981_, InteractionHand hand) {
        boolean isClientSide = player.f_19853_.m_5776_();
        if (!(player instanceof ServerPlayer)) {
            return InteractionResult.m_19078_((boolean)isClientSide);
        }
        ServerPlayer sp = (ServerPlayer)player;
        if (!((Boolean)this.f_19804_.m_135370_(visible)).booleanValue()) {
            return InteractionResult.PASS;
        }
        AdvancementsInit.VISITOR_TRIGGER.trigger(sp, VisitorTrigger.Triggers.FirstVisitor);
        Jobs.openInventoryAndStatusScreen(sp, this);
        return InteractionResult.m_19078_((boolean)isClientSide);
    }

    public Container getInventory() {
        return this.job.get().getInventory();
    }

    @Nullable
    public String getStatusForClient() {
        String s = (String)this.f_19804_.m_135370_(status);
        if (s.isEmpty()) {
            return null;
        }
        return s;
    }

    public IStatus<?> getStatusForServer() {
        return this.job.get().getStatus();
    }

    public void addStatusListener(StatusListener l) {
        this.cleanupJobListeners.add(this.job.get().addStatusListener(l));
    }

    public ImmutableSnapshot<MCHeldItem, ?> getJobJournalSnapshot() {
        return this.job.get().getJournalSnapshot();
    }

    public void initialize(TownInterface town, UUID uuid, double xPos, double yPos, double zPos, Snapshot journal) {
        this.town = town;
        this.setJob(ServerJobsRegistry.getInitializedJob(town.getServerLevel(), journal.jobId(), journal, uuid));
        this.cleanupJobListeners.add(this.getJob().addStatusListener(this.getNotifiedOfJobStatusChanges()));
        this.m_6034_(xPos, yPos, zPos);
        this.m_20084_(uuid);
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public List<Boolean> getSlotLocks() {
        return this.getJob().getSlotLockStatuses();
    }

    public DataSlot getLockSlot(int i) {
        return this.job.get().getLockSlot(i);
    }

    public JobName getJobName() {
        return this.job.get().getJobName();
    }

    public Collection<? extends Quest<ResourceLocation, MCRoom>> getQuests() {
        return this.town.getQuestHandle().getQuestsForVillager(this.f_19820_);
    }

    public List<AbstractMap.SimpleEntry<MCQuest, MCReward>> getQuestsWithRewards() {
        return this.town.getQuestHandle().getQuestsWithRewardsForVillager(this.f_19820_);
    }

    public boolean canAcceptJob() {
        return GathererUnmappedNoToolWorkQtrDay.ID.rootId().equals(this.job.get().getId().rootId());
    }

    public void addChangeListener(ChangeListener cl) {
        this.changeListeners.add(cl);
    }

    public boolean m_6469_(DamageSource p_21016_, float p_21017_) {
        if (this.getJob().shouldBeNoClip(this.town, this.m_20183_())) {
            return false;
        }
        return super.m_6469_(p_21016_, p_21017_);
    }

    protected void m_7581_(ItemEntity p_21471_) {
    }

    public String toString() {
        return String.format("%s [%s]", super.toString(), this.m_20148_());
    }

    public JobID getJobId() {
        return this.job.get().getId();
    }

    public BlockPos getFlagPos() {
        return this.town.getTownFlagBasePos();
    }

    public TownInterface getTown() {
        return this.town;
    }

    public void freeze(int ticks) {
        this.freezeTicks = ticks;
    }

    public boolean isTickFrozen() {
        return this.freezeTicks > 0;
    }

    public void removeStatusListener(StatusListener inventoryAndStatusMenu) {
        this.job.get().removeStatusListener(inventoryAndStatusMenu);
    }

    public void addWantedIngredientsListener(Consumer<ImmutableList<Ingredient>> l) {
        this.ingrListeners.add(l);
    }

    public void removeWantedIngredientsListener(Consumer<ImmutableList<Ingredient>> l) {
        this.ingrListeners.remove(l);
    }

    public void addStatsListener(VillagerStatsMenu villagerStatsMenu) {
        if (this.town == null || this.town.getServerLevel() == null) {
            return;
        }
        this.town.getVillagerHandle().addStatsListener(villagerStatsMenu);
    }

    public void removeStatsListener(Consumer<VillagerStatsData> villagerStatsMenu) {
        if (this.town == null || this.town.getServerLevel() == null) {
            return;
        }
        this.town.getVillagerHandle().removeStatsListener(villagerStatsMenu);
    }

    public boolean shouldStandStill() {
        return this.job.get().shouldStandStill(this.town, this.m_20183_());
    }

    public boolean canStopWorkingAtAnyTime() {
        return this.job.get().canStopWorkingAtAnyTime();
    }

    public record WorkToUndo(JobID jobID, BlockPos pos, ImmutableList<MCHeldItem> itemsInserted) {
        public static WorkToUndo and(@Nullable WorkToUndo workToUndo, JobID id, BlockPos bp, MCHeldItem item) {
            if (workToUndo == null) {
                return new WorkToUndo(id, bp, (ImmutableList<MCHeldItem>)ImmutableList.of((Object)item));
            }
            return new WorkToUndo(id, bp, (ImmutableList<MCHeldItem>)ImmutableList.builder().addAll(workToUndo.itemsInserted()).add((Object)item).build());
        }
    }

    public static interface ChangeListener {
        public void Changed();
    }
}

