/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.render;

import ca.bradj.questown._vanilla.entities.FishingHook;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FishingHookRenderer
extends EntityRenderer<FishingHook> {
    private static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("textures/entity/fishing_hook.png");
    private static final RenderType RENDER_TYPE = RenderType.m_110452_((ResourceLocation)TEXTURE_LOCATION);
    private static final double VIEW_BOBBING_SCALE = 960.0;

    public FishingHookRenderer(EntityRendererProvider.Context p_174117_) {
        super(p_174117_);
    }

    public void render(FishingHook fishingHook, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        LivingEntity player = fishingHook.getPlayerOwner();
        Vec3 attachPoint = fishingHook.getMountPos();
        if (player != null && attachPoint != null) {
            poseStack.m_85836_();
            poseStack.m_85836_();
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            poseStack.m_85845_(this.f_114476_.m_114470_());
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
            PoseStack.Pose lastPose = poseStack.m_85850_();
            Matrix4f poseMatrix = lastPose.m_85861_();
            Matrix3f normalMatrix = lastPose.m_85864_();
            VertexConsumer quadConsumer = bufferSource.m_6299_(RENDER_TYPE);
            FishingHookRenderer.vertex(quadConsumer, poseMatrix, normalMatrix, packedLight, 0.0f, 0, 0, 1);
            FishingHookRenderer.vertex(quadConsumer, poseMatrix, normalMatrix, packedLight, 1.0f, 0, 1, 1);
            FishingHookRenderer.vertex(quadConsumer, poseMatrix, normalMatrix, packedLight, 1.0f, 1, 1, 0);
            FishingHookRenderer.vertex(quadConsumer, poseMatrix, normalMatrix, packedLight, 0.0f, 1, 0, 0);
            poseStack.m_85849_();
            double attachX = attachPoint.f_82479_;
            double attachY = attachPoint.f_82480_;
            double attachZ = attachPoint.f_82481_;
            double hookX = Mth.m_14139_((double)partialTicks, (double)fishingHook.f_19854_, (double)fishingHook.m_20185_());
            double hookY = Mth.m_14139_((double)partialTicks, (double)fishingHook.f_19855_, (double)fishingHook.m_20186_()) + 0.25;
            double hookZ = Mth.m_14139_((double)partialTicks, (double)fishingHook.f_19856_, (double)fishingHook.m_20189_());
            float deltaX = (float)(attachX - hookX);
            float deltaY = (float)(attachY - hookY);
            float deltaZ = (float)(attachZ - hookZ);
            VertexConsumer lineConsumer = bufferSource.m_6299_(RenderType.m_173247_());
            PoseStack.Pose linePose = poseStack.m_85850_();
            int segments = 16;
            for (int seg = 0; seg <= segments; ++seg) {
                FishingHookRenderer.stringVertex(deltaX, deltaY, deltaZ, lineConsumer, linePose, FishingHookRenderer.fraction(seg, segments), FishingHookRenderer.fraction(seg + 1, segments));
            }
            poseStack.m_85849_();
            super.m_7392_((Entity)fishingHook, entityYaw, partialTicks, poseStack, bufferSource, packedLight);
        }
    }

    private static float fraction(int numerator, int denominator) {
        return (float)numerator / (float)denominator;
    }

    private static void vertex(VertexConsumer consumer, Matrix4f poseMatrix, Matrix3f normalMatrix, int packedLight, float u, int v, int texU, int texV) {
        consumer.m_85982_(poseMatrix, u - 0.5f, (float)v - 0.5f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_((float)texU, (float)texV).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_85977_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void stringVertex(float deltaX, float deltaY, float deltaZ, VertexConsumer consumer, PoseStack.Pose pose, float t0, float t1) {
        float x0 = deltaX * t0;
        float y0 = deltaY * (t0 * t0 + t0) * 0.5f + 0.25f;
        float z0 = deltaZ * t0;
        float x1 = deltaX * t1 - x0;
        float y1 = deltaY * (t1 * t1 + t1) * 0.5f + 0.25f - y0;
        float z1 = deltaZ * t1 - z0;
        float length = Mth.m_14116_((float)(x1 * x1 + y1 * y1 + z1 * z1));
        consumer.m_85982_(pose.m_85861_(), x0, y0, z0).m_6122_(0, 0, 0, 255).m_85977_(pose.m_85864_(), x1 /= length, y1 /= length, z1 /= length).m_5752_();
    }

    public ResourceLocation getTextureLocation(FishingHook fishingHook) {
        return TEXTURE_LOCATION;
    }
}

