/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town;

import ca.bradj.questown.QT;
import ca.bradj.questown.core.Config;
import ca.bradj.questown.core.Pair;
import ca.bradj.questown.gui.ItemEconomicsData;
import ca.bradj.questown.jobs.Signals;
import ca.bradj.questown.town.quests.Completable;
import ca.bradj.questown.town.quests.Reward;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Stack;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTownFlagTicker<TICK_DATA, VILLAGERS> {
    private int ticksWithoutQuests;
    private boolean stopped;
    protected boolean everScanned = false;
    boolean debugMode;
    @Nullable
    private Supplier<Boolean> debugTask;
    private boolean isMorning;
    private final Stack<Long> mornings = new Stack();
    private final ArrayList<Integer> times = new ArrayList();

    protected void tick(TICK_DATA data) {
        if (this.runAnyInitializers(data)) {
            return;
        }
        ImmutableList<VILLAGERS> villagers = this.getVillagers(data);
        this.ensureCompletableQuestsExist(data, (Collection<VILLAGERS>)villagers);
        boolean alreadyStopped = this.stopped;
        this.stopped = this.allPlayersLeftArea(data, !alreadyStopped);
        if (this.stopped) {
            if (alreadyStopped) {
                return;
            }
            this.storeSleepingState(data);
        }
        long start = System.currentTimeMillis();
        if (!this.stopped) {
            this.notifySubBlocksOfTick(data);
        }
        if (this.runDebugTask()) {
            return;
        }
        Signals.DayTime dayTime = this.getDayTime(data);
        Signals signals = Signals.fromDayTime(dayTime);
        this.handleIfNewMorning(data, signals);
        boolean stateChanged = this.updateStoredData(data);
        if (stateChanged) {
            this.handleNewStoredData(data);
        }
        this.tickWorkHandle(data);
        this.tickQuests(data);
        this.tickBiomesHandle(data);
        this.tickHealingHandle(data);
        this.tickPossibleWorkHandle(data);
        this.tickRoomsHandle(data);
        if (!this.isFlagTick(data)) {
            return;
        }
        this.updateWorkStatuses(data);
        this.tickASAPRewards(data);
        this.tickPOIs(data);
        if (!(signals != Signals.NIGHT && signals != Signals.EVENING || villagers.isEmpty())) {
            this.triggerFirstNightAdvancement(data);
        }
        this.tickVillagers(data, signals);
        if (this.applyNewEconomicsData(data) && this.getTownLevelItemEconomics(data).stream().anyMatch(v -> v.timesNeeded() > 4)) {
            this.triggerUnmetNeedsAdvancement(data);
        }
        this.everScanned = true;
        this.profileTick(start);
    }

    protected abstract void triggerUnmetNeedsAdvancement(TICK_DATA var1);

    protected abstract ImmutableList<ItemEconomicsData> getTownLevelItemEconomics(TICK_DATA var1);

    protected abstract boolean applyNewEconomicsData(TICK_DATA var1);

    protected abstract void tickVillagers(TICK_DATA var1, Signals var2);

    protected abstract void triggerFirstNightAdvancement(TICK_DATA var1);

    protected abstract void tickPOIs(TICK_DATA var1);

    protected abstract void tickASAPRewards(TICK_DATA var1);

    protected abstract void updateWorkStatuses(TICK_DATA var1);

    protected abstract boolean isFlagTick(TICK_DATA var1);

    protected abstract void tickRoomsHandle(TICK_DATA var1);

    protected abstract void tickPossibleWorkHandle(TICK_DATA var1);

    protected abstract void tickHealingHandle(TICK_DATA var1);

    protected abstract void tickBiomesHandle(TICK_DATA var1);

    protected abstract void tickQuests(TICK_DATA var1);

    protected abstract void tickWorkHandle(TICK_DATA var1);

    protected abstract void handleNewStoredData(TICK_DATA var1);

    protected abstract boolean updateStoredData(TICK_DATA var1);

    private void handleIfNewMorning(TICK_DATA data, Signals signals) {
        this.detectMorning(data, signals);
        if (!this.mornings.empty()) {
            this.onMorning(data, this.mornings.pop());
        }
    }

    protected abstract void onMorning(TICK_DATA var1, Long var2);

    private void detectMorning(TICK_DATA data, Signals signals) {
        if (signals == Signals.MORNING) {
            if (!this.isMorning) {
                this.isMorning = true;
                this.onMorningDetected(this.getTick(data));
            }
        } else if (this.isMorning) {
            this.isMorning = false;
        }
    }

    protected abstract long getTick(TICK_DATA var1);

    protected abstract Signals.DayTime getDayTime(TICK_DATA var1);

    private boolean runDebugTask() {
        if (!this.debugMode) {
            return false;
        }
        if (this.debugTask == null) {
            return true;
        }
        boolean done = this.debugTask.get();
        if (done) {
            this.debugTask = null;
        }
        return true;
    }

    protected abstract void notifySubBlocksOfTick(TICK_DATA var1);

    protected abstract void storeSleepingState(TICK_DATA var1);

    protected abstract boolean allPlayersLeftArea(TICK_DATA var1, boolean var2);

    private void ensureCompletableQuestsExist(TICK_DATA data, Collection<VILLAGERS> villagers) {
        block4: {
            Iterator<VILLAGERS> iterator = villagers.iterator();
            if (!iterator.hasNext()) break block4;
            VILLAGERS villager = iterator.next();
            if (!this.isMissingCompletableQuests(data)) {
                this.ticksWithoutQuests = 0;
            } else {
                boolean allowingForBuffer;
                boolean bl = allowingForBuffer = this.ticksWithoutQuests < 500;
                if (allowingForBuffer) {
                    ++this.ticksWithoutQuests;
                } else {
                    this.addQuests(data, villager);
                    this.ticksWithoutQuests = 0;
                }
            }
        }
    }

    private void onMorningDetected(long newTime) {
        this.mornings.push(newTime);
    }

    protected abstract void addQuests(TICK_DATA var1, VILLAGERS var2);

    private boolean isMissingCompletableQuests(TICK_DATA e) {
        ImmutableList<Pair<Completable, Reward>> all = this.getAllQuestsWithRewards(e);
        if (all.stream().anyMatch(v -> !((Completable)v.a()).isComplete())) {
            return false;
        }
        ImmutableList<Reward> rewards = this.getMorningRewards(e);
        return !rewards.stream().anyMatch(Reward::addsQuestsWhenApplied);
    }

    protected abstract ImmutableList<Pair<Completable, Reward>> getAllQuestsWithRewards(TICK_DATA var1);

    protected abstract ImmutableList<Reward> getMorningRewards(TICK_DATA var1);

    protected abstract ImmutableList<VILLAGERS> getVillagers(TICK_DATA var1);

    protected abstract boolean runAnyInitializers(TICK_DATA var1);

    public boolean startDebugTask(Supplier<Boolean> debugTask) {
        if (!this.debugMode) {
            return false;
        }
        this.debugTask = debugTask;
        return true;
    }

    private void profileTick(long start) {
        if ((Integer)Config.TICK_SAMPLING_RATE.get() > 0) {
            long end = System.currentTimeMillis();
            this.times.add((int)(end - start));
            if (this.times.size() > (Integer)Config.TICK_SAMPLING_RATE.get()) {
                double tl = this.times.stream().mapToInt(Integer::intValue).average().orElse(0.0);
                QT.PROFILE_LOGGER.debug("Average tick length: {}", tl);
                this.times.clear();
            }
        }
    }

    public void toggleDebugMode() {
        this.debugMode = !this.debugMode;
    }

    public boolean isDebugEnabled() {
        return this.debugMode;
    }
}

