/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town;

import ca.bradj.questown.core.UtilClean;
import ca.bradj.questown.gui.ItemEconomicsData;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class CoreProgression<JOB, ROOM> {
    private final ImmutableList<ItemEconomicsData> needs;
    private final Predicate<JOB> isGatherer;
    private final Function<Collection<JOB>, JOB> chooseRandom;
    private final Predicate<JOB> generatesVillagerFood;
    private final EconData<JOB> econData;

    public CoreProgression(Collection<ItemEconomicsData> needs, Predicate<JOB> isGatherer, Function<Collection<JOB>, JOB> chooseRandom, Predicate<JOB> generatesVillagerFood, EconData<JOB> econData) {
        this.needs = ImmutableList.copyOf(needs);
        this.isGatherer = isGatherer;
        this.chooseRandom = chooseRandom;
        this.generatesVillagerFood = generatesVillagerFood;
        this.econData = econData;
    }

    @Nullable
    public JOB getFirstJobChange(Collection<JOB> allRootJobs, Function<JOB, ROOM> getRoom, Predicate<ROOM> isQuestExisting) {
        Predicate<ROOM> isQuestAddable;
        ImmutableList allRoots = ImmutableList.copyOf(allRootJobs);
        List firstLayerJobs = allRoots.stream().filter(Predicate.not(this.isGatherer)).toList();
        if (firstLayerJobs.isEmpty()) {
            return null;
        }
        ImmutableMap roomsNeeded = UtilClean.toMap(firstLayerJobs, getRoom);
        ImmutableMap roomsWithoutQuest = UtilClean.filterByValue(roomsNeeded, isQuestAddable = Predicate.not(isQuestExisting));
        if (roomsWithoutQuest.isEmpty()) {
            return this.chooseRandom.apply(firstLayerJobs);
        }
        List<JOB> foodProducing = roomsWithoutQuest.keySet().stream().filter(this.generatesVillagerFood).toList();
        if (!foodProducing.isEmpty()) {
            return this.chooseRandom.apply(foodProducing);
        }
        ImmutableMap<Object, Collection> most = UtilClean.toMap(roomsWithoutQuest.keySet(), z -> this.econData.getForResults(z, this.needs));
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (Map.Entry re : most.entrySet()) {
            int times = ((Collection)re.getValue()).stream().mapToInt(ItemEconomicsData::timesNeeded).sum();
            b.put(re.getKey(), (Object)new TotalTimesNeeded(times));
        }
        ImmutableMap times = b.build();
        OptionalInt maxTimesNeeded = times.values().stream().mapToInt(TotalTimesNeeded::value).max();
        if (maxTimesNeeded.isPresent()) {
            List<Object> mostNeeded = times.entrySet().stream().filter(v -> ((TotalTimesNeeded)v.getValue()).value == maxTimesNeeded.getAsInt()).map(Map.Entry::getKey).toList();
            return this.chooseRandom.apply(mostNeeded);
        }
        return this.chooseRandom.apply((Collection<JOB>)roomsWithoutQuest.keySet());
    }

    public CoreProgression<JOB, ROOM> withFoodCheck(Predicate<JOB> o) {
        return new CoreProgression<JOB, ROOM>((Collection<ItemEconomicsData>)this.needs, this.isGatherer, this.chooseRandom, o, this.econData);
    }

    public CoreProgression<JOB, ROOM> withEconomics(EconData<JOB> o) {
        return new CoreProgression<JOB, ROOM>((Collection<ItemEconomicsData>)this.needs, this.isGatherer, this.chooseRandom, this.generatesVillagerFood, o);
    }

    public static interface EconData<JOB> {
        public Collection<ItemEconomicsData> getForResults(JOB var1, ImmutableList<ItemEconomicsData> var2);
    }

    public record TotalTimesNeeded(int value) {
    }
}

