/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town;

import ca.bradj.questown.core.UtilClean;
import ca.bradj.questown.town.TemporaryBoost;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class HealingStore<POS> {
    private final Map<POS, Double> healingBedsGroundTruth = new HashMap<POS, Double>();
    private final Map<POS, Map<String, TemporaryBoost>> boosts = new HashMap<POS, Map<String, TemporaryBoost>>();
    private final Map<POS, Double> healingBedsBoosted = new HashMap<POS, Double>();

    @Nullable
    public Map.Entry<POS, Double> getRandom(Function<Integer, Integer> randRangedInt) {
        if (this.healingBedsGroundTruth.isEmpty()) {
            return null;
        }
        List list = this.healingBedsGroundTruth.entrySet().stream().toList();
        Map.Entry out = (Map.Entry)list.get(randRangedInt.apply(list.size()));
        return new AbstractMap.SimpleEntry(out.getKey(), this.getHealFactor(out.getKey()));
    }

    public void tick() {
        for (Map.Entry<POS, Map<String, TemporaryBoost>> boostMap : this.boosts.entrySet()) {
            this.tickForPosition(boostMap.getKey(), boostMap.getValue());
        }
    }

    private void tickForPosition(POS pos, Map<String, TemporaryBoost> boosts) {
        Double value = UtilClean.getOrDefault(this.healingBedsGroundTruth, pos, 1.0);
        for (String boostKey : boosts.keySet()) {
            TemporaryBoost ticked = boosts.computeIfPresent(boostKey, (k, v) -> v.ticked());
            if (Objects.requireNonNull(ticked).isDone()) {
                boosts.remove(boostKey);
                continue;
            }
            value = value * ticked.factor();
        }
        this.healingBedsBoosted.put(pos, value);
    }

    public void addBoost(POS p, String uniquenessKey, TemporaryBoost boost) {
        UtilClean.putOrInitialize(this.boosts, p, uniquenessKey, boost.rewind());
        this.tickForPosition(p, this.boosts.get(p));
    }

    public Double getHealFactor(POS p) {
        Supplier<Double> unboosted = () -> UtilClean.getOrDefault(this.healingBedsGroundTruth, p, 1.0);
        return UtilClean.getOrDefault2(this.healingBedsBoosted, p, unboosted);
    }

    protected void putGroundTruth(POS p, Double factor) {
        this.healingBedsGroundTruth.put(p, factor);
    }
}

