/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town;

import ca.bradj.questown.QT;
import ca.bradj.questown.core.init.items.ItemsInit;
import ca.bradj.questown.jobs.HeldItem;
import ca.bradj.questown.jobs.gatherer.GathererTools;
import ca.bradj.questown.town.interfaces.KnowledgeHolder;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.world.item.Item;
import org.apache.commons.lang3.function.TriFunction;

public class KnowledgeStore<BIOME, ITEM_IN extends HeldItem<ITEM_IN, ?>, ITEM_OUT extends ca.bradj.questown.jobs.Item<?>>
implements KnowledgeHolder<BIOME, ITEM_IN, ITEM_OUT> {
    private final ImmutableSet<ITEM_OUT> baseKnowledge;
    private final Function<ITEM_IN, ITEM_OUT> stripper;
    private final TriFunction<GathererTools.LootTablePrefix, BIOME, ITEM_OUT, ITEM_IN> unstripper;
    private final Function<String, BIOME> biomeFactory;
    private final Map<BIOME, Map<GathererTools.LootTablePrefix, ImmutableSet<ITEM_OUT>>> knownGatherResults = new HashMap<BIOME, Map<GathererTools.LootTablePrefix, ImmutableSet<ITEM_OUT>>>();

    public KnowledgeStore(ImmutableSet<ITEM_OUT> baseKnowledge, Function<ITEM_IN, ITEM_OUT> stripper, TriFunction<GathererTools.LootTablePrefix, BIOME, ITEM_OUT, ITEM_IN> unstripper, Function<String, BIOME> biomeFactory) {
        this.baseKnowledge = baseKnowledge;
        this.stripper = stripper;
        this.unstripper = unstripper;
        this.biomeFactory = biomeFactory;
    }

    @Override
    public ImmutableSet<ITEM_OUT> getAllKnownGatherResults(Collection<BIOME> mapBiomes, GathererTools.LootTablePrefix ltPrefix) {
        ImmutableSet.Builder b = ImmutableSet.builder();
        b.addAll(this.baseKnowledge);
        for (Map.Entry<BIOME, Map<GathererTools.LootTablePrefix, ImmutableSet<ITEM_OUT>>> e : this.knownGatherResults.entrySet()) {
            if (!mapBiomes.contains(e.getKey())) continue;
            for (Map.Entry<GathererTools.LootTablePrefix, ImmutableSet<ITEM_OUT>> e2 : e.getValue().entrySet()) {
                b.addAll((Iterable)e2.getValue());
            }
        }
        return b.build();
    }

    public ImmutableSet<ITEM_IN> getAllKnownGatherResults() {
        ImmutableSet.Builder b = ImmutableSet.builder();
        this.baseKnowledge.forEach(v -> b.add((Object)((HeldItem)this.unstripper.apply((Object)GathererTools.NO_TOOL_TABLE_PREFIX, null, v))));
        for (Map.Entry<BIOME, Map<GathererTools.LootTablePrefix, ImmutableSet<ITEM_OUT>>> i : this.knownGatherResults.entrySet()) {
            for (Map.Entry<GathererTools.LootTablePrefix, ImmutableSet<ITEM_OUT>> j : i.getValue().entrySet()) {
                for (ca.bradj.questown.jobs.Item k : j.getValue()) {
                    b.add((Object)((HeldItem)this.unstripper.apply((Object)j.getKey(), i.getKey(), (Object)k)));
                }
            }
        }
        return b.build();
    }

    @Override
    public void registerFoundLoots(Collection<ITEM_IN> items) {
        items.forEach(item -> {
            String lootPrefix;
            if (item.foundInBiome() == null) {
                return;
            }
            String o = item.foundInBiome();
            BIOME bId = this.biomeFactory.apply(o);
            Map<GathererTools.LootTablePrefix, ImmutableSet<ITEM_OUT>> biome = this.knownGatherResults.get(bId);
            if (biome == null) {
                biome = new HashMap<GathererTools.LootTablePrefix, ImmutableSet<ITEM_OUT>>();
            }
            if ((lootPrefix = item.acquiredViaLootTablePrefix()) == null) {
                if (((Item)ItemsInit.GATHERER_MAP.get()).equals(item)) {
                    return;
                }
                QT.FLAG_LOGGER.error("Found item has no loot table prefix", new Object[0]);
                return;
            }
            GathererTools.LootTablePrefix ltp = new GathererTools.LootTablePrefix(lootPrefix);
            ImmutableSet knownBiomeItems = biome.get(ltp);
            if (knownBiomeItems == null) {
                knownBiomeItems = ImmutableSet.of();
            }
            HashSet<ca.bradj.questown.jobs.Item> known = new HashSet<ca.bradj.questown.jobs.Item>((Collection<ca.bradj.questown.jobs.Item>)knownBiomeItems);
            int sizeBefore = known.size();
            ca.bradj.questown.jobs.Item stripped = (ca.bradj.questown.jobs.Item)this.stripper.apply(item);
            known.add(stripped);
            if (sizeBefore != known.size()) {
                QT.FLAG_LOGGER.debug("New item recorded as 'known': {} in biome {}", stripped.getShortName(), bId);
            }
            biome.put(ltp, ImmutableSet.copyOf(known));
            this.knownGatherResults.put(bId, biome);
        });
    }
}

