/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town;

import ca.bradj.questown.QT;
import ca.bradj.questown.core.Pair;
import ca.bradj.questown.integration.minecraft.MCContainer;
import ca.bradj.questown.integration.minecraft.MCTownItem;
import ca.bradj.questown.items.StockRequestItem;
import ca.bradj.questown.jobs.leaver.ContainerTarget;
import ca.bradj.questown.town.entity.TownFlagBlockEntity;
import ca.bradj.questown.town.interfaces.RoomsHolder;
import ca.bradj.questown.town.interfaces.TownInterface;
import ca.bradj.roomrecipes.adapter.Positions;
import ca.bradj.roomrecipes.adapter.RoomRecipeMatch;
import ca.bradj.roomrecipes.core.space.Position;
import ca.bradj.roomrecipes.serialization.MCRoom;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TownContainers {
    public static final Predicate<MCTownItem> ACCEPTS_ALL_ITEMS = i -> true;
    public static final Predicate<MCTownItem> REJECTS_EVERYTHING = i -> false;
    public static final float NO_BOOST = 1.0f;

    @Nullable
    public static ContainerTarget<MCContainer, MCTownItem> findMatching(TownInterface townFlagBlockEntity, ContainerTarget.CheckFn<MCTownItem> c) {
        ServerLevel level = townFlagBlockEntity.getServerLevel();
        if (level == null) {
            return null;
        }
        Optional<ContainerTarget<MCContainer, MCTownItem>> found = TownContainers.findAllContainersMatching(townFlagBlockEntity, c).findFirst();
        return found.orElse(null);
    }

    public static Stream<ContainerTarget<MCContainer, MCTownItem>> findAllContainersMatching(TownInterface t, ContainerTarget.CheckFn<MCTownItem> c) {
        ServerLevel level = t.getServerLevel();
        if (level == null) {
            return Stream.empty();
        }
        List<ContainerTarget<MCContainer, MCTownItem>> allContainers = TownContainers.getAllContainers(t, t.getServerLevel());
        return allContainers.stream().filter(v -> v.hasItem(c));
    }

    public static List<ContainerTarget<MCContainer, MCTownItem>> getAllContainers(TownInterface townFlagBlockEntity, ServerLevel level) {
        return TownContainers.getAllContainers(townFlagBlockEntity, level, x -> true);
    }

    public static List<ContainerTarget<MCContainer, MCTownItem>> getAllContainers(TownInterface townFlagBlockEntity, ServerLevel level, Predicate<RoomRecipeMatch<MCRoom>> include) {
        Stream<ContainerTarget<MCContainer, MCTownItem>> allChestsStream = TownContainers.getAllChestsStream(townFlagBlockEntity.getRoomHandle(), level, include, x -> true);
        Stream<ContainerTarget<MCContainer, MCTownItem>> entities = TownContainers.getAllContainerEntitiesStream(townFlagBlockEntity.getRoomHandle(), level, include, x -> true);
        return Stream.concat(allChestsStream, entities).toList();
    }

    @NotNull
    private static Stream<ContainerTarget<MCContainer, MCTownItem>> getAllChestsStream(RoomsHolder townFlagBlockEntity, ServerLevel level, Predicate<RoomRecipeMatch<MCRoom>> includeRoom, Predicate<BlockPos> includeBlock) {
        return TownContainers.getBlocks(townFlagBlockEntity, includeRoom, includeBlock).filter(v -> ((Map.Entry)v.b()).getValue() instanceof ChestBlock).map(v -> TownContainers.fromChestBlockMaybe((MCRoom)v.a(), (BlockPos)((Map.Entry)v.b()).getKey(), (ChestBlock)((Map.Entry)v.b()).getValue(), level)).filter(Objects::nonNull);
    }

    @NotNull
    private static Stream<ContainerTarget<MCContainer, MCTownItem>> getAllContainerEntitiesStream(RoomsHolder townFlagBlockEntity, ServerLevel level, Predicate<RoomRecipeMatch<MCRoom>> includeRoom, Predicate<BlockPos> includeBlock) {
        return TownContainers.getBlocks(townFlagBlockEntity, includeRoom, includeBlock).map(v -> TownContainers.fromEntity(level, (BlockPos)((Map.Entry)v.b()).getKey())).filter(Objects::nonNull);
    }

    @NotNull
    private static Stream<Pair<MCRoom, Map.Entry<BlockPos, Block>>> getBlocks(RoomsHolder townFlagBlockEntity, Predicate<RoomRecipeMatch<MCRoom>> includeRoom, Predicate<BlockPos> includeBlock) {
        return townFlagBlockEntity.getMatches(includeRoom).stream().flatMap(v -> TownContainers.getContainedBlocks(includeBlock, (RoomRecipeMatch<MCRoom>)v));
    }

    @NotNull
    private static Stream<Pair<MCRoom, Map.Entry<BlockPos, Block>>> getContainedBlocks(Predicate<BlockPos> includeBlock, RoomRecipeMatch<MCRoom> v) {
        return v.getContainedBlocks().entrySet().stream().filter(z -> includeBlock.test((BlockPos)z.getKey())).map(z -> new Pair<MCRoom, Map.Entry>((MCRoom)v.room, (Map.Entry)z));
    }

    @Nullable
    public static ContainerTarget<MCContainer, MCTownItem> fromChestBlock(MCRoom room, BlockPos p, ChestBlock block, ServerLevel level) {
        ContainerTarget<MCContainer, MCTownItem> maybe = TownContainers.fromChestBlockMaybe(room, p, block, level);
        return maybe;
    }

    @Nullable
    private static ContainerTarget<MCContainer, MCTownItem> fromChestBlockMaybe(MCRoom room, BlockPos p, ChestBlock block, ServerLevel level) {
        Position position;
        Position interactPos = position = Positions.FromBlockPos((BlockPos)p);
        BlockState blockState = level.m_8055_(p);
        Optional facing = blockState.m_61145_((Property)BlockStateProperties.f_61374_);
        if (facing.isPresent()) {
            interactPos = Positions.FromBlockPos((BlockPos)p.m_121945_((Direction)facing.get()));
        }
        if (blockState.m_60795_()) {
            return new ContainerTarget<MCContainer, MCTownItem>(Positions.FromBlockPos((BlockPos)p), p.m_123342_(), interactPos, new MCContainer(ContainerTarget.REMOVED), () -> false, item -> TownContainers.setWorkSpot(room, p, item), REJECTS_EVERYTHING, 1.0f);
        }
        if (!blockState.m_60734_().equals(block)) {
            QT.BLOCK_LOGGER.error("Given block is not present at given position. Actual blockstate {}", blockState);
            return new ContainerTarget<MCContainer, MCTownItem>(Positions.FromBlockPos((BlockPos)p), p.m_123342_(), interactPos, new MCContainer(ContainerTarget.REMOVED), () -> false, item -> TownContainers.setWorkSpot(room, p, item), REJECTS_EVERYTHING, 1.0f);
        }
        ChestType typ = blockState.m_61145_((Property)ChestBlock.f_51479_).orElse(null);
        if (!ChestType.LEFT.equals((Object)typ) && !ChestType.SINGLE.equals((Object)typ)) {
            return null;
        }
        Container container = ChestBlock.m_51511_((ChestBlock)block, (BlockState)blockState, (Level)level, (BlockPos)p, (boolean)true);
        if (container == null) {
            throw new IllegalStateException("Container is null at " + String.valueOf(p));
        }
        MCContainer mcContainer = new MCContainer(container);
        return new ContainerTarget<MCContainer, MCTownItem>(position, p.m_123342_(), interactPos, mcContainer, () -> level.m_8055_(p) == blockState, item -> TownContainers.setWorkSpot(room, p, item), ACCEPTS_ALL_ITEMS, 1.0f);
    }

    private static void setWorkSpot(MCRoom room, BlockPos p, MCTownItem item) {
        if (item.get().m_7968_().m_41619_()) {
            return;
        }
        if (item.get() instanceof StockRequestItem) {
            if (StockRequestItem.hasRoom(item.getItemNBT())) {
                return;
            }
            item.setNBT(tag -> StockRequestItem.writeToNBT(tag, room, p));
        }
    }

    @Nullable
    public static ContainerTarget<MCContainer, MCTownItem> findClosestMatching(TownInterface town, ContainerTarget.CheckFn<MCTownItem> checkFn, BlockPos pos, Collection<MCTownItem> itemsThatMustBeInserted) {
        Stream<ContainerTarget<MCContainer, MCTownItem>> chests = TownContainers.findAllContainersMatching(town, checkFn);
        if (!itemsThatMustBeInserted.isEmpty()) {
            chests = chests.filter(v -> itemsThatMustBeInserted.stream().anyMatch(v::canAccept));
        }
        return chests.min(Comparator.comparingDouble(a -> TownContainers.comparison(pos, a))).orElse(null);
    }

    @Nullable
    public static ContainerTarget<MCContainer, MCTownItem> fromEntity(ServerLevel level, BlockPos p) {
        BlockEntity blockEntity;
        Position position;
        BlockState blockState = level.m_8055_(p);
        Optional facing = blockState.m_61145_((Property)BlockStateProperties.f_61374_);
        Position interactPos = position = Positions.FromBlockPos((BlockPos)p);
        if (facing.isPresent()) {
            interactPos = Positions.FromBlockPos((BlockPos)p.m_121945_((Direction)facing.get()));
        }
        if ((blockEntity = level.m_7702_(p)) == null) {
            return null;
        }
        if (!(blockEntity instanceof ContainerTarget.Container)) {
            return null;
        }
        return new ContainerTarget<MCContainer, MCTownItem>(position, p.m_123342_(), interactPos, (ContainerTarget.Container)blockEntity, () -> level.m_8055_(p) == blockState, item -> {}, item -> ((ContainerTarget.Container)blockEntity).canAcceptIfSpaceAllows(item), ((ContainerTarget.Container)blockEntity).getItemAcceptanceRankBoost().value());
    }

    public static double comparison(BlockPos pos, ContainerTarget<MCContainer, MCTownItem> a) {
        return pos.m_123331_((Vec3i)a.getBlockPos()) / (double)a.getRankingBoost();
    }

    public static Collection<Item> getUniqueItems(TownInterface t) {
        List<ContainerTarget<MCContainer, MCTownItem>> all = TownContainers.getAllContainers(t, t.getServerLevel());
        HashSet<Item> uniqueItems = new HashSet<Item>();
        for (ContainerTarget<MCContainer, MCTownItem> container : all) {
            if (container.getContainer() == null) continue;
            for (int i = 0; i < container.getContainer().size(); ++i) {
                ItemStack stack = container.getContainer().getItem(i).toMCItemStack();
                if (stack.m_41619_()) continue;
                uniqueItems.add(stack.m_41720_());
            }
        }
        return uniqueItems;
    }

    public static ImmutableList<MCTownItem> getAllStacks(TownFlagBlockEntity e, ServerLevel serverLevel) {
        List<ContainerTarget<MCContainer, MCTownItem>> cs = TownContainers.getAllContainers(e, serverLevel);
        return (ImmutableList)cs.stream().map(ContainerTarget::getItems).flatMap(Collection::stream).filter(v -> !v.isEmpty()).collect(ImmutableList.toImmutableList());
    }
}

