/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town;

import ca.bradj.questown.QT;
import ca.bradj.questown.core.Config;
import ca.bradj.questown.core.init.items.ItemsInit;
import ca.bradj.questown.integration.minecraft.MCContainer;
import ca.bradj.questown.integration.minecraft.MCTownItem;
import ca.bradj.questown.items.GathererMap;
import ca.bradj.questown.jobs.gatherer.Loots;
import ca.bradj.questown.jobs.leaver.ContainerTarget;
import ca.bradj.questown.town.TownContainers;
import ca.bradj.questown.town.UnsafeTown;
import ca.bradj.questown.town.entity.TownFlagBlockEntity;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class TownKnownBiomes {
    private final UnsafeTown town = new UnsafeTown(this.getClass());
    private final ArrayList<Biome> nearbyBiomes = new ArrayList();
    private boolean initialized = false;

    public void initialize(TownFlagBlockEntity t) {
        this.town.initialize(t);
        this.initialized = true;
    }

    public Collection<ResourceLocation> getAllInTown() {
        ImmutableSet.Builder b = ImmutableSet.builder();
        try {
            this.getBiomesFromMapsInChests((ImmutableSet.Builder<ResourceLocation>)b);
        }
        catch (IllegalStateException ex) {
            QT.FLAG_LOGGER.error("TownKnownBiomes is not connected to town. Fallback biome will be used", new Object[0]);
        }
        this.nearbyBiomes.forEach(v -> {
            ResourceLocation key = ForgeRegistries.BIOMES.getKey(v);
            if (key == null) {
                return;
            }
            b.add((Object)key);
        });
        b.add((Object)Loots.fallbackBiome);
        return b.build();
    }

    private void getBiomesFromMapsInChests(ImmutableSet.Builder<ResourceLocation> b) {
        @NotNull TownFlagBlockEntity e = this.town.getUnsafe();
        List<ContainerTarget<MCContainer, MCTownItem>> cs = TownContainers.getAllContainers(e, e.getServerLevel());
        for (ContainerTarget<MCContainer, MCTownItem> c : cs) {
            for (ResourceLocation mapItem : TownKnownBiomes.getMapItems(c)) {
                b.add((Object)mapItem);
            }
        }
    }

    @NotNull
    private static List<ResourceLocation> getMapItems(ContainerTarget<MCContainer, MCTownItem> v) {
        return v.getItems().stream().filter(i -> ((Item)ItemsInit.GATHERER_MAP.get()).equals(i.get())).map(i -> GathererMap.getBiome(i.toQTItemStack())).filter(Objects::nonNull).toList();
    }

    public ResourceLocation getRandomNearbyBiome() {
        if (this.nearbyBiomes.isEmpty()) {
            TownKnownBiomes.computeNearbyBiomes(this);
        }
        Biome biome = (Biome)Util.m_214621_(this.nearbyBiomes, (RandomSource)this.town.getServerLevelUnsafe().m_213780_());
        return ForgeRegistries.BIOMES.getKey((Object)biome);
    }

    public void tick() {
        if (this.nearbyBiomes.isEmpty()) {
            TownKnownBiomes.computeNearbyBiomes(this);
        }
    }

    private static void computeNearbyBiomes(TownKnownBiomes e) {
        TownFlagBlockEntity town = e.town.getUnsafe();
        BlockPos blockPos = town.m_58899_();
        ServerLevel level = e.town.getServerLevelUnsafe();
        ChunkPos here = new ChunkPos(blockPos);
        Biome value = (Biome)level.m_204166_(blockPos).m_203334_();
        e.nearbyBiomes.add(value);
        for (Direction d : Direction.Plane.HORIZONTAL) {
            for (int i = 0; i < (Integer)Config.BIOME_SCAN_RADIUS.get(); ++i) {
                ChunkPos there = new ChunkPos(here.f_45578_ + d.m_122429_() * i, here.f_45579_ + d.m_122431_() * i);
                Biome biome = (Biome)level.m_204166_(there.m_151394_(blockPos.m_123342_())).m_203334_();
                e.nearbyBiomes.add(biome);
            }
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

