/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town;

import ca.bradj.questown.QT;
import ca.bradj.questown.blocks.TownFlagSubBlocks;
import ca.bradj.questown.core.Config;
import ca.bradj.questown.core.init.BlocksInit;
import ca.bradj.questown.logic.TownCycle;
import ca.bradj.questown.town.WallDetection;
import ca.bradj.roomrecipes.core.Room;
import ca.bradj.roomrecipes.core.space.InclusiveSpace;
import ca.bradj.roomrecipes.core.space.Position;
import ca.bradj.roomrecipes.logic.InclusiveSpaces;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TownPois {
    private final TownFlagSubBlocks subBlocks;
    private List<BlockPos> welcomeMats = new ArrayList<BlockPos>();
    private Listener listener;
    private BlockPos visitorSpot = null;

    public TownPois(TownFlagSubBlocks subBlocks) {
        this.subBlocks = subBlocks;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public Vec3 getVisitorJoinPos(ServerLevel level, BlockPos fallback) {
        if (this.visitorSpot == null) {
            return new Vec3((double)fallback.m_123341_(), (double)fallback.m_123342_(), (double)fallback.m_123343_());
        }
        BlockPos vs = this.visitorSpot.m_5484_(Direction.Plane.HORIZONTAL.m_235690_(level.m_213780_()), 2);
        for (int i = 0; i < (Integer)Config.BASE_MAX_LOOP.get() && !level.m_45752_(level.m_8055_(vs.m_7495_()), vs, CollisionContext.m_82749_()); ++i) {
            vs = this.visitorSpot.m_5484_(Direction.Plane.HORIZONTAL.m_235690_(level.m_213780_()), 2);
        }
        return new Vec3((double)vs.m_123341_(), (double)vs.m_123342_(), (double)vs.m_123343_());
    }

    public <R extends Room, P> P getWanderTarget(ServerLevel level, Collection<R> all, Filter<R> filter, PositionFactory<P, R> pFact) {
        Room r = (Room)ImmutableList.copyOf(all).get(level.m_213780_().m_188503_(all.size()));
        Collection allEnclosed = InclusiveSpaces.getPositions((InclusiveSpace)r.getSpace(), (InclusiveSpaces.PositionType)InclusiveSpaces.PositionType.INTERIOR_ONLY);
        ImmutableList.Builder b = ImmutableList.builder();
        for (Position p : allEnclosed) {
            if (!filter.include(p, r)) continue;
            b.add(pFact.make(p, r));
        }
        ImmutableList positions = b.build();
        if (positions.isEmpty()) {
            return null;
        }
        return (P)positions.get(level.m_213780_().m_188503_(positions.size()));
    }

    @Nullable
    public BlockPos getWelcomeMatPos(@NotNull ServerLevel level) {
        for (int i = 0; i < (Integer)Config.BASE_MAX_LOOP.get() && !this.welcomeMats.isEmpty(); ++i) {
            int index;
            ImmutableList copy = ImmutableList.copyOf(this.welcomeMats);
            BlockPos mat = (BlockPos)copy.get(index = level.f_46441_.m_188503_(copy.size()));
            if (level.m_8055_(mat).m_60713_((Block)BlocksInit.WELCOME_MAT_BLOCK.get())) {
                return mat;
            }
            this.welcomeMats.remove(index);
        }
        return null;
    }

    public void registerWelcomeMat(BlockPos welcomeMatBlock) {
        this.welcomeMats.add(welcomeMatBlock);
        this.subBlocks.register(welcomeMatBlock);
        QT.FLAG_LOGGER.debug("Welcome mat was registered with town flag at {}", welcomeMatBlock);
    }

    public ImmutableList<BlockPos> getWelcomeMats() {
        return ImmutableList.copyOf(this.welcomeMats);
    }

    public void tick(ServerLevel level, BlockPos flagPos, int villagerCount) {
        BlockPos welcomePos;
        Optional<Object> fire = Optional.empty();
        if (this.visitorSpot == null && villagerCount <= 0) {
            fire = TownCycle.findCampfire(flagPos, (Level)level);
            fire.ifPresent(bp -> this.listener.campfireFound((BlockPos)bp));
        }
        if ((welcomePos = this.getWelcomeMatPos(level)) == null) {
            this.visitorSpot = (BlockPos)fire.orElse(this.visitorSpot);
            return;
        }
        BlockPos gate = TownCycle.findTownGate(welcomePos, level, position -> WallDetection.IsWall(level, position, welcomePos.m_123342_()));
        if (gate != null) {
            this.listener.townGateFound(gate);
            this.visitorSpot = gate;
        }
    }

    public static interface Listener {
        public void campfireFound(BlockPos var1);

        public void townGateFound(BlockPos var1);
    }

    public static interface Filter<R extends Room> {
        public boolean include(Position var1, R var2);
    }

    public static interface PositionFactory<P, R extends Room> {
        public P make(Position var1, R var2);
    }
}

