/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town;

import ca.bradj.questown.jobs.HeldItem;
import ca.bradj.questown.jobs.ImmutableSnapshot;
import ca.bradj.questown.jobs.Item;
import ca.bradj.questown.jobs.ProductionTimeWarper;
import ca.bradj.questown.jobs.leaver.ContainerTarget;
import ca.bradj.questown.town.Claim;
import ca.bradj.questown.town.Effect;
import ca.bradj.questown.town.VillagerDataCollectionHolder;
import ca.bradj.questown.town.interfaces.ImmutableWorkStateContainer;
import ca.bradj.questown.town.workstatus.State;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TownState<C extends ContainerTarget.Container<I>, I extends Item<I>, H extends HeldItem<H, I> & Item<H>, P, SELF>
implements ProductionTimeWarper.Town<I, H>,
ImmutableWorkStateContainer<P, SELF>,
VillagerDataCollectionHolder<H> {
    @NotNull
    public final ImmutableList<VillagerData<H>> villagers;
    @NotNull
    public final ImmutableList<ContainerTarget<C, I>> containers;
    @NotNull
    public final ImmutableList<P> gates;
    public final long worldTimeAtSleep;
    public final ImmutableMap<P, State> workStates;
    public final ImmutableMap<P, Integer> workTimers;
    public final ImmutableMap<UUID, Boolean> blocksOfProgress;

    public TownState(@NotNull List<VillagerData<H>> villagers, @NotNull List<ContainerTarget<C, I>> containers, @NotNull ImmutableMap<P, State> workStates, @NotNull ImmutableMap<P, Integer> workTimers, @NotNull List<P> gates, @NotNull ImmutableMap<UUID, Boolean> blocksOfProgress, long worldTimeAtSleep) {
        this.villagers = ImmutableList.copyOf(villagers);
        this.containers = ImmutableList.copyOf(containers);
        this.gates = ImmutableList.copyOf(gates);
        this.worldTimeAtSleep = worldTimeAtSleep;
        this.workStates = workStates;
        this.workTimers = workTimers;
        this.blocksOfProgress = ImmutableMap.copyOf(blocksOfProgress);
    }

    @Override
    public VillagerData<H> getVillager(int villagerIndex) {
        return (VillagerData)this.villagers.get(villagerIndex);
    }

    public String toString() {
        return "TownState{\n\tvillagers=" + String.valueOf(this.villagers) + ",\n\tcontainers=" + String.valueOf(this.containers) + ",\n\tstates=" + String.valueOf(this.workStates) + ",\n\ttimers=" + String.valueOf(this.workTimers) + ",\n\tworldTimeAtSleep=" + this.worldTimeAtSleep + "\n}";
    }

    @Override
    public ImmutableList<H> depositItems(ImmutableList<H> itemsToDeposit) {
        ImmutableList.Builder notDepositedItems = ImmutableList.builder();
        boolean allFull = false;
        for (HeldItem item : itemsToDeposit) {
            boolean deposited = false;
            if (!allFull) {
                for (int i = 0; i < this.containers.size(); ++i) {
                    ContainerTarget container = (ContainerTarget)this.containers.get(i);
                    for (int j = 0; j < container.size(); ++j) {
                        Object containerItem = container.getItem(j);
                        if (!containerItem.isEmpty()) continue;
                        container.setItem(j, item.get());
                        deposited = true;
                        break;
                    }
                    if (deposited) break;
                }
            }
            if (deposited) continue;
            allFull = true;
            notDepositedItems.add((Object)item);
        }
        return notDepositedItems.build();
    }

    @Override
    public boolean IsStorageAvailable() {
        for (ContainerTarget container : this.containers) {
            if (!container.isFull()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasGate() {
        return !this.gates.isEmpty();
    }

    @Override
    @Nullable
    public State getJobBlockState(P bp) {
        return (State)this.workStates.get(bp);
    }

    @Override
    public ImmutableMap<P, State> getAll() {
        return ImmutableMap.copyOf(this.workStates);
    }

    @Override
    public SELF setJobBlockState(P bp, State bs) {
        HashMap<P, State> m = new HashMap<P, State>(this.workStates);
        m.put(bp, bs);
        return this.newTownState(this.villagers, this.containers, ImmutableMap.copyOf(m), this.workTimers, this.gates, this.blocksOfProgress, this.worldTimeAtSleep);
    }

    protected abstract SELF newTownState(ImmutableList<VillagerData<H>> var1, ImmutableList<ContainerTarget<C, I>> var2, ImmutableMap<P, State> var3, ImmutableMap<P, Integer> var4, ImmutableList<P> var5, ImmutableMap<UUID, Boolean> var6, long var7);

    @Override
    public SELF setJobBlockStateWithTimer(P bp, State bs, int ticksToNextState) {
        HashMap<P, State> m = new HashMap<P, State>(this.workStates);
        m.put(bp, bs);
        HashMap<P, Integer> m2 = new HashMap<P, Integer>(this.workTimers);
        m2.put(bp, ticksToNextState);
        return this.newTownState(this.villagers, this.containers, ImmutableMap.copyOf(m), ImmutableMap.copyOf(m2), this.gates, this.blocksOfProgress, this.worldTimeAtSleep);
    }

    @Override
    public SELF clearState(P bp) {
        HashMap<P, State> m = new HashMap<P, State>(this.workStates);
        m.remove(bp);
        return this.newTownState(this.villagers, this.containers, ImmutableMap.copyOf(m), this.workTimers, this.gates, this.blocksOfProgress, this.worldTimeAtSleep);
    }

    public SELF withVillagerData(int index, VillagerData<H> data) {
        ArrayList<VillagerData<H>> vilz = new ArrayList<VillagerData<H>>(this.villagers);
        vilz.set(index, data);
        return this.newTownState(ImmutableList.copyOf(vilz), this.containers, this.workStates, this.workTimers, this.gates, this.blocksOfProgress, this.worldTimeAtSleep);
    }

    public Map.Entry<SELF, I> withContainerItemRemoved(Predicate<I> itemCheck) {
        ImmutableList.Builder b = ImmutableList.builder();
        Item removed = null;
        for (ContainerTarget container : this.containers) {
            @Nullable Map.Entry<ContainerTarget<C, I>, I> wRem = container.withItemRemoved(itemCheck);
            if (wRem != null) {
                b.add(wRem.getKey());
                removed = (Item)wRem.getValue();
                continue;
            }
            b.add((Object)container);
        }
        return new AbstractMap.SimpleEntry<SELF, Item>(this.newTownState(this.villagers, b.build(), this.workStates, this.workTimers, this.gates, this.blocksOfProgress, this.worldTimeAtSleep), removed);
    }

    public SELF withTimerReducedBy(P bp, int stepInterval) {
        if (this.workTimers.get(bp) == null || (Integer)this.workTimers.get(bp) == 0) {
            return this.unchanged();
        }
        HashMap<P, State> m = new HashMap<P, State>(this.workStates);
        HashMap<P, Integer> m2 = new HashMap<P, Integer>(this.workTimers);
        m2.compute(bp, (k, v) -> v == null ? 0 : Math.max(0, v - stepInterval));
        if (m2.get(bp) <= 0) {
            m.compute(bp, (k, v) -> (v == null ? State.fresh() : v).incrProcessing());
        }
        return this.newTownState(this.villagers, this.containers, ImmutableMap.copyOf(m), ImmutableMap.copyOf(m2), this.gates, this.blocksOfProgress, this.worldTimeAtSleep);
    }

    protected final SELF unchanged() {
        return this.newTownState(this.villagers, this.containers, this.workStates, this.workTimers, this.gates, this.blocksOfProgress, this.worldTimeAtSleep);
    }

    public SELF withBOPCleared(UUID vUUID) {
        HashMap<UUID, Boolean> b = new HashMap<UUID, Boolean>((Map<UUID, Boolean>)this.blocksOfProgress);
        b.put(vUUID, false);
        return this.newTownState(this.villagers, this.containers, this.workStates, this.workTimers, this.gates, (ImmutableMap<UUID, Boolean>)ImmutableMap.copyOf(b), this.worldTimeAtSleep);
    }

    @Override
    public boolean claimSpot(P bp, Claim claim) {
        return true;
    }

    @Override
    public void clearClaim(P position) {
    }

    @Override
    public boolean canClaim(P position, Supplier<Claim> makeClaim) {
        return true;
    }

    public static final class VillagerData<I extends HeldItem<I, ? extends Item<?>>> {
        public final UUID uuid;
        public final double xPosition;
        public final double yPosition;
        public final double zPosition;
        public final ImmutableSnapshot<I, ?> journal;
        private final List<Effect> effects = new ArrayList<Effect>();

        public VillagerData(double xPosition, double yPosition, double zPosition, ImmutableSnapshot<I, ?> journal, UUID uuid) {
            this.xPosition = xPosition;
            this.yPosition = yPosition;
            this.zPosition = zPosition;
            this.journal = journal;
            this.uuid = uuid;
        }

        public String toString() {
            return "VillagerData{\n\tvUUID=" + String.valueOf(this.uuid) + ",\n\txPosition=" + this.xPosition + ",\n\tyPosition=" + this.yPosition + ",\n\tzPosition=" + this.zPosition + ",\n\tjournal=" + String.valueOf(this.journal) + "\n}";
        }

        public int getCapacity() {
            return 6;
        }

        public VillagerData<I> withSetItem(int itemIndex, I item) {
            return new VillagerData<I>(this.xPosition, this.yPosition, this.zPosition, (ImmutableSnapshot)this.journal.withSetItem(itemIndex, item), this.uuid);
        }

        @Nullable
        public VillagerData<I> withAddedItem(I value) {
            Optional<HeldItem> first = this.journal.items().stream().filter(Item::isEmpty).findFirst();
            if (first.isEmpty()) {
                return null;
            }
            int idx = this.journal.items().indexOf((Object)first.get());
            return new VillagerData<I>(this.xPosition, this.yPosition, this.zPosition, (ImmutableSnapshot)this.journal.withSetItem(idx, value), this.uuid);
        }

        public VillagerData<I> withItems(ImmutableList<I> items) {
            return new VillagerData<I>(this.xPosition, this.yPosition, this.zPosition, (ImmutableSnapshot)this.journal.withItems(items), this.uuid);
        }

        public VillagerData<I> withEffect(Effect effect) {
            this.effects.add(effect);
            return this;
        }

        public Collection<Effect> getEffectsAndClearExpired(long currentTick) {
            ImmutableList.Builder b = ImmutableList.builder();
            ImmutableList.Builder r = ImmutableList.builder();
            this.effects.forEach(e -> {
                if (e.untilTick() <= currentTick) {
                    b.add(e);
                    return;
                }
                r.add(e);
            });
            this.effects.removeAll((Collection<?>)r.build());
            return b.build();
        }
    }
}

