/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town;

import ca.bradj.questown.QT;
import ca.bradj.questown.blocks.RoomBlock;
import ca.bradj.questown.core.UtilClean;
import ca.bradj.questown.core.VillagerUUID;
import ca.bradj.questown.core.advancements.RoomTrigger;
import ca.bradj.questown.core.init.AdvancementsInit;
import ca.bradj.questown.core.network.EconomicsUpdate;
import ca.bradj.questown.core.network.OpenVillagerAdvancementsMenuMessage;
import ca.bradj.questown.core.network.QuestownNetwork;
import ca.bradj.questown.core.network.ShowItemJobsMessage;
import ca.bradj.questown.core.network.SyncVillagerAdvancementsMessage;
import ca.bradj.questown.gui.FlagMenus;
import ca.bradj.questown.gui.FlagTabsEmbedding;
import ca.bradj.questown.gui.InventoryAndStatusMenu;
import ca.bradj.questown.gui.ItemEconomicsData;
import ca.bradj.questown.gui.JobChangeConfirmMenu;
import ca.bradj.questown.gui.MultiStatusMenu;
import ca.bradj.questown.gui.UIJob;
import ca.bradj.questown.gui.UIQuest;
import ca.bradj.questown.gui.VillagerBlockofProgressMenu;
import ca.bradj.questown.gui.VillagerEconomicsData;
import ca.bradj.questown.gui.VillagerEconomicsMenu;
import ca.bradj.questown.gui.VillagerMenus;
import ca.bradj.questown.gui.VillagerQuestsContainer;
import ca.bradj.questown.gui.VillagerStatsMenu;
import ca.bradj.questown.gui.VillagerTabs;
import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.integration.minecraft.MCTownItem;
import ca.bradj.questown.jobs.DeclarativeJob;
import ca.bradj.questown.jobs.IStatus;
import ca.bradj.questown.jobs.ImmutableSnapshot;
import ca.bradj.questown.jobs.Job;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.ServerJobsRegistry;
import ca.bradj.questown.jobs.Work;
import ca.bradj.questown.jobs.Works;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.mobs.visitor.VisitorMobEntity;
import ca.bradj.questown.town.VillagerStatsData;
import ca.bradj.questown.town.econ.NoMCEconomics;
import ca.bradj.questown.town.entity.TownFlagBlockEntity;
import ca.bradj.questown.town.quests.MCReward;
import ca.bradj.questown.town.quests.Quest;
import ca.bradj.questown.town.special.SpecialQuests;
import ca.bradj.roomrecipes.recipes.RecipesInit;
import ca.bradj.roomrecipes.recipes.RoomRecipe;
import ca.bradj.roomrecipes.serialization.MCRoom;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TownVillagerUIs {
    private static ImmutableMap<String, Consumer<ShowerData>> menuShow;

    public static void showMultiStatusUI(final ServerPlayer player, final FlagTabsEmbedding.FlagInfo townFlagBasePos, final Collection<LivingEntity> entities, Supplier<Collection<? extends Map.Entry<? extends Quest<ResourceLocation, MCRoom>, MCReward>>> questsSrc, int bopCount) {
        List<VisitorMobEntity> es = entities.stream().map(v -> (VisitorMobEntity)v).toList();
        Compat.openScreen(player, new MenuProvider(){

            @NotNull
            public Component m_5446_() {
                return Compat.literal("");
            }

            @NotNull
            public AbstractContainerMenu m_7208_(int windowId, @NotNull Inventory inv, @NotNull Player p) {
                MultiStatusMenu multiStatusMenu = new MultiStatusMenu(windowId, townFlagBasePos, this::triggerAdvancement);
                return multiStatusMenu;
            }

            private void triggerAdvancement() {
                if (entities.isEmpty()) {
                    return;
                }
                AdvancementsInit.ROOM_TRIGGER.triggerForNearestPlayer(player.m_9236_(), RoomTrigger.Triggers.FirstOpenFlagMenu, townFlagBasePos.flagPos());
            }
        }, data -> {
            List<UIQuest> quests = UIQuest.fromLevel((Level)player.m_9236_(), (Collection)questsSrc.get());
            FlagMenus.writeAndLink(data, quests, townFlagBasePos, player, es, bopCount);
        });
    }

    public static void showItemJobsUI(ServerPlayer sender, TownFlagBlockEntity unsafeTown, Collection<LivingEntity> entities, Ingredient itemToShowJobsFor) {
        HashMap vb = new HashMap();
        for (LivingEntity entity : entities) {
            if (!(entity instanceof VisitorMobEntity)) continue;
            VisitorMobEntity vme = (VisitorMobEntity)entity;
            UtilClean.addOrInitializeList(vb, vme.getJobId(), vme.m_20148_());
        }
        ImmutableMap.Builder rMapB = ImmutableMap.builder();
        SpecialQuests.SPECIAL_QUESTS.forEach((arg_0, arg_1) -> ((ImmutableMap.Builder)rMapB).put(arg_0, arg_1));
        sender.m_9236_().m_7465_().m_44013_(RecipesInit.ROOM).forEach(v -> rMapB.put((Object)v.m_6423_(), v));
        ImmutableMap rMap = rMapB.build();
        ImmutableList.Builder b = ImmutableList.builder();
        ImmutableMap<JobID, ResourceLocation> jubz = ServerJobsRegistry.getAllJobsThatProduce(unsafeTown.getTownData(), itemToShowJobsFor);
        for (JobID job : jubz.keySet()) {
            Job<MCHeldItem, ImmutableSnapshot<MCHeldItem, ?>, IStatus<?>> j = ServerJobsRegistry.getUninitializedJob(job, VillagerUUID.random()).getJob();
            if (!(j instanceof DeclarativeJob)) continue;
            DeclarativeJob dj = (DeclarativeJob)j;
            ImmutableSet<MCTownItem> results = ServerJobsRegistry.getResults(unsafeTown.getTownData(), job);
            ImmutableList<Ingredient> roomRecipe = TownVillagerUIs.getRoomIngredients(dj, (ImmutableMap<ResourceLocation, RoomRecipe>)rMap);
            b.add((Object)new UIJob(j.getId(), (ImmutableList<UUID>)ImmutableList.copyOf((Collection)vb.values().stream().flatMap(Collection::stream).collect(Collectors.toSet())), (ImmutableList<Ingredient>)ImmutableList.copyOf((Collection)dj.initialIngredients.values()), (ImmutableList<Ingredient>)ImmutableList.copyOf((Collection)dj.initialTools.values()), dj.location().baseRoom(), roomRecipe, (ImmutableList<ItemStack>)((ImmutableList)results.stream().map(v -> v.get().m_7968_()).collect(ImmutableList.toImmutableList()))));
        }
        ShowItemJobsMessage msg = new ShowItemJobsMessage(itemToShowJobsFor, (ImmutableList<UIJob>)b.build(), unsafeTown.getTownFlagBasePos());
        QuestownNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sender), (Object)msg);
    }

    @NotNull
    private static ImmutableList<Ingredient> getRoomIngredients(DeclarativeJob dj, ImmutableMap<ResourceLocation, RoomRecipe> rMap) {
        RoomRecipe r = (RoomRecipe)rMap.get((Object)dj.location().baseRoom());
        @Nullable ItemStack roomBlock = RoomBlock.getRoomBlock(dj.location().baseRoom());
        ImmutableList roomRecipe = roomBlock != null ? ImmutableList.of((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{roomBlock})) : (r == null ? ImmutableList.of() : ImmutableList.copyOf((Collection)r.m_7527_()));
        return roomRecipe;
    }

    public static void showJobsWithSameRootUI(ServerPlayer sender, @NotNull TownFlagBlockEntity unsafe, List<LivingEntity> entities, JobID childJob) {
        HashMap vb = new HashMap();
        for (LivingEntity entity : entities) {
            if (!(entity instanceof VisitorMobEntity)) continue;
            VisitorMobEntity vme = (VisitorMobEntity)entity;
            UtilClean.addOrInitializeList(vb, vme.getJobId(), vme.m_20148_());
        }
        ImmutableMap.Builder rMapB = ImmutableMap.builder();
        SpecialQuests.SPECIAL_QUESTS.forEach((arg_0, arg_1) -> ((ImmutableMap.Builder)rMapB).put(arg_0, arg_1));
        sender.m_9236_().m_7465_().m_44013_(RecipesInit.ROOM).forEach(v -> rMapB.put((Object)v.m_6423_(), v));
        ImmutableMap rMap = rMapB.build();
        ImmutableList jubz = (ImmutableList)ServerJobsRegistry.getAllJobs().stream().filter(v -> v.sameRoot(childJob)).collect(ImmutableList.toImmutableList());
        ImmutableList.Builder b = ImmutableList.builder();
        for (JobID job : jubz) {
            Job<MCHeldItem, ImmutableSnapshot<MCHeldItem, ?>, IStatus<?>> j = ServerJobsRegistry.getUninitializedJob(job, VillagerUUID.random()).getJob();
            if (!(j instanceof DeclarativeJob)) continue;
            DeclarativeJob dj = (DeclarativeJob)j;
            ImmutableSet<MCTownItem> results = ServerJobsRegistry.getResults(unsafe.getTownData(), job);
            RoomRecipe r = (RoomRecipe)rMap.get((Object)dj.location().baseRoom());
            b.add((Object)new UIJob(j.getId(), (ImmutableList<UUID>)ImmutableList.copyOf((Collection)vb.values().stream().flatMap(Collection::stream).collect(Collectors.toSet())), (ImmutableList<Ingredient>)ImmutableList.copyOf((Collection)dj.initialIngredients.values()), (ImmutableList<Ingredient>)ImmutableList.copyOf((Collection)dj.initialTools.values()), dj.location().baseRoom(), TownVillagerUIs.getRoomIngredients(dj, (ImmutableMap<ResourceLocation, RoomRecipe>)rMap), (ImmutableList<ItemStack>)((ImmutableList)results.stream().map(v -> v.get().m_7968_()).collect(ImmutableList.toImmutableList()))));
        }
        ShowItemJobsMessage msg = new ShowItemJobsMessage(Ingredient.m_43927_((ItemStack[])new ItemStack[]{ItemStack.f_41583_}), (ImmutableList<UIJob>)b.build(), unsafe.getTownFlagBasePos());
        QuestownNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sender), (Object)msg);
    }

    public static void showUI(ServerPlayer sender, Collection<LivingEntity> entities, String type, UUID villagerId, Map<UUID, ? extends Set<JobID>> unlockedJobs, Set<JobID> unlockableJobs) {
        Optional<LivingEntity> f = entities.stream().filter(VisitorMobEntity.class::isInstance).filter(v -> villagerId.equals(v.m_20148_())).findFirst();
        if (f.isEmpty()) {
            QT.FLAG_LOGGER.error("No villagers with ID {} while opening UI", villagerId);
            return;
        }
        TownVillagerUIs.syncWorkToClient(sender);
        VisitorMobEntity e = (VisitorMobEntity)f.get();
        TownFlagBlockEntity flag = TownFlagBlockEntity.getFromPos(sender.f_19853_, e.getFlagPos());
        List<UIQuest> quests = flag.getQuestHandle().getAllBatchesForVillager(e.m_20148_()).stream().map(v -> UIQuest.fromLevel(sender.m_9236_(), v)).flatMap(Collection::stream).toList();
        VillagerStatsData stats = flag.getVillagerHandle().getStats(e.m_20148_());
        VillagerEconomicsData econ = new VillagerEconomicsData((ImmutableList<ItemEconomicsData>)ImmutableList.of());
        Consumer runnable = (Consumer)menuShow.get((Object)type);
        if (runnable == null) {
            throw new IllegalArgumentException("Unexpected menu type: \"" + type + "\"");
        }
        ShowerData d = new ShowerData(sender, quests, e, stats, econ, flag::getEconomicsHandle, unlockedJobs, unlockableJobs, villagerId, flag.getVillagerHandle().isJobChangePending(e.getVUID()));
        runnable.accept(d);
    }

    private static void syncWorkToClient(ServerPlayer sender) {
        PacketDistributor.PacketTarget tgt = PacketDistributor.PLAYER.with(() -> sender);
        HashMap<JobID, @Nullable JobID> b = new HashMap<JobID, JobID>();
        HashMap<JobID, ResourceLocation> b2 = new HashMap<JobID, ResourceLocation>();
        Works.values().forEach(w -> {
            Work work = (Work)w.get();
            b.put(work.id, work.parentID);
            b2.put(work.id, Compat.getItemId(work.icon.m_41720_()));
        });
        QuestownNetwork.CHANNEL.send(tgt, (Object)new SyncVillagerAdvancementsMessage(b, b2));
    }

    public static void staticInit() {
        ImmutableMap.Builder b = ImmutableMap.builder();
        b.put((Object)"inventory", d -> TownVillagerUIs.openMenu(d.sender(), (TriFunction<Integer, Inventory, Player, AbstractContainerMenu>)((TriFunction)(windowId, inv, p) -> {
            VisitorMobEntity e = d.entity();
            InventoryAndStatusMenu x = new InventoryAndStatusMenu((int)windowId, e.getInventory(), p.m_150109_(), (Collection<Boolean>)e.getSlotLocks(), e.m_20148_(), e.getJobId(), e.getFlagPos(), e.hasBlockOfProgress());
            x.connectToServer(e, d.sender());
            return x;
        }), d.quests(), d.entity(), d.stats(), d.jobChangePending()));
        b.put((Object)"quests", d -> {
            VisitorMobEntity e = d.entity();
            TownVillagerUIs.openMenu(d.sender(), (TriFunction<Integer, Inventory, Player, AbstractContainerMenu>)((TriFunction)(windowId, inv, p) -> new VillagerQuestsContainer((int)windowId, e.m_20148_(), (Collection<UIQuest>)d.quests(), e.getFlagPos(), e.hasBlockOfProgress())), d.quests(), e, d.stats(), d.jobChangePending());
        });
        b.put((Object)"stats", d -> {
            VisitorMobEntity e = d.entity();
            TownVillagerUIs.openMenu(d.sender(), (TriFunction<Integer, Inventory, Player, AbstractContainerMenu>)((TriFunction)(windowId, inv, p) -> new VillagerStatsMenu((int)windowId, e, e.getFlagPos(), d.stats(), e.hasBlockOfProgress())), d.quests(), e, d.stats(), d.jobChangePending());
        });
        b.put((Object)"skills", d -> {
            ImmutableList vUnlocked = UtilClean.getOrDefaultCollection(d.unlockedJobs(), d.entity().m_20148_(), ImmutableList.of());
            OpenVillagerAdvancementsMenuMessage msg = new OpenVillagerAdvancementsMenuMessage(d.entity().getFlagPos(), d.entity().m_20148_(), (Collection<JobID>)vUnlocked, (Collection<JobID>)d.unlockableJobs, d.entity().getJobId(), d.entity().hasBlockOfProgress());
            QuestownNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(d::sender), (Object)msg);
        });
        b.put((Object)"change_root", d -> TownVillagerUIs.openMenu(d.sender(), (TriFunction<Integer, Inventory, Player, AbstractContainerMenu>)((TriFunction)(windowId, inv, p) -> new JobChangeConfirmMenu((int)windowId, (Container)new SimpleContainer(1){

            public int m_6893_() {
                return 1;
            }
        }, d.sender.m_150109_(), d.entity.m_20148_(), d.entity.getJobId(), d.entity().getFlagPos(), d.jobChangePending())), d.quests(), d.entity(), d.stats(), d.jobChangePending()));
        b.put((Object)"economics", d -> {
            NoMCEconomics tEcon = d.econHandle.get();
            ImmutableList<ItemEconomicsData> aggregated = tEcon.getAggregatedItems(d.villagerId());
            QuestownNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(d::sender), (Object)new EconomicsUpdate(aggregated));
            TownVillagerUIs.openMenu(d.sender(), (TriFunction<Integer, Inventory, Player, AbstractContainerMenu>)((TriFunction)(windowId, inv, p) -> new VillagerEconomicsMenu((int)windowId, d.entity(), d.entity().getFlagPos(), d.econ(), d.entity().hasBlockOfProgress())), d.quests(), d.entity(), d.stats(), d.jobChangePending());
        });
        b.put((Object)"bop", d -> {
            NoMCEconomics tEcon = d.econHandle.get();
            ImmutableList<ItemEconomicsData> aggregated = tEcon.getAggregatedItems(d.villagerId());
            QuestownNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(d::sender), (Object)new EconomicsUpdate(aggregated));
            TownVillagerUIs.openMenu(d.sender(), (TriFunction<Integer, Inventory, Player, AbstractContainerMenu>)((TriFunction)(windowId, inv, p) -> new VillagerBlockofProgressMenu((int)windowId, d.entity().m_20148_(), d.entity().getFlagPos())), d.quests(), d.entity(), d.stats(), d.jobChangePending());
        });
        menuShow = b.build();
        ArrayList<String> a = new ArrayList<String>(VillagerTabs.all());
        a.removeAll((Collection<?>)menuShow.keySet());
        if (a.isEmpty()) {
            return;
        }
        throw new IllegalStateException("Missing MenuShow entry for [" + Strings.join(a, (String)", ") + "]");
    }

    private static void openMenu(ServerPlayer sender, final TriFunction<Integer, Inventory, Player, AbstractContainerMenu> shower, List<UIQuest> quests, VisitorMobEntity e, VillagerStatsData stats, boolean isJobChangePending) {
        Compat.openScreen(sender, new MenuProvider(){

            @NotNull
            public Component m_5446_() {
                return Compat.literal("");
            }

            @NotNull
            public AbstractContainerMenu m_7208_(int windowId, @NotNull Inventory inv, @NotNull Player p) {
                return (AbstractContainerMenu)shower.apply((Object)windowId, (Object)inv, (Object)p);
            }
        }, data -> VillagerMenus.write(data, quests, e, e.getInventory().m_6643_(), e.getJobId(), stats, new VillagerEconomicsData((ImmutableList<ItemEconomicsData>)ImmutableList.of()), e.hasBlockOfProgress(), isJobChangePending));
    }

    record ShowerData(ServerPlayer sender, List<UIQuest> quests, VisitorMobEntity entity, VillagerStatsData stats, VillagerEconomicsData econ, Supplier<NoMCEconomics> econHandle, Map<UUID, ? extends Set<JobID>> unlockedJobs, Set<JobID> unlockableJobs, UUID villagerId, boolean jobChangePending) {
    }
}

